% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbcb_get_series.R
\name{get_series}
\alias{get_series}
\title{Get the series from BCB}
\usage{
get_series(
  code,
  start_date = NULL,
  end_date = NULL,
  last = 0,
  as = c("tibble", "xts", "ts", "data.frame", "text")
)
}
\arguments{
\item{code}{series code}

\item{start_date}{series initial date. Accepts ISO character formated date and \code{Date}.}

\item{end_date}{series final date. Accepts ISO character formated date and \code{Date}.}

\item{last}{last items of the series}

\item{as}{the returning type: data objects (\code{tibble, xts, data.frame, ts}) or \code{text} for raw JSON

\code{code} argument can be obtained in the SGS system site. In this site searches can be executed in
order to find out the desired series and use the series code in the \code{code} argument.

The arguments \code{start_date}, \code{end_date} and \code{last} are optional.
If none of these arguments are set, then the entire time series is downloaded.
Define \code{start_date} and \code{end_date} to download a period of data and to
download the last \code{N} registers define the \code{last} argument to \code{N}
a positive integer.
Once \code{last} is provided it overrides the arguments \code{start_date} and \code{end_date}.}
}
\value{
\code{tibble} is the default returning class, but the argument \code{as} can be set
to \code{xts}, \code{data.frame}, \code{ts}, or \code{text} to return these other types.
\code{text} returns the JSON data provided by the remote API.
}
\description{
Get the series from BCB
}
\examples{
# download the entire series
\dontrun{get_series(1)}
# download a period of dates
\dontrun{get_series(1, start_date = '2016-12-01')}
\dontrun{x <- get_series(1, start_date = '2016-12-01', end_date = '2016-12-31')}
# downlaod the last register
x <- get_series(1, last = 1)

}
