% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currency_helpers.R
\name{helpers}
\alias{helpers}
\alias{Bid}
\alias{Bid.data.frame}
\alias{Bid.xts}
\alias{Bid.olinda_df}
\alias{Ask}
\alias{Ask.data.frame}
\alias{Ask.xts}
\alias{Ask.olinda_df}
\title{Helpers to access time series columns}
\usage{
Bid(x, ...)

\method{Bid}{data.frame}(x, ...)

\method{Bid}{xts}(x, ...)

\method{Bid}{olinda_df}(x, ...)

Ask(x, ...)

\method{Ask}{data.frame}(x, ...)

\method{Ask}{xts}(x, ...)

\method{Ask}{olinda_df}(x, ...)
}
\arguments{
\item{x}{time series objects containing data to be extracted}

\item{...}{additional arguments}
}
\value{
tibble with time series
}
\description{
Extraxt bid and ask data from time series objects.
}
\examples{
\dontrun{
x <- get_currency("EUR", "2018-06-22", "2018-06-28")
Bid(x)
Ask(x)
}
}
