% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbcb_get_market_expectations.R
\name{get_market_expectations}
\alias{get_market_expectations}
\title{Get market expectations}
\usage{
get_market_expectations(
  type = c("annual", "quarterly", "monthly", "inflation-12-months", "top5s-monthly",
    "top5s-annual", "institutions", "selic", "top5s-selic"),
  indic = NULL,
  start_date = NULL,
  end_date = NULL,
  keep_names = TRUE,
  ...
)
}
\arguments{
\item{type}{a character with one of the following: \code{annual}, \code{quarterly}
\code{monthly}, \code{inflation-12-months}, \code{top5s-monthly}, \code{top5s-annual},
\code{institutions}.}

\item{indic}{a character vector with economic indicators names.
They are case sensitive and don't forget the accents.}

\item{start_date}{series initial date.
Accepts ISO character formated date and \code{Date}.}

\item{end_date}{series final date.
Accepts ISO character formated date and \code{Date}.}

\item{keep_names}{if \code{TRUE} keeps the column names returned by the API
(in portuguese), if \code{FALSE} the columns are renamed to standardized
names (in english).}

\item{...}{additional parameters to be passed to the API

\code{type} defines the API used to fetch data.

\itemize{
\item \code{annual}: refers to the API *Expectativas de Mercado Anuais* for annual market expectations
\item \code{quarterly}: refers to the API *Expectativas de Mercado Trimestrais* for quarterly market expectations
\item \code{monthly}: refers to the API *Expectativas de Mercado Mensais* for monthly market expectations
\item \code{inflation-12-months}: refers to the API *Expectativas de mercado para inflação nos próximos 12 meses* for market expectations of inflation indexes for the next 12 months.
\item \code{top5s-monthly}: refers to the API *Expectativas de mercado mensais para os indicadores do Top 5* for monthly market expectations of top 5 indicators
\item \code{top5s-annual}: refers to the API *Expectativas de mercado anuais para os indicadores do Top 5* for annual market expectations of top 5 indicators
\item \code{institutions}: refers to the API *Expectativas de mercado informadas pelas instituições credenciadas* for market expectations sent by institutions
}

\code{indic} argument must be one of indicators listed in Details.
Respecting the case, blank spaces and accents.

The \code{...} is to be used with API's parameters. \code{$top} to specify
the maximum number of rows to be returned, this returns the \code{$top} rows,
in chronological order.
\code{$skip} can be used to ignore the first rows.
If provided \code{$filter} applies filters according to <https://olinda.bcb.gov.br/olinda/servico/ajuda>.}
}
\value{
A \code{data.frame} with the requested data.
}
\description{
General function to get statistics of market expectations.
The API provides requests for annual, monthly, and quarterly expectations.
Is is also proveided expectations for 12 months ahead, specific requests for
the top 5 indicators for annual and monthly expectations and data provided
by financial institutions.
}
\details{
All statistics are computed based on expectations provided by many financial
institutions in Brazil: banks, funds, risk managers, so on and so forth.
These expections and its statistics are used to build the FOCUS Report weekly
released by the Brazilian Central Bank.

There are market expectations available for the following indicators:

\itemize{
\item Balança Comercial
\item Câmbio
\item Conta corrente
\item Dívida bruta do governo geral
\item Dívida líquida do setor público
\item IGP-DI
\item IGP-M
\item INPC
\item Investimento direto no país
\item IPA-DI
\item IPA-M
\item IPCA
\item IPCA Administrados
\item IPCA Alimentação no domicílio
\item IPCA Bens industrializados
\item IPCA Livres
\item IPCA Serviços
\item IPCA-15
\item IPC-FIPE
\item PIB Agropecuária
\item PIB Despesa de consumo da administração pública
\item PIB despesa de consumo das famílias
\item PIB Exportação de bens e serviços
\item PIB Formação Bruta de Capital Fixo
\item PIB Importação de bens e serviços
\item PIB Indústria
\item PIB Serviços
\item PIB Total
\item Produção industrial
\item Resultado nominal
\item Resultado primário
\item Selic
\item Taxa de desocupação
}

Check <https://olinda.bcb.gov.br/olinda/servico/Expectativas/versao/v1/documentacao>
for more details
}
\examples{
\dontrun{
indic <- c("IPCA", "Câmbio")
x <- get_market_expectations("annual", indic, `$top` = 10)

x <- get_market_expectations("monthly", "Selic", `$top` = 20)

# get monthly expectations for top 5 indicators since 2021
x <- get_market_expectations("top5s-monthly", start_date = "2021-01-01")

# get annual expectations for top 5 indicators since 2021
x <- get_market_expectations("top5s-annual", `$top` = 20)

# get all inflation expectations for 12 months ahead starting on 2021-01
x <- get_market_expectations("inflation-12-months", start_date = "2021-01-01")

# get all IPCA expectations informed by financial institutions since 2020
x <- get_market_expectations("institutions", "IPCA", start_date = "2020-01-01")

# get all SELIC expectations informed by financial institutions since 2022
x <- get_market_expectations("selic", start_date = "2022-01-01")

# get TOP5 SELIC expectations starting on 2022
x <- get_market_expectations("top5s-selic", start_date = "2022-01-01")
}

}
