% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-cotahist.R
\name{cotahist-options-superset}
\alias{cotahist-options-superset}
\alias{cotahist_equity_options_superset}
\alias{cotahist_options_by_symbol_superset}
\title{Extracts equity option superset of data}
\usage{
cotahist_equity_options_superset(ch, yc)

cotahist_options_by_symbol_superset(symbol, ch, yc)
}
\arguments{
\item{ch}{cotahist data structure}

\item{yc}{yield curve}

\item{symbol}{character with the name of the stock}
}
\value{
A dataframe with data of equities, equity options, and interest rates.
}
\description{
Equity options superset is a dataframe that brings together all data
regarding equities, equity options and interest rates.
This data forms a complete set (superset) up and ready to run options
models, implied volatility calculations and volatility models.
}
\examples{
\dontrun{
refdate <- Sys.Date() - 1
ch <- cotahist_get(refdate, "daily")
yc <- yc_get(refdate)
ch_ss <- cotahist_equity_options_superset(ch, yc)
petr4_ch_ss <- cotahist_options_by_symbol_superset("PETR4", ch, yc)
}
}
