% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.R
\name{scale_lines}
\alias{scale_lines}
\title{Scale Lines}
\usage{
scale_lines(lines, scale = 1)
}
\arguments{
\item{lines}{The line scene.}

\item{scale}{Default `c(1,1,1)`. The scale amount, per axis.}
}
\value{
Scaled line matrix.
}
\description{
Scale Lines
}
\examples{
#Generate a cube out of lines
\donttest{
cube_outline = generate_line(start = c(-1, -1, -1), end = c(-1, -1, 1)) \%>\%
  add_lines(generate_line(start = c(-1, -1, -1), end = c(-1, 1, -1))) \%>\%
  add_lines(generate_line(start = c(-1, -1, -1), end = c(1, -1, -1))) \%>\%
  add_lines(generate_line(start = c(-1, -1, 1), end = c(-1, 1, 1))) \%>\%
  add_lines(generate_line(start = c(-1, -1, 1), end = c(1, -1, 1))) \%>\%
  add_lines(generate_line(start = c(-1, 1, 1), end = c(-1, 1, -1))) \%>\%
  add_lines(generate_line(start = c(-1, 1, 1), end = c(1, 1, 1))) \%>\%
  add_lines(generate_line(start = c(1, 1, -1), end = c(1, -1, -1))) \%>\%
  add_lines(generate_line(start = c(1, 1, -1), end = c(1, 1, 1))) \%>\%
  add_lines(generate_line(start = c(1, -1, -1), end = c(1, -1, 1))) \%>\%
  add_lines(generate_line(start = c(1, -1, 1), end = c(1, 1, 1))) \%>\%
  add_lines(generate_line(start = c(-1, 1, -1), end = c(1, 1, -1)))
rasterize_lines(cube_outline,fov=90,lookfrom=c(0,0,3))

#Scale the cube uniformly
scaled_cube = color_lines(scale_lines(cube_outline,scale=0.5),color="red")
rasterize_lines(add_lines(cube_outline,scaled_cube),fov=90,lookfrom=c(0,0,3))

#Scale the cube non-uniformly
scaled_cube = color_lines(scale_lines(cube_outline,scale=c(0.8,2,0.4)),color="red")
rasterize_lines(add_lines(cube_outline,scaled_cube),fov=60,lookfrom=c(3,3,3))
}
}
