% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_studio.R
\name{generate_studio}
\alias{generate_studio}
\title{Generate Studio}
\usage{
generate_studio(
  depth = -1,
  distance = -10,
  width = 100,
  height = 100,
  curvature = 8,
  material = diffuse()
)
}
\arguments{
\item{depth}{Default `-1`. Depth of the ground in the scene.}

\item{distance}{Default `-10`. Distance to the backdrop in the scene from the origin, on the z-axis.}

\item{width}{Default `100`. Width of the backdrop.}

\item{height}{Default `100`. height of the backdrop.}

\item{curvature}{Default `2`. Radius of the curvature connecting the bottom plane to the vertical
backdrop.}

\item{material}{Default  \code{\link{diffuse}} with `color= "#ccff00"`.The material, called from one of the material 
functions \code{\link{diffuse}}, \code{\link{metal}}, or \code{\link{dielectric}}.}
}
\value{
Tibble representing the scene.
}
\description{
Generates a curved studio backdrop.
}
\examples{
#Generate the ground and add some objects
scene = generate_studio(depth=-1, material = diffuse(color="white")) \%>\%
  add_object(obj_model(r_obj(),y=-1,x=0.7,material=glossy(color="darkred"),angle=c(0,-20,0))) \%>\%
  add_object(sphere(x=-0.7,radius=0.5,material=dielectric())) \%>\% 
  add_object(sphere(y=3,x=-2,z=20,material=light(intensity=600)))
if(run_documentation()) {
render_scene(scene, parallel=TRUE,lookfrom=c(0,2,10),fov=20,clamp_value=10,samples=128)
}

#Zooming out to show the full default scene
if(run_documentation()) {
render_scene(scene, parallel=TRUE,lookfrom=c(0,200,400),clamp_value=10,samples=128)
}
}
