% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csg_construct.R
\name{csg_cylinder}
\alias{csg_cylinder}
\title{CSG Cylinder}
\usage{
csg_cylinder(
  start = c(0, 0, 0),
  end = c(0, 1, 0),
  radius = 1,
  corner_radius = 0
)
}
\arguments{
\item{start}{Default `c(0, 0, 0)`. Start point of the cylinder, specifing `x`, `y`, `z`.}

\item{end}{Default `c(0, 1, 0)`. End point of the cylinder, specifing `x`, `y`, `z`.}

\item{radius}{Default `1`. Cylinder radius.}

\item{corner_radius}{Default `0`. Radius if rounded cylinder.}
}
\value{
List describing the cylinder in the scene.
}
\description{
CSG Cylinder
}
\examples{
if(rayrender:::run_documentation()) {
#Generate a basic cylinder:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_cylinder(radius=0.25),material=glossy(color="red"))) \%>\% 
  render_scene(clamp_value=10,fov=20)
  }
if(rayrender:::run_documentation()) {
#Change the orientation by specifying a start and end
generate_ground(material=diffuse(color="dodgerblue4",checkercolor="grey10")) \%>\% 
  add_object(csg_object(csg_cylinder(start = c(-1,0.5,-2), end = c(1,0.5,-2),
    radius=0.5),material=glossy(checkercolor="red"))) \%>\% 
  render_scene(clamp_value=10,fov=20,
               lookat=c(0,0.5,-2),lookfrom=c(3,3,10))
 }
if(rayrender:::run_documentation()) {
#Show the effect of changing the radius
generate_ground(material=diffuse(color="dodgerblue4",checkercolor="grey10")) \%>\% 
  add_object(csg_object(
    csg_combine(
    csg_cylinder(start = c(-1,0.5,-2), end = c(1,0.5,-2), radius=0.5),
    csg_cylinder(start = c(-0.5,1.5,-2), end = c(0.5,1.5,-2), radius=0.25)),
    material=glossy(checkercolor="red"))) \%>\% 
  render_scene(clamp_value=10,fov=20,
               lookat=c(0,0.5,-2),lookfrom=c(-3,3,10))
    }
if(rayrender:::run_documentation()) {           
#Render a red marble cylinder in a Cornell box
generate_cornell(light=FALSE) \%>\% 
  add_object(csg_object(
    csg_cylinder(start = c(555/2,0,555/2), end = c(555/2,350,555/2), radius=100),
    material=glossy(color="darkred",noisecolor="white",noise=0.03))) \%>\% 
    add_object(sphere(y=555,x=5,z=5, radius=5,
               material=light(intensity=10000,
                              spotlight_focus = c(555/2,555/2,555/2),spotlight_width = 45))) \%>\% 
  render_scene(clamp_value=4)
}
}
