% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwelch.R
\name{pwelch}
\alias{pwelch}
\alias{print.pwelch}
\alias{plot.pwelch}
\alias{mv_pwelch}
\title{Calculate 'Welch Periodogram'}
\usage{
pwelch(
  x,
  fs,
  window = 64,
  noverlap = 8,
  nfft = 256,
  col = "black",
  xlim = NULL,
  ylim = NULL,
  main = "Welch periodogram",
  plot = 0,
  log = c("xy", "", "x", "y"),
  ...
)

\method{print}{pwelch}(x, ...)

\method{plot}{pwelch}(
  x,
  log = c("xy", "x", "y", ""),
  type = "l",
  add = FALSE,
  col = 1,
  cex = 1,
  cex.main = cex,
  cex.sub = cex,
  cex.lab = cex * 0.8,
  cex.axis = cex * 0.7,
  las = 1,
  main = "Welch periodogram",
  xlab,
  ylab,
  xlim = NULL,
  ylim = NULL,
  ...
)

mv_pwelch(x, margin, fs, nfft)
}
\arguments{
\item{x}{\code{'pwelch'} instance returned by \code{pwelch} function}

\item{fs}{sample rate, average number of time points per second}

\item{window}{window length in time points, default size is \code{64}}

\item{noverlap}{overlap between two adjacent windows, measured in time points; default is \code{8}}

\item{nfft}{number of basis functions to apply}

\item{col, xlim, ylim, main, type, cex, cex.main, cex.sub, cex.lab, cex.axis, las, xlab, ylab}{parameters passed to \code{\link[graphics]{plot.default}}}

\item{plot}{integer, whether to plot the result or not; choices are \code{0}, no plot; \code{1} plot on a new canvas; \code{2} add to existing canvas}

\item{log}{indicates which axis should be \code{log10}-transformed, used by the plot function. For \code{'x'} axis, it's \code{log10}-transform; for \code{'y'} axis, it's \code{10log10}-transform (decibel unit). Choices are \code{"xy"}, \code{"x"}, \code{"y"}, and \code{""}.}

\item{...}{will be passed to \code{plot.pwelch} or ignored}

\item{add}{logical, whether the plot should be added to existing canvas}

\item{margin}{the margin in which \code{pwelch} should be applied to}
}
\value{
A list with class \code{'ravetools-pwelch'} that contains the
following items:
\describe{
\item{\code{freq}}{frequencies used to calculate the 'periodogram'}
\item{\code{spec}}{resulting spectral power for each frequency}
\item{\code{window}}{window function (in numerical vector) used}
\item{\code{noverlap}}{number of overlapping time-points between two adjacent windows}
\item{\code{nfft}}{number of basis functions}
\item{\code{fs}}{sample rate}
\item{\code{x_len}}{input signal length}
\item{\code{method}}{a character string \code{'Welch'}}
}
}
\description{
\code{pwelch} is for single signal trace only; \code{mv_pwelch}
is for multiple traces. Currently \code{mv_pwelch} is experimental and
should not be called directly.
}
\examples{

x <- rnorm(1000)
pwel <- pwelch(x, 100)
pwel

plot(pwel, log = "xy")

}
