% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startle.r
\name{summariseStartle}
\alias{summariseStartle}
\title{Summarise Startle}
\usage{
summariseStartle(df, method = "wilcox.test")
}
\arguments{
\item{df}{A dataframe returned by loadStartleData function.}

\item{method}{A parameter defining what type of statistical testing will be used.}
}
\value{
A mathematical summary in a list.
}
\description{
Returns a mathematical summary of the startle data. Returned list with two data frames. First contains calculated median, interquartile range, mean and standard deviation for values pertaining to the period of the pulse and in between pulses. The second contains the results of the desired statistical test, by default Wilcox is used. User can specify which test will be used with method argument.
}
\examples{
# Load example data
df <- ratpasta_demo

# running examples
summariseStartle(df)
}
