% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqs_monitors.R
\name{aqs_monitors}
\alias{aqs_monitors}
\alias{monitors_bysite}
\alias{monitors_bycounty}
\alias{monitors_bystate}
\alias{monitors_bybox}
\alias{monitors_bycbsa}
\title{AQS API Monitors service}
\usage{
aqs_monitors(
  aqs_filter = c("bySite", "byCounty", "byState", "byBox", "byCBSA"),
  aqs_variables = NULL,
  header = FALSE,
  ...
)

monitors_bysite(
  param,
  bdate,
  edate,
  state,
  county,
  site,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)

monitors_bycounty(
  param,
  bdate,
  edate,
  state,
  county,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)

monitors_bystate(
  param,
  bdate,
  edate,
  state,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)

monitors_bybox(
  param,
  bdate,
  edate,
  minlat,
  maxlat,
  minlon,
  maxlon,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)

monitors_bycbsa(
  param,
  bdate,
  edate,
  cbsa,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)
}
\arguments{
\item{aqs_filter}{A string specifying one of the service filters. NOT
case-sensitive.}

\item{aqs_variables}{A named list of variables to fetch data (e.g.,
\code{state}). Only necessary variables are passed to a specific endpoint
(service/filter) to make a valid request.}

\item{header}{A logical specifying whether the function returns additional
information from the API header. Default is \code{FALSE} to return data only.}

\item{...}{Reserved for future use.}

\item{param}{A string or vector of strings specifying the 5-digit AQS
parameter code for data selection. An integer will be coerced to a string.
A maximum of 5 parameter codes may be listed in a single request. A list
of the parameter codes can be obtained via \link{list_parametersbyclass}.}

\item{bdate}{A string specifying the begin date of data selection in
YYYYMMDD format. Only data on or after this date will be returned.}

\item{edate}{A string specifying the end date of data selection in YYYYMMDD
format. Only data on or before this date will be returned.}

\item{state}{A string specifying the 2-digit state FIPS code. An integer
will be coerced to a string with a leading zero if necessary (e.g., 1 ->
"01"). A list of the state codes can be obtained via \link{list_states}.}

\item{county}{A string specifying the 3-digit county FIPS code. An integer
will be coerced to a string with leading zeros if necessary (e.g., 89 ->
"089"). A list of the county codes within each state can be obtained via
\link{list_countiesbystate}.}

\item{site}{A string specifying the 4-digit AQS site number within the
county. An integer will be coerced to a string with leading zeros if
necessary (e.g., 14 -> "0014"). A list of the site codes within each
county can be obtained via \link{list_sitesbycounty}.}

\item{email}{A string specifying the email address of the requester. If you
set your email and key with \link{set_aqs_user}, you don't have to specify
this.}

\item{key}{A string specifying the key matching the email address for the
requester. If you set your email and key with \link{set_aqs_user}, you don't
have to specify this.}

\item{minlat}{A string or numeric value specifying the minimum latitude of a
geographic box. Decimal latitude with north being positive.}

\item{maxlat}{A string or numeric value specifying the maximum latitude of a
geographic box. Decimal latitude with north being positive.}

\item{minlon}{A string or numeric value specifying the minimum longitude of
a geographic box. Decimal longitude with east being positive.}

\item{maxlon}{A string or numeric value specifying the maximum longitude of
a geographic box. Decimal longitude with east being positive.}

\item{cbsa}{A string specifying the AQS CBSA code. A list of the CBSA codes
can be obtained via \link{list_cbsas}.}
}
\value{
A data.frame containing parsed data or a named list containing
header and data.
}
\description{
A collection of functions to fetch operational information about the
samplers (monitors) used to collect data, including identifying information,
operational dates, operating organizations, and etc.
}
\details{
\link{aqs_monitors} sends a request to the AQS API based on a user-provided
filter using the following underlying functions:
\itemize{
\item \link{monitors_bysite} returns \code{param} monitors that were operating at \code{site}
in \code{county}, within \code{state}, between \code{bdate} and \code{edate}.
\item \link{monitors_bycounty} returns \code{param} monitors that were operating in
\code{county} within \code{state} between \code{bdate} and \code{edate}.
\item \link{monitors_bystate} returns \code{param} monitors that were operating in \code{state}
between \code{bdate} and \code{edate}.
\item \link{monitors_bybox} returns \code{param} monitors that were operating at a
user-provided latitude/longitude bounding box (\code{minlat}, \code{maxlat}, \code{minlon},
\code{maxlon}) between \code{bdate} and \code{edate}.
\item \link{monitors_bycbsa} returns \code{param} monitors that were operating at a
user-provided CBSA between \code{bdate} and \code{edate}.
}
}
\examples{
\dontrun{

## Set your API Key first using set_aqs_user to run the following codes

## Example from the AQS website
## SO2 monitors in Hawaii that were operating on May 01, 2015
aqs_variables <- list(
  param = "42401", bdate = "20150501", edate = "20150502", state = "15"
)
aqs_monitors(aqs_filter = "bySite", aqs_variables = aqs_variables)

## Equivalent to above; used integers instead of strings
monitors_bystate(
  param = 42401, bdate = "20150501", edate = "20150502", state = 15
)
}
}
