% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/RapResults.R, R/RapSolved.R
\name{score}
\alias{score}
\alias{score.RapResults}
\alias{score.RapSolved}
\title{Solution score}
\usage{
score(x, y)

\method{score}{RapResults}(x, y = 0)

\method{score}{RapSolved}(x, y = 0)
}
\arguments{
\item{x}{\code{\link[=RapResults]{RapResults()}} or \code{\link[=RapSolved]{RapSolved()}} object.}

\item{y}{Available inputs include: \code{NULL} to return all scores,
\code{integer} number specifying the solution for which the score should
be returned, and \code{0} to return score for the best solution.}
}
\value{
\code{matrix} or \code{numeric} vector with solution score(s)
depending on arguments.
}
\description{
Extract solution score from \code{\link[=RapResults]{RapResults()}} or
\code{\link[=RapSolved]{RapSolved()}} object.
}
\examples{
\dontrun{
# load data
data(sim_rs)

# score for the best solution
score(sim_rs, 0)

# score for the second solution
score(sim_rs, 2)

# score for all solutions
score(sim_rs, NULL)
}
}
\seealso{
\code{\link[=RapResults]{RapResults()}}, \code{\link[=RapSolved]{RapSolved()}}.
}
