% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/RapResults.R, R/RapSolved.R
\name{logging.file}
\alias{logging.file}
\alias{logging.file.RapResults}
\alias{logging.file.RapSolved}
\title{Log file}
\usage{
logging.file(x, y)

\method{logging.file}{RapResults}(x, y = 0)

\method{logging.file}{RapSolved}(x, y = 0)
}
\arguments{
\item{x}{\code{RapResults} or \code{RapSolved} object.}

\item{y}{\code{NULL} to return all values, \code{integer} 0 to return the log file for best solution, \code{integer} value greater than 0 for log file for the \code{y}'th solution.}
}
\description{
This function returns the Gurobi log file (*.log) associated with solving RAP.
}
\note{
The term logging file was used due to collisions with the \code{log} function in base R.
}
\examples{
data(sim_rs)
# log file for best solution
cat(logging.file(sim_rs, 0))
# log file for second solution
cat(logging.file(sim_rs, 2))
# log files for all solutions
cat(logging.file(sim_rs, NULL))
}
\seealso{
\code{RapResults}, \code{RapSolved}.
}

