% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoReport.R
\name{createAutoReport}
\alias{createAutoReport}
\title{Create and add report to config}
\usage{
createAutoReport(
  synopsis,
  package,
  type = "subscription",
  fun,
  paramNames,
  paramValues,
  owner,
  ownerName = "",
  email,
  organization,
  runDayOfYear,
  startDate = as.character(Sys.Date()),
  terminateDate = NULL,
  interval = "",
  intervalName = "",
  dryRun = FALSE
)
}
\arguments{
\item{synopsis}{String with description of the report and to be used in
subject field of email distributed reports}

\item{package}{String with package name also corresponding to registry}

\item{type}{Character string defining type of auto report. Currently, one of
'subscription' (default) or 'dispatchment'}

\item{fun}{String providing name of function to be called for generating
report}

\item{paramNames}{String vector where each element corresponds to the input
parameter to be used in the above function}

\item{paramValues}{String vector with corresponding values to paramNames}

\item{owner}{String providing the owner of the report. Usually a user name}

\item{ownerName}{String providing full name of owner. Defaults to an empty
string to maintain backwards compatibility}

\item{email}{String with email address to recipient of email containing the
report}

\item{organization}{String identifying the organization the owner belongs to}

\item{runDayOfYear}{Integer vector with day numbers of the year when the
report is to be run}

\item{startDate}{Date-class date when report will be run first time. Default
value is set to \code{Sys.Date() + 1} \emph{i.e.} tomorrow.}

\item{terminateDate}{Date-class date after which report is no longer run.
Default value set to \code{NULL} in which case the function will provide an
expiry date adding 3 years to the current date if in a PRODUCTION context
and 1 month if not}

\item{interval}{String defining a time interval as defined in
\code{\link[base:seq.POSIXt]{seq.POSIXt}}. Default value is an empty string}

\item{intervalName}{String providing a human understandable representation of
\code{interval}. Default value is an empty string}

\item{dryRun}{Logical defining if global auto report config actually is to
be updated. If set to TRUE the actual config (all of it) will be returned by
the function. FALSE by default}
}
\value{
Nothing unless dryRun is set TRUE in which case a list of all config
will be returned
}
\description{
Adds an entry to the system configuration of reports to run at given
intervals. After generating the configuration from the new entry
the function load the current system configuration, adds the new
entry and saves the updated system configuration.
}
\seealso{
\code{\link{deleteAutoReport}}
}
