% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoReportFuns.R
\name{makeRunDayOfYearSequence}
\alias{makeRunDayOfYearSequence}
\title{Make a sequence of day numbers from av given date and interval}
\usage{
makeRunDayOfYearSequence(startDay = Sys.Date(), interval)
}
\arguments{
\item{startDay}{Start date of sequence. May be provided as a string,
\emph{e.g.} \"2019-03-17\" or as class \"Date\". Defaults to today}

\item{interval}{String representing a valid seq.POSIXt interval such as
"DSTday", "week", "month", "quarter" or "year")}
}
\value{
Integer vector of day numbers
}
\description{
This function provides an even sequence of day numbers spanning 365/366
days from the start date and interval provided. Mainly to be used in
setting up automated reports at Rapporteket
}
\examples{
makeRunDayOfYearSequence(interval = "month")

}
