% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AppNavbarUserWidget.R
\name{appNavbarUserWidget}
\alias{appNavbarUserWidget}
\title{Create widget for registry apps at Rapporteket}
\usage{
appNavbarUserWidget(user = "Undefined person",
  organization = "Undefined organization")
}
\arguments{
\item{user}{String providing the name of the user}

\item{organization}{String providing the organization of the user}
}
\value{
Ready made html script
}
\description{
Provides a widget-like information and utility block to be applied to all
registry apps at Rapporteket. Contains the user name, organization and
logout/exit as hyperlinked text.
}
\details{
Normally, user information will be be provided through the session parameter
and hence this will have to be provided from the server. The "rendering" of
this info must hence be done within a layout element at the client such as
a \code{tabPanel}. Selecting any one of them should be fine... At the
client, both \code{uiOutput} and \code{textOutput} will be fine "rendering
the information provided by the server.

Example of use in shiny (pseudo code):
\preformatted{
server <- function(input, output, session) {
  ...
  output$appUserName <- renderText(getUserName(session))
  output$appUserOrg <- renderText(getUserReshId(session))
  ...
}

ui <- tagList(
  navbarPage(
    ...,
    tabPanel(...,
    appNavbarUserWidget(user = uiOutput(appUserName), organization = textOutput(appUserOrg))
    ),
    ...
  )
)
}
}
\examples{
appNavbarUserWidget()
}
