% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GUI.R
\name{rankFD_GUI}
\alias{rankFD_GUI}
\title{A graphical user interface for the package rankFD}
\usage{
rankFD_GUI()
}
\description{
This function provides a graphical user interface for calculating rank-based 
statistical tests in general factorial designs.
}
\details{
The function produces a GUI for the calculation of the test statistics and 
for plotting. Data can be loaded via the "load data" button. The formula 
and the significance level alpha (default: 0.05) need to be specified.
One can choose between two different null hypotheses (\eqn{H_0^F} and \eqn{H_0^p}, see the details
to \code{\link{rankFD}}) to be tested as well as
weighted or unweighted effects as discussed in Brunner et al. (2016) (\eqn{r_i} and \eqn{p_i} in
their notation).
If the plot option is chosen, an additional window opens containing
information on the plots.
}
\references{
Brunner, E., Bathke, A.C., Konietschke, F. Rank and Pseudo-Rank Procedures 
for Independent Observations in Factorial Designs. Springer International Publishing, 2018.

Brunner, E., Konietschke, F., Pauly, M., Puri, M. L. (2017). Rank-based procedures in factorial designs: 
Hypotheses about non-parametric treatment effects. Journal of the Royal Statistical Society: Series B 
(Statistical Methodology), 79(5), 1463-1485.

Akritas, M. G., Arnold, S. F., and Brunner, E. (1997). Nonparametric hypotheses and rank statistics for unbalanced factorial designs.
Journal of the American Statistical Association 92, 258-265.

Brunner, E., Dette, H., and Munk, A. (1997). Box-Type Approximations in Nonparametric Factorial Designs. Journal
of the American Statistical Association 92, 1494-1502.

Konietschke, F., Hothorn, L. A., Brunner, E. (2012). Rank-based multiple test procedures and simultaneous confidence intervals. Electronic Journal of Statistics,
6, 738-759.
}
