% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rangemodel_1d.R
\name{rangemod.1d}
\alias{rangemod.1d}
\title{Range Cohesion Model for Ordered (and Non-spatial) Data}
\usage{
rangemod.1d(spmat, nb = NULL, var = NULL, first = FALSE, degen = FALSE,
  rsize = c("observed", "unif"), reps)
}
\arguments{
\item{spmat}{a site by species matrix or data frame with species in columns}

\item{nb}{a neighbour object similar to one generated with
'\code{\link[spdep]{poly2nb}}' of '\pkg{\link[spdep]{spdep}}'.
If NULL then a list resembling object of class 'nb' is created.
If NA then result is range scatter.}

\item{var}{an optional vector containing explanatory variable for
constraining the randomization}

\item{first}{If TRUE, 'var' is used while choosing the first occurence as
well.if 'var' is null, first is always set 'FALSE'}

\item{degen}{If true, each randomized site by species matrix is saved and
provided in output}

\item{rsize}{which rangesizes to use for simulation, can be an integer
vector of same length as number of species(collumns) or either
'observed' or'unif'. See details for explanations}

\item{reps}{number of replicates}
}
\value{
If degen is FALSE, a data frame with four colums for mean, SD and
       confidence intervals of expected richness

\itemize{
 \item{"mod.rich"}{ mean richness of each site}
 \item{"mod.sd"}{ standard deviation of species richness}
 \item{"q2.5"}{ lower limit of the confidence interval}
 \item{"q97.5"}{ upper limit of the confidence interval}
}
       If degen is TRUE, then a list containing above data frame and a list
       of all the randomized matrices
}
\description{
rangemod.1d takes observed site by species matrix and returns
              expected species richness values of each site
}
\details{
rangemod.1d impliments simulations used by Rahbeck et.al (2007) to
         data which are only in form of a site by species matrix and without
         any spatial information. A list similar to an nb object of spdep can
         prepared according to order in which the rows (sites) are arranged.
         A manually prepared list of neighbours for each site can also be
         used.It is important that each site must have at least one neighbour.
         'rsize' provides a vector of rangesizes.It can be 'unif' -
          ranges are drawn from a uniform distribution,between 1 to
         number of sites or 'observed' - rangesize
         of each species is exactly the same as in the observed matrix.
         Alternatively a it can also be a user specified integer vector, of
         same length as number of species.
}
\examples{
tempmat <- matrix(0,nrow=10,ncol=200,dimnames=list(letters[1:10],1:200))
tempmat <- as.matrix(apply(tempmat,2,function(x){rbinom(nrow(tempmat),1,
                     runif(1,0.1,1))}))
rownames(tempmat) <- letters[1:10]
temp <- rangemod.1d(tempmat,nb = NULL,var = NULL,rsize = "observed",reps = 5)
plot(temp[,1],ylim= c(min(temp[,1] -2),max(temp[,1]+2)),pch = 16,ylab = 'Species Richness')
segments(1:10,y0=temp[,1]-temp[,2],y1= temp[,1]+temp[,2])
}
\references{
Rahbek, C., Gotelli, N., Colwell, R., Entsminger, G., Rangel, T.
             & Graves, G. (2007) Predicting continental-scale patterns of
             bird species richness with spatially explicit
             models. Proceedings of the Royal Society B: Biological Sciences,
             274, 165.

             Gotelli, N.J., Anderson, M.J., Arita, H.T., Chao, A., Colwell,
             R.K., Connolly, S.R., Currie, D.J., Dunn, R.R., Graves, G.R. &
             Green, J.L. (2009) Patterns and causes of species richness:
             a general simulation model for macroecology. Ecology Letters,
             12, 873-886.
}

