% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges_espace.R
\name{ranges_espace}
\alias{ranges_espace}
\title{Comparison of species ranges in environmental space}
\usage{
ranges_espace(..., add_occurrences = TRUE, variables,
              max_background = 10000, occurrence_color = "blue",
              range_colors = NULL, alpha = 0.6, legend = TRUE,
              verbose = TRUE)
}
\arguments{
\item{...}{one or more objects of class \code{\link{sp_range}} produced with
any of the following functions: \code{\link{rangemap_buffer}},
\code{\link{rangemap_boundaries}}, \code{\link{rangemap_hull}},
\code{\link{rangemap_enm}}, and/or \code{\link{rangemap_tsa}}. Using up to
five ranges is allowed for more precise comparisons.}

\item{add_occurrences}{(logical) if \code{TRUE}, species occurrences contained
in one of the \code{sp_range} objects will be plotted. Default = \code{TRUE}.
If  none of the objects contains occurrences this argument will be ignored.}

\item{variables}{a RasterStack object of at least 3 environmental variables
that will be used to perform a principal component analysis, and use the 3
first principal components to represent the environmental space. Projection
is assumed to be WGS84 (EPSG:4326).}

\item{max_background}{(numeric) maximum number of data from variables to be
used for representing the environmental space. Default = 10000.}

\item{occurrence_color}{color for occurrence records in environmental space.}

\item{range_colors}{vector of colors for the ranges to be represented. If
\code{NULL}, the default, a set of colors will be used. Since transparency is
used for representing ranges in the plot, colors may look different.}

\item{alpha}{(numeric) degree of opacity for plotting species ranges.
Default = 0.6.}

\item{legend}{(logical) if \code{TRUE}, a simple legend will be added.
Default = \code{TRUE}.}

\item{verbose}{(logical) whether or not to print messages about the process.
Default = TRUE.}
}
\value{
A figure showing distributional ranges of a species represented in environmental
space (3 principal components).
}
\description{
ranges_espace generates a three dimensional comparison of
distributional ranges for a species created using distinct functions of
\code{\link{rangemap}}, to visualize them in environmental conditions.
}
\examples{
# example data
data("buffer_range", package = "rangemap")
data("cxhull_range", package = "rangemap")

vars <- raster::stack(system.file("extdata", "variables.tif",
                                  package = "rangemap"))
names(vars) <- c("bio5", "bio6", "bio13", "bio14")

## comparison
ranges_espace(buffer_range, cxhull_range, variables = vars,
              add_occurrences = TRUE)
}
