% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_rs.R
\name{simple_rs}
\alias{simple_rs}
\title{Simple Random Sampling}
\usage{
simple_rs(N, prob = NULL, check_inputs = TRUE)
}
\arguments{
\item{N}{The number of units. N must be a positive integer. (required)}

\item{prob}{prob is the probability of being sampled must be a real number between 0 and 1 inclusive. (optional)}

\item{check_inputs}{logical. Defaults to TRUE.}
}
\value{
A numeric vector of length N that indicates if a unit is sampled (1) or not (0).
}
\description{
simple_rs implements a random sampling procedure in which units are independently sampled. Because units are sampled independently, the number of units that are sampled can vary from sample to sample. For most applications in which the number of units in the sampling frame is known in advance, \code{\link{complete_rs}} is better because the number of units sampled is fixed across sampled.\cr\cr
}
\examples{

S <- simple_rs(N = 100)
table(S)

S <- simple_rs(N = 100, prob = 0.3)
table(S)

}
