% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{price_with_intensity_link}
\alias{price_with_intensity_link}
\title{Helper function (instrument pricing) for calibration of equity-linked default intensity}
\usage{
price_with_intensity_link(p, s, h, variance_instruments,
  variance_instrument_prices, variance_instrument_spreads, fit_instruments,
  S0, num_time_steps = 30, ..., relative_spread_tolerance = 0.15,
  num_variance_time_steps = 30)
}
\arguments{
\item{p}{Power of default intensity}

\item{s}{Proportion of constant default intensity}

\item{h}{Base default intensity}

\item{variance_instruments}{A list of instruments in strictly increasing order
of maturity, from which the volatility term structure will be inferred.  Once the
calibration is finished, the chosen parameters will reproduce the prices of
these instruments with fairly high precision.}

\item{variance_instrument_prices}{Central price targets for the variance instruments}

\item{variance_instrument_spreads}{Bid-offer spreads used to normalize errors
in variance instrument prices during term structure fitting}

\item{fit_instruments}{A list of instruments in any order, from which the
mispricing penalties used for judging fit quality will be computed}

\item{S0}{Current underlying price}

\item{num_time_steps}{Time step count passed on to \code{\link{find_present_value}}
while fitting instrument values}

\item{...}{Further arguments passed to both
\code{\link{fit_variance_cumulation}} and to
\code{\link{find_present_value}}}

\item{relative_spread_tolerance}{Tolerance to apply in
calling \code{\link{fit_variance_cumulation}}}

\item{num_variance_time_steps}{Number of time steps to use in
calling \code{\link{fit_variance_cumulation}}}
}
\description{
Given derivative instruments (subclasses of
  GridPricedInstrument, though typically either \code{\link{AmericanOption}}
  or \code{\link{EuropeanOption}} objects), along with their prices and spreads, calibrate
  variance cumulation (the
 at-the-money volatility of the continuous process) and then price the instruments via equity linked default
 intensity of the form $h(s + (1-s)(S0/S_t)^p)$.
}
