% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FirstOrder.R
\name{first_order_features}
\alias{first_order_features}
\alias{calc_energy}
\alias{calc_entropy}
\alias{calc_kurtosis}
\alias{calc_meanDeviation}
\alias{calc_skewness}
\alias{calc_uniformity}
\alias{calc_mean}
\alias{calc_median}
\alias{calc_max}
\alias{calc_min}
\alias{calc_variance}
\alias{calc_RMS}
\alias{calc_sd}
\title{First order features}
\usage{
calc_energy(data)

calc_entropy(data, base = 2, nbins = length(unique(c(data))))

calc_kurtosis(data)

calc_meanDeviation(data)

calc_skewness(data)

calc_uniformity(data, nbins = length(unique(c(data))))

calc_mean(data)

calc_median(data)

calc_max(data)

calc_min(data)

calc_variance(data)

calc_RMS(data)

calc_sd(data)
}
\arguments{
\item{data}{Numeric 2D matrix data.}

\item{base}{The base for which the logarithm is calculate}

\item{nbins}{The number of bins the histogram is discretized into}
}
\description{
First order features
}
\section{Functions}{
\itemize{
\item \code{calc_energy}: Energy (ASM)

\item \code{calc_entropy}: Entropy

\item \code{calc_kurtosis}: Kurtosis

\item \code{calc_meanDeviation}: Mean Deviation

\item \code{calc_skewness}: Skewness

\item \code{calc_uniformity}: Uniformity

\item \code{calc_mean}: Mean

\item \code{calc_median}: Median

\item \code{calc_max}: Maximum Value

\item \code{calc_min}: Minimum Value

\item \code{calc_variance}: Variance

\item \code{calc_RMS}: Root Mean Squared

\item \code{calc_sd}: Standard Deviation
}}

\references{
\url{http://journals.plos.org/plosone/article?id=10.1371/journal.pone.0102107#s5}
}
