% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclus.R
\name{hclus}
\alias{hclus}
\title{Hierarchical cluster analysis}
\usage{
hclus(dataset, vars, labels = "none", distance = "sq.euclidian",
  method = "ward.D", max_cases = 5000, standardize = TRUE,
  data_filter = "")
}
\arguments{
\item{dataset}{Dataset}

\item{vars}{Vector of variables to include in the analysis}

\item{labels}{A vector of labels for the leaves of the tree}

\item{distance}{Distance}

\item{method}{Method}

\item{max_cases}{Maximum number of cases allowed (default is 1000). Set to avoid long-running analysis in the radiant web-interface}

\item{standardize}{Standardized data (TRUE or FALSE)}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list of all variables used in hclus as an object of class hclus
}
\description{
Hierarchical cluster analysis
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/hclus.html} for an example in Radiant
}
\examples{
hclus(shopping, vars = "v1:v6") \%>\% str()

}
\seealso{
\code{\link{summary.hclus}} to summarize results

\code{\link{plot.hclus}} to plot results
}
