% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{regress}
\alias{regress}
\title{Linear regression using OLS}
\usage{
regress(dataset, rvar, evar, int = "", check = "", data_filter = "")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{rvar}{The response variable in the regression}

\item{evar}{Explanatory variables in the regression}

\item{int}{Interaction terms to include in the model}

\item{check}{Use "standardize" to see standardized coefficient estimates. Use "stepwise-backward" (or "stepwise-forward", or "stepwise-both") to apply step-wise selection of variables in estimation}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list of all variables variables used in the regress function as an object of class regress
}
\description{
Linear regression using OLS
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/regress.html} for an example in Radiant
}
\examples{
result <- regress("diamonds", "price", c("carat","clarity"))
result <- regress("diamonds", "price", c("carat","clarity"), check = "standardize")

}
\seealso{
\code{\link{summary.regress}} to summarize results

\code{\link{plot.regress}} to plot results

\code{\link{predict.regress}} to generate predictions
}
