% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naivebayes.R
\name{plot.nb.predict}
\alias{plot.nb.predict}
\title{Plot method for nb.predict function}
\usage{
\method{plot}{nb.predict}(x, xvar = "", facet_row = ".", facet_col = ".",
  color = ".class", ...)
}
\arguments{
\item{x}{Return value from predict function predict.nb}

\item{xvar}{Variable to display along the X-axis of the plot}

\item{facet_row}{Create vertically arranged subplots for each level of the selected factor variable}

\item{facet_col}{Create horizontally arranged subplots for each level of the selected factor variable}

\item{color}{Adds color to a scatter plot to generate a heat map. For a line plot one line is created for each group and each is assigned a different colour}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for nb.predict function
}
\examples{
result <- nb("titanic", "survived", c("pclass","sex","age"))
pred <- predict(result, pred_cmd="pclass=levels(pclass), sex=levels(sex), age=seq(0,100,20)")
plot(pred, xvar = "age", facet_col = "sex", facet_row = "pclass")
pred <- predict(result, pred_data="titanic")
plot(pred, xvar = "age", facet_col = "sex")

}
\seealso{
\code{\link{predict.nb}} to generate predictions
}
