% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doe.R
\name{estimable}
\alias{estimable}
\title{Determine coefficients that can be estimated based on a partial factorial design}
\usage{
estimable(design)
}
\arguments{
\item{design}{An experimental design generated by the doe function that includes a partial and full factorial design}
}
\description{
A function to determine which coefficients can be estimated based on a partial factorial design. Adapted from a function written by Blakeley McShane at https://github.com/fzettelmeyer/mktg482/blob/master/R/expdesign.R
}
\examples{
design <- doe(c("price; $10; $13; $16", "food; popcorn; gourmet; no food"), trials = 6)
estimable(design)
}
