% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivotr.R
\name{pivotr}
\alias{pivotr}
\title{Create a pivot table using dplyr}
\usage{
pivotr(dataset, cvars = "", nvar = "None", fun = "mean_rm",
  normalize = "None", tabfilt = "", tabsort = "", nr = NULL,
  data_filter = "", shiny = FALSE)
}
\arguments{
\item{dataset}{Name of the dataframe to change}

\item{cvars}{Categorical variables}

\item{nvar}{Numerical variable}

\item{fun}{Function to apply to numerical variable}

\item{normalize}{Normalize the table by "row" total,"column" totals, or overall "total"}

\item{tabfilt}{Expression used to filter the table. This should be a string (e.g., "Total > 10000")}

\item{tabsort}{Expression used to sort the table (e.g., "-Total")}

\item{nr}{Number of rows to display}

\item{data_filter}{Expression used to filter the dataset. This should be a string (e.g., "price > 10000")}

\item{shiny}{Logical (TRUE, FALSE) to indicate if the function call originate inside a shiny app}
}
\description{
Create a pivot table using dplyr
}
\details{
Create a pivot-table. See \url{http://radiant-rstats.github.io/docs/data/pivotr.html} for an example in Radiant
}
\examples{
result <- pivotr("diamonds", cvars = "cut")$tab
result <- pivotr("diamonds", cvars = c("cut","clarity","color"))$tab
result <- pivotr("diamonds", cvars = "cut:clarity", nvar = "price")$tab
result <- pivotr("diamonds", cvars = "cut", nvar = "price")$tab
result <- pivotr("diamonds", cvars = "cut", normalize = "total")$tab

}

