% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_rtwig.R
\name{run_rtwig}
\alias{run_rtwig}
\title{Run Real Twig}
\usage{
run_rtwig(
  file,
  twig_radius,
  backend = "multisession",
  metrics = TRUE,
  version = NULL,
  smooth = TRUE,
  standardize = FALSE
)
}
\arguments{
\item{file}{file path to QSM (.mat, .csv, .json)}

\item{twig_radius}{Twig radius in millimeters}

\item{backend}{Parallel backend for multi-core processing. Defaults to "multisession" (all platforms), but can be set to "multicore" (MacOS & Linux), "cluster" (all platforms), or a "package::backend" string.}

\item{metrics}{Calculate tree metrics? Defaults to TRUE.}

\item{version}{Defaults to NULL. If using a specific version of TreeQSM, the user can specify the version (e.g. 2.4.1, 2.0, etc.).}

\item{smooth}{Defaults to TRUE, if using TreeQSM. Can be set to FALSE.}

\item{standardize}{Standardize QSM cylinder data? Defaults to FALSE. Can be set to TRUE.}
}
\value{
Returns cylinder data frame or list if metrics is true.
}
\description{
Runs all Real Twig steps
}
\examples{
\donttest{

## TreeQSM
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- run_rtwig(file, twig_radius = 4.23)
str(qsm$cylinder)

## SimpleForest
file <- system.file("extdata/QSM.csv", package = "rTwig")
qsm <- run_rtwig(file, twig_radius = 4.23)
str(qsm)
}

}
