% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pages.R
\name{get_pages}
\alias{get_pages}
\title{Get several pages of one type of request}
\usage{
get_pages(
  url_,
  stoken,
  per_page = 30,
  page_id = 1,
  page_max = 1,
  before = NULL,
  after = NULL,
  queries = NULL,
  All = FALSE
)
}
\arguments{
\item{url_}{string of url for the request to the API}

\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}

\item{per_page}{numeric indicating number of items retrieved per page (maximum 200)}

\item{page_id}{numeric indicating page id}

\item{page_max}{numeric indicating maximum number of pages to return}

\item{before}{date object for filtering activities before the indicated date}

\item{after}{date object for filtering activities after the indicated date}

\item{queries}{list of additional queries to pass to the API}

\item{All}{logical if you want all possible pages within the ratelimit constraint}
}
\value{
Data from an API request.
}
\description{
Get several pages of one type of request to the API
}
\details{
Requires authentication stoken using the \code{\link{strava_oauth}} function and a user-created API on the strava website.
}
\examples{
\dontrun{
# create authentication token
# requires user created app name, id, and secret from Strava website
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, 
	app_secret, cache = TRUE))

# get basic user info
# returns 30 activities
get_pages('https://strava.com/api/v3/activities', stoken)

}
}
\concept{token}
