% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calculateSRDValues}
\alias{calculateSRDValues}
\title{calculateSRDValues}
\usage{
calculateSRDValues(data_matrix, output_to_file = FALSE)
}
\arguments{
\item{data_matrix}{A DataFrame.}

\item{output_to_file}{Boolean flag to enable file output.}
}
\value{
A vector containing the SRD values.
}
\description{
R interface to calculate SRD values.
To test the results' significance run calculateSRDDistribution(). 
For more information about SRD scores and their validation 
see Héberger and Kollár-Hunek (2011).
}
\examples{
df <- data.frame(
A=c(32, 52, 44, 44, 47),
B=c(73, 75, 65, 76, 70),
C=c(60, 59, 57, 55, 60),
D=c(35, 24, 44, 83, 47),
E=c(41, 52, 46, 50, 65))

calculateSRDValues(df)
}
\references{
Héberger K., Kollár-Hunek K. (2011) 
"Sum of ranking differences for method discrimination and its validation:
comparison of ranks with random numbers", Journal of Chemometrics, 25(4), pp. 151–158.
}
\author{
Balázs R. Sziklai \email{sziklai.balazs@krtk.hu}, Linus Olsson \email{linusmeol@gmail.com}
}
