% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractional.computations.R
\name{precision.CBrSPDEobj2d}
\alias{precision.CBrSPDEobj2d}
\title{Get the precision matrix of CBrSPDEobj2d objects}
\usage{
\method{precision}{CBrSPDEobj2d}(
  object,
  nu = NULL,
  hx = NULL,
  hy = NULL,
  hxy = NULL,
  sigma = NULL,
  m = NULL,
  ...
)
}
\arguments{
\item{object}{The covariance-based rational SPDE approximation,
computed using \code{\link[=matern2d.operators]{matern2d.operators()}}}

\item{nu}{If non-null, update the shape parameter of the
covariance function.}

\item{hx}{If non-null, update the hx parameter.}

\item{hy}{If non-null, update the hy parameter.}

\item{hxy}{If non-null, update the hxy parameter.}

\item{sigma}{If non-null, update the standard deviation of
the covariance function.}

\item{m}{If non-null, update the order of the rational approximation,
which needs to be a positive integer.}

\item{...}{Currently not used.}
}
\value{
The precision matrix.
}
\description{
Function to get the precision matrix of a CBrSPDEobj2d object
}
\examples{
library(fmesher)
n_loc <- 2000
loc_2d_mesh <- matrix(runif(n_loc * 2), n_loc, 2)
mesh_2d <- fm_mesh_2d(loc = loc_2d_mesh, cutoff = 0.03, max.edge = c(0.1, 0.5))
op <- matern2d.operators(mesh = mesh_2d)
Q <- precision(op)
}
\seealso{
\code{\link[=simulate.CBrSPDEobj2d]{simulate.CBrSPDEobj2d()}}, \code{\link[=matern2d.operators]{matern2d.operators()}}
}
