% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla_rspde.R
\name{rspde.matern.precision.opt}
\alias{rspde.matern.precision.opt}
\title{Optimized precision matrix of the covariance-based rational approximation}
\usage{
rspde.matern.precision.opt(
  kappa,
  nu,
  tau,
  rspde_order,
  dim,
  fem_matrices,
  graph = NULL,
  sharp
)
}
\arguments{
\item{kappa}{Range parameter of the covariance function.}

\item{nu}{Shape parameter of the covariance function.}

\item{tau}{Scale parameter of the covariance function.}

\item{rspde_order}{The order of the rational approximation}

\item{dim}{The dimension of the domain}

\item{fem_matrices}{A list containing the FEM-related matrices. The list should contain elements C, G, G_2, G_3, etc.}

\item{graph}{The sparsity graph of the matrices. If NULL, only a vector
of the elements will be returned, if non-NULL, a sparse matrix will be returned.}

\item{sharp}{The sparsity graph should have the correct sparsity (costs more to perform
a sparsity analysis) or an upper bound for the sparsity?}
}
\value{
The precision matrix
}
\description{
\code{rspde.matern.precision} is used for computing the
optimized version of the precision matrix of the
covariance-based rational SPDE approximation of a stationary Gaussian random
fields on \eqn{R^d} with a Matern covariance function
\deqn{C(h) = \frac{\sigma^2}{2^(\nu-1)\Gamma(\nu)}(\kappa h)^\nu K_\nu(\kappa h)}{C(h) =
(\sigma^2/(2^(\nu-1)\Gamma(\nu))(\kappa h)^\nu K_\nu(\kappa h)}
}
