% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sea.R
\name{SEA}
\alias{SEA}
\title{SEA}
\usage{
SEA(pvalue, featureIDs, data, pathlist, select, tdphat = TRUE,
  selfcontained = TRUE, competitive = TRUE, thresh = NULL,
  alpha = 0.05)
}
\arguments{
\item{pvalue}{Vector of p-values. It can be the name of the covariate representing the Vector of
all raw p-values in the \code{data} or a single vector but in the latter case it should match the
\code{featureIDs} vector}

\item{featureIDs}{Vector of feature IDs. It can be the name of the covariate representing the IDs in the
\code{data} or a single vector but in the latter case it should match the \code{pvalue} vector}

\item{data}{Optional data frame or matrix containing the variables in \code{pvalue} and \code{featureIDs}}

\item{pathlist}{A list containing pathways defined by \code{featureIDs}. Checkout the vignette
for more details and available codes to create your own pathway}

\item{select}{A vector. Number or names of pathways of interest from the \code{pathlist} of choice.
If missing, all pathways of the database will be included}

\item{tdphat}{Logical. If \code{TRUE} the point estimate of the True Discoveries Proportion
within each pathway will be calculated}

\item{selfcontained}{Logical. If \code{TRUE} the self-contained null hypothesis will be tested
for each pathway and the corresponding adj. p-value is returned}

\item{competitive}{Logical. If \code{TRUE} the default competitive null hypothesis will be tested
for each pathway and the corresponding adj. p-value is returned, you can define a threshold with
\code{thresh} argument}

\item{thresh}{A real number between 0 and 1. If specified, the competitive null hypothesis will be tested
against this threshold for each pathway and the corresponding adj. p-value is returned}

\item{alpha}{The type I error allowed for TDP bound. The default is 0.05.}
}
\value{
A data.frame is returned including a list of pathways with corresponding TDP bound estimate,
and if specified, TDP point estimate and adjusted p-values
}
\description{
returns SEA chart (a data.frame) including the test results and estimates for the specified
feature-sets from \code{pathlist}.
}
\examples{

\dontrun{
##Generate a vector of pvalues
set.seed(159)

m<- 100
pvalues <- runif(m,0,1)^5
featureIDs <- as.character(1:m)

# perform a self-contained test for all features
settest(pvalues, featureIDs, testype = "selfcontained")

# create 3 random pathway of size 60, 20 and 45
randpathlist=list(A=as.character(c(sample(1:m, 60))),
             B=as.character(c(sample(1:m, 20))),
             C=as.character(c(sample(1:m, 45))))


# get the seachart for the whole pathlist
set(pvalues, featureIDs, pathlist=randpathlist)

# get the seachart for only first two pathways of the randpathlist
sea(pvalues, featureIDs, pathlist=randpathlist, select=1:2)
}
}
\references{
Mitra Ebrahimpoor, Pietro Spitali, Kristina Hettne, Roula Tsonaka, Jelle Goeman,
Simultaneous Enrichment Analysis of all Possible Gene-sets: Unifying Self-Contained
and Competitive Methods, Briefings in Bioinformatics, , bbz074, https://doi.org/10.1093/bib/bbz074
}
\seealso{
\code{\link{setTest}}, \code{\link{topSEA}},
}
\author{
Mitra Ebrahimpoor

\email{m.ebrahimpoor@lumc.nl}
}
