% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex-pref.r
\name{complex_pref}
\alias{&.preference}
\alias{*.preference}
\alias{+.preference}
\alias{complex_pref}
\alias{is.complex_pref}
\alias{reverse}
\alias{|.preference}
\title{Complex Preferences}
\usage{
\method{*}{preference}(p1, p2)

\method{&}{preference}(p1, p2)

\method{|}{preference}(p1, p2)

\method{+}{preference}(p1, p2)

reverse(p)

is.complex_pref(x)
}
\arguments{
\item{p, p1, p2}{Preference objects (they can be either base preferences, see \code{\link{base_pref}}, or complex preferences)}

\item{x}{An object to be tested if it is a complex preference.}
}
\description{
Complex preferences are used to compose different preference orders. 
For example the Pareto composition (via operator \code{*}) is the usual operator
to compose the preference for a Skyline query. The Skyline is also known as Pareto frontier.
All complex preferences are mathematically strict partial orders (irreflexive and transitive).
}
\section{Skylines}{


The most important preference composition operator is the Pareto operator (\code{p1 * p2}) to formulate a Skyline query. 
A tuple t1 is better than t2 w.r.t. \code{p1 * p2} if it is strictly better w.r.t. one of the preferences p1, p2 and is better or equal w.r.t. the other preference.

The syntactical correspondence to other query languages supporting Skylines/preferences to rPref
is given as follows:

\itemize{
\item A query in the syntax from Borzsonyi et. al (2001) like

"\code{... SKYLINE OF a MAX, b MIN, c MAX}" 

corresponds in rPref to the preference

\code{high(a) * low(b) * high(c)}.


\item A query in the syntax from Kiessling (2002) like 

"\code{... PREFERRING a LOWEST AND (b HIGHEST PRIOR TO c LOWEST)}" 

corresponds in rPref to 

\code{low(a) * (high(b) & low(c))}.


\item A query in the syntax of the "Skyline" feature of the commercial database "EXASOL EXASolution 5" like 

"\code{... PREFERRING LOW a PLUS (b = 1 PRIOR TO LOW c))}" 

corresponds in rPref to

\code{low(a) * (true(b == 1) & low(c))}.

}

Note that preferences in rPref can be translated to some of this query dialects by \code{\link{show.query}}.
}

\section{Definition of Additional Preference Operators}{


Additionally, rPref supports the following preference composition operators:

\describe{
 \item{\code{p1 & p2}}{Prioritization (lexicographical order): A tuple t1 is better than t2 w.r.t. \code{p1 & p2} if it is 
  strictly better w.r.t. \code{p1} or is equal w.r.t. \code{p1} and is better w.r.t. \code{p2}.}
 \item{\code{p1 | p2}}{Intersection preference: A tuple t1 is better than t2 w.r.t. \code{p1 | p2} if it is strictly better w.r.t. both preferences. 
       This is a stricter variant of the Pareto operator. The evaluation of \code{psel(df, p1 | p2)} is always a subset of \code{psel(df, p1 * p2)}.}
 \item{\code{p1 + p2}}{Union preference: A tuple t1 is better than t2 w.r.t. \code{p1 + p2} if it is strictly better w.r.t. to one of the preferences. 
 Note that this can violate the strict partial order property, if the domains (the tuples on which \code{p1} and \code{p2} define better-than-relationships) 
 of the preferences are not disjoint.}
 \item{\code{reverse(p1)} or \code{-p1}}{Reverse preference (converse relation): 
 A tuple t1 is better than t2 w.r.t. \code{-p1} if t2 is better than t1 w.r.t. \code{p1}. 
 The unary minus operator, i.e. \code{-p1}, is a short hand notation for \code{reverse(p1)}.}
}

The function \code{is.complex_pref} returns \code{TRUE} if \code{x} is a complex preference object 
(i.e., was constructed by one of these binary operators or the unary operator \code{reverse}) 
and \code{FALSE} otherwise.
}

\section{Associated Data Sets}{


If one of the preferences for a binary operator are associated with a data set (see \code{\link{base_pref}}),
then this association is propagated. For example, the preference

\code{p <- high(mpg, df = mtcars) * high(hp)}

as well as

\code{p <- high(mpg) * high(hp, df = mtcars)}

both result in the same complex preference which is associated with \code{mtcars}. 
A partial evaluation is also invoked for all preferenced which are added. 
For example, using this \code{p}, 

\code{p <- p * true(cyl == max(mtcars$cyl))}

generates the following console output:

\code{[Preference] high(mpg) * high(hp) * true(cyl == 8)} \cr
\code{  * associated data source: data.frame "mtcars" [32 x 11]}

We see that the association with the data set is propagated and \code{max(mtcars$cyl)} is partially evaluated.
}
\examples{
# define preference for cars with low consumption (high mpg-value) 
# and simultaneously high horsepower
p1 <- high(mpg) * high(hp)  

# perform the preference search
psel(mtcars, p1)

# alternative way: create preference with associated data set
p2 <- high(mpg, df = mtcars) * high(hp)  
peval(p2)
}
\references{
S. Borzsonyi, D. Kossmann, K. Stocker (2001): The Skyline Operator. In Data Engineering (ICDE '01), pages 421-430.

W. Kiessling (2002): Foundations of Preferences in Database Systems. In Very Large Data Bases (VLDB '02), pages 311-322.

S. Mandl, O. Kozachuk, M. Endres, W. Kiessling (2015): Preference Analytics in EXASolution. 
16th Conference on Database Systems for Business, Technology, and Web.
}
\seealso{
See \code{\link{base_pref}} for the construction of base preferences. 
See \code{\link{general_pref}} for functions applicable to all kind of preferences.
See \code{\link{psel}} for the evaluation of preferences.
}

