% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tg.R
\name{tg.cut}
\alias{tg.cut}
\title{tg.cut}
\usage{
tg.cut(tg, tStart = -Inf, tEnd = Inf)
}
\arguments{
\item{tg}{TextGrid object}

\item{tStart}{beginning time of time frame to be cut (default \code{-Inf} = cut from the tmin of the TextGrid)}

\item{tEnd}{final time of time frame to be cut (default \code{Inf} = cut to the tmax of the TextGrid)}
}
\value{
TextGrid object
}
\description{
Cut the specified time frame from the TextGrid and preserve time
}
\examples{
tg <- tg.sample()
tg2 <-   tg.cut(tg,  tStart = 3)
tg2_0 <- tg.cut0(tg, tStart = 3)
tg3 <-   tg.cut(tg,  tStart = 2, tEnd = 3)
tg3_0 <- tg.cut0(tg, tStart = 2, tEnd = 3)
tg4 <-   tg.cut(tg,  tEnd = 1)
tg4_0 <- tg.cut0(tg, tEnd = 1)
tg5 <-   tg.cut(tg,  tStart = -1, tEnd = 5)
tg5_0 <- tg.cut0(tg, tStart = -1, tEnd = 5)
\dontrun{
tg.plot(tg)
tg.plot(tg2)
tg.plot(tg2_0)
tg.plot(tg3)
tg.plot(tg3_0)
tg.plot(tg4)
tg.plot(tg4_0)
tg.plot(tg5)
tg.plot(tg5_0)
}
}
\seealso{
\code{\link{tg.cut0}}, \code{\link{pt.cut}}, \code{\link{pt.cut0}}, \code{\link{tg.read}}, \code{\link{tg.plot}}, \code{\link{tg.write}}, \code{\link{tg.insertInterval}}
}
