# Also available as files:
# system.file("extdata", "H.TextGrid", package = "rPraat")
# system.file("extdata", "H_problem.TextGrid", package = "rPraat")
# system.file("extdata", "H.PitchTier", package = "rPraat")
#
# E.g.:
#   tg <- tg.read(system.file("extdata", "H.TextGrid", package = "rPraat"))

#' tg.sample
#'
#' Returns sample TextGrid.
#'
#' @return TextGrid
#' @export
#' @seealso \code{\link{tg.plot}}
#'
#' @examples
#' tg <- tg.sample()
#' tg.plot(tg)
tg.sample <- function() {
tg <- structure(list(phoneme = structure(list(name = "phoneme", type = "point",
t = c(0.120889365898715, 0.180597224347416, 0.255441139997666,
0.323525331333184, 0.375027067444295, 0.435376815025253,
0.504279694264069, 0.562717206724197, 0.610965695488722,
0.674057937198658, 0.737962529488432, 0.827253285259762,
0.868531134448233, 0.918910050365654, 0.974990086094542,
1.05053934430682, 1.21167268104584, 1.88902324993668, 1.92282441350142,
1.96615363138769, 2.02116389408869, 2.06893833121809, 2.11783390528662,
2.1695607451066, 2.22032423657473, 2.27591881435465, 2.31952662340463,
2.35271936402631, 2.40370606752593, 2.47583170709847, 2.53340121033917,
2.58361187610004, 2.65895915060935, 2.73945082859849, 2.84348900462963,
2.9951353595599, 3.0883101125227, 3.14535462546526, 3.21171193910256,
3.272169808837, 3.33241603782642, 3.38647934980882, 3.45468235960145
), label = c("j", "a:", "c", "i", "P\\", "e", "k", "n", "u",
"t_s", "o", "u", "J\\", "e", "l", "a:", "S", "n", "e", "j",
"d", "P\\", "i:", "f", "n", "a", "j", "d", "e", "Z", "h",
"u", "t_S", "k", "u", "a", "a", "t", "a", "m", "a", "n",
"a")), .Names = c("name", "type", "t", "label")), phone = structure(list(
name = "phone", type = "interval", t1 = c(0.008, 0.0965724658757064,
0.145206265921723, 0.215988182773109, 0.294894097222222,
0.352156565444145, 0.397897569444444, 0.472856060606061,
0.535703327922078, 0.589731085526316, 0.632200305451128,
0.715915568946188, 0.760009490030675, 0.803739120702006,
0.850767449817518, 0.886294819078947, 0.95152528165236, 0.998454890536723,
1.10262379807692, 1.32072156401475, 1.87136778049296, 1.9066787193804,
1.93897010762243, 1.99333715515295, 2.04899063302442, 2.08888602941177,
2.14678178116147, 2.19233970905172, 2.24830876409774, 2.30352886461156,
2.3355243821977, 2.36991434585492, 2.43749778919694, 2.514165625,
2.55263679567834, 2.61458695652174, 2.70333134469697, 2.7755703125,
2.91140769675926, 2.96666963493613, 3.02360108418367, 3.07030520488411,
3.10631502016129, 3.18439423076923, 3.2390296474359, 3.3053099702381,
3.35952210541475, 3.4134365942029, 3.495928125), t2 = c(0.0965724658757064,
0.145206265921723, 0.215988182773109, 0.294894097222222,
0.352156565444145, 0.397897569444444, 0.472856060606061,
0.535703327922078, 0.589731085526316, 0.632200305451128,
0.715915568946188, 0.760009490030675, 0.803739120702006,
0.850767449817518, 0.886294819078947, 0.95152528165236, 0.998454890536723,
1.10262379807692, 1.32072156401475, 1.87136778049296, 1.9066787193804,
1.93897010762243, 1.99333715515295, 2.04899063302442, 2.08888602941177,
2.14678178116147, 2.19233970905172, 2.24830876409774, 2.30352886461156,
2.3355243821977, 2.36991434585492, 2.43749778919694, 2.514165625,
2.55263679567834, 2.61458695652174, 2.70333134469697, 2.7755703125,
2.91140769675926, 2.96666963493613, 3.02360108418367, 3.07030520488411,
3.10631502016129, 3.18439423076923, 3.2390296474359, 3.3053099702381,
3.35952210541475, 3.4134365942029, 3.495928125, 3.616), label = c("",
"j", "a:", "c", "i", "P\\", "e", "k", "n", "u", "t_s", "o",
"?", "u", "J\\", "e", "l", "a:", "S", " ", "n", "e", "j",
"d", "P\\", "i:", "f", "n", "a", "j", "d", "e", "Z", "h\\",
"u", "t_S", "k", "u", "?", "a", "?", "a", "t", "a", "m",
"a", "n", "a:", "")), .Names = c("name", "type", "t1", "t2",
"label")), syllable = structure(list(name = "syllable", type = "interval",
t1 = c(0, 0.0965724658757064, 0.215988182773109, 0.352156565444145,
0.535703327922078, 0.632200305451128, 0.760009490030675,
0.850767449817518, 0.95152528165236, 1.32072156401475, 1.87136778049296,
1.99333715515295, 2.19233970905172, 2.3355243821977, 2.514165625,
2.70333134469697, 2.91140769675926, 3.02360108418367, 3.10631502016129,
3.2390296474359, 3.35952210541475, 3.495928125), t2 = c(0.0965724658757064,
0.215988182773109, 0.352156565444145, 0.535703327922078,
0.632200305451128, 0.760009490030675, 0.850767449817518,
0.95152528165236, 1.32072156401475, 1.87136778049296, 1.99333715515295,
2.19233970905172, 2.3355243821977, 2.514165625, 2.70333134469697,
2.91140769675926, 3.02360108418367, 3.10631502016129, 3.2390296474359,
3.35952210541475, 3.495928125, 3.616), label = c("", "ja:",
"ci", "P\\ek", "nu", "t_so", "?u", "J\\e", "la:S", "", "nej",
"dP\\i:f", "naj", "deZ", "h\\ut_S", "ku", "?a", "?a", "ta",
"ma", "na:", "")), .Names = c("name", "type", "t1", "t2",
"label")), word = structure(list(name = "word", type = "interval",
t1 = c(0.008, 0.0965724658757064, 0.215988182773109, 0.352156565444145,
0.632200305451128, 0.760009490030675, 1.32072156401475, 1.87136778049296,
2.19233970905172, 2.514165625, 2.91140769675926, 3.02360108418367,
3.495928125), t2 = c(0.0965724658757064, 0.215988182773109,
0.352156565444145, 0.632200305451128, 0.760009490030675,
1.32072156401475, 1.87136778049296, 2.19233970905172, 2.514165625,
2.91140769675926, 3.02360108418367, 3.495928125, 3.616),
label = c("", "ja", "ti", "reknu", "co", "udelas", "{pause}",
"nejdriv", "najdes", "Hucku", "a", "Atamana", "")), .Names = c("name",
"type", "t1", "t2", "label")), phrase = structure(list(name = "phrase",
type = "interval", t1 = 0, t2 = 3.608, label = "Ja ti reknu, co udelas. Nejdriv najdes Hucku a Atamana"), .Names = c("name",
"type", "t1", "t2", "label"))), .Names = c("phoneme", "phone",
"syllable", "word", "phrase"), class = structure(c("list", "0",
"3.616", "TextGrid", "sample.TextGrid"), .Names = c("", "tmin", "tmax", "type", "name")))

    return(tg)
}

#' tg.sampleProblem
#'
#' Returns sample TextGrid with continuity problem.
#'
#' @return TextGrid
#' @export
#' @seealso \code{\link{tg.repairContinuity}}
#'
#' @examples
#' tg <- tg.sampleProblem()
#' tg2 <- tg.repairContinuity(tg)
#' tg2 <- tg.repairContinuity(tg2)
#' tg.plot(tg2)
tg.sampleProblem <- function() {
tg <- structure(list(phoneme = structure(list(name = "phoneme", type = "point",
t = c(0.120889365898715, 0.180597224347416, 0.255441139997666,
0.323525331333184, 0.375027067444295, 0.435376815025253,
0.504279694264069, 0.562717206724197, 0.610965695488722,
0.674057937198658, 0.737962529488432, 0.827253285259762,
0.868531134448233, 0.918910050365654, 0.974990086094542,
1.05053934430682, 1.21167268104584, 1.88902324993668, 1.92282441350142,
1.96615363138769, 2.02116389408869, 2.06893833121809, 2.11783390528662,
2.1695607451066, 2.22032423657473, 2.27591881435465, 2.31952662340463,
2.35271936402631, 2.40370606752593, 2.47583170709847, 2.53340121033917,
2.58361187610004, 2.65895915060935, 2.73945082859849, 2.84348900462963,
2.9951353595599, 3.0883101125227, 3.14535462546526, 3.21171193910256,
3.272169808837, 3.33241603782642, 3.38647934980882, 3.45468235960145
), label = c("j", "a:", "c", "i", "P\\", "e", "k", "n", "u",
"t_s", "o", "u", "J\\", "e", "l", "a:", "S", "n", "e", "j",
"d", "P\\", "i:", "f", "n", "a", "j", "d", "e", "Z", "h",
"u", "t_S", "k", "u", "a", "a", "t", "a", "m", "a", "n",
"a")), .Names = c("name", "type", "t", "label")), phone = structure(list(
name = "phone", type = "interval", t1 = c(0.008, 0.0965724658757064,
0.145206265921723, 0.215988182773109, 0.294894097222222,
0.352156565444145, 0.397897569444444, 0.472856060606061,
0.535703327922078, 0.589731085526316, 0.632200305451128,
0.715915568946188, 0.760009490030675, 0.803739120702006,
0.850767449817518, 0.886294819078947, 0.951, 0.998454890536723,
1.10262379807692, 1.32072156401475, 1.87136778049296, 1.9066787193804,
1.93897010762243, 1.99333715515295, 2.0489, 2.08888602941177,
2.14678178116147, 2.19233970905172, 2.24830876409774, 2.30352886461156,
2.3355243821977, 2.36991434585492, 2.43749778919694, 2.514165625,
2.55263679567834, 2.61458695652174, 2.70333134469697, 2.7755703125,
2.91140769675926, 2.96666963493613, 3.02360108418367, 3.07030520488411,
3.10631502016129, 3.18439423076923, 3.2390296474359, 3.3053099702381,
3.35952210541475, 3.4134365942029, 3.495928125), t2 = c(0.0965724658757064,
0.145206265921723, 0.215988182773109, 0.294894097222222,
0.352156565444145, 0.397897569444444, 0.472856060606061,
0.535703327922078, 0.589731085526316, 0.632200305451128,
0.715915568946188, 0.760009490030675, 0.803739120702006,
0.850767449817518, 0.886294819078947, 0.95100001, 0.998454890536723,
1.10262379807692, 1.32072156401475, 1.87136778049296, 1.9066787193804,
1.93897010762243, 1.99333715515295, 2.04890000001, 2.08888602941177,
2.14678178116147, 2.19233970905172, 2.24830876409774, 2.30352886461156,
2.3355243821977, 2.36991434585492, 2.43749778919694, 2.514165625,
2.55263679567834, 2.61458695652174, 2.70333134469697, 2.7755703125,
2.91140769675926, 2.96666963493613, 3.02360108418367, 3.07030520488411,
3.10631502016129, 3.18439423076923, 3.2390296474359, 3.3053099702381,
3.35952210541475, 3.4134365942029, 3.495928125, 3.616), label = c("",
"j", "a:", "c", "i", "P\\", "e", "k", "n", "u", "t_s", "o",
"?", "u", "J\\", "e", "l", "a:", "S", " ", "n", "e", "j",
"d", "P\\", "i:", "f", "n", "a", "j", "d", "e", "Z", "h\\",
"u", "t_S", "k", "u", "?", "a", "?", "a", "t", "a", "m",
"a", "n", "a:", "")), .Names = c("name", "type", "t1", "t2",
"label")), syllable = structure(list(name = "syllable", type = "interval",
t1 = c(0, 0.0965724658757064, 0.215988182773109, 0.352156565444145,
0.535703327922078, 0.632200305451128, 0.760009490030675,
0.850767449817518, 0.95152528165236, 1.32072156401475, 1.87136778049296,
1.99333715515295, 2.19233970905172, 2.3355243821977, 2.514165625,
2.70333134469697, 2.91140769675926, 3.02360108418367, 3.10631502016129,
3.2390296474359, 3.35952210541475, 3.495928125), t2 = c(0.0965724658757064,
0.215988182773109, 0.352156565444145, 0.535703327922078,
0.632200305451128, 0.760009490030675, 0.850767449817518,
0.95152528165236, 1.32072156401475, 1.87136778049296, 1.99333715515295,
2.19233970905172, 2.3355243821977, 2.514165625, 2.70333134469697,
2.91140769675926, 3.02360108418367, 3.10631502016129, 3.2390296474359,
3.35952210541475, 3.495928125, 3.616), label = c("", "ja:",
"ci", "P\\ek", "nu", "t_so", "?u", "J\\e", "la:S", "", "nej",
"dP\\i:f", "naj", "deZ", "h\\ut_S", "ku", "?a", "?a", "ta",
"ma", "na:", "")), .Names = c("name", "type", "t1", "t2",
"label")), word = structure(list(name = "word", type = "interval",
t1 = c(0.008, 0.0965724658757064, 0.2158999, 0.352156565444145,
0.632200305451128, 0.7601, 1.32072156401475, 1.87136778049296,
2.19233970905172, 2.514165625, 2.91140769675926, 3.02360108418367,
3.495928125), t2 = c(0.0965724658757064, 0.2159, 0.352156565444145,
0.632200305451128, 0.76, 1.32072156401475, 1.87136778049296,
2.19233970905172, 2.514165625, 2.91140769675926, 3.02360108418367,
3.495928125, 3.616), label = c("", "ja", "ti", "eeknu", "co",
"udelas", "{pause}", "nejdriv", "najdes", "Hucku", "a", "Atamana",
"")), .Names = c("name", "type", "t1", "t2", "label")), phrase = structure(list(
name = "phrase", type = "interval", t1 = 0, t2 = 3.608, label = "Ja ti reknu, co udelas. Nejdriv najdes Hucku a Atamana"), .Names = c("name",
"type", "t1", "t2", "label"))), .Names = c("phoneme", "phone",
"syllable", "word", "phrase"), class = structure(c("list", "0",
"3.616", "TextGrid", "sample_problem.TextGrid"), .Names = c("", "tmin", "tmax", "type", "name")))

    return(tg)
}

#' pt.sample
#'
#' Returns sample PitchTier.
#'
#' @return PitchTier
#' @export
#' @seealso \code{\link{pt.plot}}
#'
#' @examples
#' pt <- pt.sample()
#' pt.plot(pt)
pt.sample <- function() {
pt <- structure(list(t = c(0.0935625, 0.1035625, 0.1135625, 0.1235625,
0.1335625, 0.1435625, 0.1535625, 0.1635625, 0.1735625, 0.1835625,
0.1935625, 0.2035625, 0.2135625, 0.2235625, 0.2335625, 0.2935625,
0.3035625, 0.3135625, 0.3235625, 0.3335625, 0.3435625, 0.3535625,
0.3635625, 0.3735625, 0.3835625, 0.3935625, 0.4035625, 0.4135625,
0.4235625, 0.4335625, 0.4435625, 0.4535625, 0.4635625, 0.4735625,
0.4835625, 0.5335625, 0.5435625, 0.5535625, 0.5635625, 0.5735625,
0.5835625, 0.5935625, 0.6035625, 0.6135625, 0.6235625, 0.6335625,
0.6435625, 0.7635625, 0.7735625, 0.7835625, 0.7935625, 0.8035625,
0.8135625, 0.8235625, 0.8335625, 0.8435625, 0.8535625, 0.8635625,
0.8735625, 0.8835625, 0.8935625, 0.9035625, 0.9135625, 0.9235625,
0.9335625, 0.9435625, 0.9535625, 0.9635625, 0.9735625, 0.9835625,
0.9935625, 1.0035625, 1.0135625, 1.0235625, 1.0335625, 1.0435625,
1.0535625, 1.0635625, 1.0735625, 1.8835625, 1.8935625, 1.9035625,
1.9135625, 1.9235625, 1.9335625, 1.9435625, 1.9535625, 1.9635625,
1.9735625, 1.9835625, 1.9935625, 2.0035625, 2.0135625, 2.0235625,
2.0335625, 2.0435625, 2.0535625, 2.0635625, 2.0735625, 2.0835625,
2.0935625, 2.1035625, 2.1135625, 2.1235625, 2.1335625, 2.1435625,
2.1535625, 2.1635625, 2.1735625, 2.1835625, 2.1935625, 2.2035625,
2.2135625, 2.2235625, 2.2335625, 2.2435625, 2.2535625, 2.2635625,
2.2735625, 2.2835625, 2.2935625, 2.3035625, 2.3135625, 2.3235625,
2.3335625, 2.3435625, 2.3535625, 2.3635625, 2.3735625, 2.3835625,
2.3935625, 2.4035625, 2.4135625, 2.4235625, 2.4335625, 2.4435625,
2.4535625, 2.4635625, 2.4735625, 2.4835625, 2.4935625, 2.5035625,
2.5135625, 2.5235625, 2.5335625, 2.5435625, 2.5535625, 2.5635625,
2.5735625, 2.5835625, 2.5935625, 2.6035625, 2.6135625, 2.6235625,
2.7735625, 2.7835625, 2.7935625, 2.8035625, 2.8135625, 2.8235625,
2.8335625, 2.8435625, 2.8535625, 2.8635625, 2.8735625, 2.8835625,
2.8935625, 2.9035625, 2.9135625, 2.9735625, 2.9835625, 2.9935625,
3.0835625, 3.0935625, 3.1035625, 3.1135625, 3.1235625, 3.1835625,
3.1935625, 3.2035625, 3.2135625, 3.2235625, 3.2335625, 3.2435625,
3.2535625, 3.2635625, 3.2735625, 3.2835625, 3.2935625, 3.3035625,
3.3135625, 3.3235625, 3.3335625, 3.3435625, 3.3535625, 3.3635625,
3.3735625, 3.3835625, 3.3935625, 3.4035625, 3.4135625, 3.4235625,
3.4335625, 3.4435625, 3.4535625, 3.4635625, 3.4735625, 3.4835625,
3.4935625), f = c(210.062730604157, 216.000196664877, 219.493067264917,
221.285940333729, 224.36498589873, 230.294721059186, 215.384932287278,
203.822697661509, 192.487360695774, 189.580336693526, 192.010434279107,
195.546951066892, 195.850901240659, 194.155083009587, 196.718508016374,
263.360850890751, 270.839100386271, 273.781213701986, 274.477050697928,
273.731416381412, 269.116875870315, 255.938338875776, 249.020739362198,
253.605684139787, 255.081182343559, 257.626948880897, 261.542408896129,
263.874974051543, 259.376303268924, 249.874050194761, 244.346302349768,
238.955773132525, 233.334171955406, 228.259396501552, 238.600903437817,
256.704350631582, 250.505302942172, 245.871566074717, 240.46776707795,
231.739728498653, 224.096816353289, 218.31420157621, 208.571102020563,
202.605591647841, 196.42453309938, 188.124951679469, 190.255400192583,
130.339830499355, 131.422275593081, 130.375240804352, 131.80845758233,
142.993210985898, 163.086311438615, 170.930003795472, 179.103957377679,
183.925712800319, 183.708720734564, 179.324279762828, 179.815340050368,
180.891628172382, 180.152499814796, 174.615487687711, 170.051914230606,
168.286965420936, 161.690798518359, 157.248717185988, 153.43139380722,
150.018603806651, 149.294032098336, 150.659001928989, 150.036514446679,
145.597586703768, 144.096737362489, 138.389894719079, 135.058732367581,
139.947635859238, 139.801102125312, 125.001688237588, 132.863609653836,
209.639731409055, 212.651774291658, 214.263711114672, 208.596838587026,
207.417017067516, 205.896156071496, 204.237633185179, 203.958769396148,
206.17780711045, 209.024291208526, 211.176511609948, 208.611571275892,
198.818598493777, 192.232732519572, 190.45408958964, 196.591038969483,
209.64764000854, 217.914090385371, 229.344890791382, 241.961023002769,
245.341260835484, 258.404655176344, 264.497858603965, 267.897181403162,
269.544598222722, 272.401183884358, 275.224750717397, 268.332220166645,
257.354140347377, 263.152167356754, 270.182436280803, 282.526571900806,
290.817631479134, 290.309405567278, 287.470160062553, 281.211085097782,
274.595809563152, 262.780653649015, 262.426351901909, 263.826052710528,
266.040128338263, 267.395651401899, 268.390180030573, 268.827018256277,
267.139116916271, 262.161148741023, 247.817246433156, 239.29922673489,
239.997809826399, 245.401970170869, 247.604823503263, 248.016032818953,
248.193575634296, 247.122000583395, 238.646694076005, 231.586314416343,
220.207694900041, 218.736118387651, 191.999146527106, 192.658264872739,
193.537356424397, 190.555605530456, 190.584099438807, 190.382196420787,
200.876282309822, 204.67346466601, 215.54918365073, 217.285728368339,
216.114998591509, 207.033409425367, 201.07800889974, 199.756746823744,
194.630624629961, 193.287010582472, 202.387223155445, 214.765766211789,
211.424350451087, 215.495977618704, 217.811569429731, 217.393642207838,
218.612486614289, 220.208234200306, 220.63229383082, 220.255358340888,
221.081834151832, 220.979546322984, 215.842694446365, 205.918141427629,
200.429951632128, 185.191053751928, 199.515885856117, 199.799817380161,
196.152600306061, 199.417690685637, 202.251943733849, 198.406454456676,
198.546294242503, 201.468815590477, 207.167735931803, 197.24235841142,
192.672020346964, 193.014500541187, 194.807344999663, 195.028206757606,
200.82583284068, 206.003615672747, 204.867353800571, 203.413384147931,
201.75281351547, 200.593313777613, 195.140565337496, 189.150055732336,
185.326578109853, 179.688544688706, 174.905314080388, 171.534920048563,
166.594639799738, 165.826947538547, 162.724141783348, 160.706032197959,
160.870776102449, 159.572532516518, 154.14529425336, 152.699424431425,
153.023853237342, 157.128947241149, 160.505660143832, 161.468571250085,
162.42251152617, 161.70257708723), tmin = 0, tmax = 3.617125), .Names = c("t",
"f", "tmin", "tmax"), class = structure(c("list", "PitchTier", "sample.PitchTier"), .Names = c("", "type", "name")))

    return(pt)
}

#' it.sample
#'
#' Returns sample IntensityTier.
#'
#' @return IntensityTier
#' @export
#' @seealso \code{\link{it.plot}}
#'
#' @examples
#' it <- it.sample()
#' it.plot(it)
it.sample <- function() {
return(structure(list(t = c(0.0552291666666667, 0.0685625000000001,
0.0818958333333334, 0.0952291666666667, 0.1085625, 0.121895833333333,
0.135229166666667, 0.1485625, 0.161895833333333, 0.175229166666667,
0.1885625, 0.201895833333333, 0.215229166666667, 0.2285625, 0.241895833333333,
0.255229166666667, 0.2685625, 0.281895833333333, 0.295229166666667,
0.3085625, 0.321895833333333, 0.335229166666667, 0.3485625, 0.361895833333333,
0.375229166666667, 0.3885625, 0.401895833333333, 0.415229166666667,
0.4285625, 0.441895833333333, 0.455229166666667, 0.4685625, 0.481895833333333,
0.495229166666667, 0.5085625, 0.521895833333333, 0.535229166666667,
0.5485625, 0.561895833333333, 0.575229166666667, 0.5885625, 0.601895833333334,
0.615229166666667, 0.6285625, 0.641895833333333, 0.655229166666667,
0.6685625, 0.681895833333333, 0.695229166666667, 0.7085625, 0.721895833333334,
0.735229166666667, 0.7485625, 0.761895833333333, 0.775229166666667,
0.7885625, 0.801895833333333, 0.815229166666667, 0.8285625, 0.841895833333334,
0.855229166666667, 0.8685625, 0.881895833333334, 0.895229166666667,
0.9085625, 0.921895833333333, 0.935229166666667, 0.9485625, 0.961895833333334,
0.975229166666667, 0.9885625, 1.00189583333333, 1.01522916666667,
1.0285625, 1.04189583333333, 1.05522916666667, 1.0685625, 1.08189583333333,
1.09522916666667, 1.1085625, 1.12189583333333, 1.13522916666667,
1.1485625, 1.16189583333333, 1.17522916666667, 1.1885625, 1.20189583333333,
1.21522916666667, 1.2285625, 1.24189583333333, 1.25522916666667,
1.2685625, 1.28189583333333, 1.29522916666667, 1.3085625, 1.32189583333333,
1.33522916666667, 1.3485625, 1.36189583333333, 1.37522916666667,
1.3885625, 1.40189583333333, 1.41522916666667, 1.4285625, 1.44189583333333,
1.45522916666667, 1.4685625, 1.48189583333333, 1.49522916666667,
1.5085625, 1.52189583333333, 1.53522916666667, 1.5485625, 1.56189583333333,
1.57522916666667, 1.5885625, 1.60189583333333, 1.61522916666667,
1.6285625, 1.64189583333333, 1.65522916666667, 1.6685625, 1.68189583333333,
1.69522916666667, 1.7085625, 1.72189583333333, 1.73522916666667,
1.7485625, 1.76189583333333, 1.77522916666667, 1.7885625, 1.80189583333333,
1.81522916666667, 1.8285625, 1.84189583333333, 1.85522916666667,
1.8685625, 1.88189583333333, 1.89522916666667, 1.9085625, 1.92189583333333,
1.93522916666667, 1.9485625, 1.96189583333333, 1.97522916666667,
1.9885625, 2.00189583333333, 2.01522916666667, 2.0285625, 2.04189583333333,
2.05522916666667, 2.0685625, 2.08189583333333, 2.09522916666667,
2.1085625, 2.12189583333333, 2.13522916666667, 2.1485625, 2.16189583333333,
2.17522916666667, 2.1885625, 2.20189583333333, 2.21522916666667,
2.2285625, 2.24189583333333, 2.25522916666667, 2.2685625, 2.28189583333333,
2.29522916666667, 2.3085625, 2.32189583333333, 2.33522916666667,
2.3485625, 2.36189583333333, 2.37522916666667, 2.3885625, 2.40189583333333,
2.41522916666667, 2.4285625, 2.44189583333333, 2.45522916666667,
2.4685625, 2.48189583333333, 2.49522916666667, 2.5085625, 2.52189583333333,
2.53522916666667, 2.5485625, 2.56189583333333, 2.57522916666667,
2.5885625, 2.60189583333333, 2.61522916666667, 2.6285625, 2.64189583333333,
2.65522916666667, 2.6685625, 2.68189583333333, 2.69522916666667,
2.7085625, 2.72189583333333, 2.73522916666667, 2.7485625, 2.76189583333333,
2.77522916666667, 2.7885625, 2.80189583333333, 2.81522916666667,
2.8285625, 2.84189583333333, 2.85522916666667, 2.8685625, 2.88189583333333,
2.89522916666667, 2.9085625, 2.92189583333333, 2.93522916666667,
2.9485625, 2.96189583333333, 2.97522916666667, 2.9885625, 3.00189583333333,
3.01522916666667, 3.0285625, 3.04189583333333, 3.05522916666667,
3.0685625, 3.08189583333333, 3.09522916666667, 3.1085625, 3.12189583333333,
3.13522916666667, 3.1485625, 3.16189583333333, 3.17522916666667,
3.1885625, 3.20189583333333, 3.21522916666667, 3.2285625, 3.24189583333333,
3.25522916666667, 3.2685625, 3.28189583333333, 3.29522916666667,
3.3085625, 3.32189583333333, 3.33522916666667, 3.3485625, 3.36189583333333,
3.37522916666667, 3.3885625, 3.40189583333333, 3.41522916666667,
3.4285625, 3.44189583333333, 3.45522916666667, 3.4685625, 3.48189583333333,
3.49522916666667, 3.5085625, 3.52189583333333, 3.53522916666667,
3.5485625, 3.56189583333333), i = c(40.8563568492368, 49.9501061694254,
61.1300167456885, 68.4290227580218, 72.6628305386552, 75.9537150235435,
79.1874168055474, 81.1439712873194, 81.5883338312037, 80.958116077764,
79.8316994372077, 77.933512920565, 74.1127257089545, 67.5575312031175,
58.7607129358692, 51.7834567814199, 54.3583000765697, 66.0178872239849,
73.6365900150609, 77.588819154687, 78.9048440009974, 78.6227964802997,
76.9387749971376, 73.6023248092663, 71.7042997230837, 75.5332526495588,
78.6480264660153, 79.7737538755513, 79.3352420499331, 77.6957465574339,
74.9698953454813, 70.867777567006, 65.2876225103102, 60.5097606039458,
62.6396563604087, 70.5033747928643, 77.2895716279333, 80.7934946497421,
81.5448152006219, 80.4392663158201, 78.2807934611486, 75.3031892924578,
72.2016443497279, 69.3633154357388, 65.1834147135157, 59.1284732975381,
53.3546097057634, 50.8451401736733, 58.3446739765188, 67.3751517057329,
72.2533929700176, 73.496045024372, 72.0610217883492, 69.3190670724883,
67.4420024617764, 67.3018641880242, 68.2534019035242, 69.7766533033108,
71.1806231031693, 71.6421515916891, 70.9871749389853, 71.0634976526798,
72.6668744813889, 73.7852053240651, 74.1468549560747, 74.1266574396854,
73.5234578162816, 72.4169629441516, 70.4719703040092, 68.6386070309391,
67.697851652102, 67.0148161251967, 66.1134349093455, 64.9119956174099,
63.8963393552611, 63.0338430275956, 61.8456554018995, 60.5654976791684,
59.6174335400558, 58.8993675732758, 58.0534369151624, 55.7260044981744,
51.5791578299194, 49.2411416795846, 50.1725459086193, 51.4867457389894,
52.4335633641844, 53.3323003003384, 54.0091711207422, 54.3799399379854,
54.5355911922557, 53.6629735120924, 52.3195553439905, 50.2005143763753,
47.110119833831, 45.0592999248046, 44.1928473791222, 43.0299459147909,
41.34393026595, 39.8637821578297, 38.5169488490309, 37.6845112146165,
37.7263872098172, 37.9879930087839, 37.5515215887357, 36.1262620391226,
35.547150779541, 36.6637354494481, 37.8188816171058, 37.1440151465579,
36.0272013404764, 35.2845700324973, 35.1094019815983, 34.6598060958388,
34.4113360782963, 34.695285308224, 33.2290859045475, 30.8246775713152,
29.8348866957543, 30.1759284593639, 29.7756371565634, 29.4341237180678,
29.8026979528814, 28.7828212230406, 27.5125804314066, 27.5587855206492,
27.8718532757239, 28.451999944474, 29.0606288387143, 30.2708107734888,
30.4780728313203, 30.7688603908062, 32.1709356649268, 36.3831951942814,
52.8288702851053, 64.3322089287259, 70.631503325887, 73.7467411359864,
75.0455946199815, 75.1626352833933, 75.2103650876187, 75.847307227302,
76.2664664887898, 75.9597035034484, 74.8741528121846, 73.1011997224578,
71.1948353962884, 69.3793952975454, 67.0327783034717, 65.3139034779525,
66.3301198180553, 71.0738250731365, 75.6597839705943, 78.2166753387837,
79.1386797779249, 79.0288633683169, 78.2101505125164, 76.2758586255199,
72.5961761966909, 70.1034129076178, 74.2419874954717, 78.6198274986842,
81.0582894589522, 81.5209697500595, 80.068625390462, 77.3526071539828,
75.8539821150117, 76.4121267924749, 77.1478994743615, 77.5203620309114,
77.5098392443767, 76.9329837974676, 75.3798920050475, 74.5589610952538,
76.3953334991016, 77.3153099449496, 77.2353119939299, 76.8697404151972,
75.7134215909847, 73.2076050904008, 69.2454284173627, 65.4214730537506,
64.955060247986, 65.5110061107278, 66.8807566511488, 69.2270955791742,
72.2214922845998, 75.0625271428137, 76.6351339754036, 76.8139129810117,
75.7990426943671, 73.2496088097964, 69.09641624288, 63.4945456003489,
60.6843381479561, 61.7866787112843, 62.9570413827429, 63.9316807074578,
63.1075156570144, 58.7137441157515, 50.3964870174956, 44.4905730540085,
52.4481689717538, 62.1954870914451, 69.672967857164, 74.0479967188166,
75.7591526945457, 75.8210510297616, 75.2114052269417, 74.5941380893298,
74.3081652625197, 74.016899124087, 72.9460129879391, 70.7214630899912,
68.9065589365368, 68.5393818145094, 68.2948629761306, 68.828491044411,
71.215919920804, 73.5828542307994, 74.8778855205034, 75.0864007510338,
74.3259279423985, 73.3447459650121, 72.9299351456988, 73.0544662614739,
73.3561457607198, 73.1201867992631, 71.4061095238704, 67.225445273873,
60.5454938360571, 53.4642342588378, 49.8764672006431, 61.2843787534051,
69.6496913017386, 73.4694972258114, 74.2272716190469, 73.8760814747153,
73.5546867127489, 74.3368266042783, 75.0061122103054, 74.5030148831044,
73.8460398923785, 73.1744628943444, 72.1855711852974, 71.464609806732,
70.8422793823321, 70.0455356861978, 69.1676760076026, 68.8737306874642,
69.1429276919534, 69.5201331475928, 69.5627845995082, 68.7201184346438,
67.418283228119, 66.8197773819322, 66.3063805209716, 64.4512364325199,
60.5040946940446, 54.6823140586514, 49.0950579803872, 44.5384396751039,
41.2934084685615, 39.5779047936857), tmin = 0, tmax = 3.617125), class = c("list",
type = "IntensityTier", name = "H.IntensityTier")))
}


#' pitch.sample
#'
#' Returns sample Pitch object.
#'
#' @return Pitch
#' @export
#' @seealso \code{\link{tg.sample}}, \code{\link{pt.sample}}, \code{\link{it.sample}}, \code{\link{formant.sample}}
#'
#' @examples
#' pitch <- pitch.sample()
pitch.sample <- function() {
pitch <- structure(list(xmin = 0, xmax = 3.617125, nx = 358, dx = 0.01, 
x1 = 0.0235625, t = c(0.0235625, 0.0335625, 0.0435625, 0.0535625, 
0.0635625, 0.0735625, 0.0835625, 0.0935625, 0.1035625, 0.1135625, 
0.1235625, 0.1335625, 0.1435625, 0.1535625, 0.1635625, 0.1735625, 
0.1835625, 0.1935625, 0.2035625, 0.2135625, 0.2235625, 0.2335625, 
0.2435625, 0.2535625, 0.2635625, 0.2735625, 0.2835625, 0.2935625, 
0.3035625, 0.3135625, 0.3235625, 0.3335625, 0.3435625, 0.3535625, 
0.3635625, 0.3735625, 0.3835625, 0.3935625, 0.4035625, 0.4135625, 
0.4235625, 0.4335625, 0.4435625, 0.4535625, 0.4635625, 0.4735625, 
0.4835625, 0.4935625, 0.5035625, 0.5135625, 0.5235625, 0.5335625, 
0.5435625, 0.5535625, 0.5635625, 0.5735625, 0.5835625, 0.5935625, 
0.6035625, 0.6135625, 0.6235625, 0.6335625, 0.6435625, 0.6535625, 
0.6635625, 0.6735625, 0.6835625, 0.6935625, 0.7035625, 0.7135625, 
0.7235625, 0.7335625, 0.7435625, 0.7535625, 0.7635625, 0.7735625, 
0.7835625, 0.7935625, 0.8035625, 0.8135625, 0.8235625, 0.8335625, 
0.8435625, 0.8535625, 0.8635625, 0.8735625, 0.8835625, 0.8935625, 
0.9035625, 0.9135625, 0.9235625, 0.9335625, 0.9435625, 0.9535625, 
0.9635625, 0.9735625, 0.9835625, 0.9935625, 1.0035625, 1.0135625, 
1.0235625, 1.0335625, 1.0435625, 1.0535625, 1.0635625, 1.0735625, 
1.0835625, 1.0935625, 1.1035625, 1.1135625, 1.1235625, 1.1335625, 
1.1435625, 1.1535625, 1.1635625, 1.1735625, 1.1835625, 1.1935625, 
1.2035625, 1.2135625, 1.2235625, 1.2335625, 1.2435625, 1.2535625, 
1.2635625, 1.2735625, 1.2835625, 1.2935625, 1.3035625, 1.3135625, 
1.3235625, 1.3335625, 1.3435625, 1.3535625, 1.3635625, 1.3735625, 
1.3835625, 1.3935625, 1.4035625, 1.4135625, 1.4235625, 1.4335625, 
1.4435625, 1.4535625, 1.4635625, 1.4735625, 1.4835625, 1.4935625, 
1.5035625, 1.5135625, 1.5235625, 1.5335625, 1.5435625, 1.5535625, 
1.5635625, 1.5735625, 1.5835625, 1.5935625, 1.6035625, 1.6135625, 
1.6235625, 1.6335625, 1.6435625, 1.6535625, 1.6635625, 1.6735625, 
1.6835625, 1.6935625, 1.7035625, 1.7135625, 1.7235625, 1.7335625, 
1.7435625, 1.7535625, 1.7635625, 1.7735625, 1.7835625, 1.7935625, 
1.8035625, 1.8135625, 1.8235625, 1.8335625, 1.8435625, 1.8535625, 
1.8635625, 1.8735625, 1.8835625, 1.8935625, 1.9035625, 1.9135625, 
1.9235625, 1.9335625, 1.9435625, 1.9535625, 1.9635625, 1.9735625, 
1.9835625, 1.9935625, 2.0035625, 2.0135625, 2.0235625, 2.0335625, 
2.0435625, 2.0535625, 2.0635625, 2.0735625, 2.0835625, 2.0935625, 
2.1035625, 2.1135625, 2.1235625, 2.1335625, 2.1435625, 2.1535625, 
2.1635625, 2.1735625, 2.1835625, 2.1935625, 2.2035625, 2.2135625, 
2.2235625, 2.2335625, 2.2435625, 2.2535625, 2.2635625, 2.2735625, 
2.2835625, 2.2935625, 2.3035625, 2.3135625, 2.3235625, 2.3335625, 
2.3435625, 2.3535625, 2.3635625, 2.3735625, 2.3835625, 2.3935625, 
2.4035625, 2.4135625, 2.4235625, 2.4335625, 2.4435625, 2.4535625, 
2.4635625, 2.4735625, 2.4835625, 2.4935625, 2.5035625, 2.5135625, 
2.5235625, 2.5335625, 2.5435625, 2.5535625, 2.5635625, 2.5735625, 
2.5835625, 2.5935625, 2.6035625, 2.6135625, 2.6235625, 2.6335625, 
2.6435625, 2.6535625, 2.6635625, 2.6735625, 2.6835625, 2.6935625, 
2.7035625, 2.7135625, 2.7235625, 2.7335625, 2.7435625, 2.7535625, 
2.7635625, 2.7735625, 2.7835625, 2.7935625, 2.8035625, 2.8135625, 
2.8235625, 2.8335625, 2.8435625, 2.8535625, 2.8635625, 2.8735625, 
2.8835625, 2.8935625, 2.9035625, 2.9135625, 2.9235625, 2.9335625, 
2.9435625, 2.9535625, 2.9635625, 2.9735625, 2.9835625, 2.9935625, 
3.0035625, 3.0135625, 3.0235625, 3.0335625, 3.0435625, 3.0535625, 
3.0635625, 3.0735625, 3.0835625, 3.0935625, 3.1035625, 3.1135625, 
3.1235625, 3.1335625, 3.1435625, 3.1535625, 3.1635625, 3.1735625, 
3.1835625, 3.1935625, 3.2035625, 3.2135625, 3.2235625, 3.2335625, 
3.2435625, 3.2535625, 3.2635625, 3.2735625, 3.2835625, 3.2935625, 
3.3035625, 3.3135625, 3.3235625, 3.3335625, 3.3435625, 3.3535625, 
3.3635625, 3.3735625, 3.3835625, 3.3935625, 3.4035625, 3.4135625, 
3.4235625, 3.4335625, 3.4435625, 3.4535625, 3.4635625, 3.4735625, 
3.4835625, 3.4935625, 3.5035625, 3.5135625, 3.5235625, 3.5335625, 
3.5435625, 3.5535625, 3.5635625, 3.5735625, 3.5835625, 3.5935625
), ceiling = 600, maxnCandidates = 15, frame = list(list(
intensity = 0.00661166360756471, nCandidates = 5, frequency = c(0, 
317.784801303693, 151.473571629285, 101.388449787185, 
75.148413679075), strength = c(0, 0.63499720317288, 0.512409026953771, 
0.375743541251148, 0.274454751217709)), list(intensity = 0.00913308633007843, 
nCandidates = 5, frequency = c(0, 314.098789702609, 151.414000301039, 
102.842547076027, 77.8005527039216), strength = c(0, 
0.640164797925622, 0.566160959416143, 0.378288281735255, 
0.239106751600409)), list(intensity = 0.00368538934316041, 
nCandidates = 3, frequency = c(0, 321.488246286418, 156.751011316438
), strength = c(0, 0.704761643457015, 0.39617684700198
)), list(intensity = 0.00289092266507821, nCandidates = 1, 
frequency = 0, strength = 0), list(intensity = 0.00283569949248335, 
nCandidates = 3, frequency = c(0, 324.22248951215, 158.25417311564
), strength = c(0, 0.414180527918068, 0.250648211921512
)), list(intensity = 0.0185560145773086, nCandidates = 3, 
frequency = c(0, 300.391089290152, 147.793479743364), 
strength = c(0, 0.618489062248302, 0.276003604989282)), 
list(intensity = 0.0152520106543565, nCandidates = 3, 
frequency = c(0, 296.216197048168, 148.922384798347
), strength = c(0, 0.53672690031368, 0.283081307322132
)), list(intensity = 0.134964407651245, nCandidates = 2, 
frequency = c(210.062730604157, 0), strength = c(0.523631296007945, 
0)), list(intensity = 0.187244394191304, nCandidates = 3, 
frequency = c(216.000196664877, 0, 108.3322024544
), strength = c(0.866366459508301, 0, 0.677597416860614
)), list(intensity = 0.206825331410057, nCandidates = 3, 
frequency = c(219.493067264917, 0, 109.982215319168
), strength = c(0.973329382476048, 0, 0.927799045152899
)), list(intensity = 0.270448641374209, nCandidates = 4, 
frequency = c(221.285940333729, 0, 112.841794450296, 
74.7973380354534), strength = c(0.977550499314864, 
0, 0.974843660757229, 0.983569554333727)), list(intensity = 0.429261208461253, 
nCandidates = 4, frequency = c(224.36498589873, 0, 
114.199586549906, 75.9223379602159), strength = c(0.92979113084382, 
0, 0.882101479705447, 0.804531515624334)), list(intensity = 0.75161875835959, 
nCandidates = 6, frequency = c(230.294721059186, 
455.738435006483, 0, 154.080991878842, 113.806473087304, 
75.4777138423209), strength = c(0.831094605461032, 
0.373107131676558, 0, 0.322895743268617, 0.648427051771529, 
0.431276569999532)), list(intensity = 0.597868488139777, 
nCandidates = 5, frequency = c(215.384932287278, 
524.072339854383, 0, 156.307568562362, 107.544451192046
), strength = c(0.687024367276181, 0.271417680438672, 
0, 0.283960618816305, 0.433682225798929)), list(intensity = 0.991062175171329, 
nCandidates = 8, frequency = c(203.822697661509, 
647.027684414885, 323.077291608285, 0, 155.455962454648, 
125.76940831745, 103.08596200953, 78.6385365430565
), strength = c(0.68620810963999, 0.507798540261371, 
0.443572206924092, 0, 0.354001715187514, 0.378869495080529, 
0.434234708296992, 0.260900828506867)), list(intensity = 0.696427925854709, 
nCandidates = 7, frequency = c(192.487360695774, 
653.912364947362, 537.535057670114, 304.891338393993, 
208.503732305801, 0, 95.514109640085), strength = c(0.598496026057943, 
0.352987784612916, 0.228480306768534, 0.284087052004266, 
0.398894716046829, 0, 0.3375650484358)), list(intensity = 0.755811083670709, 
nCandidates = 11, frequency = c(189.580336693526, 
2231.26747855272, 662.395465985823, 523.151491738432, 
297.36170264858, 207.15644757077, 0, 174.868643490878, 
94.7715025252216, 91.062838368346, 80.1594168246893
), strength = c(0.905738159824389, 0.324514954761419, 
0.252829360763034, 0.255378819250163, 0.237215314005982, 
0.296696148683359, 0, 0.290154835744944, 0.786977697690624, 
0.284071541123821, 0.250943554631383)), list(intensity = 0.648233322164766, 
nCandidates = 8, frequency = c(192.010434279107, 
532.176171860467, 296.2747354172, 0, 141.851380957963, 
114.715973779718, 95.8985554438124, 81.5752691086747
), strength = c(0.845702632148644, 0.35072196115177, 
0.314542257458184, 0, 0.339470466017936, 0.266327683457936, 
0.716724141324599, 0.297950259133744)), list(intensity = 0.476713630382569, 
nCandidates = 3, frequency = c(195.546951066892, 
0, 97.4437078632105), strength = c(0.880386983498845, 
0, 0.677572361602734)), list(intensity = 0.285124786285463, 
nCandidates = 3, frequency = c(195.850901240659, 
0, 97.4333048733023), strength = c(0.820545840285296, 
0, 0.617065293750273)), list(intensity = 0.091970623951273, 
nCandidates = 4, frequency = c(194.155083009587, 
0, 97.5620075990447, 80.0840362689604), strength = c(0.785993666136867, 
0, 0.600772744990029, 0.291441565443257)), list(intensity = 0.0449276439259641, 
nCandidates = 3, frequency = c(196.718508016374, 
0, 99.5436037067276), strength = c(0.725679653850576, 
0, 0.528992343074)), list(intensity = 0.0267637707014111, 
nCandidates = 3, frequency = c(0, 196.765231587302, 
82.2852627987487), strength = c(0, 0.556652644788352, 
0.278345035127359)), list(intensity = 0.0238982468177496, 
nCandidates = 6, frequency = c(0, 459.304510327323, 
196.527694125431, 137.376023754052, 98.5878415765475, 
81.3804303742136), strength = c(0, 0.356075585347403, 
0.671064195196881, 0.480632107228236, 0.303278444728469, 
0.415555576246745)), list(intensity = 0.0159244105000774, 
nCandidates = 7, frequency = c(0, 442.718222676033, 
402.123903225177, 199.191189384902, 140.497632012275, 
100.716637183804, 82.9248583288526), strength = c(0, 
0.293742911779686, 0.310470108083316, 0.573471442923847, 
0.402479718453185, 0.248132737861801, 0.485497227677822
)), list(intensity = 0.025402860129868, nCandidates = 3, 
frequency = c(0, 1996.26070506577, 96.5474944414951
), strength = c(0, 0.276340151233336, 0.232777559207711
)), list(intensity = 0.0170780564011297, nCandidates = 5, 
frequency = c(0, 277.10938635462, 138.412960512474, 
132.880278592794, 87.996518330162), strength = c(0, 
0.488614065216779, 0.246825786773928, 0.255488962023613, 
0.320996599149075)), list(intensity = 0.138504498489712, 
nCandidates = 4, frequency = c(263.360850890751, 
0, 131.686821353751, 88.5531396849766), strength = c(0.82501893977207, 
0, 0.644201998392056, 0.418612276017781)), list(intensity = 0.363069159540236, 
nCandidates = 4, frequency = c(270.839100386271, 
0, 135.265354271655, 90.1654310598919), strength = c(0.943611484490176, 
0, 0.831117371544996, 0.68249630784142)), list(intensity = 0.407798687535295, 
nCandidates = 4, frequency = c(273.781213701986, 
0, 137.001372511932, 91.3248218595095), strength = c(0.984412743237899, 
0, 0.951675806503736, 0.902713553998053)), list(intensity = 0.409261344055612, 
nCandidates = 4, frequency = c(274.477050697928, 
0, 137.264731703049, 91.5472732007807), strength = c(0.995614820627516, 
0, 0.990451597767268, 0.983448562098932)), list(intensity = 0.398679676096044, 
nCandidates = 4, frequency = c(273.731416381412, 
0, 136.872571938551, 91.2129800676896), strength = c(0.993194326303988, 
0, 0.98314462915119, 0.967319527672154)), list(intensity = 0.383508204155752, 
nCandidates = 4, frequency = c(269.116875870315, 
0, 134.508273611344, 89.4541478764199), strength = c(0.962825855782267, 
0, 0.881428052378758, 0.780993148173981)), list(intensity = 0.300070840972364, 
nCandidates = 4, frequency = c(255.938338875776, 
0, 127.188823687786, 83.4636563769746), strength = c(0.894690651901849, 
0, 0.724836412912702, 0.623424508363376)), list(intensity = 0.19647252452974, 
nCandidates = 4, frequency = c(249.020739362198, 
0, 121.891510715575, 80.7595042964573), strength = c(0.880510320666652, 
0, 0.740051093917028, 0.669582444568869)), list(intensity = 0.111698259666254, 
nCandidates = 6, frequency = c(253.605684139787, 
0, 124.623151198315, 119.379890589145, 114.219339542026, 
75.1281597214815), strength = c(0.739881578201596, 
0, 0.322467047199424, 0.350017390646262, 0.334269545861774, 
0.683638255310829)), list(intensity = 0.17237703676583, 
nCandidates = 4, frequency = c(255.081182343559, 
0, 127.630058437504, 84.649124275402), strength = c(0.921235424904108, 
0, 0.776621958179493, 0.54678777591579)), list(intensity = 0.324630652564354, 
nCandidates = 4, frequency = c(257.626948880897, 
0, 128.655496818759, 85.8525205659848), strength = c(0.970438522851478, 
0, 0.911166818151148, 0.818852623335839)), list(intensity = 0.465476772808375, 
nCandidates = 4, frequency = c(261.542408896129, 
0, 130.770290095665, 87.1955553366869), strength = c(0.981506246556562, 
0, 0.941646406645129, 0.884452185114741)), list(intensity = 0.568383380951546, 
nCandidates = 4, frequency = c(263.874974051543, 
0, 132.042665241222, 88.0101080580211), strength = c(0.986525906576428, 
0, 0.959223365548377, 0.925707996734761)), list(intensity = 0.60914388321234, 
nCandidates = 4, frequency = c(259.376303268924, 
0, 129.642001632376, 86.1952449457489), strength = c(0.964310658114859, 
0, 0.89652886874495, 0.829200686204785)), list(intensity = 0.495580790497318, 
nCandidates = 4, frequency = c(249.874050194761, 
0, 124.92718300964, 83.1157661790328), strength = c(0.973128762855237, 
0, 0.926514804973617, 0.874209668501622)), list(intensity = 0.383519622346053, 
nCandidates = 4, frequency = c(244.346302349768, 
0, 122.020331404151, 81.3342208706886), strength = c(0.978418611735232, 
0, 0.932501104723497, 0.874214824656319)), list(intensity = 0.27526848340016, 
nCandidates = 4, frequency = c(238.955773132525, 
0, 119.160260328092, 79.3310713199917), strength = c(0.966489914938073, 
0, 0.908088866919501, 0.849730632892237)), list(intensity = 0.202394661297927, 
nCandidates = 4, frequency = c(233.334171955406, 
0, 115.95461558914, 77.0412917234024), strength = c(0.940453682051556, 
0, 0.83895898069574, 0.72040901477789)), list(intensity = 0.105435108262854, 
nCandidates = 4, frequency = c(228.259396501552, 
0, 114.554383362701, 76.4701924272895), strength = c(0.90721427524521, 
0, 0.78397679901749, 0.655662669437258)), list(intensity = 0.0571093633149004, 
nCandidates = 4, frequency = c(238.600903437817, 
0, 119.340571030492, 78.8204494434198), strength = c(0.872346612434477, 
0, 0.822332412077814, 0.851857205781102)), list(intensity = 0.0415916617172664, 
nCandidates = 4, frequency = c(0, 252.5010423334, 
119.698237716869, 83.0599994579458), strength = c(0, 
0.478178279762213, 0.46451321820359, 0.311319584227159
)), list(intensity = 0.0559640651673295, nCandidates = 4, 
frequency = c(0, 288.155537891287, 119.037796137544, 
85.8757874724566), strength = c(0, 0.369774498068014, 
0.412991947382198, 0.473750820043508)), list(intensity = 0.166111618755876, 
nCandidates = 7, frequency = c(0, 1566.46854233447, 
295.19132148806, 247.629491380769, 111.467384951401, 
80.3620798222669, 76.8944439058481), strength = c(0, 
0.564934646166492, 0.375917882501341, 0.338227005184602, 
0.45930815914684, 0.342235822549382, 0.242981047435883
)), list(intensity = 0.134516410513064, nCandidates = 7, 
frequency = c(0, 1559.65775549726, 294.821411026309, 
247.568349266552, 113.161727091556, 80.9390316173198, 
77.3473185668509), strength = c(0, 0.586382026640044, 
0.462656755070066, 0.454512014042542, 0.37357498196999, 
0.297367889933125, 0.3116383629855)), list(intensity = 0.240806440604736, 
nCandidates = 4, frequency = c(256.704350631582, 
0, 126.881244713389, 83.5519634219772), strength = c(0.844083665636551, 
0, 0.552924354584506, 0.326558271814579)), list(intensity = 0.430870304073598, 
nCandidates = 4, frequency = c(250.505302942172, 
0, 124.970686103954, 83.2977243560392), strength = c(0.953394725921332, 
0, 0.850828802930205, 0.718247069574409)), list(intensity = 0.544793437781602, 
nCandidates = 4, frequency = c(245.871566074717, 
0, 122.939032502361, 81.9667621940836), strength = c(0.988477730970558, 
0, 0.957327928402101, 0.907834835832554)), list(intensity = 0.514968994812787, 
nCandidates = 4, frequency = c(240.46776707795, 0, 
120.22095163052, 80.1111466825946), strength = c(0.986774130405083, 
0, 0.951832661960307, 0.902138728605885)), list(intensity = 0.482132026584062, 
nCandidates = 4, frequency = c(231.739728498653, 
0, 115.741636661494, 77.0270094240102), strength = c(0.980457442294209, 
0, 0.937518321547727, 0.900356958499852)), list(intensity = 0.402421908971152, 
nCandidates = 4, frequency = c(224.096816353289, 
0, 112.093209491566, 74.7792904225713), strength = c(0.98301031594612, 
0, 0.960718465583681, 0.943152913817093)), list(intensity = 0.377976306201062, 
nCandidates = 3, frequency = c(218.31420157621, 0, 
109.268028444088), strength = c(0.942459360956609, 
0, 0.838721199425304)), list(intensity = 0.246203774077379, 
nCandidates = 3, frequency = c(208.571102020563, 
0, 104.059941227399), strength = c(0.957158730969074, 
0, 0.898684700415087)), list(intensity = 0.200864477507605, 
nCandidates = 3, frequency = c(202.605591647841, 
0, 100.913694478599), strength = c(0.972258854893643, 
0, 0.929571629587089)), list(intensity = 0.156796529201555, 
nCandidates = 3, frequency = c(196.42453309938, 0, 
97.813914451345), strength = c(0.950834132252949, 
0, 0.844498503167891)), list(intensity = 0.109485800449, 
nCandidates = 3, frequency = c(188.124951679469, 
0, 93.9866073311498), strength = c(0.918037066414704, 
0, 0.777829289989523)), list(intensity = 0.056775837396508, 
nCandidates = 3, frequency = c(190.255400192583, 
0, 96.9469166461626), strength = c(0.767384392612925, 
0, 0.555183030657784)), list(intensity = 0.0289600954414198, 
nCandidates = 3, frequency = c(0, 198.197016240048, 
100.724097188221), strength = c(0, 0.607173583281322, 
0.663920358359531)), list(intensity = 0.0356397207536833, 
nCandidates = 12, frequency = c(0, 1908.93561755217, 
203.774625637586, 186.453446814185, 164.334923795684, 
100.850278287409, 98.4026608081023, 95.9576979056624, 
93.4014542160198, 91.1129396135951, 89.0549222754958, 
87.1363750245893), strength = c(0, 0.641699178223994, 
0.541135851719391, 0.561823339165349, 0.383287742701368, 
0.283429675568134, 0.324684849961305, 0.316861840384008, 
0.314020879104734, 0.337393670136971, 0.332908382015272, 
0.348522408762747)), list(intensity = 0.018399107917913, 
nCandidates = 11, frequency = c(0, 3823.11161939261, 
1900.8697932831, 205.590511904586, 186.587424580988, 
98.6822919413325, 96.2315103156637, 93.6972707833307, 
91.6714885316453, 89.7653969356014, 87.4825095213696
), strength = c(0, 0.658351944106989, 0.587557901604443, 
0.425309035486411, 0.433689943675526, 0.334905034897598, 
0.374671050557229, 0.34310129056982, 0.388722171277775, 
0.360768210932517, 0.413524547573757)), list(intensity = 0.0170850802374064, 
nCandidates = 9, frequency = c(0, 3609.84440557802, 
1878.69283901782, 221.464932937686, 211.076665804002, 
199.99999583167, 190.554952991977, 98.474934111693, 
95.6222160163329), strength = c(0, 0.304633882626765, 
0.487804663039106, 0.234014522664338, 0.25161281023645, 
0.269652933716868, 0.299380544787878, 0.249898140761012, 
0.24934447103614)), list(intensity = 0.0286319717634553, 
nCandidates = 5, frequency = c(0, 3694.45086508186, 
1925.73583910001, 561.743349372308, 490.625292177059
), strength = c(0, 0.477293038129697, 0.368714285685137, 
0.317707036220719, 0.351800060771934)), list(intensity = 0.0431053582085635, 
nCandidates = 7, frequency = c(0, 3786.70910971346, 
1968.71757752171, 1319.82981531219, 195.827877773133, 
186.662602105414, 178.076903180599), strength = c(0, 
0.62272027804398, 0.430934942248292, 0.334419525463799, 
0.325633886207155, 0.36706257514732, 0.270483619754808
)), list(intensity = 0.124165852252092, nCandidates = 3, 
frequency = c(0, 227.675084317734, 115.352140984997
), strength = c(0, 0.470926080520469, 0.237185632319849
)), list(intensity = 0.327592547102233, nCandidates = 3, 
frequency = c(0, 207.442408823155, 102.34450052964
), strength = c(0, 0.655327098328991, 0.318249008015131
)), list(intensity = 0.344369137367622, nCandidates = 3, 
frequency = c(0, 189.793778325187, 96.0759013145381
), strength = c(0, 0.567366575209681, 0.238987791684054
)), list(intensity = 0.335979472342239, nCandidates = 5, 
frequency = c(0, 502.572642791714, 273.914303710737, 
174.902725778641, 82.8470051828451), strength = c(0, 
0.398415721550322, 0.260425968445486, 0.42553647531034, 
0.243467860061845)), list(intensity = 0.238231835153554, 
nCandidates = 6, frequency = c(0, 514.459636968076, 
264.211028936157, 128.246070435381, 101.511724288961, 
84.4617702031787), strength = c(0, 0.381659253663883, 
0.302358381041793, 0.377099929342574, 0.306057256217175, 
0.385621959886916)), list(intensity = 0.158025500199925, 
nCandidates = 7, frequency = c(130.339830499355, 
512.421021398201, 256.958267260473, 172.775375822677, 
0, 103.220675141613, 85.930204269787), strength = c(0.860211924054369, 
0.464166117572791, 0.480737233831904, 0.45835955712234, 
0, 0.441322615498245, 0.529551973941502)), list(intensity = 0.122977949353884, 
nCandidates = 4, frequency = c(131.422275593081, 
495.211631593905, 257.404555027451, 0), strength = c(0.796820450813852, 
0.298625973792736, 0.233067925283677, 0)), list(intensity = 0.109712069679151, 
nCandidates = 2, frequency = c(130.375240804352, 
0), strength = c(0.859034816879697, 0)), list(intensity = 0.119980140034517, 
nCandidates = 4, frequency = c(131.80845758233, 383.16425923225, 
0, 97.5870718931134), strength = c(0.827923272686366, 
0.232224595197116, 0, 0.298401156178963)), list(intensity = 0.157222739298022, 
nCandidates = 4, frequency = c(142.993210985898, 
415.102253959975, 0, 79.522307341791), strength = c(0.439802000511656, 
0.29340531664815, 0, 0.266059265234428)), list(intensity = 0.183983716292607, 
nCandidates = 3, frequency = c(163.086311438615, 
0, 81.1158259420419), strength = c(0.800660909264062, 
0, 0.629400802505087)), list(intensity = 0.193922346726875, 
nCandidates = 4, frequency = c(170.930003795472, 
0, 113.997702318261, 85.6087782969888), strength = c(0.895348970887168, 
0, 0.232133213426818, 0.750488235378765)), list(intensity = 0.212365087551668, 
nCandidates = 5, frequency = c(179.103957377679, 
356.118478200302, 0, 118.366276973104, 89.4511924591636
), strength = c(0.949390103774629, 0.330713776339204, 
0, 0.302029595485657, 0.876482953868561)), list(intensity = 0.238088798203792, 
nCandidates = 3, frequency = c(183.925712800319, 
0, 91.7163328160409), strength = c(0.942114867985279, 
0, 0.83441806122086)), list(intensity = 0.175615252744999, 
nCandidates = 3, frequency = c(183.708720734564, 
0, 91.4071778839264), strength = c(0.961980025229184, 
0, 0.931610679257383)), list(intensity = 0.162411889862675, 
nCandidates = 3, frequency = c(179.324279762828, 
0, 89.6345921946394), strength = c(0.986607625825366, 
0, 0.989099254308508)), list(intensity = 0.189438501308111, 
nCandidates = 3, frequency = c(179.815340050368, 
0, 90.1027630329783), strength = c(0.986235298387476, 
0, 0.974510763342943)), list(intensity = 0.245014324583361, 
nCandidates = 5, frequency = c(180.891628172382, 
363.850651923926, 0, 121.755168159353, 91.0920982825918
), strength = c(0.974381653139745, 0.408552409840826, 
0, 0.386225475443303, 0.923377846827554)), list(intensity = 0.294353338846599, 
nCandidates = 5, frequency = c(180.152499814796, 
363.457699421146, 0, 122.101645550255, 90.7642049381548
), strength = c(0.944232402470025, 0.556565655988087, 
0, 0.527835708233378, 0.851248635651528)), list(intensity = 0.278124031392317, 
nCandidates = 5, frequency = c(174.615487687711, 
352.98384517969, 0, 120.779896396218, 87.9621097518495
), strength = c(0.902661662646521, 0.362841902762546, 
0, 0.361900778132794, 0.792481292401258)), list(intensity = 0.342542763008383, 
nCandidates = 7, frequency = c(170.051914230606, 
495.219669086313, 278.233204151589, 0, 126.84367390137, 
105.83270301784, 86.4361527547212), strength = c(0.897676639311978, 
0.330131344583773, 0.276182087938552, 0, 0.273103426208936, 
0.298659521371886, 0.786374284874719)), list(intensity = 0.347980124451029, 
nCandidates = 7, frequency = c(168.286965420936, 
501.986086131919, 255.409753167062, 0, 128.154415816868, 
103.4817594013, 85.011578782566), strength = c(0.773167075151669, 
0.477515453445272, 0.453609888793233, 0, 0.365328012054801, 
0.372698505436425, 0.559193138385679)), list(intensity = 0.308789912637762, 
nCandidates = 4, frequency = c(161.690798518359, 
573.630317247639, 0, 80.9301543840338), strength = c(0.750299872909441, 
0.295939471982547, 0, 0.620489660493652)), list(intensity = 0.366110529059103, 
nCandidates = 7, frequency = c(157.248717185988, 
595.604698902731, 321.818826239251, 214.102138835008, 
0, 91.0479811786434, 78.8959507731918), strength = c(0.849290070211991, 
0.350961164160155, 0.237519764299298, 0.372018209476825, 
0, 0.261832928054084, 0.639436862397075)), list(intensity = 0.248745620048093, 
nCandidates = 5, frequency = c(153.43139380722, 596.209574518396, 
209.973903568538, 0, 76.0800642403211), strength = c(0.736937655098333, 
0.327819202244218, 0.311393403238336, 0, 0.455783978195072
)), list(intensity = 0.189405396492738, nCandidates = 4, 
frequency = c(150.018603806651, 0, 85.2131039551847, 
74.8297408325335), strength = c(0.795136007431405, 
0, 0.226835086418063, 0.967084056790216)), list(intensity = 0.161884196059411, 
nCandidates = 5, frequency = c(149.294032098336, 
600.227539039534, 200.189529232644, 0, 74.6474651034397
), strength = c(0.926678049391794, 0.238908960752344, 
0.231043116367875, 0, 0.895316400692312)), list(intensity = 0.159234458934821, 
nCandidates = 3, frequency = c(150.659001928989, 
0, 75.201584876191), strength = c(0.945590336996107, 
0, 0.909148360176822)), list(intensity = 0.180209790000816, 
nCandidates = 3, frequency = c(150.036514446679, 
0, 74.9803335060735), strength = c(0.811331512790025, 
0, 0.61863970523651)), list(intensity = 0.146482921135849, 
nCandidates = 2, frequency = c(145.597586703768, 
0), strength = c(0.864508617526256, 0)), list(intensity = 0.16863854636301, 
nCandidates = 2, frequency = c(144.096737362489, 
0), strength = c(0.709141368493784, 0)), list(intensity = 0.130786707768702, 
nCandidates = 2, frequency = c(138.389894719079, 
0), strength = c(0.765858915249239, 0)), list(intensity = 0.102919162509768, 
nCandidates = 2, frequency = c(135.058732367581, 
0), strength = c(0.637077530025605, 0)), list(intensity = 0.125272991771156, 
nCandidates = 3, frequency = c(139.947635859238, 
0, 127.418227412328), strength = c(0.508000181871023, 
0, 0.456008147903018)), list(intensity = 0.100900639564801, 
nCandidates = 3, frequency = c(139.801102125312, 
0, 126.252952929498), strength = c(0.506159365202971, 
0, 0.476147918344602)), list(intensity = 0.0974364487052879, 
nCandidates = 3, frequency = c(125.001688237588, 
137.23152075785, 0), strength = c(0.599359588089603, 
0.378857375934542, 0)), list(intensity = 0.0725111294033467, 
nCandidates = 2, frequency = c(132.863609653836, 
0), strength = c(0.724303936747755, 0)), list(intensity = 0.0831007648874302, 
nCandidates = 2, frequency = c(0, 162.425773006424
), strength = c(0, 0.267722785877413)), list(intensity = 0.0768907846871839, 
nCandidates = 4, frequency = c(0, 169.987759668818, 
86.6327404652576, 78.5468900388516), strength = c(0, 
0.370870479122913, 0.667790420318921, 0.244340504416465
)), list(intensity = 0.0781342147404943, nCandidates = 3, 
frequency = c(0, 170.776680704749, 77.5139105541115
), strength = c(0, 0.24389423757927, 0.49915618286007
)), list(intensity = 0.0537879043069419, nCandidates = 5, 
frequency = c(0, 2021.44859336439, 206.644938982846, 
193.978100862528, 79.9742612138714), strength = c(0, 
0.72702597392911, 0.401623130082027, 0.414530214546554, 
0.406282641408124)), list(intensity = 0.0383628815830539, 
nCandidates = 3, frequency = c(0, 176.898113911317, 
83.9477276316494), strength = c(0, 0.53100757231577, 
0.746254989554293)), list(intensity = 0.0321891074108019, 
nCandidates = 3, frequency = c(0, 186.513217045297, 
92.5559866194371), strength = c(0, 0.724295162736646, 
0.497696591024692)), list(intensity = 0.0161647386803492, 
nCandidates = 10, frequency = c(0, 2051.0121300435, 
973.761900440482, 229.133177763009, 206.944112485143, 
187.068231832908, 171.668521312365, 102.288711255071, 
97.3631724303681, 93.5798037489356), strength = c(0, 
0.680351654488061, 0.241698603261229, 0.324252197966884, 
0.589758443709781, 0.68168931125966, 0.542990064202085, 
0.446841641470604, 0.637460080184658, 0.63422840440235
)), list(intensity = 0.016279173461523, nCandidates = 11, 
frequency = c(0, 2028.20172390774, 1006.00707743522, 
224.715235582682, 205.518716413218, 186.664436067005, 
170.912120235253, 104.692019074807, 96.9108401768089, 
93.5772654659533, 89.658715835633), strength = c(0, 
0.656974564594302, 0.245560794530803, 0.335689217703584, 
0.478193446435208, 0.502586990595421, 0.415911881696345, 
0.28639704142267, 0.430500271867336, 0.489140684150775, 
0.3796140100812)), list(intensity = 0.0163200129661398, 
nCandidates = 13, frequency = c(0, 2040.57893437216, 
1009.86814949833, 251.022988532859, 223.238839607857, 
200.935780068081, 182.949423362975, 168.543843528746, 
100.949787427175, 96.3422030906933, 92.1042935290816, 
88.1253533045635, 84.5261348054218), strength = c(0, 
0.708595651015412, 0.364333468492035, 0.242987857730907, 
0.370059977312129, 0.449035286125448, 0.443246837667864, 
0.374397946554523, 0.29817054576275, 0.342239236579613, 
0.392352591488953, 0.402296516984129, 0.307651957939897
)), list(intensity = 0.0240808389654847, nCandidates = 8, 
frequency = c(0, 1960.73170142276, 969.632371387741, 
638.239077597754, 476.005823534887, 184.710793848775, 
168.616736032579, 74.7203099636634), strength = c(0, 
0.671235017543838, 0.416298032124121, 0.305164166678332, 
0.263798953573339, 0.291000641964162, 0.326450082171609, 
0.237773856810754)), list(intensity = 0.0241310270058479, 
nCandidates = 12, frequency = c(0, 1915.31244247233, 
949.242513697951, 630.468643368862, 472.39349348927, 
376.48565431438, 134.906164211951, 126.176507716645, 
118.350287033276, 111.619316273292, 105.268993912267, 
99.8403283353144), strength = c(0, 0.681608253768584, 
0.513246296694189, 0.445371607288202, 0.476665588489065, 
0.290145405489845, 0.267456902093265, 0.305256765053991, 
0.311209002030392, 0.339514687901598, 0.3535398143829, 
0.344907319125949)), list(intensity = 0.0275445191205488, 
nCandidates = 13, frequency = c(0, 1938.52546637097, 
963.357481840218, 647.940665300309, 482.290108657751, 
136.164640122633, 127.374560955547, 119.638671548496, 
112.468476524985, 100.92387012959, 96.2383348489385, 
91.5196667534521, 76.9942729775291), strength = c(0, 
0.623945096083908, 0.608740233985311, 0.43934580615708, 
0.398001877774686, 0.250792855849129, 0.310090522501412, 
0.265347832826078, 0.320632922448758, 0.271822352789245, 
0.268071844871452, 0.291043733716028, 0.242856290661411
)), list(intensity = 0.0267067403312465, nCandidates = 8, 
frequency = c(0, 2055.34655551324, 968.564478269904, 
645.985735687531, 478.230233524082, 387.040231946262, 
80.0309124667244, 76.9522728369977), strength = c(0, 
0.471946122909001, 0.383007352508345, 0.267455764941803, 
0.33763444144257, 0.331492050335735, 0.24301171423079, 
0.242756744135936)), list(intensity = 0.0268614343702595, 
nCandidates = 10, frequency = c(0, 2217.85616089958, 
465.203204353921, 386.851161392659, 326.811085967995, 
282.172766489939, 163.840448066374, 151.627726060578, 
103.884569580518, 85.2445366381755), strength = c(0, 
0.491357155145159, 0.276902776771386, 0.312268178740102, 
0.358188283756764, 0.418353216362755, 0.376306466631458, 
0.311526669582155, 0.287042500826653, 0.26328208786265
)), list(intensity = 0.0306979088679574, nCandidates = 15, 
frequency = c(0, 2040.5045550541, 1001.59909461915, 
75.3774635995993, 98.3094354585583, 391.124466558489, 
326.73457751473, 280.146122434114, 245.536664213199, 
217.980372978315, 196.516710137365, 178.990586003491, 
164.018830720319, 93.7911479280441, 103.18991615584
), strength = c(0, 0.592598269279788, 0.386879546520809, 
0.315997706162161, 0.346050337118918, 0.434745326123358, 
0.376431032228269, 0.406729014782796, 0.332380096901721, 
0.318240222648594, 0.433923620226547, 0.438930939778947, 
0.415555848082896, 0.315955937864089, 0.343566655592212
)), list(intensity = 0.0309986115135627, nCandidates = 15, 
frequency = c(0, 2121.24008501743, 1012.44215568636, 
685.610316920113, 216.358163877383, 196.253692706054, 
180.132582473918, 164.651957051181, 152.693019727541, 
85.938300500646, 123.052041133793, 115.498177862526, 
109.698397923936, 103.81226680978, 98.6251784434412
), strength = c(0, 0.553528320925224, 0.334574258652607, 
0.361348614110291, 0.29475088192934, 0.415330915509367, 
0.366167036800171, 0.371544072120017, 0.346517002942064, 
0.321292539831097, 0.272598483964282, 0.381004698795401, 
0.428812269221717, 0.269259694785024, 0.297143653557351
)), list(intensity = 0.0350219507906984, nCandidates = 6, 
frequency = c(0, 2115.59891096306, 109.724458057489, 
104.206543372893, 85.7735902898466, 76.1521178130819
), strength = c(0, 0.341644477239409, 0.409063516500408, 
0.318601049353612, 0.287734594541105, 0.41475847528224
)), list(intensity = 0.0388830345040125, nCandidates = 11, 
frequency = c(0, 1948.38367054115, 940.328088020545, 
661.599898649879, 482.430066509712, 276.937843524904, 
243.847264303888, 215.138376152358, 194.005925524961, 
162.289409055077, 150.622955157431), strength = c(0, 
0.485046642306992, 0.339095802041285, 0.227936578893873, 
0.287868309758534, 0.253051303150711, 0.292831910194396, 
0.264788692948752, 0.252624985238574, 0.263611426919162, 
0.28083071140549)), list(intensity = 0.0319008894173683, 
nCandidates = 5, frequency = c(0, 2088.70324943592, 
472.12483793924, 387.259370059343, 194.34405463944
), strength = c(0, 0.370699300436913, 0.302802890180987, 
0.416750050219285, 0.339632842344688)), list(intensity = 0.0321873139308312, 
nCandidates = 5, frequency = c(0, 2212.11233699973, 
384.163683790631, 193.762249869276, 128.457407402305
), strength = c(0, 0.392561004093572, 0.293726223246955, 
0.259652229060289, 0.274254923451763)), list(intensity = 0.0274004039850075, 
nCandidates = 4, frequency = c(0, 2251.2790871742, 
331.862196288123, 79.888251965938), strength = c(0, 
0.47985399088044, 0.238316917590639, 0.253919133252271
)), list(intensity = 0.0222995728233127, nCandidates = 6, 
frequency = c(0, 2185.7365888285, 382.996366517363, 
304.38645108545, 79.9930309443734, 77.1845720437213
), strength = c(0, 0.476923725874354, 0.237778518620874, 
0.241938149370199, 0.309445080326464, 0.278172997119598
)), list(intensity = 0.0168573302613724, nCandidates = 9, 
frequency = c(0, 2050.12659306769, 462.473762943759, 
375.921594856427, 311.229027357984, 168.270437481074, 
107.99295092916, 84.0272141176801, 80.442347391568
), strength = c(0, 0.45041521011169, 0.325902062444105, 
0.370365393307841, 0.266094250034845, 0.283806319128326, 
0.311613380142667, 0.35232065904801, 0.421620384895905
)), list(intensity = 0.0113155301923687, nCandidates = 4, 
frequency = c(0, 1981.70235962144, 375.678831153932, 
317.357502360662), strength = c(0, 0.480559297794555, 
0.312339065598395, 0.403937470530178)), list(intensity = 0.00956910300579621, 
nCandidates = 7, frequency = c(0, 2016.85570453636, 
316.794191719078, 286.217757735934, 126.189523926436, 
90.1964891288369, 87.025150093858), strength = c(0, 
0.485282083217215, 0.412349876385871, 0.464645213104312, 
0.235786130564677, 0.326306666905718, 0.350947363592153
)), list(intensity = 0.00896847011529329, nCandidates = 5, 
frequency = c(0, 311.258386172192, 162.512361302994, 
108.616931157024, 81.099817318143), strength = c(0, 
0.577515621584649, 0.450989359099093, 0.493753186911295, 
0.591055530583215)), list(intensity = 0.010935708744902, 
nCandidates = 3, frequency = c(0, 358.60638021133, 
166.880745156805), strength = c(0, 0.509798460814934, 
0.301904096720598)), list(intensity = 0.00545386304876869, 
nCandidates = 6, frequency = c(0, 374.668088963935, 
319.720435200605, 99.7130406198236, 78.758215791118, 
75.708060824411), strength = c(0, 0.568939075398628, 
0.389853646659904, 0.324646070403763, 0.421615745718691, 
0.30708524066884)), list(intensity = 0.00819849208947641, 
nCandidates = 5, frequency = c(0, 313.279739387106, 
157.049774052972, 106.11622877969, 79.2694314834066
), strength = c(0, 0.646974187313917, 0.601433095526268, 
0.428290148785388, 0.44193695648518)), list(intensity = 0.00537385599824653, 
nCandidates = 5, frequency = c(0, 316.831652265279, 
156.335562551055, 104.769203951803, 78.7933646611846
), strength = c(0, 0.432232655389309, 0.613007354442065, 
0.34906516040927, 0.706056712522457)), list(intensity = 0.00530530050189526, 
nCandidates = 6, frequency = c(0, 319.40482256137, 
154.97554007692, 104.998700949344, 79.428247783401, 
77.2228158165212), strength = c(0, 0.59556677026301, 
0.553407237165651, 0.39367576766175, 0.268532874149868, 
0.252290242613087)), list(intensity = 0.00473438386250442, 
nCandidates = 4, frequency = c(0, 359.374726569288, 
155.148585837494, 76.7211756131496), strength = c(0, 
0.233572877845338, 0.256948513075739, 0.326697865384018
)), list(intensity = 0.00399058747296633, nCandidates = 1, 
frequency = 0, strength = 0), list(intensity = 0.00451080533748643, 
nCandidates = 3, frequency = c(0, 296.845306254089, 
153.629921312811), strength = c(0, 0.422023795575843, 
0.370026535305398)), list(intensity = 0.00444873547517472, 
nCandidates = 7, frequency = c(0, 289.501452035434, 
257.38545233511, 150.001893021024, 137.979313399692, 
94.1254053133644, 89.6033114879101), strength = c(0, 
0.483228960681796, 0.445870705146022, 0.339186335282498, 
0.400598909993327, 0.394269584432962, 0.355453787093813
)), list(intensity = 0.00554721310629248, nCandidates = 3, 
frequency = c(0, 300.544450365217, 151.624736141861
), strength = c(0, 0.49245405488948, 0.256734451516161
)), list(intensity = 0.00391501747669147, nCandidates = 4, 
frequency = c(0, 376.589634674607, 318.626497110548, 
80.9130957995914), strength = c(0, 0.295020410806454, 
0.29665886108743, 0.320234161782634)), list(intensity = 0.0032292591128146, 
nCandidates = 4, frequency = c(0, 336.255613540936, 
171.866943505907, 85.1591040412426), strength = c(0, 
0.492877861742002, 0.347684999200759, 0.402027215661019
)), list(intensity = 0.00293514982383441, nCandidates = 3, 
frequency = c(0, 368.606816300489, 161.932012275184
), strength = c(0, 0.257063802930331, 0.348828234554626
)), list(intensity = 0.00300226142211372, nCandidates = 2, 
frequency = c(0, 76.510977204311), strength = c(0, 
0.240636086109974)), list(intensity = 0.00359165703720317, 
nCandidates = 3, frequency = c(0, 340.086857731709, 
77.0168593712354), strength = c(0, 0.573609833985307, 
0.548492300089106)), list(intensity = 0.00478518917591807, 
nCandidates = 4, frequency = c(0, 322.563986180204, 
160.538333823867, 107.560696752262), strength = c(0, 
0.663097240230658, 0.392201270451319, 0.315219315976123
)), list(intensity = 0.00456511786434639, nCandidates = 4, 
frequency = c(0, 323.310662004798, 135.244365232097, 
95.4559685579605), strength = c(0, 0.441167531134259, 
0.266464409459629, 0.289479147285058)), list(intensity = 0.00273251202562359, 
nCandidates = 3, frequency = c(0, 357.835990758187, 
77.7808220715912), strength = c(0, 0.430629382942367, 
0.452018970154889)), list(intensity = 0.00341668290832692, 
nCandidates = 2, frequency = c(0, 386.691496363779
), strength = c(0, 0.49762758397466)), list(intensity = 0.00352203866179285, 
nCandidates = 2, frequency = c(0, 370.924976447932
), strength = c(0, 0.482789646602084)), list(intensity = 0.00327929623290771, 
nCandidates = 2, frequency = c(0, 441.727664536792
), strength = c(0, 0.411274500353517)), list(intensity = 0.00365509583248408, 
nCandidates = 2, frequency = c(0, 290.712887556992
), strength = c(0, 0.324192269177185)), list(intensity = 0.00282482692781831, 
nCandidates = 2, frequency = c(0, 298.891521994539
), strength = c(0, 0.312529168298693)), list(intensity = 0.00335441120658351, 
nCandidates = 2, frequency = c(0, 298.98020014725
), strength = c(0, 0.281582281143646)), list(intensity = 0.00354258993383922, 
nCandidates = 2, frequency = c(0, 294.575016807789
), strength = c(0, 0.469272860883214)), list(intensity = 0.00243642596125586, 
nCandidates = 3, frequency = c(0, 374.561796227257, 
302.556783832395), strength = c(0, 0.469044101716265, 
0.479544866035821)), list(intensity = 0.00192802831625506, 
nCandidates = 7, frequency = c(0, 1660.74600853516, 
792.917193142583, 511.342414684107, 379.176504839606, 
304.419444502561, 256.576658467479), strength = c(0, 
0.766040826736848, 0.464585452464441, 0.315613613899723, 
0.381709669398123, 0.463509204018741, 0.397054826476926
)), list(intensity = 0.00170548329808753, nCandidates = 6, 
frequency = c(0, 1783.99275845199, 303.481821701138, 
257.57977153917, 171.288149587976, 77.2271019473224
), strength = c(0, 0.654714333508918, 0.270064495746595, 
0.279681296953896, 0.23571415452765, 0.301027000598157
)), list(intensity = 0.00197400149083844, nCandidates = 4, 
frequency = c(0, 167.861079732149, 150.092034972701, 
77.6068314045033), strength = c(0, 0.361735998653441, 
0.309165249118274, 0.335594334124477)), list(intensity = 0.0015443082573052, 
nCandidates = 2, frequency = c(0, 148.838197548985
), strength = c(0, 0.333719710289787)), list(intensity = 0.00132245095376567, 
nCandidates = 1, frequency = 0, strength = 0), list(
intensity = 0.00224444305106738, nCandidates = 2, 
frequency = c(0, 3529.00541043567), strength = c(0, 
0.946502687890435)), list(intensity = 0.00140052946727986, 
nCandidates = 6, frequency = c(0, 3043.92999925427, 
991.141117169425, 740.941929654551, 576.969764004547, 
414.771348838424), strength = c(0, 0.869888204813727, 
0.640057156476245, 0.524431218428126, 0.401495285652879, 
0.245529286091055)), list(intensity = 0.00219257426438688, 
nCandidates = 4, frequency = c(0, 3211.57638359287, 
1262.1786532882, 760.236395002586), strength = c(0, 
0.774390793799626, 0.615316064271755, 0.440041977129419
)), list(intensity = 0.00309174659942217, nCandidates = 13, 
frequency = c(0, 3760.92929053161, 1924.96013664079, 
1281.58704025962, 968.276352639694, 772.731643898735, 
84.167911404724, 82.3268899060811, 80.7380707192261, 
79.0584699725794, 77.550599605601, 75.9999762995456, 
74.6239458778758), strength = c(0, 0.85322122860761, 
0.812870527130509, 0.697880333285132, 0.580686594984667, 
0.467426030764418, 0.240284018519935, 0.254467685211563, 
0.309277768358724, 0.315476614600009, 0.317806512647772, 
0.284343120178807, 0.253148170971912)), list(intensity = 0.00164831583675268, 
nCandidates = 10, frequency = c(0, 3844.45700133048, 
1933.09932167346, 1291.50800305092, 972.814525900189, 
779.242509999516, 651.700725456687, 81.7345477586982, 
80.096494606152, 78.5214313374193), strength = c(0, 
0.889370884090387, 0.833045847431368, 0.724945655183349, 
0.61569970579311, 0.504111414399567, 0.362277433417237, 
0.427719302627422, 0.442100889042534, 0.418831876049194
)), list(intensity = 0.00120026133160441, nCandidates = 4, 
frequency = c(0, 177.627280273889, 92.1020550838771, 
87.9437799687599), strength = c(0, 0.506349696319605, 
0.334939399354998, 0.319423776145099)), list(intensity = 0.00114426823503588, 
nCandidates = 2, frequency = c(0, 170.227473277334
), strength = c(0, 0.438622117696867)), list(intensity = 0.00103378136321427, 
nCandidates = 1, frequency = 0, strength = 0), list(
intensity = 0.0012710457351298, nCandidates = 1, 
frequency = 0, strength = 0), list(intensity = 0.001414310725328, 
nCandidates = 2, frequency = c(0, 125.523577844629
), strength = c(0, 0.543767874309642)), list(intensity = 0.00106900635238944, 
nCandidates = 2, frequency = c(0, 139.309818053296
), strength = c(0, 0.385362425538855)), list(intensity = 0.00115393953349641, 
nCandidates = 1, frequency = 0, strength = 0), list(
intensity = 0.00192665821104585, nCandidates = 2, 
frequency = c(0, 74.5704203176605), strength = c(0, 
0.353054355470049)), list(intensity = 0.00165893948759695, 
nCandidates = 2, frequency = c(0, 76.9255417229139
), strength = c(0, 0.474561728977028)), list(intensity = 0.00251896669254895, 
nCandidates = 1, frequency = 0, strength = 0), list(
intensity = 0.00210174162393861, nCandidates = 1, 
frequency = 0, strength = 0), list(intensity = 0.0029096150251369, 
nCandidates = 1, frequency = 0, strength = 0), list(
intensity = 0.00116463018418671, nCandidates = 4, 
frequency = c(0, 249.160973551017, 212.508226569453, 
187.10360591085), strength = c(0, 0.375070927331892, 
0.38820853691408, 0.393874418357276)), list(intensity = 0.00179825970979114, 
nCandidates = 2, frequency = c(0, 289.377505580982
), strength = c(0, 0.539468925166673)), list(intensity = 0.00626409570911762, 
nCandidates = 3, frequency = c(0, 283.866646306785, 
140.100831397031), strength = c(0, 0.597881897680934, 
0.249232704845807)), list(intensity = 0.00600644698409517, 
nCandidates = 2, frequency = c(0, 97.1937660372836
), strength = c(0, 0.254182789431712)), list(intensity = 0.0190985793671723, 
nCandidates = 1, frequency = 0, strength = 0), list(
intensity = 0.341964494331595, nCandidates = 3, frequency = c(0, 
194.243149365751, 101.056009574841), strength = c(0, 
0.351777360021178, 0.458599017763254)), list(intensity = 0.272815850370525, 
nCandidates = 3, frequency = c(209.639731409055, 
0, 104.58901164229), strength = c(0.85114135147684, 
0, 0.844813984538187)), list(intensity = 0.31975592398474, 
nCandidates = 3, frequency = c(212.651774291658, 
0, 106.356370285676), strength = c(0.976251721164752, 
0, 0.944694918009424)), list(intensity = 0.318756881987365, 
nCandidates = 3, frequency = c(214.263711114672, 
0, 107.473052695623), strength = c(0.906655709057959, 
0, 0.902777087335311)), list(intensity = 0.2976769246768, 
nCandidates = 3, frequency = c(208.596838587026, 
0, 104.525808204114), strength = c(0.811008984973887, 
0, 0.775911557687484)), list(intensity = 0.348073814906662, 
nCandidates = 3, frequency = c(207.417017067516, 
0, 103.694009993891), strength = c(0.9624871232866, 
0, 0.963314211675934)), list(intensity = 0.432836907607196, 
nCandidates = 6, frequency = c(205.896156071496, 
410.060466204187, 0, 136.672851561426, 102.914788568274, 
81.9358027839268), strength = c(0.982654642316033, 
0.379099601955781, 0, 0.366998028495124, 0.952408497457382, 
0.349748844243844)), list(intensity = 0.456750697055504, 
nCandidates = 6, frequency = c(204.237633185179, 
405.184865463074, 0, 135.037246864088, 102.08658433808, 
81.0208726891675), strength = c(0.987380702348517, 
0.45227259842461, 0, 0.446583725244609, 0.961144304636473, 
0.439394154436946)), list(intensity = 0.430920857686457, 
nCandidates = 6, frequency = c(203.958769396148, 
400.775165814778, 0, 134.190573008992, 101.864771807866, 
80.6905148205989), strength = c(0.980238023375205, 
0.477309192968928, 0, 0.473218139444152, 0.942600893035297, 
0.456223852176921)), list(intensity = 0.380250910366769, 
nCandidates = 6, frequency = c(206.17780711045, 408.019160940877, 
0, 135.705254394256, 103.046117531202, 81.3110915364288
), strength = c(0.977138547476754, 0.369089208696306, 
0, 0.352985239401914, 0.923532644584352, 0.328976357605712
)), list(intensity = 0.306956722263138, nCandidates = 3, 
frequency = c(209.024291208526, 0, 104.48124040031
), strength = c(0.969819159327634, 0, 0.907007769278627
)), list(intensity = 0.256465210396632, nCandidates = 3, 
frequency = c(211.176511609948, 0, 105.743662803447
), strength = c(0.957970837433707, 0, 0.87777418436892
)), list(intensity = 0.18013870557881, nCandidates = 3, 
frequency = c(208.611571275892, 0, 103.276864332692
), strength = c(0.953404770353284, 0, 0.895419582034931
)), list(intensity = 0.167664363451655, nCandidates = 3, 
frequency = c(198.818598493777, 0, 99.0123638111519
), strength = c(0.961973912411003, 0, 0.889261069864678
)), list(intensity = 0.131230881301339, nCandidates = 3, 
frequency = c(192.232732519572, 0, 95.5205963119753
), strength = c(0.950800034871977, 0, 0.87317254255141
)), list(intensity = 0.104037009126279, nCandidates = 3, 
frequency = c(190.45408958964, 0, 94.4753441264191
), strength = c(0.945186942209758, 0, 0.8736549793884
)), list(intensity = 0.0871333802266282, nCandidates = 3, 
frequency = c(196.591038969483, 0, 98.5984651349874
), strength = c(0.879741601665408, 0, 0.845637816801556
)), list(intensity = 0.0852308283914665, nCandidates = 3, 
frequency = c(209.64764000854, 0, 102.350425477047
), strength = c(0.815587848678102, 0, 0.831901742481076
)), list(intensity = 0.0925281800278967, nCandidates = 3, 
frequency = c(217.914090385371, 0, 109.661094000464
), strength = c(0.840239509007077, 0, 0.765453079693803
)), list(intensity = 0.0830127537042488, nCandidates = 6, 
frequency = c(229.344890791382, 3670.65418486918, 
0, 217.873014114108, 112.30260494888, 75.3188841166103
), strength = c(0.874589231645988, 0.879217964643347, 
0, 0.857921689830802, 0.932583278721402, 0.97746498620787
)), list(intensity = 0.194344715591331, nCandidates = 4, 
frequency = c(241.961023002769, 0, 118.584367605627, 
78.2419816873811), strength = c(0.906536766080793, 
0, 0.808853907751611, 0.697517052740716)), list(intensity = 0.269930002041288, 
nCandidates = 4, frequency = c(245.341260835484, 
0, 123.809715760518, 82.5789307510145), strength = c(0.950043660125291, 
0, 0.883867898252761, 0.790994250990052)), list(intensity = 0.372031552469092, 
nCandidates = 4, frequency = c(258.404655176344, 
0, 128.946628414461, 85.9218080976791), strength = c(0.976857855272164, 
0, 0.924186091699151, 0.853363950763997)), list(intensity = 0.423272816968842, 
nCandidates = 4, frequency = c(264.497858603965, 
0, 132.291776102843, 88.1296079656946), strength = c(0.990986307916819, 
0, 0.978178614629521, 0.965109834241627)), list(intensity = 0.455794067010358, 
nCandidates = 4, frequency = c(267.897181403162, 
0, 133.969088721992, 89.2716124672092), strength = c(0.994136913295785, 
0, 0.982039015989769, 0.963672579904814)), list(intensity = 0.444582141295232, 
nCandidates = 4, frequency = c(269.544598222722, 
0, 134.739457909815, 89.8200322457203), strength = c(0.997305968448275, 
0, 0.993019791301087, 0.988467448863387)), list(intensity = 0.405600148393206, 
nCandidates = 4, frequency = c(272.401183884358, 
0, 136.04775218621, 90.6967582430866), strength = c(0.991605499365621, 
0, 0.976715618686609, 0.961947282287602)), list(intensity = 0.322907555551538, 
nCandidates = 4, frequency = c(275.224750717397, 
0, 137.534814837244, 91.5580265002294), strength = c(0.984313232573722, 
0, 0.950176831153541, 0.90308077611762)), list(intensity = 0.235532234829836, 
nCandidates = 4, frequency = c(268.332220166645, 
0, 133.673801011342, 89.0825663305643), strength = c(0.964273774311841, 
0, 0.889766879735806, 0.788574976020356)), list(intensity = 0.13069377475767, 
nCandidates = 4, frequency = c(257.354140347377, 
0, 128.460773018166, 85.7160949242406), strength = c(0.965949058777887, 
0, 0.936860319988928, 0.926378141374655)), list(intensity = 0.0876171996317254, 
nCandidates = 4, frequency = c(263.152167356754, 
0, 131.975290938433, 87.9392150897828), strength = c(0.958733131773274, 
0, 0.977411663198594, 0.966599818320843)), list(intensity = 0.130732417981027, 
nCandidates = 4, frequency = c(270.182436280803, 
0, 134.50981503711, 89.6356933655667), strength = c(0.947405504042873, 
0, 0.925525548982833, 0.925153525738826)), list(intensity = 0.208216332755026, 
nCandidates = 4, frequency = c(282.526571900806, 
0, 140.817019966472, 93.7121398492931), strength = c(0.961197602327398, 
0, 0.903765582268693, 0.821087122963563)), list(intensity = 0.341008398019681, 
nCandidates = 4, frequency = c(290.817631479134, 
0, 145.29512289266, 96.7935504298918), strength = c(0.986677441760239, 
0, 0.95757163331232, 0.915670673770376)), list(intensity = 0.467217676441936, 
nCandidates = 4, frequency = c(290.309405567278, 
0, 145.169336538111, 96.7856005585177), strength = c(0.99355669896692, 
0, 0.976429002241724, 0.948246490810613)), list(intensity = 0.509989933687065, 
nCandidates = 4, frequency = c(287.470160062553, 
0, 143.761522065548, 95.834177179872), strength = c(0.993852585951028, 
0, 0.976785177483332, 0.94913179864259)), list(intensity = 0.473936585169424, 
nCandidates = 4, frequency = c(281.211085097782, 
0, 140.711951343187, 93.7833319554607), strength = c(0.985419494026205, 
0, 0.955087172126499, 0.920070120704495)), list(intensity = 0.445691981683057, 
nCandidates = 4, frequency = c(274.595809563152, 
0, 138.299320039888, 91.8404534340631), strength = c(0.92972810533151, 
0, 0.875882055874238, 0.809997104321082)), list(intensity = 0.369395583688504, 
nCandidates = 7, frequency = c(262.780653649015, 
294.882207694466, 0, 139.086826114323, 131.229567773764, 
90.5580729040311, 87.3993218609788), strength = c(0.895448957820328, 
0.710948258039999, 0, 0.635187408842022, 0.794812562233979, 
0.64573854885205, 0.850623831460754)), list(intensity = 0.439808588060085, 
nCandidates = 11, frequency = c(262.426351901909, 
2238.23675245423, 297.715109104053, 0, 235.205119027167, 
139.541229839798, 131.195713409929, 124.066060480561, 
91.092022136958, 87.4651758908675, 84.2741844860077
), strength = c(0.972744912262668, 0.635269168498732, 
0.636319044037193, 0, 0.60988322065099, 0.607550427492032, 
0.939919837548286, 0.604512023004737, 0.589911583819149, 
0.932300239239562, 0.621717507162968)), list(intensity = 0.418281417539455, 
nCandidates = 12, frequency = c(263.826052710528, 
2237.4057553915, 299.308531615673, 0, 236.256632827228, 
140.233799148656, 131.91290777091, 124.726374303782, 
91.5535335969828, 87.94173559048, 84.7320015798976, 
81.4774391710473), strength = c(0.982071762581765, 
0.667370094957298, 0.647710091338314, 0, 0.671181563790268, 
0.612141361895518, 0.952254653567164, 0.675252904890328, 
0.572862336567257, 0.929668980897602, 0.691580666207051, 
0.236925590725944)), list(intensity = 0.425077582829639, 
nCandidates = 11, frequency = c(266.040128338263, 
2308.44529277, 300.994616660123, 0, 238.716972530675, 
141.270284714943, 133.034612350357, 125.88085320461, 
92.2950547503786, 88.6807887385502, 85.4558618089636
), strength = c(0.985581508276202, 0.683627004216792, 
0.67163522433805, 0, 0.682826598633825, 0.65102433923114, 
0.962661169392901, 0.67649196713367, 0.627398209754657, 
0.933661962517701, 0.667399432280678)), list(intensity = 0.419478592782729, 
nCandidates = 11, frequency = c(267.395651401899, 
2365.82959965612, 301.880490326345, 0, 240.398746199445, 
141.87783003329, 133.717362001336, 126.679667028862, 
92.721732820445, 89.153153145803, 85.991770544491
), strength = c(0.989877073871921, 0.6835598279691, 
0.677555694081268, 0, 0.683657102418819, 0.668038554286347, 
0.977433917531317, 0.680772771342288, 0.65401789955271, 
0.957377506059389, 0.674530435755292)), list(intensity = 0.485104962790199, 
nCandidates = 11, frequency = c(268.390180030573, 
2550.71881904049, 300.112876458656, 0, 242.893341055985, 
141.759612466215, 134.217162804255, 127.531263107545, 
92.7778957800007, 89.4767630619597, 86.4477752090102
), strength = c(0.994404837010259, 0.686340401975539, 
0.683918002528142, 0, 0.685617076139464, 0.680468787544084, 
0.989471053162648, 0.68542410787191, 0.676084817406754, 
0.981875175023239, 0.683350083593036)), list(intensity = 0.442723459666202, 
nCandidates = 4, frequency = c(268.827018256277, 
0, 134.406568973067, 89.601184761444), strength = c(0.995515126634282, 
0, 0.989954168794226, 0.982262317501442)), list(intensity = 0.467288429329671, 
nCandidates = 4, frequency = c(267.139116916271, 
0, 133.576159348159, 89.0634629756564), strength = c(0.98010011438677, 
0, 0.939954737105945, 0.891058272684482)), list(intensity = 0.370953374756071, 
nCandidates = 4, frequency = c(262.161148741023, 
0, 126.809853417784, 85.1499109202305), strength = c(0.927155921794791, 
0, 0.816798106013115, 0.794961405175183)), list(intensity = 0.329299630236759, 
nCandidates = 4, frequency = c(247.817246433156, 
0, 123.432148220154, 82.2766020593945), strength = c(0.928910506317782, 
0, 0.81730573532879, 0.703258419306942)), list(intensity = 0.209124959269247, 
nCandidates = 4, frequency = c(239.29922673489, 0, 
118.326424953144, 77.2816891639745), strength = c(0.88437738620356, 
0, 0.645669782340232, 0.411888201198346)), list(intensity = 0.238518131006247, 
nCandidates = 4, frequency = c(239.997809826399, 
0, 119.23974362926, 76.7476392771278), strength = c(0.841330649991102, 
0, 0.541238054558772, 0.407314767760379)), list(intensity = 0.41383495771415, 
nCandidates = 4, frequency = c(245.401970170869, 
0, 122.961504042183, 81.8695750633587), strength = c(0.946978500232451, 
0, 0.837396634352796, 0.689808444987827)), list(intensity = 0.424692690502279, 
nCandidates = 4, frequency = c(247.604823503263, 
0, 123.821457989072, 82.5305334438527), strength = c(0.986891055490531, 
0, 0.960901139010394, 0.919556559536176)), list(intensity = 0.422347295101709, 
nCandidates = 4, frequency = c(248.016032818953, 
0, 124.013968521338, 82.6762753522883), strength = c(0.99688774679226, 
0, 0.995284501389794, 0.994642967413614)), list(intensity = 0.3920327289242, 
nCandidates = 4, frequency = c(248.193575634296, 
0, 124.08092600979, 82.7291100286385), strength = c(0.995139426651961, 
0, 0.994032825841375, 0.992834701617346)), list(intensity = 0.382957630311555, 
nCandidates = 4, frequency = c(247.122000583395, 
0, 123.356386096167, 81.5438071574745), strength = c(0.981302504828561, 
0, 0.945038455291265, 0.912189289627184)), list(intensity = 0.339836943653572, 
nCandidates = 4, frequency = c(238.646694076005, 
0, 119.196242251991, 79.4053490924803), strength = c(0.968728520859675, 
0, 0.925658451910715, 0.875606009926796)), list(intensity = 0.265925583466615, 
nCandidates = 4, frequency = c(231.586314416343, 
0, 114.880997660582, 76.5482746970903), strength = c(0.945067053625529, 
0, 0.890511969433471, 0.823763323002906)), list(intensity = 0.197849379495788, 
nCandidates = 3, frequency = c(220.207694900041, 
0, 110.176349752729), strength = c(0.918947485855424, 
0, 0.833992848981548)), list(intensity = 0.141040453438633, 
nCandidates = 6, frequency = c(218.736118387651, 
2709.20688746161, 0, 202.423840412319, 109.918903045158, 
105.841217500998), strength = c(0.768622860075521, 
0.788441028570459, 0, 0.739983142580992, 0.511196363647239, 
0.599944534301954)), list(intensity = 0.0749723058927372, 
nCandidates = 11, frequency = c(191.999146527106, 
2394.34067038773, 920.767491550887, 215.015349982662, 
0, 174.782075250422, 104.054800692387, 99.7714477180727, 
95.6976405176802, 90.622332892006, 86.7539558354551
), strength = c(0.460090733540948, 0.593671479736382, 
0.25945659467195, 0.42019518611791, 0, 0.34516757549283, 
0.308817977816931, 0.586400718359191, 0.619690122886527, 
0.385608930525237, 0.280591167844294)), list(intensity = 0.0765602309750233, 
nCandidates = 12, frequency = c(192.658264872739, 
1924.23764128677, 931.041330002007, 232.756634048972, 
210.877024605714, 0, 174.205538320144, 105.277216943779, 
100.108133174334, 95.5097911567873, 91.0941533984241, 
86.8467455961759), strength = c(0.596214059894247, 
0.65739351323, 0.366611069966175, 0.283830131480808, 
0.507753268676169, 0, 0.471212467548285, 0.386374302121561, 
0.585556952096023, 0.623174464813454, 0.492882792131276, 
0.253986837189868)), list(intensity = 0.133695300168722, 
nCandidates = 9, frequency = c(193.537356424397, 
1865.77745558654, 926.320064708045, 209.606723172108, 
0, 173.786009776638, 101.302700542937, 96.1570268513978, 
91.6308397848516), strength = c(0.549887517258715, 
0.74295255321376, 0.362185613903876, 0.495123051356413, 
0, 0.423499617013372, 0.488171652665556, 0.579176188065754, 
0.439155167108169)), list(intensity = 0.104257473574443, 
nCandidates = 7, frequency = c(190.555605530456, 
1710.18726492111, 215.134149661759, 0, 99.6124399529961, 
94.4462013745284, 90.0421315561347), strength = c(0.658559513630669, 
0.701323181431129, 0.511107344030849, 0, 0.568303374716698, 
0.669561499292195, 0.501829980084453)), list(intensity = 0.110156142954322, 
nCandidates = 8, frequency = c(190.584099438807, 
1627.01550617509, 216.187109269011, 0, 170.580585757001, 
99.3119682906308, 94.5523521510512, 90.0858227673989
), strength = c(0.823521260569063, 0.689018548955065, 
0.623337841684328, 0, 0.610295309845649, 0.67420642125553, 
0.7678928088808, 0.560243455547668)), list(intensity = 0.146418090632984, 
nCandidates = 4, frequency = c(190.382196420787, 
1637.36006911288, 0, 97.6581434659499), strength = c(0.845597905220125, 
0.665935721383265, 0, 0.823113225409112)), list(intensity = 0.135706214747183, 
nCandidates = 3, frequency = c(200.876282309822, 
0, 98.8590428969416), strength = c(0.908267217800812, 
0, 0.897429217798746)), list(intensity = 0.175748096850657, 
nCandidates = 3, frequency = c(204.67346466601, 0, 
103.399745129364), strength = c(0.939193084170779, 
0, 0.888597365413043)), list(intensity = 0.229464017786897, 
nCandidates = 3, frequency = c(215.54918365073, 0, 
107.584617473527), strength = c(0.959892091374488, 
0, 0.918606485692127)), list(intensity = 0.334842391835272, 
nCandidates = 3, frequency = c(217.285728368339, 
0, 108.830744950264), strength = c(0.969292149561743, 
0, 0.906411544658957)), list(intensity = 0.393770304942032, 
nCandidates = 3, frequency = c(216.114998591509, 
0, 108.045318079842), strength = c(0.965586287079929, 
0, 0.888674806106595)), list(intensity = 0.37130233393969, 
nCandidates = 3, frequency = c(207.033409425367, 
0, 103.46361689779), strength = c(0.938724142691745, 
0, 0.820920157680588)), list(intensity = 0.325948331624989, 
nCandidates = 6, frequency = c(201.07800889974, 402.564512500333, 
0, 134.244428543718, 100.454704682181, 80.608356588671
), strength = c(0.963366613653736, 0.506539576451171, 
0, 0.446387475933156, 0.882956032011788, 0.336629813058432
)), list(intensity = 0.291594394186995, nCandidates = 3, 
frequency = c(199.756746823744, 0, 99.448903765432
), strength = c(0.947730331178276, 0, 0.850752801947601
)), list(intensity = 0.171092326050768, nCandidates = 3, 
frequency = c(194.630624629961, 0, 96.7047738959869
), strength = c(0.928413306539086, 0, 0.874691562464948
)), list(intensity = 0.150835804379352, nCandidates = 3, 
frequency = c(193.287010582472, 0, 96.8056012752452
), strength = c(0.852694415246029, 0, 0.597238135545044
)), list(intensity = 0.0582736554840484, nCandidates = 3, 
frequency = c(202.387223155445, 0, 101.637835811162
), strength = c(0.777638451689037, 0, 0.679550003208021
)), list(intensity = 0.0362061260813373, nCandidates = 6, 
frequency = c(0, 3081.57016047274, 211.408550400659, 
199.974253432721, 101.429967703029, 86.3537998075967
), strength = c(0, 0.741691895165321, 0.621686393435142, 
0.645456425217851, 0.415445132764468, 0.283078310039319
)), list(intensity = 0.0885147822910722, nCandidates = 4, 
frequency = c(0, 2824.5544150012, 530.533194946864, 
105.443940031025), strength = c(0, 0.469310759714907, 
0.364145942469106, 0.248782933528849)), list(intensity = 0.092479867962863, 
nCandidates = 15, frequency = c(0, 2365.86307323713, 
680.711592479397, 531.136432652535, 297.249219814686, 
264.258132796526, 207.094765175386, 190.727209651892, 
175.424310889335, 149.774325813472, 139.870212218569, 
131.814102163455, 91.2708400335782, 116.581973645659, 
110.237787661145), strength = c(0, 0.430311416733534, 
0.399792931296338, 0.488515189375909, 0.392985481811736, 
0.352861137605194, 0.32424268660002, 0.433476076493269, 
0.377272240804837, 0.380015803992409, 0.416520869552679, 
0.387033321209762, 0.296682963854767, 0.301924171639695, 
0.311519117219957)), list(intensity = 0.0831243768022139, 
nCandidates = 9, frequency = c(0, 1951.83226940321, 
970.976399070308, 266.432087278694, 235.842801784006, 
209.326360654384, 190.646843262082, 174.703845241226, 
99.240150714345), strength = c(0, 0.542766139713736, 
0.313721731844806, 0.26423083206722, 0.314355386966781, 
0.297377628069454, 0.334698053167, 0.305684122587588, 
0.267013971099264)), list(intensity = 0.11747781434258, 
nCandidates = 10, frequency = c(0, 1778.39852249177, 
902.510111851496, 321.381108580846, 272.76344655716, 
237.209208024622, 209.08092619157, 187.222982589988, 
83.2601525369148, 79.5395113541887), strength = c(0, 
0.648393331054582, 0.377285968723564, 0.260602855676331, 
0.32057617183584, 0.386092870963986, 0.360376425292245, 
0.264085875368133, 0.235493903046635, 0.283643160886117
)), list(intensity = 0.0785372943321619, nCandidates = 12, 
frequency = c(0, 1598.95241525328, 773.18461105126, 
517.76709911599, 386.65884525433, 309.493650991889, 
190.983420345396, 170.005074098882, 153.564160970275, 
139.975517175812, 128.600255956349, 76.822704122562
), strength = c(0, 0.732264858297834, 0.482876105393206, 
0.410579043845185, 0.309525935263673, 0.247578979888678, 
0.264149224291762, 0.317908231836139, 0.412461700243753, 
0.398045294866252, 0.345648743071321, 0.277686087445448
)), list(intensity = 0.149013481767889, nCandidates = 10, 
frequency = c(0, 1546.39381437173, 762.463031531681, 
510.709679082849, 381.292314456808, 305.50519164646, 
168.18356006801, 151.996657086059, 138.375793129664, 
126.909810025849), strength = c(0, 0.828681134233605, 
0.655232485149361, 0.502695632826744, 0.365122916180128, 
0.278997822670057, 0.294721322935461, 0.353653824531648, 
0.323223767512346, 0.259058523376368)), list(intensity = 0.0401197123266445, 
nCandidates = 10, frequency = c(0, 1525.72640212286, 
755.086089362043, 211.950154245098, 187.027517840861, 
167.104240586616, 151.105712797841, 90.2180188703387, 
80.2184317617336, 76.2540164352773), strength = c(0, 
0.763649653494739, 0.439340147590134, 0.275766410464242, 
0.321478762933313, 0.305171814611437, 0.271455744552642, 
0.254374433347359, 0.262587506481915, 0.250218410139618
)), list(intensity = 0.015978947049393, nCandidates = 15, 
frequency = c(0, 1535.82795246277, 765.459756248039, 
512.660982895951, 387.949224652117, 311.597362255763, 
258.591031571084, 76.5514426061009, 190.090919525729, 
84.8359182140476, 80.4020890283073, 89.8788009729546, 
95.3795510497949, 108.154383183232, 101.320013171429
), strength = c(0, 0.76168972091698, 0.521159698378258, 
0.381566151753793, 0.332829519178202, 0.335807887599984, 
0.3017819573116, 0.312091616634707, 0.288955897442117, 
0.395592284004081, 0.394967673647677, 0.318130826688712, 
0.309639756718523, 0.315158358189717, 0.311484516755731
)), list(intensity = 0.00972179130573827, nCandidates = 14, 
frequency = c(0, 1557.72692479683, 774.862178943514, 
517.448977181098, 386.740314716329, 311.338399402125, 
259.162503584174, 221.565187681641, 129.586819567636, 
119.519460887056, 91.2290917779928, 86.1911311960381, 
81.2930683486646, 77.0031275544077), strength = c(0, 
0.723276540783329, 0.474185933891787, 0.402133122448857, 
0.462713316923678, 0.471541463263887, 0.419867588831979, 
0.322768105423425, 0.272084475696708, 0.236248551928762, 
0.301078900093841, 0.305864814608198, 0.261319609875267, 
0.313047914760337)), list(intensity = 0.00830923000544218, 
nCandidates = 5, frequency = c(0, 1552.12256407939, 
735.755550456585, 188.799351181357, 167.931257458232
), strength = c(0, 0.648648381805309, 0.30447176714944, 
0.292646438922527, 0.284834520197578)), list(intensity = 0.0055970227582248, 
nCandidates = 4, frequency = c(0, 1549.92629808493, 
769.052435567655, 521.764542157895), strength = c(0, 
0.719819943956903, 0.4886185663065, 0.295907450233764
)), list(intensity = 0.0242327523929379, nCandidates = 3, 
frequency = c(0, 474.542433566659, 317.02564194064
), strength = c(0, 0.230561459225625, 0.239774867049901
)), list(intensity = 0.0528133917323643, nCandidates = 4, 
frequency = c(0, 314.201916499549, 191.491930935704, 
119.149190318529), strength = c(0, 0.326604888574736, 
0.225626616610553, 0.249855443049562)), list(intensity = 0.0914627354724744, 
nCandidates = 3, frequency = c(214.765766211789, 
0, 107.113744104749), strength = c(0.665134424456966, 
0, 0.386576540592283)), list(intensity = 0.228152026400857, 
nCandidates = 5, frequency = c(211.424350451087, 
422.18631088424, 0, 140.367260142847, 105.722389001855
), strength = c(0.906904573020359, 0.334884994974795, 
0, 0.273684164081534, 0.762454589664488)), list(intensity = 0.321976541026765, 
nCandidates = 6, frequency = c(215.495977618704, 
430.675607850877, 0, 143.478626621095, 107.732784540454, 
86.0222167119627), strength = c(0.963809715008408, 
0.455664395526046, 0, 0.411418706182958, 0.87455727705167, 
0.342094726472638)), list(intensity = 0.331750682253665, 
nCandidates = 6, frequency = c(217.811569429731, 
435.280804906935, 0, 145.086910012418, 108.90642446723, 
87.0336424068716), strength = c(0.992880729755793, 
0.463514355386774, 0, 0.458979515720241, 0.977286698589381, 
0.454540667614033)), list(intensity = 0.308241736723954, 
nCandidates = 6, frequency = c(217.393642207838, 
434.365339257856, 0, 144.783538229293, 108.70835239676, 
86.8848297536057), strength = c(0.996167235891439, 
0.46413184320402, 0, 0.458613297286172, 0.99064874318387, 
0.449138182887421)), list(intensity = 0.301323631033242, 
nCandidates = 6, frequency = c(218.612486614289, 
436.972482880033, 0, 145.651176819241, 109.31053548144, 
87.3979327006496), strength = c(0.995447325410092, 
0.408462138556229, 0, 0.403605263522393, 0.9856515126673, 
0.396198938750997)), list(intensity = 0.26196440356721, 
nCandidates = 6, frequency = c(220.208234200306, 
440.281309117528, 0, 146.763394357403, 110.108472862028, 
88.0589850006248), strength = c(0.998341093787558, 
0.34381401758813, 0, 0.343034732037483, 0.995398785214971, 
0.343486697274691)), list(intensity = 0.240549437220063, 
nCandidates = 6, frequency = c(220.63229383082, 441.0710424442, 
0, 147.023518818884, 110.318041300442, 88.2161675640358
), strength = c(0.999412993462735, 0.337326341144077, 
0, 0.341883159478655, 0.995515072093728, 0.353153140241375
)), list(intensity = 0.24787079937604, nCandidates = 6, 
frequency = c(220.255358340888, 440.414207005205, 
0, 146.804741654781, 110.136941334771, 88.0932108647686
), strength = c(0.997429030251483, 0.436650589562419, 
0, 0.434917042999245, 0.991966443723036, 0.432307437536948
)), list(intensity = 0.248896214002409, nCandidates = 6, 
frequency = c(221.081834151832, 442.335422041805, 
0, 147.441557086451, 110.540134871542, 88.4622096034461
), strength = c(0.997540935254134, 0.548154173865749, 
0, 0.546485360702269, 0.993728288840654, 0.547748224262857
)), list(intensity = 0.245912099860723, nCandidates = 6, 
frequency = c(220.979546322984, 442.8291621403, 0, 
147.580569553954, 110.499633642066, 88.5195450069086
), strength = c(0.985121100841721, 0.655584307323983, 
0, 0.642143380754722, 0.949399833136273, 0.619516630062144
)), list(intensity = 0.216257902824832, nCandidates = 6, 
frequency = c(215.842694446365, 437.048148138419, 
0, 145.051618833151, 108.075387992905, 86.7588412129324
), strength = c(0.924327443131062, 0.683761704975702, 
0, 0.635682478003074, 0.771431016824701, 0.532237625261318
)), list(intensity = 0.153442506050198, nCandidates = 6, 
frequency = c(205.918141427629, 455.978286164302, 
0, 142.527025126991, 102.802382439723, 84.1757717628874
), strength = c(0.8967191528681, 0.518946361035713, 
0, 0.55990554228174, 0.729791657043727, 0.548983242986491
)), list(intensity = 0.128142368925275, nCandidates = 7, 
frequency = c(200.429951632128, 503.679361086982, 
0, 143.416691211606, 101.364189063224, 93.8738966716594, 
79.3200213464673), strength = c(0.672272327033283, 
0.483286359211521, 0, 0.368564272261963, 0.277684224656848, 
0.303115726645574, 0.28394021665025)), list(intensity = 0.171306644487999, 
nCandidates = 7, frequency = c(185.191053751928, 
548.301500723291, 277.674711311802, 0, 139.571553861764, 
111.997951989886, 92.7911493757745), strength = c(0.555799095427637, 
0.679844960582862, 0.525730426588368, 0, 0.304872750875084, 
0.278628965305073, 0.357869555480261)), list(intensity = 0.146794958495469, 
nCandidates = 6, frequency = c(0, 586.65794535061, 
290.226530321067, 105.506132916742, 88.9734840091658, 
77.353338072468), strength = c(0, 0.641970405030135, 
0.420314308202377, 0.419554430704432, 0.488284830137679, 
0.579804503129238)), list(intensity = 0.193120500667193, 
nCandidates = 9, frequency = c(0, 633.858434732888, 
312.847524786849, 208.09677652043, 155.49174747319, 
124.151093369425, 104.525321608316, 89.8131674087133, 
78.6650723775121), strength = c(0, 0.606895985455638, 
0.430127863456846, 0.409520915616394, 0.413089953647155, 
0.531324372302816, 0.50327115284012, 0.405868034676697, 
0.352162599392347)), list(intensity = 0.203002450459291, 
nCandidates = 7, frequency = c(0, 660.765512863964, 
328.075982677507, 210.543173734248, 156.591145189351, 
94.1797882454341, 79.287961106917), strength = c(0, 
0.539451691630902, 0.336060450043037, 0.256983662821391, 
0.237479221536804, 0.294936050763729, 0.313638155957072
)), list(intensity = 0.232419352842684, nCandidates = 3, 
frequency = c(0, 699.612976515909, 114.870516970279
), strength = c(0, 0.420811417616247, 0.341567846782682
)), list(intensity = 0.316852861494103, nCandidates = 13, 
frequency = c(0, 1406.53925733388, 722.468626604041, 
477.083941799619, 358.256137536127, 286.096602764992, 
238.094430901126, 203.999205337157, 178.652158568488, 
158.828831759319, 143.587821682761, 130.323016262844, 
75.0202701485081), strength = c(0, 0.312510892043297, 
0.47315697371808, 0.288056793567492, 0.293489334921201, 
0.273210374001062, 0.270117637036865, 0.237779317804925, 
0.407389758080644, 0.266705262223249, 0.278752573403445, 
0.402644300980677, 0.364275543741294)), list(intensity = 0.340145583653933, 
nCandidates = 5, frequency = c(199.515885856117, 
729.922652904012, 0, 98.9170880838995, 92.362967370608
), strength = c(0.486353545939098, 0.362970514331353, 
0, 0.34246438123363, 0.390034487932472)), list(intensity = 0.429078348840384, 
nCandidates = 9, frequency = c(199.799817380161, 
1403.49222809669, 721.334987362754, 233.358701308117, 
0, 175.002404065373, 156.795770529496, 99.7847105145424, 
92.9413295157193), strength = c(0.826620526307518, 
0.338814984787982, 0.302859263407795, 0.272854636521571, 
0, 0.268929608896996, 0.226133041636652, 0.66966156531833, 
0.234141158332272)), list(intensity = 0.393071208072021, 
nCandidates = 6, frequency = c(196.152600306061, 
1407.23902064605, 734.769848457792, 228.919660514508, 
0, 98.329434303482), strength = c(0.712687727422998, 
0.365561666209383, 0.234674527231791, 0.261180770476023, 
0, 0.414090892551751)), list(intensity = 0.484152153555306, 
nCandidates = 6, frequency = c(0, 1410.67105600942, 
744.398897204543, 491.311308527534, 188.540810497389, 
94.0166905194881), strength = c(0, 0.407892035937741, 
0.342407871613915, 0.315778788164327, 0.363474117622676, 
0.338610530590774)), list(intensity = 0.450404257844813, 
nCandidates = 10, frequency = c(0, 1398.72098045658, 
743.522994754137, 481.74271144215, 295.264748919437, 
171.926912274054, 152.495933549353, 126.305111757342, 
108.324905547052, 80.7681943053045), strength = c(0, 
0.37585908026238, 0.41469248970652, 0.320142877990547, 
0.241174799175409, 0.347506286585821, 0.363977436302432, 
0.303607864488389, 0.248183951041074, 0.400239081905137
)), list(intensity = 0.414084924325101, nCandidates = 13, 
frequency = c(0, 1398.47481701234, 744.138286670267, 
477.190587237701, 293.837120225501, 172.310434093146, 
153.046451628847, 139.505662277473, 126.875286876973, 
108.458698550042, 100.417460969231, 88.5717191741165, 
80.8350100097584), strength = c(0, 0.347469388429536, 
0.432905541004923, 0.40378429536786, 0.240756023086924, 
0.323341855257775, 0.357157012286542, 0.297945489213512, 
0.500174864701832, 0.604604715768942, 0.319132162837385, 
0.264301454914103, 0.296023707420927)), list(intensity = 0.455914139342791, 
nCandidates = 7, frequency = c(0, 1405.29181021111, 
747.365640051897, 479.638822048456, 292.512485323733, 
109.297763077256, 80.8995066327623), strength = c(0, 
0.304016678258914, 0.555062980709593, 0.478652503642072, 
0.447947859613872, 0.231148105600996, 0.3730495920098
)), list(intensity = 0.400275762697626, nCandidates = 12, 
frequency = c(0, 755.019223789444, 480.337757730768, 
293.096519605263, 210.757077878244, 181.997471075029, 
146.560195656415, 122.730774481491, 112.294391252281, 
97.810083474677, 86.6065846660622, 81.2383901734268
), strength = c(0, 0.610405701018499, 0.453020013814369, 
0.495893471502825, 0.312154505121569, 0.238836318877483, 
0.274260177491435, 0.231435653029677, 0.299247567911273, 
0.448450495195842, 0.361560774271623, 0.570252527337211
)), list(intensity = 0.35474239884529, nCandidates = 8, 
frequency = c(0, 747.621465474567, 475.937278405258, 
291.519801694751, 209.975233043943, 98.4518019384476, 
87.1276775364255, 81.6403639255326), strength = c(0, 
0.575888074387139, 0.361849407690556, 0.374743527328955, 
0.236872951812522, 0.326424394727694, 0.4206022197223, 
0.483174576141562)), list(intensity = 0.333210596755193, 
nCandidates = 10, frequency = c(0, 743.321773844657, 
471.623023248916, 289.315757395988, 177.882010010762, 
143.315593052495, 108.395322179072, 94.7765766727265, 
84.0758071370466, 79.3090042005477), strength = c(0, 
0.464984207658684, 0.303606266814507, 0.367531035761571, 
0.225569423678507, 0.339579435590833, 0.48624483741915, 
0.383528940778062, 0.303861395995208, 0.329102082028041
)), list(intensity = 0.327748437742217, nCandidates = 6, 
frequency = c(0, 736.406826461085, 201.008385458067, 
143.891209429845, 94.9551764388711, 84.0552476885399
), strength = c(0, 0.356856869180814, 0.388398616278563, 
0.250844182908473, 0.285270007743641, 0.392019186128673
)), list(intensity = 0.284286944924905, nCandidates = 3, 
frequency = c(199.417690685637, 0, 100.034714355129
), strength = c(0.826435563263748, 0, 0.642023915091449
)), list(intensity = 0.300225534948547, nCandidates = 3, 
frequency = c(202.251943733849, 0, 101.020145550849
), strength = c(0.848091928148938, 0, 0.604584499326457
)), list(intensity = 0.171326662070755, nCandidates = 3, 
frequency = c(198.406454456676, 0, 93.052223205446
), strength = c(0.702587208494868, 0, 0.475132480030739
)), list(intensity = 0.0667509782755606, nCandidates = 5, 
frequency = c(198.546294242503, 0, 155.889925787845, 
99.58788673544, 87.3370906273828), strength = c(0.80210686724939, 
0, 0.281386370796894, 0.621324169222292, 0.289290128987343
)), list(intensity = 0.0374615735074088, nCandidates = 3, 
frequency = c(201.468815590477, 0, 100.926211708554
), strength = c(0.807770784772601, 0, 0.638780953675791
)), list(intensity = 0.0190097101829372, nCandidates = 5, 
frequency = c(0, 199.782269139379, 157.734113791838, 
100.05200331075, 87.6711593489161), strength = c(0, 
0.749102547224055, 0.280085109682863, 0.354401037373106, 
0.547910476671202)), list(intensity = 0.0165737073173192, 
nCandidates = 4, frequency = c(0, 200.91815742607, 
100.184174651642, 88.2810068167872), strength = c(0, 
0.812623919379633, 0.505567531323772, 0.235261483609893
)), list(intensity = 0.00902874846662549, nCandidates = 4, 
frequency = c(0, 201.450644472238, 101.410974904091, 
91.5968159149439), strength = c(0, 0.700164742885397, 
0.299675222601079, 0.249601864693751)), list(intensity = 0.00324817332675149, 
nCandidates = 2, frequency = c(0, 615.93754026148
), strength = c(0, 0.228461800220499)), list(intensity = 0.0458307542129968, 
nCandidates = 2, frequency = c(0, 209.335761021466
), strength = c(0, 0.277150116895491)), list(intensity = 0.362618832578859, 
nCandidates = 3, frequency = c(207.167735931803, 
0, 101.294340216309), strength = c(0.633461121905359, 
0, 0.296021874699565)), list(intensity = 0.378207533541476, 
nCandidates = 4, frequency = c(197.24235841142, 310.115091680069, 
0, 97.6542007192416), strength = c(0.71421893233394, 
0.236226846389625, 0, 0.43725940643471)), list(intensity = 0.305495466631452, 
nCandidates = 3, frequency = c(192.672020346964, 
0, 96.2157302300123), strength = c(0.941386605455011, 
0, 0.927812906490361)), list(intensity = 0.307981839162163, 
nCandidates = 3, frequency = c(193.014500541187, 
0, 96.4894162180525), strength = c(0.959743618073622, 
0, 0.883864081751111)), list(intensity = 0.267048256588854, 
nCandidates = 3, frequency = c(194.807344999663, 
0, 97.436353513285), strength = c(0.945174273599085, 
0, 0.859588008535987)), list(intensity = 0.234979440652896, 
nCandidates = 3, frequency = c(195.028206757606, 
0, 96.9549133144772), strength = c(0.91166902346434, 
0, 0.880528775588501)), list(intensity = 0.238567634158075, 
nCandidates = 3, frequency = c(200.82583284068, 0, 
100.132456803633), strength = c(0.874020663741487, 
0, 0.686226134490595)), list(intensity = 0.301944972817507, 
nCandidates = 3, frequency = c(206.003615672747, 
0, 103.057719350285), strength = c(0.964707827063933, 
0, 0.896164812073619)), list(intensity = 0.2515871622127, 
nCandidates = 3, frequency = c(204.867353800571, 
0, 102.506104729634), strength = c(0.997227034161039, 
0, 0.997541476416316)), list(intensity = 0.200972508672963, 
nCandidates = 3, frequency = c(203.413384147931, 
0, 101.720126533186), strength = c(0.999304723308265, 
0, 0.988577950097395)), list(intensity = 0.210302857474046, 
nCandidates = 3, frequency = c(201.75281351547, 0, 
100.859074173507), strength = c(0.994736588008886, 
0, 0.986086274489642)), list(intensity = 0.206609742814731, 
nCandidates = 3, frequency = c(200.593313777613, 
0, 100.378869151917), strength = c(0.976002838406868, 
0, 0.942400973888755)), list(intensity = 0.211144661851864, 
nCandidates = 3, frequency = c(195.140565337496, 
0, 98.10591237225), strength = c(0.931734876598187, 
0, 0.86844881032818)), list(intensity = 0.230768421270574, 
nCandidates = 3, frequency = c(189.150055732336, 
0, 94.5739352002191), strength = c(0.963523682217858, 
0, 0.91942667659001)), list(intensity = 0.220492338213009, 
nCandidates = 3, frequency = c(185.326578109853, 
0, 92.7271735621876), strength = c(0.937608498997769, 
0, 0.831364648837668)), list(intensity = 0.179637442419678, 
nCandidates = 4, frequency = c(179.688544688706, 
1662.24674446053, 0, 89.7645407746155), strength = c(0.90560172385069, 
0.387655559614295, 0, 0.7960686107851)), list(intensity = 0.177972978322837, 
nCandidates = 3, frequency = c(174.905314080388, 
0, 87.3345232318082), strength = c(0.93385922187145, 
0, 0.851873480110032)), list(intensity = 0.168649815471588, 
nCandidates = 5, frequency = c(171.534920048563, 
336.387787847372, 0, 112.53288992712, 85.5377029668501
), strength = c(0.886743477062124, 0.304363082541192, 
0, 0.269091388996342, 0.711474482091811)), list(intensity = 0.151244857238894, 
nCandidates = 5, frequency = c(166.594639799738, 
327.603318785313, 0, 108.854453986619, 81.3248526742911
), strength = c(0.895848149265523, 0.426781452899758, 
0, 0.443201456187811, 0.888742272017794)), list(intensity = 0.146598397808093, 
nCandidates = 5, frequency = c(165.826947538547, 
327.426064105355, 0, 109.583422189381, 82.5300198358469
), strength = c(0.955305254861895, 0.317551111179371, 
0, 0.340276786544523, 0.925276698783629)), list(intensity = 0.142791749453463, 
nCandidates = 5, frequency = c(162.724141783348, 
324.781425870384, 0, 108.505401438945, 81.2910431589085
), strength = c(0.98468064329055, 0.386238054623754, 
0, 0.380220754138012, 0.972588197103774)), list(intensity = 0.1416636219046, 
nCandidates = 5, frequency = c(160.706032197959, 
322.346542168941, 0, 107.505587014482, 80.3989744026777
), strength = c(0.988587774360861, 0.439279301720134, 
0, 0.433656563890949, 0.986915546315058)), list(intensity = 0.148520229183424, 
nCandidates = 5, frequency = c(160.870776102449, 
323.085438468593, 0, 107.913820260509, 80.6164722568363
), strength = c(0.968328681241663, 0.446617846002179, 
0, 0.456864722089539, 0.958683454766801)), list(intensity = 0.18171092834671, 
nCandidates = 5, frequency = c(159.572532516518, 
320.836295426122, 0, 108.327491730738, 80.4148478974104
), strength = c(0.903735010713258, 0.542793211881325, 
0, 0.514833849117273, 0.853364110693079)), list(intensity = 0.160202782944847, 
nCandidates = 5, frequency = c(154.14529425336, 311.626201597687, 
0, 104.97479619143, 77.1695856115973), strength = c(0.934032320926468, 
0.489411167994262, 0, 0.426378384027461, 0.799096077790082
)), list(intensity = 0.127047325757517, nCandidates = 5, 
frequency = c(152.699424431425, 305.428398218452, 
0, 101.784799397533, 76.3409335745468), strength = c(0.984323297547842, 
0.324367779960664, 0, 0.318676142558727, 0.968575723284083
)), list(intensity = 0.111408452662563, nCandidates = 3, 
frequency = c(153.023853237342, 0, 76.4798795443381
), strength = c(0.970866502479028, 0, 0.972831752775828
)), list(intensity = 0.110863349036008, nCandidates = 3, 
frequency = c(157.128947241149, 0, 77.932057510042
), strength = c(0.924778845401474, 0, 0.868159193733231
)), list(intensity = 0.126032970445927, nCandidates = 3, 
frequency = c(160.505660143832, 0, 80.1328156410849
), strength = c(0.9576843612478, 0, 0.917369035195555
)), list(intensity = 0.111928889892715, nCandidates = 3, 
frequency = c(161.468571250085, 0, 80.7317742842719
), strength = c(0.965512066419636, 0, 0.913540347995407
)), list(intensity = 0.0872989625414906, nCandidates = 3, 
frequency = c(162.42251152617, 0, 81.1547630053183
), strength = c(0.937910702925221, 0, 0.807975704018148
)), list(intensity = 0.0465025081099097, nCandidates = 3, 
frequency = c(161.70257708723, 0, 80.4897716255685
), strength = c(0.922929811901074, 0, 0.787912785457795
)), list(intensity = 0.0233308923672176, nCandidates = 3, 
frequency = c(0, 157.216491204761, 78.4343433639064
), strength = c(0, 0.9438033683661, 0.869725617323605
)), list(intensity = 0.0159954777612325, nCandidates = 3, 
frequency = c(0, 158.409446107811, 79.1863707831327
), strength = c(0, 0.893385256215519, 0.732498895186952
)), list(intensity = 0.0103629370203749, nCandidates = 3, 
frequency = c(0, 156.626869057606, 78.4775806503561
), strength = c(0, 0.85732657784539, 0.839043279550836
)), list(intensity = 0.00977517586535605, nCandidates = 3, 
frequency = c(0, 159.774108484387, 80.4422840653962
), strength = c(0, 0.697905337396232, 0.701559895419903
)), list(intensity = 0.00684523538586815, nCandidates = 3, 
frequency = c(0, 162.238992731352, 80.1994675429886
), strength = c(0, 0.631942201582137, 0.598954370691439
)), list(intensity = 0.0056103584811227, nCandidates = 4, 
frequency = c(0, 161.301379168387, 148.631969916213, 
79.3635410391303), strength = c(0, 0.496760865778541, 
0.431574755205846, 0.568362775542684)), list(intensity = 0.00538992152961147, 
nCandidates = 4, frequency = c(0, 127.821362395547, 
123.042675256502, 83.1402870153829), strength = c(0, 
0.260658862749201, 0.258979934359319, 0.52550872880403
)), list(intensity = 0.00517580670975958, nCandidates = 2, 
frequency = c(0, 295.057503008522), strength = c(0, 
0.40244992763164)), list(intensity = 0.00354512993467312, 
nCandidates = 6, frequency = c(0, 300.958725261785, 
266.845310839371, 105.542921163603, 102.965152682339, 
76.4258890544458), strength = c(0, 0.349219025749472, 
0.268039086866112, 0.2533233486473, 0.24725340742129, 
0.410418252990207)), list(intensity = 0.00383262924142157, 
nCandidates = 3, frequency = c(0, 80.3345892137103, 
76.5757476729248), strength = c(0, 0.32050695011357, 
0.435685210347268)))), class = c("list", type = "Pitch 1", 
name = "H.Pitch"))
    return(pitch)
}

#' formant.sample
#'
#' Returns sample Formant object.
#'
#' @return Formant
#' @export
#' @seealso \code{\link{tg.sample}}, \code{\link{pt.sample}}, \code{\link{it.sample}}, \code{\link{pitch.sample}}
#'
#' @examples
#' formant <- formant.sample()
formant.sample <- function() {
return(
structure(list(xmin = 0, xmax = 3.617125, nx = 571, dx = 0.00625,
x1 = 0.0273, t = c(0.0273, 0.0336, 0.0398, 0.0461,
0.0523, 0.0586, 0.0648, 0.0711, 0.0773, 0.0836, 0.0898, 0.0961,
0.1023, 0.1086, 0.1148, 0.1211, 0.1273, 0.1336, 0.1398, 0.1461,
0.1523, 0.1586, 0.1648, 0.1711, 0.1773, 0.1836, 0.1898, 0.1961,
0.2023, 0.2086, 0.2148, 0.2211, 0.2273, 0.2336, 0.2398, 0.2461,
0.2523, 0.2586, 0.2648, 0.2711, 0.2773, 0.2836, 0.2898, 0.2961,
0.3023, 0.3086, 0.3148, 0.3211, 0.3273, 0.3336, 0.3398, 0.3461,
0.3523, 0.3586, 0.3648, 0.3711, 0.3773, 0.3836, 0.3898, 0.3961,
0.4023, 0.4086, 0.4148, 0.4211, 0.4273, 0.4336, 0.4398, 0.4461,
0.4523, 0.4586, 0.4648, 0.4711, 0.4773, 0.4836, 0.4898, 0.4961,
0.5023, 0.5086, 0.5148, 0.5211, 0.5273, 0.5336, 0.5398, 0.5461,
0.5523, 0.5586, 0.5648, 0.5711, 0.5773, 0.5836, 0.5898, 0.5961,
0.6023, 0.6086, 0.6148, 0.6211, 0.6273, 0.6336, 0.6398, 0.6461,
0.6523, 0.6586, 0.6648, 0.6711, 0.6773, 0.6836, 0.6898, 0.6961,
0.7023, 0.7086, 0.7148, 0.7211, 0.7273, 0.7336, 0.7398, 0.7461,
0.7523, 0.7586, 0.7648, 0.7711, 0.7773, 0.7836, 0.7898, 0.7961,
0.8023, 0.8086, 0.8148, 0.8211, 0.8273, 0.8336, 0.8398, 0.8461,
0.8523, 0.8586, 0.8648, 0.8711, 0.8773, 0.8836, 0.8898, 0.8961,
0.9023, 0.9086, 0.9148, 0.9211, 0.9273, 0.9336, 0.9398, 0.9461,
0.9523, 0.9586, 0.9648, 0.9711, 0.9773, 0.9836, 0.9898, 0.9961,
1.0023, 1.0086, 1.0148, 1.0211, 1.0273, 1.0336, 1.0398, 1.0461,
1.0523, 1.0586, 1.0648, 1.0711, 1.0773, 1.0836, 1.0898, 1.0961,
1.1023, 1.1086, 1.1148, 1.1211, 1.1273, 1.1336, 1.1398, 1.1461,
1.1523, 1.1586, 1.1648, 1.1711, 1.1773, 1.1836, 1.1898, 1.1961,
1.2023, 1.2086, 1.2148, 1.2211, 1.2273, 1.2336, 1.2398, 1.2461,
1.2523, 1.2586, 1.2648, 1.2711, 1.2773, 1.2836, 1.2898, 1.2961,
1.3023, 1.3086, 1.3148, 1.3211, 1.3273, 1.3336, 1.3398, 1.3461,
1.3523, 1.3586, 1.3648, 1.3711, 1.3773, 1.3836, 1.3898, 1.3961,
1.4023, 1.4086, 1.4148, 1.4211, 1.4273, 1.4336, 1.4398, 1.4461,
1.4523, 1.4586, 1.4648, 1.4711, 1.4773, 1.4836, 1.4898, 1.4961,
1.5023, 1.5086, 1.5148, 1.5211, 1.5273, 1.5336, 1.5398, 1.5461,
1.5523, 1.5586, 1.5648, 1.5711, 1.5773, 1.5836, 1.5898, 1.5961,
1.6023, 1.6086, 1.6148, 1.6211, 1.6273, 1.6336, 1.6398, 1.6461,
1.6523, 1.6586, 1.6648, 1.6711, 1.6773, 1.6836, 1.6898, 1.6961,
1.7023, 1.7086, 1.7148, 1.7211, 1.7273, 1.7336, 1.7398, 1.7461,
1.7523, 1.7586, 1.7648, 1.7711, 1.7773, 1.7836, 1.7898, 1.7961,
1.8023, 1.8086, 1.8148, 1.8211, 1.8273, 1.8336, 1.8398, 1.8461,
1.8523, 1.8586, 1.8648, 1.8711, 1.8773, 1.8836, 1.8898, 1.8961,
1.9023, 1.9086, 1.9148, 1.9211, 1.9273, 1.9336, 1.9398, 1.9461,
1.9523, 1.9586, 1.9648, 1.9711, 1.9773, 1.9836, 1.9898, 1.9961,
2.0023, 2.0086, 2.0148, 2.0211, 2.0273, 2.0336, 2.0398, 2.0461,
2.0523, 2.0586, 2.0648, 2.0711, 2.0773, 2.0836, 2.0898, 2.0961,
2.1023, 2.1086, 2.1148, 2.1211, 2.1273, 2.1336, 2.1398, 2.1461,
2.1523, 2.1586, 2.1648, 2.1711, 2.1773, 2.1836, 2.1898, 2.1961,
2.2023, 2.2086, 2.2148, 2.2211, 2.2273, 2.2336, 2.2398, 2.2461,
2.2523, 2.2586, 2.2648, 2.2711, 2.2773, 2.2836, 2.2898, 2.2961,
2.3023, 2.3086, 2.3148, 2.3211, 2.3273, 2.3336, 2.3398, 2.3461,
2.3523, 2.3586, 2.3648, 2.3711, 2.3773, 2.3836, 2.3898, 2.3961,
2.4023, 2.4086, 2.4148, 2.4211, 2.4273, 2.4336, 2.4398, 2.4461,
2.4523, 2.4586, 2.4648, 2.4711, 2.4773, 2.4836, 2.4898, 2.4961,
2.5023, 2.5086, 2.5148, 2.5211, 2.5273, 2.5336, 2.5398, 2.5461,
2.5523, 2.5586, 2.5648, 2.5711, 2.5773, 2.5836, 2.5898, 2.5961,
2.6023, 2.6086, 2.6148, 2.6211, 2.6273, 2.6336, 2.6398, 2.6461,
2.6523, 2.6586, 2.6648, 2.6711, 2.6773, 2.6836, 2.6898, 2.6961,
2.7023, 2.7086, 2.7148, 2.7211, 2.7273, 2.7336, 2.7398, 2.7461,
2.7523, 2.7586, 2.7648, 2.7711, 2.7773, 2.7836, 2.7898, 2.7961,
2.8023, 2.8086, 2.8148, 2.8211, 2.8273, 2.8336, 2.8398, 2.8461,
2.8523, 2.8586, 2.8648, 2.8711, 2.8773, 2.8836, 2.8898, 2.8961,
2.9023, 2.9086, 2.9148, 2.9211, 2.9273, 2.9336, 2.9398, 2.9461,
2.9523, 2.9586, 2.9648, 2.9711, 2.9773, 2.9836, 2.9898, 2.9961,
3.0023, 3.0086, 3.0148, 3.0211, 3.0273, 3.0336, 3.0398, 3.0461,
3.0523, 3.0586, 3.0648, 3.0711, 3.0773, 3.0836, 3.0898, 3.0961,
3.1023, 3.1086, 3.1148, 3.1211, 3.1273, 3.1336, 3.1398, 3.1461,
3.1523, 3.1586, 3.1648, 3.1711, 3.1773, 3.1836, 3.1898, 3.1961,
3.2023, 3.2086, 3.2148, 3.2211, 3.2273, 3.2336, 3.2398, 3.2461,
3.2523, 3.2586, 3.2648, 3.2711, 3.2773, 3.2836, 3.2898, 3.2961,
3.3023, 3.3086, 3.3148, 3.3211, 3.3273, 3.3336, 3.3398, 3.3461,
3.3523, 3.3586, 3.3648, 3.3711, 3.3773, 3.3836, 3.3898, 3.3961,
3.4023, 3.4086, 3.4148, 3.4211, 3.4273, 3.4336, 3.4398, 3.4461,
3.4523, 3.4586, 3.4648, 3.4711, 3.4773, 3.4836, 3.4898, 3.4961,
3.5023, 3.5086, 3.5148, 3.5211, 3.5273, 3.5336, 3.5398, 3.5461,
3.5523, 3.5586, 3.5648, 3.5711, 3.5773, 3.5836, 3.5898),
maxnFormants = 5, frame = list(list(intensity = 2.93217978222906e-06,
nFormants = 5, frequency = c(339.9, 1533.1, 2573.7, 3233,
3814), bandwidth = c(21.5, 571.4, 374, 110.1, 34.5)),
list(intensity = 2.93217978222906e-06, nFormants = 5,
frequency = c(328.6, 1512.7, 2436.8, 3320.4, 3841.4
), bandwidth = c(22, 607.8, 359.1, 179.9, 34.7)),
list(intensity = 2.93217978222906e-06, nFormants = 5,
frequency = c(325.8, 1574.1, 2452, 3346.8, 3838),
bandwidth = c(26.3, 465.3, 241.5, 164.8, 50.5)),
list(intensity = 2.93217978222906e-06, nFormants = 5,
frequency = c(317.5, 1515.9, 2406, 3319.5, 3803.3
), bandwidth = c(160.1, 487.4, 214.2, 114.5, 62.1
)), list(intensity = 1.77585520803808e-05, nFormants = 5,
frequency = c(169, 1430, 2474.9, 3394.4, 3839.2),
bandwidth = c(481.7, 491.3, 348.4, 82, 45.6)), list(
intensity = 1.77585520803808e-05, nFormants = 5,
frequency = c(250.5, 1616.9, 2511.2, 3440.8, 3811.1
), bandwidth = c(451.3, 463.5, 400.7, 92.8, 56.3)),
list(intensity = 1.77585520803808e-05, nFormants = 5,
frequency = c(333.7, 1757.6, 2674.5, 3463.3, 3792.7
), bandwidth = c(165.7, 380.4, 418.5, 92.8, 69.5)),
list(intensity = 1.77585520803808e-05, nFormants = 5,
frequency = c(342.4, 1337.2, 2431.6, 3505, 3874.5
), bandwidth = c(43.6, 1165.6, 282.1, 132.2, 30.6
)), list(intensity = 0.000865409715361889, nFormants = 5,
frequency = c(324.5, 1154.8, 2413.9, 3549.3, 3872
), bandwidth = c(38.9, 1176.6, 184.1, 119.6, 28.1
)), list(intensity = 0.00233852874519735, nFormants = 5,
frequency = c(301.3, 1300.3, 2436.6, 3518.7, 3874.2
), bandwidth = c(18.4, 621.4, 123.6, 127.1, 29.8)),
list(intensity = 0.00289034181751635, nFormants = 5,
frequency = c(343.5, 1230, 2375.9, 3494.4, 3890.4
), bandwidth = c(69.2, 1785.1, 368.7, 107.8, 24.4
)), list(intensity = 0.00289034181751635, nFormants = 5,
frequency = c(340.8, 987.6, 2368.9, 3520.5, 3880.6
), bandwidth = c(81.6, 1853.1, 276.4, 102.9, 26.1
)), list(intensity = 0.00917435755193477, nFormants = 5,
frequency = c(338.8, 864.9, 2396.3, 3566.6, 3876.6
), bandwidth = c(108.4, 1918, 286.6, 71, 28.1)),
list(intensity = 0.0103529653634511, nFormants = 5, frequency = c(313.5,
1103.7, 2403.4, 3554.5, 3888.3), bandwidth = c(104.3,
1754.6, 267.8, 60.5, 22.7)), list(intensity = 0.0188102351837758,
nFormants = 5, frequency = c(299.6, 1235.9, 2404.1,
3534.1, 3879.2), bandwidth = c(103.8, 1933, 202.9,
68.5, 34.4)), list(intensity = 0.0429740762739572,
nFormants = 5, frequency = c(311.3, 1539, 2388.5,
3501.5, 3881.2), bandwidth = c(90.3, 1969.9, 174.2,
59.1, 42.1)), list(intensity = 0.045654278246398,
nFormants = 5, frequency = c(345.4, 1794, 2371.3,
3468.7, 3887.9), bandwidth = c(69.3, 1527.7, 172.8,
89.2, 55.9)), list(intensity = 0.0630189862108861,
nFormants = 5, frequency = c(396.4, 1959.3, 2317.9,
3352.9, 3839.8), bandwidth = c(51.2, 1325.5, 216.6,
161.2, 68.7)), list(intensity = 0.13122599942023,
nFormants = 5, frequency = c(443.4, 2028.2, 2251.8,
3229, 3789.9), bandwidth = c(28.4, 1018.6, 188.3,
210.7, 58.2)), list(intensity = 0.23055782550916,
nFormants = 5, frequency = c(468.1, 2040, 2199.4,
3202.6, 3816.2), bandwidth = c(28.9, 853, 170.5,
257.1, 55.8)), list(intensity = 0.23055782550916,
nFormants = 5, frequency = c(518.2, 1856.1, 2135.4,
3140.1, 3790.5), bandwidth = c(57.3, 1024.6, 97.6,
279, 48.1)), list(intensity = 0.23055782550916, nFormants = 5,
frequency = c(601, 2006.8, 2103.7, 3091, 3809.3),
bandwidth = c(31.3, 500.4, 233.8, 361.1, 64.5)),
list(intensity = 0.23055782550916, nFormants = 5, frequency = c(608.6,
1971.6, 2197.9, 3071, 3807.4), bandwidth = c(25.4, 220.5,
383.2, 507.6, 51.8)), list(intensity = 0.23055782550916,
nFormants = 5, frequency = c(602.6, 1912.7, 2253.3,
3082.1, 3825.9), bandwidth = c(42, 200.1, 240.8,
459.8, 32.2)), list(intensity = 0.23055782550916,
nFormants = 5, frequency = c(599.6, 1925.1, 2230.3,
3038.9, 3823.5), bandwidth = c(107.4, 209.3, 265.2,
541.6, 31.2)), list(intensity = 0.23055782550916,
nFormants = 5, frequency = c(593.3, 1922.5, 2174.9,
3007, 3814.4), bandwidth = c(84.6, 251.9, 292.6,
451.5, 30.8)), list(intensity = 0.23055782550916,
nFormants = 5, frequency = c(580.6, 1927, 2111.7,
2954.6, 3832.1), bandwidth = c(59.2, 347.5, 257.5,
275.1, 34.4)), list(intensity = 0.222722705748011,
nFormants = 5, frequency = c(556.9, 1908.9, 2127.8,
2909.7, 3854.5), bandwidth = c(44.3, 391.2, 238.8,
221.8, 37.9)), list(intensity = 0.222722705748011,
nFormants = 5, frequency = c(518.7, 1699.2, 2110.5,
2871.5, 3818.5), bandwidth = c(43.4, 695.8, 124.5,
145.4, 72.3)), list(intensity = 0.151997930020442,
nFormants = 5, frequency = c(458.8, 1495.4, 2115.3,
2917, 3745.3), bandwidth = c(56.1, 830, 136.3, 178.8,
164.9)), list(intensity = 0.118416331761164, nFormants = 5,
frequency = c(451.1, 1389.7, 2109.1, 2890.6, 3795.5
), bandwidth = c(68.8, 922.1, 145.2, 191.2, 91.6)),
list(intensity = 0.050794924078466, nFormants = 5, frequency = c(523.2,
1414.5, 2126.4, 2750.6, 3768.5), bandwidth = c(63.1,
991.7, 228.4, 226, 97.6)), list(intensity = 0.010696271021193,
nFormants = 5, frequency = c(521.4, 1628.7, 2040.7,
2780.5, 3757.2), bandwidth = c(72.1, 819.8, 215,
144.9, 117.3)), list(intensity = 0.00448207061280216,
nFormants = 5, frequency = c(475.8, 1853.2, 2088,
2878.6, 3748.9), bandwidth = c(95.6, 606.5, 362.7,
201, 70.2)), list(intensity = 0.00152812154214752,
nFormants = 5, frequency = c(502.9, 1675.1, 2269.3,
3052, 3772.7), bandwidth = c(83.8, 321.8, 269.7,
204.4, 58.5)), list(intensity = 0.000711658100860156,
nFormants = 5, frequency = c(523.2, 1636.3, 2119.9,
2838.7, 3777.7), bandwidth = c(117.4, 316.1, 288,
233.2, 55.2)), list(intensity = 0.000402536213523537,
nFormants = 5, frequency = c(480.6, 1586.5, 2115.6,
2765.6, 3761.8), bandwidth = c(62.7, 352.3, 167.2,
150.9, 79.4)), list(intensity = 0.000258029956161726,
nFormants = 5, frequency = c(454.6, 1697.4, 2322.2,
3041, 3833.4), bandwidth = c(67.5, 386.5, 245.7,
464, 62.5)), list(intensity = 0.000258029956161726,
nFormants = 5, frequency = c(526.6, 1708.8, 2415,
3361.9, 3880.4), bandwidth = c(167.6, 328.7, 237.3,
208, 56.9)), list(intensity = 0.00133973626436287,
nFormants = 5, frequency = c(610.3, 1856.5, 2488.3,
3382.4, 3858.4), bandwidth = c(314.6, 250.9, 334.5,
214.8, 63.5)), list(intensity = 0.00137738518966813,
nFormants = 5, frequency = c(573, 1742.1, 2375.1,
3352.3, 3795.1), bandwidth = c(417.7, 315.4, 285.2,
245.8, 52.3)), list(intensity = 0.00876778925706674,
nFormants = 5, frequency = c(492.6, 1727.2, 2511.5,
3361.7, 3856.3), bandwidth = c(282.1, 276.5, 345.3,
160, 49.4)), list(intensity = 0.0138050355806256,
nFormants = 5, frequency = c(342.5, 1835, 2523.8,
3352.4, 3874.5), bandwidth = c(110.6, 487.7, 420.7,
86.6, 58.6)), list(intensity = 0.0142673542457718,
nFormants = 5, frequency = c(318.9, 1741.7, 2331,
3346.2, 3851.4), bandwidth = c(61.7, 831, 435.5,
77.8, 41.2)), list(intensity = 0.0142673542457718,
nFormants = 5, frequency = c(314.3, 1819.1, 2222.7,
3273.8, 3831.4), bandwidth = c(64.4, 1295, 320, 105.5,
38.9)), list(intensity = 0.0142673542457718, nFormants = 5,
frequency = c(321.7, 1821.4, 2201.8, 3183.6, 3839.9
), bandwidth = c(67.4, 1059.9, 244.4, 87.4, 21.7)),
list(intensity = 0.0142673542457718, nFormants = 5, frequency = c(345.3,
1704.8, 2190.1, 3098.1, 3841.4), bandwidth = c(90.9,
1164.5, 230.8, 107.5, 19.6)), list(intensity = 0.0142673542457718,
nFormants = 5, frequency = c(368.6, 1583.7, 2195.3,
3038, 3821.9), bandwidth = c(106.6, 1202.7, 361.9,
124.4, 29.9)), list(intensity = 0.0142673542457718,
nFormants = 5, frequency = c(386, 1407.2, 2213.2,
2995.1, 3823.3), bandwidth = c(113, 1205.1, 441.8,
148.3, 40.4)), list(intensity = 0.0142673542457718,
nFormants = 5, frequency = c(410, 928.9, 2210.3,
2834.6, 3854.6), bandwidth = c(142.7, 2010.8, 277.1,
101.3, 37.4)), list(intensity = 0.0142673542457718,
nFormants = 5, frequency = c(411.6, 775.2, 2124.5,
2800.7, 3793.9), bandwidth = c(126.3, 2591.8, 113.9,
65.6, 100.7)), list(intensity = 0.0104527795613987,
nFormants = 5, frequency = c(395.9, 1549, 2070.3,
2842.5, 3894.1), bandwidth = c(96.5, 2667.9, 263.3,
167.5, 47.6)), list(intensity = 0.00868052825109016,
nFormants = 5, frequency = c(366, 1744.7, 2568.6,
3189.1, 3851.5), bandwidth = c(66.5, 445.9, 574,
784.1, 30.7)), list(intensity = 0.00868052825109016,
nFormants = 5, frequency = c(311.8, 1753.9, 2590.7,
3298.2, 3848.9), bandwidth = c(59.3, 283.5, 400.5,
667.9, 16.1)), list(intensity = 0.00868052825109016,
nFormants = 5, frequency = c(321.6, 1784.7, 2707.3,
3031.7, 3854.5), bandwidth = c(71.7, 404.3, 305.7,
501.8, 14.6)), list(intensity = 0.00564407640504595,
nFormants = 5, frequency = c(389.4, 1921.3, 2733.4,
3037.3, 3820), bandwidth = c(108, 215.7, 326, 520.4,
40.1)), list(intensity = 0.00770637859987075, nFormants = 5,
frequency = c(332.2, 1931.6, 2697.3, 3267, 3809.9
), bandwidth = c(124.3, 133.1, 260.3, 511.5, 34.1
)), list(intensity = 0.0152481798092707, nFormants = 5,
frequency = c(270.9, 1942.2, 2782.5, 3306.4, 3847.1
), bandwidth = c(41.4, 80, 297, 572.1, 28.1)), list(
intensity = 0.0152481798092707, nFormants = 5, frequency = c(290.7,
1861, 2845.3, 3191.9, 3836.5), bandwidth = c(41.7,
145.2, 332.9, 860.7, 34.7)), list(intensity = 0.0307296068405123,
nFormants = 5, frequency = c(341.7, 1851.5, 2309.2,
2944.2, 3765.7), bandwidth = c(74.3, 293.6, 1639.9,
310.4, 43.4)), list(intensity = 0.0307296068405123,
nFormants = 5, frequency = c(392.9, 1548.5, 2016,
2958.7, 3812.4), bandwidth = c(96, 2118.7, 195, 243.9,
48.9)), list(intensity = 0.0307296068405123, nFormants = 5,
frequency = c(432, 1215, 2061.4, 3087.2, 3776), bandwidth = c(97.5,
2071.5, 117.7, 270.1, 68)), list(intensity = 0.0307296068405123,
nFormants = 5, frequency = c(458.6, 1299.8, 2122.6,
3050.3, 3844.8), bandwidth = c(78.1, 1923.5, 122.3,
307.5, 42.8)), list(intensity = 0.0307296068405123,
nFormants = 5, frequency = c(466.6, 1644.1, 2118.1,
2993.7, 3861), bandwidth = c(60.3, 2025.6, 132.4,
267.4, 19.9)), list(intensity = 0.0307296068405123,
nFormants = 5, frequency = c(456, 1720.8, 2090.4,
3011.9, 3833.7), bandwidth = c(64.1, 2029.4, 170,
251, 27.7)), list(intensity = 0.0307296068405123,
nFormants = 5, frequency = c(429.9, 1901.1, 2057.5,
3054.6, 3837), bandwidth = c(72.7, 1816.1, 303.8,
353.7, 63.1)), list(intensity = 0.0307296068405123,
nFormants = 5, frequency = c(415.9, 1792, 2270.2,
3135.7, 3835.9), bandwidth = c(68, 871.4, 777.7,
371.7, 54.1)), list(intensity = 0.0224066323451793,
nFormants = 5, frequency = c(426.6, 1663.3, 2154.4,
3159.1, 3858.3), bandwidth = c(61.5, 1104.9, 338,
341.8, 30.3)), list(intensity = 0.0161413254888746,
nFormants = 5, frequency = c(425.8, 1633.9, 2201.3,
3068.8, 3875.9), bandwidth = c(49.8, 1151.5, 156.4,
371.7, 21.1)), list(intensity = 0.00818605910799823,
nFormants = 5, frequency = c(430.4, 1599.4, 2186.9,
3089.3, 3830.7), bandwidth = c(46.4, 1733.4, 83.6,
396.2, 26.7)), list(intensity = 0.00818605910799823,
nFormants = 5, frequency = c(399.6, 1804.5, 2178.5,
3078.5, 3849.6), bandwidth = c(53.2, 1155.1, 150.5,
313.6, 25.6)), list(intensity = 0.00750200818538844,
nFormants = 5, frequency = c(322.5, 1820.4, 2261.2,
3007.5, 3809.6), bandwidth = c(85.2, 405.4, 299.2,
202.6, 50.4)), list(intensity = 0.00599606498935324,
nFormants = 5, frequency = c(313.7, 1746.7, 2306.9,
3025.9, 3736.2), bandwidth = c(182.7, 417.4, 246.4,
213.7, 80.6)), list(intensity = 0.00271237243505942,
nFormants = 5, frequency = c(397, 1703.2, 2249.7,
3103.3, 3693.5), bandwidth = c(135.7, 419, 158.9,
248.4, 87)), list(intensity = 0.00144206795086777,
nFormants = 5, frequency = c(384.9, 1624.9, 2233.5,
3106, 3737.1), bandwidth = c(102.3, 426.5, 190.2,
209.9, 92.1)), list(intensity = 0.00715069702295081,
nFormants = 5, frequency = c(336, 1632, 2285.9, 2953.4,
3735.5), bandwidth = c(69, 141.8, 339.2, 252, 131
)), list(intensity = 0.00715069702295081, nFormants = 5,
frequency = c(338.7, 1544.9, 2235, 2848.3, 3753.7
), bandwidth = c(173, 113.2, 406.5, 186, 101.8)),
list(intensity = 0.00715069702295081, nFormants = 5,
frequency = c(318.6, 1558.1, 2326.7, 2853.6, 3791.9
), bandwidth = c(229.6, 99.4, 459.5, 204.7, 68.9)),
list(intensity = 0.00715069702295081, nFormants = 5,
frequency = c(267.6, 1507.9, 2163.8, 2774.3, 3692.7
), bandwidth = c(644, 51.3, 410.5, 73.5, 130.4)),
list(intensity = 0.00715069702295081, nFormants = 5,
frequency = c(255.4, 1490, 2148.9, 2759.1, 3684.4
), bandwidth = c(636, 29, 394.8, 51.1, 177.9)), list(
intensity = 0.00715069702295081, nFormants = 5, frequency = c(289.9,
1490.9, 2298.8, 2834.3, 3764.9), bandwidth = c(216.3,
24.8, 387.2, 64.8, 118.2)), list(intensity = 0.00715069702295081,
nFormants = 5, frequency = c(272.2, 1530.4, 2271.8,
2804.9, 3709.3), bandwidth = c(15.8, 103.5, 722.8,
45.5, 150.4)), list(intensity = 0.00715069702295081,
nFormants = 5, frequency = c(269.2, 1400.9, 1712.8,
2741.1, 3558.6), bandwidth = c(16.1, 812.6, 369,
41.7, 284.4)), list(intensity = 0.00638473144187371,
nFormants = 5, frequency = c(265.7, 1223.1, 1798.6,
2669.2, 3700.8), bandwidth = c(23.4, 758.3, 391.4,
34.4, 367.2)), list(intensity = 0.00638473144187371,
nFormants = 5, frequency = c(267.6, 1243.4, 1872,
2670.3, 3788.9), bandwidth = c(26, 627.7, 449.2,
25.5, 226.9)), list(intensity = 0.00638473144187371,
nFormants = 5, frequency = c(268.8, 1230.8, 1882.6,
2665, 3737.5), bandwidth = c(31.8, 653.4, 440.7,
23.5, 247)), list(intensity = 0.0125163756623175,
nFormants = 5, frequency = c(273.3, 1141.3, 2005.1,
2635.6, 3729.3), bandwidth = c(45.1, 741.8, 471.8,
31.2, 310.3)), list(intensity = 0.0125163756623175,
nFormants = 5, frequency = c(285.9, 943.3, 2098.8,
2642.2, 3779.5), bandwidth = c(71.4, 842.1, 392.7,
44, 234.7)), list(intensity = 0.0125163756623175,
nFormants = 5, frequency = c(303.6, 1052.2, 2069.9,
2671.5, 3689.3), bandwidth = c(91.1, 1139.7, 601,
57.1, 199.3)), list(intensity = 0.0125163756623175,
nFormants = 5, frequency = c(303.4, 1480.8, 2499.1,
3009.2, 3725.5), bandwidth = c(55.5, 270.6, 501.4,
298.9, 186)), list(intensity = 0.0125163756623175,
nFormants = 5, frequency = c(310.1, 1515.8, 2398.4,
3114.3, 3765.3), bandwidth = c(73.6, 124, 407.8,
163.7, 115.4)), list(intensity = 0.0125163756623175,
nFormants = 5, frequency = c(337.9, 1471.6, 2346.6,
3119.9, 3737.7), bandwidth = c(76, 83, 391.2, 336.9,
87.5)), list(intensity = 0.0125163756623175, nFormants = 5,
frequency = c(391.8, 1463.1, 2380.4, 3007.9, 3721
), bandwidth = c(84.2, 89.3, 708.7, 517.7, 58.1)),
list(intensity = 0.0125163756623175, nFormants = 5, frequency = c(405.4,
1447.8, 2353, 3166, 3741.7), bandwidth = c(69, 94.4,
592.1, 495.2, 53.3)), list(intensity = 0.00420953641728538,
nFormants = 5, frequency = c(376.4, 1443.4, 2318.8,
3268.3, 3751), bandwidth = c(62.2, 141.1, 584.2,
496.8, 56.5)), list(intensity = 0.00420953641728538,
nFormants = 5, frequency = c(337, 1400.9, 2416.1,
3340.9, 3816.2), bandwidth = c(53.6, 238.9, 474.9,
474.5, 58.9)), list(intensity = 0.00268061202463476,
nFormants = 5, frequency = c(297.3, 1413.2, 2472.1,
3494.3, 3830.7), bandwidth = c(41.8, 229.5, 320.6,
276.2, 74.7)), list(intensity = 0.00250045187386288,
nFormants = 5, frequency = c(271, 1419.6, 2474.5,
3384.2, 3796.4), bandwidth = c(60, 211.2, 394.1,
226.4, 55.6)), list(intensity = 0.00187782080373519,
nFormants = 5, frequency = c(262.8, 1464.9, 2586,
3445.3, 3847.5), bandwidth = c(95.6, 227.5, 449.1,
199.4, 36.1)), list(intensity = 0.0011458277105932,
nFormants = 5, frequency = c(346.2, 1592.3, 2696.2,
3523.2, 3916.5), bandwidth = c(103.8, 181.1, 321.4,
119.1, 48.1)), list(intensity = 0.000345564827832182,
nFormants = 5, frequency = c(365.8, 1647.7, 2728,
3466.2, 3901.2), bandwidth = c(123, 172.8, 252.3,
124.9, 37.4)), list(intensity = 0.000261694268945735,
nFormants = 5, frequency = c(321.2, 1543.4, 2698.8,
3463, 3877.2), bandwidth = c(253.1, 87.6, 215.9,
93.2, 30.4)), list(intensity = 0.000261694268945735,
nFormants = 5, frequency = c(307.7, 1523.1, 2724.6,
3439.3, 3839.2), bandwidth = c(459.9, 55.8, 249.1,
242, 48.9)), list(intensity = 0.000261694268945735,
nFormants = 5, frequency = c(322.2, 1594.4, 2695.1,
3374.8, 3885.9), bandwidth = c(676.9, 126.3, 339,
233.7, 23.2)), list(intensity = 0.000919147332477818,
nFormants = 5, frequency = c(201.2, 1720, 2731.8,
3365.6, 3885.6), bandwidth = c(958.3, 139.8, 378.8,
291.8, 25.2)), list(intensity = 0.000989706697097458,
nFormants = 5, frequency = c(663.4, 1709.9, 2621.1,
3360, 3921.1), bandwidth = c(1261.7, 189.3, 425.9,
263.8, 46.1)), list(intensity = 0.000989706697097458,
nFormants = 5, frequency = c(904.3, 1767.4, 2596.5,
3376.6, 3913), bandwidth = c(953.2, 222.6, 397.7,
180.2, 51.9)), list(intensity = 0.00112965066754122,
nFormants = 5, frequency = c(614, 1712.4, 2746, 3452.5,
3916.2), bandwidth = c(354.8, 187.7, 157.5, 162.5,
18.9)), list(intensity = 0.00642620535367012, nFormants = 5,
frequency = c(575.6, 1752.9, 2782.8, 3405.1, 3920.8
), bandwidth = c(256.5, 248.1, 123.4, 368.4, 10)),
list(intensity = 0.00699809646436631, nFormants = 5,
frequency = c(545.2, 1788.7, 2784.1, 3382.6, 3901.3
), bandwidth = c(387.5, 197.7, 214.2, 629.5, 11.8
)), list(intensity = 0.0160276957140407, nFormants = 5,
frequency = c(387.4, 1556.4, 2712.9, 3070.3, 3850.5
), bandwidth = c(168.6, 122, 486.2, 803.3, 12.6)),
list(intensity = 0.0160276957140407, nFormants = 5, frequency = c(421.1,
1483.2, 2315, 3016.2, 3794.1), bandwidth = c(91.7, 139.4,
1455.5, 460.7, 29.3)), list(intensity = 0.0160276957140407,
nFormants = 5, frequency = c(475.4, 1446.9, 2281,
2902.9, 3760.9), bandwidth = c(83.6, 177.8, 1309,
346, 37.3)), list(intensity = 0.0160276957140407,
nFormants = 5, frequency = c(514.5, 1456.1, 2266.4,
2876.6, 3730), bandwidth = c(64, 107.5, 1058, 234.5,
63.7)), list(intensity = 0.0160276957140407, nFormants = 5,
frequency = c(523.6, 1435.4, 2439.7, 3000, 3678),
bandwidth = c(59.4, 58.4, 712.6, 361.7, 59.8)), list(
intensity = 0.0160276957140407, nFormants = 5, frequency = c(534.9,
1387.3, 2480.8, 3164.6, 3662.1), bandwidth = c(55.1,
48.6, 515, 481.1, 71)), list(intensity = 0.0160276957140407,
nFormants = 5, frequency = c(529.7, 1349.7, 2445.4,
3242.6, 3681.6), bandwidth = c(54.5, 75, 511.3, 425.8,
101.6)), list(intensity = 0.0160276957140407, nFormants = 5,
frequency = c(521.1, 1342.9, 2422.8, 3143.4, 3630.4
), bandwidth = c(61.1, 135.3, 627.4, 541.2, 102.1
)), list(intensity = 0.0155653983452974, nFormants = 5,
frequency = c(507.8, 1214, 2414, 3008.4, 3607.6),
bandwidth = c(74.2, 276.2, 653, 636.6, 78.7)), list(
intensity = 0.00478574377560196, nFormants = 5, frequency = c(505.7,
1075.5, 2315.2, 2962.6, 3615.2), bandwidth = c(80.1,
198.3, 567.1, 491.3, 58.2)), list(intensity = 0.00206184974003803,
nFormants = 5, frequency = c(461.5, 1049.4, 2189.3,
2917.9, 3613.1), bandwidth = c(83.1, 137.4, 618.2,
302.7, 76.3)), list(intensity = 0.00104133059362965,
nFormants = 5, frequency = c(444.8, 1018.6, 2168.7,
2926.3, 3641.8), bandwidth = c(74.8, 141.9, 693.6,
365.1, 110.1)), list(intensity = 0.00104133059362965,
nFormants = 5, frequency = c(426.6, 967.6, 2357.6,
3026.7, 3669.3), bandwidth = c(76.6, 184.8, 538.1,
503.3, 103.3)), list(intensity = 0.000852340820135399,
nFormants = 5, frequency = c(405.4, 980.8, 2317.8,
3083.5, 3667), bandwidth = c(69.6, 139.3, 542.6,
505.8, 111.7)), list(intensity = 0.00133004447372437,
nFormants = 5, frequency = c(406.1, 985.3, 2211,
3104.4, 3661.5), bandwidth = c(50, 79.6, 514.5, 423.7,
108.4)), list(intensity = 0.00186360863078154, nFormants = 5,
frequency = c(427.2, 988.2, 2282.1, 3180, 3699.1),
bandwidth = c(50.1, 90.5, 423.4, 485.8, 97.1)), list(
intensity = 0.00260003531833227, nFormants = 5, frequency = c(411.8,
1017.4, 2289.1, 3148.1, 3653.9), bandwidth = c(55.1,
153.3, 386.8, 499.4, 83.2)), list(intensity = 0.00260003531833227,
nFormants = 5, frequency = c(403.1, 1129.1, 2233.5,
3041.9, 3627.4), bandwidth = c(50.5, 215.4, 416.1,
511.6, 63.5)), list(intensity = 0.00260003531833227,
nFormants = 5, frequency = c(378.5, 1248.9, 2187.5,
3200.2, 3642), bandwidth = c(44, 152.4, 284.6, 487.2,
81.4)), list(intensity = 0.00260003531833227, nFormants = 5,
frequency = c(370.4, 1388, 2144.2, 3245.8, 3669.3
), bandwidth = c(34.6, 201.1, 237.4, 478.1, 87.8)),
list(intensity = 0.00260003531833227, nFormants = 5,
frequency = c(364.4, 1513.6, 2124, 3259.6, 3688.5
), bandwidth = c(29.9, 221.4, 276.8, 355.2, 79.1)),
list(intensity = 0.00260003531833227, nFormants = 5,
frequency = c(351.1, 1636.7, 2107.8, 3255.2, 3686.3
), bandwidth = c(25.9, 294, 393.4, 316.9, 76.7)),
list(intensity = 0.00260003531833227, nFormants = 5,
frequency = c(332.4, 1698.4, 2092.3, 3317.2, 3721.8
), bandwidth = c(29.2, 403.1, 483.3, 311.8, 103.7
)), list(intensity = 0.00296775551251341, nFormants = 5,
frequency = c(300.4, 1677.9, 2124.6, 3108.8, 3758.5
), bandwidth = c(40, 484.3, 529.9, 397.6, 50.2)),
list(intensity = 0.00301832800237571, nFormants = 5,
frequency = c(309.3, 1838, 2114.7, 3150.3, 3747.4
), bandwidth = c(38.3, 706.8, 465.1, 302.3, 33.2)),
list(intensity = 0.00324185193553367, nFormants = 5,
frequency = c(333.9, 2087.7, 2123.2, 3162.7, 3728.4
), bandwidth = c(31.4, 284.4, 1415, 248.7, 26.7)),
list(intensity = 0.00438439537305187, nFormants = 5,
frequency = c(349.6, 2109.6, 2152.9, 3176.3, 3737.6
), bandwidth = c(23.8, 152.5, 1499.3, 244.5, 31.8
)), list(intensity = 0.0063776476801628, nFormants = 5,
frequency = c(359.2, 2104.6, 2212.8, 3160.6, 3747.4
), bandwidth = c(19.2, 133.1, 1306.5, 255.7, 49.6
)), list(intensity = 0.0107139311912401, nFormants = 5,
frequency = c(367.9, 2105.9, 2129.4, 3094.1, 3737
), bandwidth = c(18.4, 113.6, 1398.8, 194.9, 57.6
)), list(intensity = 0.0153124542623669, nFormants = 5,
frequency = c(378.5, 2067.8, 2156.8, 3068.5, 3734.8
), bandwidth = c(23.9, 141.9, 1219.2, 180, 43.1)),
list(intensity = 0.0198890819991012, nFormants = 5, frequency = c(401.4,
2023.4, 2150.9, 3074.4, 3715), bandwidth = c(38.8, 108.7,
1310.3, 218.1, 38.6)), list(intensity = 0.0198890819991012,
nFormants = 5, frequency = c(448.1, 2007.2, 2173,
3083.9, 3713.7), bandwidth = c(43.2, 90.5, 1118.7,
321.1, 44.6)), list(intensity = 0.0301958090901889,
nFormants = 5, frequency = c(481.3, 1999.2, 2066.4,
3030, 3712.9), bandwidth = c(31.4, 99.6, 876.9, 287.1,
24.3)), list(intensity = 0.0301958090901889, nFormants = 5,
frequency = c(499.3, 1953.1, 2066.5, 3035.7, 3712.9
), bandwidth = c(26.3, 173.4, 571.1, 270.1, 23.3)),
list(intensity = 0.0301958090901889, nFormants = 5, frequency = c(514.5,
1834.8, 2256.2, 3045.1, 3760.1), bandwidth = c(38.8,
142.8, 441.6, 404.1, 33.4)), list(intensity = 0.0301958090901889,
nFormants = 5, frequency = c(556.9, 1775.3, 2336.6,
2922.7, 3780.8), bandwidth = c(71.8, 111.1, 709.6,
431.2, 28)), list(intensity = 0.0301958090901889,
nFormants = 5, frequency = c(592.4, 1725.9, 2316.2,
2859.7, 3813.4), bandwidth = c(64.2, 133.3, 949.7,
387, 23.1)), list(intensity = 0.0301958090901889,
nFormants = 5, frequency = c(598.6, 1665.4, 2240.7,
2894, 3815.7), bandwidth = c(63.5, 176.4, 1083.8,
303.3, 26.7)), list(intensity = 0.0301958090901889,
nFormants = 5, frequency = c(587.3, 1568.4, 2332.8,
2857.5, 3832.1), bandwidth = c(68.6, 190.8, 1078.4,
293.7, 34.2)), list(intensity = 0.0301958090901889,
nFormants = 5, frequency = c(572.7, 1469.3, 2240.1,
2827.6, 3834.8), bandwidth = c(98.4, 225.2, 917.1,
193.2, 18.5)), list(intensity = 0.0300040008755732,
nFormants = 5, frequency = c(556.9, 1369.3, 2112.2,
2800.4, 3850.9), bandwidth = c(101.5, 226.1, 785.6,
140.2, 9.4)), list(intensity = 0.027750856892738,
nFormants = 5, frequency = c(567.5, 1322.6, 2348.2,
2842.8, 3863), bandwidth = c(87.6, 178.6, 938.5,
243.2, 23.6)), list(intensity = 0.0173385805483246,
nFormants = 5, frequency = c(569.7, 1281.3, 2266.6,
2876.9, 3886.8), bandwidth = c(116.7, 226.7, 858.6,
254.8, 25.5)), list(intensity = 0.00754156384866431,
nFormants = 5, frequency = c(570.7, 1209, 2219.9,
2878, 3901.1), bandwidth = c(125, 256.3, 584.4, 238.7,
23.9)), list(intensity = 0.00754156384866431, nFormants = 5,
frequency = c(581.3, 1221.3, 2288, 2854.6, 3922.8
), bandwidth = c(122.4, 180.7, 666, 193.6, 22.1)),
list(intensity = 0.00754156384866431, nFormants = 5,
frequency = c(624.2, 1257.7, 2278.7, 2847.9, 3887.5
), bandwidth = c(169.8, 183.8, 866.3, 172.5, 29.9
)), list(intensity = 0.00754156384866431, nFormants = 5,
frequency = c(700.5, 1290.3, 2154.9, 2841.6, 3856.6
), bandwidth = c(191.1, 234.7, 872.2, 121.6, 26.9
)), list(intensity = 0.00754156384866431, nFormants = 5,
frequency = c(734.9, 1291.5, 2079.6, 2820.1, 3847.3
), bandwidth = c(173, 308.2, 846.4, 111.8, 41.4)),
list(intensity = 0.00754156384866431, nFormants = 5,
frequency = c(731.3, 1296, 2043.5, 2819.1, 3829.7
), bandwidth = c(201.4, 425.2, 930.7, 128.3, 56.9
)), list(intensity = 0.00754156384866431, nFormants = 5,
frequency = c(653.5, 1253.5, 2019.2, 2835.4, 3801.5
), bandwidth = c(272.5, 291.9, 614.5, 146, 48.7)),
list(intensity = 0.00569208372222114, nFormants = 5,
frequency = c(673.9, 1255.6, 1946.4, 2813.4, 3852.8
), bandwidth = c(307.5, 378.7, 666.9, 135.7, 46.7
)), list(intensity = 0.00551875362993072, nFormants = 5,
frequency = c(681.1, 1270.2, 1901.2, 2789.8, 3853.2
), bandwidth = c(333.2, 405.4, 670.5, 109.4, 43.8
)), list(intensity = 0.00395476971861012, nFormants = 5,
frequency = c(674, 1238.8, 1911.9, 2791.6, 3821.6
), bandwidth = c(361.4, 375.3, 703.1, 80.4, 60)),
list(intensity = 0.00395476971861012, nFormants = 5,
frequency = c(718.7, 1234.1, 1771.9, 2782, 3825.7
), bandwidth = c(372.9, 522.5, 805.6, 68.6, 67.7)),
list(intensity = 0.00395476971861012, nFormants = 5,
frequency = c(660, 1301.5, 1743.1, 2775.1, 3821.9
), bandwidth = c(290.7, 486.9, 589.8, 147.9, 65)),
list(intensity = 0.00319039193138373, nFormants = 5,
frequency = c(677.9, 1419.1, 1684.9, 2772.5, 3833.9
), bandwidth = c(289.5, 604.4, 652.1, 117.8, 38.4
)), list(intensity = 0.00319039193138373, nFormants = 5,
frequency = c(661.1, 1524, 1530.1, 2762.9, 3796.5
), bandwidth = c(325.7, 240.5, 1719.5, 133, 38.9)),
list(intensity = 0.00227653511421427, nFormants = 5,
frequency = c(599.5, 1375.3, 1556.5, 2768.5, 3774
), bandwidth = c(376.3, 976.1, 379.4, 83.5, 55.5)),
list(intensity = 0.00206148652355773, nFormants = 5,
frequency = c(504.8, 1301.9, 1803, 2794.8, 3817.1
), bandwidth = c(277.2, 511.1, 508.7, 111.9, 35.4
)), list(intensity = 0.00206148652355773, nFormants = 5,
frequency = c(569.3, 1370.8, 1809, 2781, 3858), bandwidth = c(312.3,
876.7, 435.2, 90.5, 14)), list(intensity = 0.00206148652355773,
nFormants = 5, frequency = c(666.3, 1345.8, 1823.3,
2766.3, 3865.5), bandwidth = c(316.4, 1099.9, 424.4,
58.7, 11.5)), list(intensity = 0.00115979735261578,
nFormants = 5, frequency = c(557.8, 1556.3, 1863.2,
2743.8, 3827), bandwidth = c(410.3, 890.6, 937, 103.4,
15.6)), list(intensity = 0.00115979735261578, nFormants = 5,
frequency = c(565.8, 1641.9, 1833.3, 2774.1, 3810.4
), bandwidth = c(439.8, 597.7, 1423.5, 115.3, 23.8
)), list(intensity = 0.00115979735261578, nFormants = 5,
frequency = c(456.8, 1684, 2585.8, 3256, 3822), bandwidth = c(313.5,
64.1, 385.4, 747.3, 45.2)), list(intensity = 0.00077713370123567,
nFormants = 5, frequency = c(312.9, 1687.6, 2430.5,
3412.2, 3800.8), bandwidth = c(305.9, 72.6, 419.4,
563.8, 38.9)), list(intensity = 0.00077713370123567,
nFormants = 5, frequency = c(326.5, 1677.2, 2469.6,
2984.8, 3735.9), bandwidth = c(514.3, 256.4, 826.3,
649.5, 32.5)), list(intensity = 0.000472091215322859,
nFormants = 5, frequency = c(334.6, 1574.8, 2243,
2950.5, 3693.1), bandwidth = c(610.9, 565.3, 897.7,
372.7, 41)), list(intensity = 0.000472091215322859,
nFormants = 5, frequency = c(276.8, 1768.9, 2401.5,
3018.2, 3786.4), bandwidth = c(467.2, 227.3, 573.5,
484.1, 74.6)), list(intensity = 0.000184727798386559,
nFormants = 5, frequency = c(432.7, 1809.7, 2421,
3249.4, 3825.4), bandwidth = c(346.6, 122.2, 284.1,
453.9, 58.9)), list(intensity = 0.000182213651688614,
nFormants = 5, frequency = c(508.1, 1740.4, 2317.3,
3274.3, 3803.7), bandwidth = c(404.9, 145.1, 242.9,
328, 55.6)), list(intensity = 0.000182213651688614,
nFormants = 5, frequency = c(490.7, 1764.6, 2220.4,
3168.6, 3766.2), bandwidth = c(544.5, 257.5, 234.1,
240.6, 49.8)), list(intensity = 0.000598170481817972,
nFormants = 5, frequency = c(392.8, 1880.4, 2273.5,
3147.2, 3837), bandwidth = c(651.4, 159, 327.3, 280.3,
42)), list(intensity = 0.000598170481817972, nFormants = 5,
frequency = c(425.2, 1873.8, 2286.6, 3174.1, 3899.5
), bandwidth = c(986.1, 150.2, 242.5, 265, 41.1)),
list(intensity = 0.000598170481817972, nFormants = 5,
frequency = c(593.4, 1946.9, 2327.3, 3212.2, 3772.6
), bandwidth = c(869.8, 187.9, 335.4, 269.1, 57.3
)), list(intensity = 0.000697164001937284, nFormants = 5,
frequency = c(635.1, 1917.6, 2411.1, 3250.2, 3734.8
), bandwidth = c(433.9, 54.6, 352.4, 242.4, 20.4)),
list(intensity = 0.000697164001937284, nFormants = 5,
frequency = c(643.8, 1885.6, 2432.3, 3347.4, 3774.9
), bandwidth = c(549.3, 53.6, 295, 235.3, 26.2)),
list(intensity = 0.000752711347563872, nFormants = 5,
frequency = c(796.1, 1900.5, 2589.4, 3262.9, 3794.7
), bandwidth = c(711.4, 65.8, 359.6, 411.5, 41.9)),
list(intensity = 0.000752711347563872, nFormants = 5,
frequency = c(862.7, 1941, 2608.8, 3121.5, 3758.9
), bandwidth = c(594.9, 40.7, 461.1, 266, 43.6)),
list(intensity = 0.000844172475906858, nFormants = 5,
frequency = c(885.9, 1913.2, 2537, 3133.2, 3756.2
), bandwidth = c(791.7, 74.5, 317.7, 227.6, 37.7)),
list(intensity = 0.00110114745022537, nFormants = 5,
frequency = c(844.1, 1958.1, 2484.9, 3121.6, 3750.7
), bandwidth = c(693, 198.2, 260.5, 267, 60.2)),
list(intensity = 0.00110114745022537, nFormants = 5,
frequency = c(1102.6, 1912.5, 2343, 3091.4, 3750.1
), bandwidth = c(1113.6, 371.8, 259.9, 203.6, 81)),
list(intensity = 0.00110114745022537, nFormants = 5,
frequency = c(1132.5, 1922.1, 2374.9, 3207.7, 3807.9
), bandwidth = c(1077, 166, 366.2, 216.8, 52)), list(
intensity = 0.001717722745204, nFormants = 5, frequency = c(940.2,
1956.2, 2501, 3250.9, 3797.8), bandwidth = c(711.8,
70, 255.1, 244.6, 76.4)), list(intensity = 0.001717722745204,
nFormants = 5, frequency = c(1007.5, 2021.7, 2526.4,
3277.5, 3751.4), bandwidth = c(602.8, 86.7, 271.1,
289.3, 105.5)), list(intensity = 0.001717722745204,
nFormants = 5, frequency = c(973.2, 1949.6, 2536.8,
3137.1, 3758.3), bandwidth = c(642.6, 166.6, 228.1,
340, 50.1)), list(intensity = 0.001717722745204,
nFormants = 5, frequency = c(1205.7, 1905.5, 2564.6,
3336.7, 3807.8), bandwidth = c(696.9, 217.9, 242.6,
258.8, 102.8)), list(intensity = 0.001717722745204,
nFormants = 5, frequency = c(1219.5, 1927.1, 2517.6,
3421.1, 3834.4), bandwidth = c(811.8, 97.7, 203.5,
128.8, 100.9)), list(intensity = 0.001717722745204,
nFormants = 5, frequency = c(1117.8, 1920.4, 2656.1,
3339.1, 3853.7), bandwidth = c(735.1, 52.2, 171.2,
277, 54.8)), list(intensity = 0.001717722745204,
nFormants = 5, frequency = c(1166, 1980.9, 2608,
3341.6, 3868.4), bandwidth = c(701.4, 196.4, 176.1,
250.5, 60)), list(intensity = 0.001717722745204,
nFormants = 5, frequency = c(945.9, 1986, 2476.2,
3289.1, 3806.3), bandwidth = c(884, 196, 267.9, 181.8,
112.9)), list(intensity = 0.00128675476416539, nFormants = 5,
frequency = c(569.6, 1959.3, 2511.4, 3245.1, 3699.6
), bandwidth = c(687.9, 131.9, 278.8, 245.9, 75.5
)), list(intensity = 0.000776848635622737, nFormants = 5,
frequency = c(376.2, 1879, 2492.6, 3196.8, 3703.4
), bandwidth = c(522.8, 162, 237, 343.1, 63.7)),
list(intensity = 0.000741970895848582, nFormants = 5,
frequency = c(335.9, 1845.3, 2479.4, 3203.3, 3767.5
), bandwidth = c(780.2, 160.8, 208.2, 403, 73.3)),
list(intensity = 0.000741970895848582, nFormants = 5,
frequency = c(513.1, 1851, 2474.4, 3213.4, 3754.9
), bandwidth = c(784.7, 110.1, 182.8, 262.6, 102.5
)), list(intensity = 0.000351860942088687, nFormants = 5,
frequency = c(589.5, 1823, 2436.2, 3131.6, 3680.5
), bandwidth = c(821.4, 114, 212.4, 249, 67.9)),
list(intensity = 0.000283875176052556, nFormants = 5,
frequency = c(631.8, 1856.3, 2382.5, 3226.3, 3696.5
), bandwidth = c(611.3, 103.8, 189.2, 306.4, 77.2
)), list(intensity = 0.000283875176052556, nFormants = 5,
frequency = c(452.2, 1753.5, 2372.8, 3254.8, 3654.1
), bandwidth = c(465.6, 123.7, 228.1, 251.9, 108.6
)), list(intensity = 0.00021860158066084, nFormants = 5,
frequency = c(422.3, 1639.9, 2437.4, 3141.7, 3649.9
), bandwidth = c(396, 75.8, 293.5, 401.8, 134.8)),
list(intensity = 0.000114168435736533, nFormants = 5,
frequency = c(365.5, 1593, 2314.9, 3041.3, 3791.6
), bandwidth = c(267.3, 116.9, 293, 407.7, 83)),
list(intensity = 0.000114168435736533, nFormants = 5,
frequency = c(395.3, 1624.8, 2341.2, 3068.4, 3762.9
), bandwidth = c(133.1, 173, 192.5, 510.4, 130.2)),
list(intensity = 3.14988770669492e-05, nFormants = 5,
frequency = c(360.5, 1591.7, 2324, 2994.2, 3745.3
), bandwidth = c(105.4, 114.9, 216.7, 461.4, 156.2
)), list(intensity = 2.20534627102325e-05, nFormants = 5,
frequency = c(385, 1562.7, 2175.8, 2933, 3754.3),
bandwidth = c(91.3, 64.4, 331, 237.3, 98.1)), list(
intensity = 8.40422415369682e-06, nFormants = 5,
frequency = c(405.4, 1529.7, 2222.9, 2879, 3715.4
), bandwidth = c(109.7, 34.8, 329.9, 212.4, 65.3)),
list(intensity = 8.40422415369682e-06, nFormants = 5,
frequency = c(360.5, 1537.4, 2204.4, 2970.3, 3695.3
), bandwidth = c(114.7, 51.8, 296.6, 207.5, 82.6)),
list(intensity = 8.40422415369682e-06, nFormants = 5,
frequency = c(353.7, 1526.5, 2311.1, 2962.7, 3572.9
), bandwidth = c(116.5, 56, 266.5, 205.4, 117.1)),
list(intensity = 8.40422415369682e-06, nFormants = 5,
frequency = c(357.9, 1566.7, 2248.7, 3043.9, 3640.6
), bandwidth = c(263.9, 102.9, 271.7, 216.7, 124.9
)), list(intensity = 5.58242381940675e-06, nFormants = 5,
frequency = c(333.2, 1643, 2305.9, 3073.9, 3675.6
), bandwidth = c(173.4, 80.4, 305.5, 245.4, 139)),
list(intensity = 5.58242381940675e-06, nFormants = 5,
frequency = c(343.3, 1654.8, 2208.9, 3040.8, 3706.5
), bandwidth = c(145.9, 169.9, 314, 266.3, 95.1)),
list(intensity = 5.58242381940675e-06, nFormants = 5,
frequency = c(411.8, 1579.5, 2180.7, 3055.8, 3756.3
), bandwidth = c(201.1, 176.8, 399.1, 325.5, 82.5
)), list(intensity = 3.96530923091482e-06, nFormants = 5,
frequency = c(438.3, 1497.8, 2365.3, 3034.1, 3807.1
), bandwidth = c(229.4, 68.9, 291.6, 275.3, 81)),
list(intensity = 3.96530923091482e-06, nFormants = 5,
frequency = c(433.6, 1512.1, 2373.1, 3005.4, 3814.7
), bandwidth = c(365.6, 76.2, 404.5, 256.9, 82.9)),
list(intensity = 3.28942828301154e-06, nFormants = 5,
frequency = c(389, 1535.4, 2381.5, 3041, 3779.3),
bandwidth = c(302, 97.8, 294.2, 293.5, 82.7)), list(
intensity = 3.28942828301154e-06, nFormants = 5,
frequency = c(384.9, 1557.9, 2390.1, 3031.5, 3760.3
), bandwidth = c(331.8, 109.5, 260, 218, 118.4)),
list(intensity = 3.28942828301154e-06, nFormants = 5,
frequency = c(363, 1528.9, 2375.1, 3067, 3806.1),
bandwidth = c(461.9, 68.6, 307.2, 92.7, 85.4)), list(
intensity = 3.28942828301154e-06, nFormants = 5,
frequency = c(367.6, 1572.4, 2322.5, 2998.6, 3727.9
), bandwidth = c(176.6, 49.5, 392.1, 147.6, 103.4
)), list(intensity = 3.28942828301154e-06, nFormants = 5,
frequency = c(355.1, 1567, 2341.1, 2919.9, 3753.9
), bandwidth = c(137.7, 49.8, 355.9, 140.7, 53.7)),
list(intensity = 3.28942828301154e-06, nFormants = 5,
frequency = c(378.7, 1566.1, 2439.9, 3019, 3740.1
), bandwidth = c(250.5, 118.7, 313.4, 193.5, 65.7
)), list(intensity = 3.28942828301154e-06, nFormants = 5,
frequency = c(403.7, 1586.1, 2363.5, 3106.8, 3759.7
), bandwidth = c(178.5, 216.7, 173.1, 210.8, 80.3
)), list(intensity = 1.8273309949121e-06, nFormants = 5,
frequency = c(388, 1551.1, 2296.5, 3179.4, 3823.4
), bandwidth = c(141.5, 164.6, 151.3, 177.9, 72.6
)), list(intensity = 1.49172972185247e-06, nFormants = 5,
frequency = c(370, 1589.7, 2249.3, 3160.2, 3804.2
), bandwidth = c(95.2, 135.6, 214.3, 171.7, 92.8)),
list(intensity = 1.40087621720244e-06, nFormants = 5,
frequency = c(437, 1544.5, 2208.8, 3029.6, 3639.7
), bandwidth = c(212.8, 164.4, 456.9, 140.4, 97.8
)), list(intensity = 1.40087621720244e-06, nFormants = 5,
frequency = c(441.8, 1510.2, 2192.8, 2968.7, 3583.5
), bandwidth = c(163.3, 124.3, 334, 91.5, 46.6)),
list(intensity = 3.11787505318531e-06, nFormants = 5,
frequency = c(424.8, 1530.5, 2347.4, 3055.2, 3683.4
), bandwidth = c(184.4, 62.6, 265.9, 172.4, 108)),
list(intensity = 3.11787505318531e-06, nFormants = 5,
frequency = c(383.8, 1569.3, 2339.6, 3046.3, 3774.6
), bandwidth = c(153.8, 81.7, 329.9, 156.1, 100.6
)), list(intensity = 3.11787505318531e-06, nFormants = 5,
frequency = c(360.5, 1527, 2284, 3035.2, 3764.9),
bandwidth = c(72.5, 234.7, 305.8, 192.7, 131.8)),
list(intensity = 3.11787505318531e-06, nFormants = 5,
frequency = c(340.3, 1647, 2426.1, 3162.1, 3758.3
), bandwidth = c(78.2, 214.6, 388.4, 134.3, 161.4
)), list(intensity = 3.11787505318531e-06, nFormants = 5,
frequency = c(360.5, 1659.4, 2495, 3152.5, 3758.7
), bandwidth = c(82.2, 278.9, 377.5, 166, 147.7)),
list(intensity = 3.11787505318531e-06, nFormants = 5,
frequency = c(385.4, 1578.1, 2427.6, 3114.8, 3769.7
), bandwidth = c(94.5, 240.1, 374.6, 210.4, 80.1)),
list(intensity = 3.11787505318531e-06, nFormants = 5,
frequency = c(390.1, 1569.8, 2332.9, 3114.3, 3736.3
), bandwidth = c(144.8, 149.3, 423.2, 146.3, 92.8
)), list(intensity = 3.11787505318531e-06, nFormants = 5,
frequency = c(392.1, 1533.9, 2343.9, 3086.5, 3826.6
), bandwidth = c(73.3, 124.5, 398.9, 120.2, 78.4)),
list(intensity = 7.73962719813364e-07, nFormants = 5,
frequency = c(439.7, 1492.6, 2478, 3126.8, 3786.1
), bandwidth = c(93.2, 193, 334.5, 264.9, 65.7)),
list(intensity = 7.73962719813364e-07, nFormants = 5,
frequency = c(407.1, 1552.1, 2578.4, 3121.2, 3785.9
), bandwidth = c(106.1, 143.1, 194.4, 440.9, 57.7
)), list(intensity = 7.73962719813364e-07, nFormants = 5,
frequency = c(435.6, 1577.4, 2482, 3145, 3876.8),
bandwidth = c(147.6, 172.5, 201.7, 309.1, 56.5)),
list(intensity = 7.60266509429069e-07, nFormants = 5,
frequency = c(445.7, 1518.8, 2384.7, 3140.1, 3857
), bandwidth = c(133.2, 146.6, 205.9, 234, 79.9)),
list(intensity = 1.27724775533995e-06, nFormants = 5,
frequency = c(371.2, 1467.3, 2271.1, 3144, 3752.3
), bandwidth = c(126.5, 161.6, 261.9, 189.3, 63.7
)), list(intensity = 1.27724775533995e-06, nFormants = 5,
frequency = c(321.2, 1526.9, 2366.8, 3144.3, 3807.3
), bandwidth = c(119, 196.8, 288.2, 294.2, 51.8)),
list(intensity = 1.27724775533995e-06, nFormants = 5,
frequency = c(355.9, 1525.5, 2443.3, 3115.6, 3819.2
), bandwidth = c(191.4, 248.3, 292.3, 385.8, 60.4
)), list(intensity = 1.27724775533995e-06, nFormants = 5,
frequency = c(365.2, 1547.9, 2563.8, 3045.1, 3873.6
), bandwidth = c(200.4, 150.8, 225.9, 308.3, 44.7
)), list(intensity = 1.27724775533995e-06, nFormants = 5,
frequency = c(359.7, 1545, 2552.8, 2936.7, 3857.7
), bandwidth = c(209.1, 137.3, 284.1, 204, 29.5)),
list(intensity = 1.27724775533995e-06, nFormants = 5,
frequency = c(322.6, 1527.4, 2510.1, 2955.5, 3795
), bandwidth = c(248.1, 136.6, 418.2, 214.7, 53.1
)), list(intensity = 1.27724775533995e-06, nFormants = 5,
frequency = c(266.2, 1542.9, 2428.2, 2955.6, 3728.7
), bandwidth = c(410.8, 150.1, 567.4, 221.1, 59.4
)), list(intensity = 1.27724775533995e-06, nFormants = 5,
frequency = c(316.7, 1534.7, 2322.2, 2988.2, 3806.3
), bandwidth = c(576.3, 104.4, 575.9, 290, 35.5)),
list(intensity = 8.11652119699336e-07, nFormants = 5,
frequency = c(438.3, 1519.5, 2387.7, 3078.5, 3807.1
), bandwidth = c(534.3, 77.9, 508.3, 210.5, 39.3)),
list(intensity = 4.82030453273129e-07, nFormants = 5,
frequency = c(347.4, 1504.5, 2352.9, 3082.5, 3840.8
), bandwidth = c(650.6, 110.8, 349.9, 170.2, 42)),
list(intensity = 4.82030453273129e-07, nFormants = 5,
frequency = c(365, 1559.3, 2297.5, 3090.8, 3837.7
), bandwidth = c(488.2, 91.5, 212.1, 174.1, 36.3)),
list(intensity = 4.82030453273129e-07, nFormants = 5,
frequency = c(336.4, 1554.7, 2372.8, 3024.2, 3808.6
), bandwidth = c(535.4, 99.7, 339.6, 177.1, 53.8)),
list(intensity = 4.82030453273129e-07, nFormants = 5,
frequency = c(366.9, 1526.1, 2470.2, 3046.5, 3828.7
), bandwidth = c(566.2, 170.8, 399.7, 212.3, 30.1
)), list(intensity = 4.00974510920157e-07, nFormants = 5,
frequency = c(298.7, 1519.1, 2535.2, 3236.1, 3863.7
), bandwidth = c(463.5, 117.4, 276.2, 217.6, 23.5
)), list(intensity = 4.00974510920157e-07, nFormants = 5,
frequency = c(381, 1525.6, 2529.8, 3295.1, 3880.6
), bandwidth = c(484.7, 151.1, 281.9, 204.6, 38.9
)), list(intensity = 4.00974510920157e-07, nFormants = 5,
frequency = c(385.4, 1497.8, 2552.8, 3317.9, 3853.6
), bandwidth = c(771, 255.9, 390.1, 146.2, 44.4)),
list(intensity = 4.27711914579003e-06, nFormants = 4,
frequency = c(1552.1, 2592.3, 3332.5, 3835.3), bandwidth = c(278,
351, 96.9, 47.5)), list(intensity = 4.27711914579003e-06,
nFormants = 5, frequency = c(305, 1577.6, 2648.6,
3175.5, 3796.5), bandwidth = c(729.3, 413.2, 306.8,
255.8, 85.6)), list(intensity = 6.25335336456919e-06,
nFormants = 5, frequency = c(418.3, 1734.7, 2668.9,
2988.1, 3803.5), bandwidth = c(607.2, 417.5, 451.2,
274.4, 57.3)), list(intensity = 6.25335336456919e-06,
nFormants = 5, frequency = c(493.1, 2012.4, 2587.1,
3254.6, 3837), bandwidth = c(520.9, 279, 362.7, 235.6,
48.1)), list(intensity = 6.25335336456919e-06, nFormants = 5,
frequency = c(243.4, 2039.9, 2561.3, 3303.8, 3842.1
), bandwidth = c(697.6, 285.6, 376, 238.7, 44.1)),
list(intensity = 6.25335336456919e-06, nFormants = 4,
frequency = c(1751.8, 2574.6, 3553.6, 3886.8), bandwidth = c(403.3,
402, 153.6, 33.5)), list(intensity = 6.25335336456919e-06,
nFormants = 4, frequency = c(1741, 2517.5, 3584.8,
3912.7), bandwidth = c(430.6, 503.6, 134.9, 28.1)),
list(intensity = 6.25335336456919e-06, nFormants = 5,
frequency = c(479.9, 1535.7, 2422.6, 3445.5, 3932.5
), bandwidth = c(640, 470.6, 319.4, 193.1, 25.6)),
list(intensity = 6.25335336456919e-06, nFormants = 5,
frequency = c(300.9, 1400.3, 2443.9, 3201.7, 3866.4
), bandwidth = c(648.6, 392.4, 418.4, 148.7, 44.8
)), list(intensity = 6.25335336456919e-06, nFormants = 5,
frequency = c(230.1, 1481.5, 2488.6, 3232.8, 3873.9
), bandwidth = c(514.7, 360.5, 358.1, 218.3, 24.2
)), list(intensity = 2.12081490027236e-07, nFormants = 5,
frequency = c(222.4, 1467, 2453, 3275.8, 3790.6),
bandwidth = c(508.7, 290.9, 251.3, 178, 81.3)), list(
intensity = 4.33306313560003e-07, nFormants = 5,
frequency = c(335.8, 1373.4, 2367.6, 3186.1, 3694.7
), bandwidth = c(674.1, 383.5, 332.7, 205.2, 105.3
)), list(intensity = 4.33306313560003e-07, nFormants = 5,
frequency = c(517.7, 1361, 2438, 3236.7, 3828.8),
bandwidth = c(520.5, 508.7, 339.9, 265.1, 57.2)),
list(intensity = 4.33306313560003e-07, nFormants = 5,
frequency = c(386.1, 1418.8, 2533.3, 3254.8, 3836.9
), bandwidth = c(485.6, 308.1, 283, 321, 61)), list(
intensity = 1.47005398860294e-06, nFormants = 5,
frequency = c(222.2, 1502.9, 2442.8, 3404.4, 3789.9
), bandwidth = c(699.2, 379.6, 245.1, 312.6, 78.9
)), list(intensity = 1.47005398860294e-06, nFormants = 4,
frequency = c(1542.1, 2295.6, 3410, 3805.6), bandwidth = c(463.5,
215.9, 224.7, 82)), list(intensity = 1.47005398860294e-06,
nFormants = 5, frequency = c(164, 1546.5, 2374, 3278.5,
3838), bandwidth = c(658.4, 299.2, 320.6, 136.6,
62.7)), list(intensity = 1.47005398860294e-06, nFormants = 5,
frequency = c(391.7, 1809.9, 2504.5, 3237.2, 3724.9
), bandwidth = c(679.2, 325.6, 588.5, 148, 89.6)),
list(intensity = 1.47005398860294e-06, nFormants = 5,
frequency = c(95.3, 1700.2, 2229.7, 3187.5, 3686.3
), bandwidth = c(949.4, 685.4, 448.2, 134.2, 69.9
)), list(intensity = 1.47005398860294e-06, nFormants = 5,
frequency = c(291.9, 1576.1, 2392.5, 3163, 3751.7
), bandwidth = c(449, 254, 433.4, 257.3, 71.4)),
list(intensity = 1.47005398860294e-06, nFormants = 5,
frequency = c(198.3, 1595.7, 2372.1, 3130.8, 3739.9
), bandwidth = c(378.5, 321.9, 539.8, 290.7, 85.4
)), list(intensity = 1.47005398860294e-06, nFormants = 5,
frequency = c(248.6, 1536.5, 2257.3, 3122.9, 3744.7
), bandwidth = c(385.5, 389.5, 353.8, 191.7, 82)),
list(intensity = 1.47256295329627e-07, nFormants = 5,
frequency = c(315.5, 1485.3, 2324.5, 3044.9, 3736.5
), bandwidth = c(253, 338.2, 378.8, 233, 52.1)),
list(intensity = 1.47256295329627e-07, nFormants = 5,
frequency = c(323.4, 1518.9, 2417.5, 3084, 3740.1
), bandwidth = c(312.5, 236.4, 340.9, 340.5, 63.6
)), list(intensity = 1.47256295329627e-07, nFormants = 5,
frequency = c(244.4, 1602.5, 2349.9, 3211.5, 3783.1
), bandwidth = c(410.5, 190, 379.8, 202.8, 51.8)),
list(intensity = 1.47256295329627e-07, nFormants = 5,
frequency = c(129.1, 1578.5, 2358.6, 3232.5, 3804
), bandwidth = c(481.3, 199.7, 351, 238, 39.2)),
list(intensity = 1.47256295329627e-07, nFormants = 5,
frequency = c(208.7, 1501.1, 2238.5, 3225.5, 3766.6
), bandwidth = c(352.2, 331.4, 276.8, 263, 57.9)),
list(intensity = 4.32049612590777e-06, nFormants = 5,
frequency = c(327.5, 1474.2, 2268.8, 3226.5, 3773
), bandwidth = c(447.6, 287.4, 272.6, 290.2, 52)),
list(intensity = 4.32049612590777e-06, nFormants = 5,
frequency = c(284.9, 1511.6, 2366.2, 3257.2, 3847.9
), bandwidth = c(457.1, 323, 241.5, 198.7, 60.9)),
list(intensity = 4.32049612590777e-06, nFormants = 5,
frequency = c(373.5, 1695.8, 2526.2, 2954.8, 3785.6
), bandwidth = c(157.1, 263.2, 226.3, 536.9, 79.4
)), list(intensity = 2.60042786893074e-05, nFormants = 5,
frequency = c(365.7, 1663.9, 2450.3, 2678, 3719.9
), bandwidth = c(80.5, 218, 425.9, 130.3, 44.6)),
list(intensity = 0.000279013028287772, nFormants = 5,
frequency = c(323.1, 1624.4, 2595.8, 2790.8, 3747.7
), bandwidth = c(87.2, 154.2, 134.7, 619.3, 61.1)),
list(intensity = 0.00366679872969578, nFormants = 5,
frequency = c(397.5, 1580.7, 2621.7, 2670.7, 3762.2
), bandwidth = c(100.8, 349.4, 584.9, 234.6, 50.2
)), list(intensity = 0.00366679872969578, nFormants = 5,
frequency = c(403.1, 1524.6, 2457.2, 2712.5, 3713.3
), bandwidth = c(56.8, 256.5, 232.2, 59.9, 105.8)),
list(intensity = 0.00366679872969578, nFormants = 5,
frequency = c(361.5, 1194.4, 2181.3, 2679.9, 3778.6
), bandwidth = c(40.9, 896.6, 287.7, 22.1, 126.3)),
list(intensity = 0.00366679872969578, nFormants = 5,
frequency = c(353.2, 1225.5, 2152.4, 2678.1, 3791
), bandwidth = c(39.5, 830.2, 321.4, 21.6, 112.8)),
list(intensity = 0.00366679872969578, nFormants = 5,
frequency = c(349, 1398.9, 2091.5, 2691.7, 3786.1
), bandwidth = c(45.8, 523.9, 440.5, 24.1, 83.2)),
list(intensity = 0.00366679872969578, nFormants = 5,
frequency = c(355, 1343.7, 2072.3, 2703, 3757.1),
bandwidth = c(48, 451, 375.7, 16.9, 89.6)), list(
intensity = 0.0111956856996783, nFormants = 5, frequency = c(346.9,
1327.2, 2110.8, 2705.6, 3742.2), bandwidth = c(47.5,
434.6, 381.3, 24, 131.1)), list(intensity = 0.017405802625779,
nFormants = 5, frequency = c(348.9, 1375.6, 2022.3,
2689.3, 3729.6), bandwidth = c(56.6, 523.4, 497.2,
34.9, 146.9)), list(intensity = 0.017405802625779,
nFormants = 5, frequency = c(359.9, 1581.5, 2250.7,
2751, 3808.1), bandwidth = c(53.4, 375.5, 611.6,
180, 51.3)), list(intensity = 0.0179486050454339,
nFormants = 5, frequency = c(389.9, 1747.7, 2289.7,
2942.5, 3842.1), bandwidth = c(84.1, 560.6, 290.7,
135.1, 31.8)), list(intensity = 0.0242435795049303,
nFormants = 5, frequency = c(430.2, 1804.1, 2325,
2975.7, 3858.4), bandwidth = c(95.2, 841.4, 256.1,
97.4, 44.6)), list(intensity = 0.0242435795049303,
nFormants = 5, frequency = c(438.2, 1860.1, 2388.3,
3010.1, 3861.5), bandwidth = c(88.5, 991.3, 257.2,
111, 62.5)), list(intensity = 0.0272401631081357,
nFormants = 5, frequency = c(425.3, 1910.1, 2444.1,
3021.8, 3851.2), bandwidth = c(63, 925.3, 311.9,
129.1, 63.4)), list(intensity = 0.0295180034292467,
nFormants = 5, frequency = c(417.8, 1958.3, 2511.6,
3039.9, 3839.6), bandwidth = c(45.7, 839.6, 364.4,
144.6, 63.7)), list(intensity = 0.0295180034292467,
nFormants = 5, frequency = c(410.5, 1932.1, 2587,
3072.4, 3826.1), bandwidth = c(34.4, 721.9, 380.6,
150, 59.8)), list(intensity = 0.0295180034292467,
nFormants = 5, frequency = c(404.3, 1910.4, 2591.7,
3087.2, 3828.5), bandwidth = c(28.5, 652, 361.7,
118.8, 50.3)), list(intensity = 0.0295180034292467,
nFormants = 5, frequency = c(401.2, 1941.6, 2555,
3083.9, 3832.1), bandwidth = c(25.8, 668.8, 323.7,
102.4, 45.6)), list(intensity = 0.0295180034292467,
nFormants = 5, frequency = c(400.7, 2019.1, 2512.8,
3078.5, 3833.9), bandwidth = c(24.7, 674, 354.7,
130.2, 58.6)), list(intensity = 0.0295180034292467,
nFormants = 5, frequency = c(403, 2058.1, 2461.4,
3053.2, 3827.9), bandwidth = c(27.8, 793.5, 336.6,
163.5, 76.8)), list(intensity = 0.0295180034292467,
nFormants = 5, frequency = c(403.2, 2013.9, 2407.9,
2960, 3804.2), bandwidth = c(35.7, 992.7, 231.3,
132.6, 65.5)), list(intensity = 0.0295180034292467,
nFormants = 5, frequency = c(395.9, 1890.5, 2364.9,
2835.4, 3763.7), bandwidth = c(48, 968.2, 176.7,
94.1, 49.2)), list(intensity = 0.016413160179328,
nFormants = 5, frequency = c(375.3, 1760.5, 2273.8,
2771.1, 3811.4), bandwidth = c(68.5, 976.7, 165.3,
56.3, 25)), list(intensity = 0.016413160179328, nFormants = 5,
frequency = c(349.7, 1660.4, 2169.2, 2801.6, 3816.4
), bandwidth = c(77.5, 850.6, 193.9, 62.3, 32.8)),
list(intensity = 0.016413160179328, nFormants = 5, frequency = c(322.1,
1477.6, 2121.8, 2809.3, 3823.3), bandwidth = c(80.9,
835.9, 281.3, 120.7, 48.3)), list(intensity = 0.0151760972487329,
nFormants = 5, frequency = c(295.3, 1144.8, 2278.3,
2784.6, 3842.9), bandwidth = c(94, 801.4, 149.8,
139.1, 68.2)), list(intensity = 0.00650620404261406,
nFormants = 5, frequency = c(248.2, 945.1, 2303.6,
2797.8, 3796.6), bandwidth = c(117.7, 858.1, 55.1,
164.6, 59.6)), list(intensity = 0.00109605910822712,
nFormants = 5, frequency = c(241.4, 1152.4, 2256.6,
2703.4, 3810.5), bandwidth = c(62.6, 1175.5, 158.3,
207.8, 27.1)), list(intensity = 0.00198713782327532,
nFormants = 5, frequency = c(260.6, 1199.7, 2238.2,
2856.8, 3818.7), bandwidth = c(79.5, 760.1, 337,
271.6, 51.2)), list(intensity = 0.00198713782327532,
nFormants = 5, frequency = c(260.8, 1438.1, 2307.6,
3057.1, 3769.5), bandwidth = c(162.2, 443.8, 457.5,
200.5, 97)), list(intensity = 0.00198713782327532,
nFormants = 5, frequency = c(322.5, 1615.8, 2427.3,
3085.4, 3848), bandwidth = c(243.2, 419.7, 485.7,
167.5, 96.6)), list(intensity = 0.00198713782327532,
nFormants = 5, frequency = c(310.5, 1699.8, 2627.3,
3061.9, 3882), bandwidth = c(243.8, 335.9, 369, 150.9,
84.3)), list(intensity = 0.00247374134763227, nFormants = 5,
frequency = c(270.5, 1895.8, 2614.6, 2977.3, 3781.4
), bandwidth = c(194.1, 443.6, 608.3, 178.3, 75.9
)), list(intensity = 0.00808287419944953, nFormants = 5,
frequency = c(259.8, 2035.4, 2726.7, 2985.6, 3717.9
), bandwidth = c(139.1, 301.8, 890.1, 284.6, 46.6
)), list(intensity = 0.00808287419944953, nFormants = 5,
frequency = c(247.8, 2000.4, 2742.5, 3415.4, 3848.5
), bandwidth = c(141.3, 194.8, 215.4, 350.1, 64.2
)), list(intensity = 0.00808287419944953, nFormants = 5,
frequency = c(235.5, 2050.4, 2782.5, 3402.9, 3910.9
), bandwidth = c(107.5, 168.5, 119.5, 244.5, 21.3
)), list(intensity = 0.00808287419944953, nFormants = 5,
frequency = c(245.5, 2100.2, 2812, 3370.3, 3903.6
), bandwidth = c(68.4, 162.8, 67.8, 374.9, 12.5)),
list(intensity = 0.00808287419944953, nFormants = 5,
frequency = c(255.3, 2072.4, 2845.7, 3345.3, 3892.3
), bandwidth = c(36.3, 139.6, 58.5, 503.5, 16.3)),
list(intensity = 0.0147790269104379, nFormants = 5, frequency = c(262.7,
2012.3, 2888.5, 3110.3, 3853.7), bandwidth = c(25.2,
271.7, 296.2, 389.9, 39.9)), list(intensity = 0.0160190370366499,
nFormants = 5, frequency = c(272.3, 1916.4, 2668.3,
3093.6, 3839), bandwidth = c(26.3, 520.3, 599, 86,
33.5)), list(intensity = 0.0189847960293251, nFormants = 5,
frequency = c(280, 1996.7, 2477.7, 3147.5, 3883.4
), bandwidth = c(30.6, 548.3, 663.3, 128.2, 25.1)),
list(intensity = 0.0237585111806374, nFormants = 5, frequency = c(285.7,
2065, 2587.8, 3258.8, 3899.2), bandwidth = c(33.2, 377.4,
658, 245.8, 25.3)), list(intensity = 0.0237585111806374,
nFormants = 5, frequency = c(291.4, 2107.9, 2636.5,
3289, 3847.9), bandwidth = c(37.3, 353.8, 721.5,
243.7, 51.4)), list(intensity = 0.0237585111806374,
nFormants = 5, frequency = c(294.5, 2076.9, 2486.9,
3251.7, 3773.1), bandwidth = c(39.5, 440.9, 585.5,
170.3, 30.6)), list(intensity = 0.0237585111806374,
nFormants = 5, frequency = c(296.5, 2058.8, 2480.1,
3242.7, 3769.5), bandwidth = c(39, 431.2, 568, 154.3,
27)), list(intensity = 0.0237585111806374, nFormants = 5,
frequency = c(298, 2081.8, 2481.2, 3183.5, 3756.4
), bandwidth = c(39.1, 469.8, 623.1, 168.4, 33.4)),
list(intensity = 0.0237585111806374, nFormants = 5, frequency = c(297.5,
2020.8, 2514.8, 3105.9, 3803.8), bandwidth = c(38, 631.6,
580.5, 165.1, 21.1)), list(intensity = 0.0237585111806374,
nFormants = 5, frequency = c(296.6, 1804.2, 2692.2,
3080.3, 3825.8), bandwidth = c(31.2, 590.2, 329.8,
323.6, 26.7)), list(intensity = 0.0237585111806374,
nFormants = 5, frequency = c(293.6, 1733.2, 2556.2,
3097.5, 3778.1), bandwidth = c(31.5, 1194.6, 192.3,
347.4, 46.1)), list(intensity = 0.0173177936558425,
nFormants = 5, frequency = c(284.5, 1750.4, 2600.5,
3126.7, 3726.8), bandwidth = c(26.8, 599.5, 227.3,
318.9, 61.9)), list(intensity = 0.00938234836465612,
nFormants = 5, frequency = c(275.1, 1736.9, 2578.3,
3088.1, 3729.2), bandwidth = c(42.4, 209, 322.5,
265.1, 55.1)), list(intensity = 0.00726487077339889,
nFormants = 5, frequency = c(268.8, 1711.6, 2507.6,
3113, 3793.8), bandwidth = c(75.5, 172.7, 259.5,
161, 61.6)), list(intensity = 0.00332740622343298,
nFormants = 5, frequency = c(279.8, 1722.2, 2489,
3106.3, 3824.6), bandwidth = c(85.2, 174.6, 293.1,
113.6, 87.8)), list(intensity = 0.00231944206966563,
nFormants = 5, frequency = c(281.8, 1629, 2509.3,
3023.1, 3844.6), bandwidth = c(111.7, 109.2, 301.8,
169.9, 72.6)), list(intensity = 0.00224854474445794,
nFormants = 5, frequency = c(275.9, 1582.9, 2529.4,
2980.9, 3799.3), bandwidth = c(79.5, 113.6, 241.9,
232.2, 77.9)), list(intensity = 0.00346604616747992,
nFormants = 5, frequency = c(280.8, 1535, 2561.1,
2906.8, 3804.9), bandwidth = c(34.7, 79.7, 251.2,
263.1, 97.2)), list(intensity = 0.00488348352665442,
nFormants = 5, frequency = c(285.5, 1503.6, 2592.2,
2910, 3796.9), bandwidth = c(7.7, 98.2, 185.3, 306.9,
101.6)), list(intensity = 0.00488348352665442, nFormants = 5,
frequency = c(292.7, 1505.5, 2467.3, 2783.2, 3850.1
), bandwidth = c(3.4, 235.9, 468, 179.8, 49.6)),
list(intensity = 0.00620665098336879, nFormants = 5,
frequency = c(292.5, 1454.4, 2349.1, 2744.5, 3893.8
), bandwidth = c(2.1, 185.4, 491.9, 113.4, 32.7)),
list(intensity = 0.0089500821919285, nFormants = 5, frequency = c(292,
1406.1, 2334.6, 2718.1, 3844.7), bandwidth = c(2.8, 200.9,
465.2, 81.9, 89.6)), list(intensity = 0.00931879875894428,
nFormants = 5, frequency = c(291.7, 1294.8, 2127.7,
2750.2, 3755.7), bandwidth = c(5.8, 520.1, 507.3,
48.3, 93)), list(intensity = 0.026236354385737, nFormants = 5,
frequency = c(292.1, 1266.4, 1931.5, 2770.4, 3765.2
), bandwidth = c(9.9, 665.7, 376.9, 24.8, 90.9)),
list(intensity = 0.026236354385737, nFormants = 5, frequency = c(291.9,
1551.1, 1842.2, 2759.8, 3801.8), bandwidth = c(15.3,
489.4, 525.5, 16, 112)), list(intensity = 0.0295216221927418,
nFormants = 5, frequency = c(294.9, 1655.9, 2498.1,
2804.3, 3811.1), bandwidth = c(36.7, 148.9, 717.8,
274.5, 69.3)), list(intensity = 0.0340521199900777,
nFormants = 5, frequency = c(314.9, 1759.9, 2315.9,
3106.8, 3805.4), bandwidth = c(125.1, 191.8, 431.6,
278.5, 46.7)), list(intensity = 0.0568681600354749,
nFormants = 5, frequency = c(363.3, 1870.5, 2167.1,
3118.3, 3772.4), bandwidth = c(378.2, 377.3, 437.2,
225, 47.9)), list(intensity = 0.0568681600354749,
nFormants = 5, frequency = c(401.7, 2049.8, 2079.8,
3129.9, 3781.3), bandwidth = c(413.6, 282.6, 707.9,
211.7, 65.4)), list(intensity = 0.0577098001964185,
nFormants = 5, frequency = c(419.8, 2074.8, 2123.6,
3118.3, 3823.5), bandwidth = c(380, 165.5, 916.6,
181.5, 62.3)), list(intensity = 0.0577098001964185,
nFormants = 5, frequency = c(417.6, 2054.2, 2103.4,
3119.7, 3844.7), bandwidth = c(381.5, 748, 161, 162.3,
62.4)), list(intensity = 0.0577098001964185, nFormants = 5,
frequency = c(374.1, 2039.8, 2119, 3071.1, 3801.9
), bandwidth = c(359.4, 824.3, 130.3, 152.6, 89.2
)), list(intensity = 0.0577098001964185, nFormants = 5,
frequency = c(354.9, 1857.1, 2140.1, 3000.2, 3688
), bandwidth = c(358.3, 974.9, 75.1, 90.6, 48.9)),
list(intensity = 0.0577098001964185, nFormants = 5, frequency = c(354.1,
1789.8, 2143.2, 3002, 3675), bandwidth = c(373.3, 1036.6,
63.1, 85.3, 45.6)), list(intensity = 0.0577098001964185,
nFormants = 5, frequency = c(358.3, 1808.5, 2145.7,
3036.8, 3682.6), bandwidth = c(317.7, 1039.7, 69.6,
97.3, 49.8)), list(intensity = 0.0577098001964185,
nFormants = 5, frequency = c(364.9, 1760.2, 2149.8,
3025.2, 3704.1), bandwidth = c(271.5, 1031.5, 72.4,
81.2, 41.6)), list(intensity = 0.0577098001964185,
nFormants = 5, frequency = c(372.2, 1711.8, 2148.3,
2999.8, 3718.9), bandwidth = c(224.9, 1201.8, 60.1,
59.2, 42)), list(intensity = 0.0496667032894049,
nFormants = 5, frequency = c(382.8, 1687.2, 2145.7,
3000.6, 3736.3), bandwidth = c(169.7, 1307.9, 54.3,
54.1, 35.7)), list(intensity = 0.0321900889234017,
nFormants = 5, frequency = c(393.3, 1759.1, 2135.9,
2996, 3755.9), bandwidth = c(134.6, 1542.8, 68.1,
67.2, 44.1)), list(intensity = 0.0321900889234017,
nFormants = 5, frequency = c(394.6, 1819.9, 2114.5,
2992, 3751.9), bandwidth = c(114.6, 1859.8, 70.4,
106.3, 77.8)), list(intensity = 0.0219439831640737,
nFormants = 5, frequency = c(366.1, 1743.7, 2107.7,
2936.1, 3727.1), bandwidth = c(108.8, 1514.8, 86.2,
151.2, 76.1)), list(intensity = 0.0219439831640737,
nFormants = 5, frequency = c(278.9, 1646.2, 2180,
2883.9, 3747), bandwidth = c(46.2, 607.8, 146.6,
139.4, 80.7)), list(intensity = 0.0204801830194724,
nFormants = 5, frequency = c(270.3, 1443.1, 2228.8,
2923.6, 3710.1), bandwidth = c(25.8, 318, 159.2,
181, 206.4)), list(intensity = 0.014149964442401,
nFormants = 5, frequency = c(276.9, 1479.1, 2160.6,
2880.1, 3797.8), bandwidth = c(47.9, 611.3, 266.3,
198.6, 56)), list(intensity = 0.014149964442401,
nFormants = 5, frequency = c(364.1, 1874.7, 2237.1,
3005.2, 3796), bandwidth = c(114.9, 295.3, 802, 363.9,
24.8)), list(intensity = 0.0153232906291262, nFormants = 5,
frequency = c(378.5, 1905.3, 2320.4, 2937.1, 3783.9
), bandwidth = c(123.2, 271.6, 856.9, 241.8, 23.1
)), list(intensity = 0.0170122684276357, nFormants = 5,
frequency = c(404.7, 1929.5, 2276.5, 2967.5, 3795.4
), bandwidth = c(88.3, 336.6, 980.8, 196.4, 29.2)),
list(intensity = 0.0170122684276357, nFormants = 5, frequency = c(417.3,
1908.2, 2429.5, 2973.9, 3757.3), bandwidth = c(67.5,
322.1, 1034.8, 260.7, 50)), list(intensity = 0.0170122684276357,
nFormants = 5, frequency = c(417.2, 1894.6, 2545.3,
2969.7, 3729.9), bandwidth = c(59.7, 313.9, 958.4,
297.7, 47.3)), list(intensity = 0.0170122684276357,
nFormants = 5, frequency = c(411.1, 1884.1, 2569.9,
3001.7, 3710.3), bandwidth = c(64.2, 360.3, 769.8,
314.1, 51.6)), list(intensity = 0.0170122684276357,
nFormants = 5, frequency = c(395.8, 1894.4, 2565.5,
2994.6, 3696), bandwidth = c(77.1, 379.9, 645.4,
353.5, 65.6)), list(intensity = 0.0170122684276357,
nFormants = 5, frequency = c(373.3, 1870.4, 2550.5,
2962.9, 3672.8), bandwidth = c(75.9, 402.1, 621.2,
327.6, 50.7)), list(intensity = 0.0170122684276357,
nFormants = 5, frequency = c(354.9, 1879.7, 2709.4,
2990.7, 3661.3), bandwidth = c(67.1, 351.9, 360.7,
713.2, 71.9)), list(intensity = 0.0170122684276357,
nFormants = 5, frequency = c(349.5, 1806.7, 2692.9,
3195.9, 3679.1), bandwidth = c(57.9, 574, 215.6,
657.6, 101.6)), list(intensity = 0.0122054498339383,
nFormants = 5, frequency = c(355, 1762.9, 2687.8,
2962.9, 3690.8), bandwidth = c(67.9, 1257.2, 457.5,
514.3, 63.2)), list(intensity = 0.0122054498339383,
nFormants = 5, frequency = c(347.2, 1703.1, 2679,
2856.5, 3688.7), bandwidth = c(65.5, 1170.8, 479.2,
287.3, 49.5)), list(intensity = 0.0122054498339383,
nFormants = 5, frequency = c(325.6, 1850.8, 2657.8,
3199.2, 3680.7), bandwidth = c(47.9, 495.5, 98.4,
413.8, 104.1)), list(intensity = 0.00795001506401367,
nFormants = 5, frequency = c(291, 1940.1, 2664.7,
3400.8, 3666.7), bandwidth = c(45.3, 187.3, 86.8,
241.3, 128.8)), list(intensity = 0.00795001506401367,
nFormants = 5, frequency = c(252.1, 1977, 2672.7,
3374.1, 3738.3), bandwidth = c(75.3, 64.9, 90, 229,
101)), list(intensity = 0.00681900286409608, nFormants = 5,
frequency = c(267.3, 1956.9, 2635.6, 3091.3, 3802.7
), bandwidth = c(179.9, 67.4, 115.2, 206.4, 49.8)),
list(intensity = 0.00681900286409608, nFormants = 5,
frequency = c(295.1, 1911.3, 2591.8, 3047.7, 3727.3
), bandwidth = c(512.7, 77.1, 152.9, 246.6, 98.6)),
list(intensity = 0.00681900286409608, nFormants = 5,
frequency = c(153.5, 1891, 2558.4, 3272.2, 3777.9
), bandwidth = c(816, 55.3, 95.1, 168.6, 92.1)),
list(intensity = 0.00681900286409608, nFormants = 5,
frequency = c(214.8, 1872.8, 2599.5, 3331.5, 3758
), bandwidth = c(760.4, 46.9, 161.1, 213.9, 124.5
)), list(intensity = 0.00681900286409608, nFormants = 4,
frequency = c(1825.2, 2479.2, 3162.4, 3745.5), bandwidth = c(72.3,
437.9, 405.5, 105.2)), list(intensity = 0.00508695433577755,
nFormants = 4, frequency = c(1784.1, 2232.8, 3076.9,
3690.3), bandwidth = c(101.1, 424.3, 433.5, 82.4)),
list(intensity = 0.00508695433577755, nFormants = 4,
frequency = c(1687, 2284.1, 3072.6, 3682.4), bandwidth = c(97.6,
491.9, 318.3, 87.3)), list(intensity = 0.00460878714521659,
nFormants = 4, frequency = c(1543.3, 2308, 3109.7,
3799.9), bandwidth = c(53.3, 304.5, 218.8, 67.7)),
list(intensity = 0.00460878714521659, nFormants = 4,
frequency = c(1512.8, 2216.3, 3083.9, 3829.8), bandwidth = c(70.2,
296.9, 196.1, 57.4)), list(intensity = 0.00456970317638621,
nFormants = 4, frequency = c(1440.9, 2119, 3018.7,
3738.9), bandwidth = c(102.8, 312.8, 309.2, 72.1)),
list(intensity = 0.0032589703528913, nFormants = 4, frequency = c(1368.8,
2107.2, 2973.6, 3739.5), bandwidth = c(80.1, 410.1, 219.2,
76.6)), list(intensity = 0.0032589703528913, nFormants = 4,
frequency = c(1320.6, 2199.8, 3056.2, 3789.3), bandwidth = c(110.8,
596.1, 279, 84.8)), list(intensity = 0.00206045942708324,
nFormants = 4, frequency = c(1278.1, 2024.6, 2995.9,
3717.6), bandwidth = c(153.2, 414.6, 244.7, 77.7)),
list(intensity = 0.00291978737829137, nFormants = 5,
frequency = c(246.7, 1257, 2058.7, 3012.3, 3720),
bandwidth = c(315.3, 135.3, 373.3, 176.2, 78.3)),
list(intensity = 0.00329950118968506, nFormants = 5,
frequency = c(275.6, 1205.2, 1911.1, 3043.3, 3688
), bandwidth = c(228.1, 153.2, 447.5, 197.1, 144.2
)), list(intensity = 0.00329950118968506, nFormants = 5,
frequency = c(314.8, 1099.5, 1914.3, 2978.1, 3675.5
), bandwidth = c(138, 148.3, 479.5, 294.9, 180.7)),
list(intensity = 0.00404184760003201, nFormants = 5,
frequency = c(351.7, 1069.7, 1944, 2995.5, 3629.8
), bandwidth = c(57.3, 129.9, 628.8, 317.8, 204.2
)), list(intensity = 0.00527069959916801, nFormants = 5,
frequency = c(370.4, 989.4, 1854.6, 2881.6, 3574.9
), bandwidth = c(52, 229.1, 657.4, 348.9, 155.9)),
list(intensity = 0.00527069959916801, nFormants = 5,
frequency = c(379.5, 940, 2014.7, 2772.6, 3560.8),
bandwidth = c(59.1, 398.3, 652.6, 574.1, 79.2)),
list(intensity = 0.00527069959916801, nFormants = 5,
frequency = c(385.3, 1032.7, 2212.8, 2852.7, 3617
), bandwidth = c(35.4, 155.6, 534.2, 765, 108.3)),
list(intensity = 0.00527069959916801, nFormants = 5,
frequency = c(395.8, 1080, 2194.5, 3086.9, 3607.8
), bandwidth = c(20.7, 112.4, 322.7, 501.4, 137.4
)), list(intensity = 0.00527069959916801, nFormants = 5,
frequency = c(394.8, 1185.1, 2142.8, 3159.2, 3582.8
), bandwidth = c(14.2, 97.9, 263.4, 408.3, 149.7)),
list(intensity = 0.00527069959916801, nFormants = 5,
frequency = c(384.5, 1239.5, 2125.8, 3080.3, 3643.3
), bandwidth = c(18, 67.8, 222.1, 261.8, 121.3)),
list(intensity = 0.00527069959916801, nFormants = 5,
frequency = c(363.4, 1263.7, 2065.2, 2940, 3608.1
), bandwidth = c(36.1, 138.5, 227.8, 319.2, 121.9
)), list(intensity = 0.00527069959916801, nFormants = 5,
frequency = c(322.8, 1330.9, 1975.3, 2691.1, 3626.1
), bandwidth = c(57.3, 292.5, 368.2, 498.9, 137.9
)), list(intensity = 0.00508564779535119, nFormants = 5,
frequency = c(298.3, 1160.4, 2103.7, 2447.3, 3680.2
), bandwidth = c(59.3, 463.2, 477.7, 685.8, 129.8
)), list(intensity = 0.0032468788107983, nFormants = 5,
frequency = c(317.4, 1048.2, 2166, 2515.8, 3629.7
), bandwidth = c(72.6, 471.7, 376.1, 916.6, 161.6
)), list(intensity = 0.00858153339282566, nFormants = 5,
frequency = c(372.5, 1038, 2023, 2686, 3541.3), bandwidth = c(61.8,
683.4, 376.7, 660.8, 128.3)), list(intensity = 0.00858153339282566,
nFormants = 5, frequency = c(382, 1099.4, 2107.6,
2936.5, 3579.6), bandwidth = c(56.3, 624.7, 383.7,
339.1, 184.2)), list(intensity = 0.0087904779557582,
nFormants = 5, frequency = c(371, 1718.4, 2424.6,
3147.3, 3723.1), bandwidth = c(137.1, 469.2, 198.2,
95, 179.2)), list(intensity = 0.0087904779557582,
nFormants = 5, frequency = c(564.8, 1841.3, 2488.1,
3153.2, 3774.3), bandwidth = c(565.1, 361.1, 246.3,
66.3, 135.4)), list(intensity = 0.0087904779557582,
nFormants = 5, frequency = c(789.9, 1985.6, 2594.5,
3186.4, 3810.9), bandwidth = c(559.6, 168.6, 231.2,
92, 60.9)), list(intensity = 0.0087904779557582,
nFormants = 5, frequency = c(648.4, 2040.8, 2617.1,
3247.9, 3816.5), bandwidth = c(672.9, 62.8, 126.8,
160.5, 55)), list(intensity = 0.0087904779557582,
nFormants = 5, frequency = c(1117.8, 2007, 2479.9,
3183.7, 3723.6), bandwidth = c(993.2, 145.1, 392.4,
272.6, 104.7)), list(intensity = 0.0087904779557582,
nFormants = 5, frequency = c(1316.5, 1887.6, 2433.2,
3204, 3798.7), bandwidth = c(556.9, 169, 421.7, 218.1,
60.6)), list(intensity = 0.0087904779557582, nFormants = 5,
frequency = c(1326.4, 1802.4, 2369.5, 3077.8, 3783.6
), bandwidth = c(612.8, 155.9, 642.6, 315, 46.8)),
list(intensity = 0.0087904779557582, nFormants = 5, frequency = c(1322,
1717, 2388.7, 3035.8, 3747.3), bandwidth = c(638.4, 139.3,
559.6, 229.8, 77.9)), list(intensity = 0.0084942895689146,
nFormants = 5, frequency = c(1532.4, 1625.3, 2151,
3012.4, 3661.4), bandwidth = c(156.8, 899.6, 538.9,
147.7, 86.4)), list(intensity = 0.0084942895689146,
nFormants = 5, frequency = c(1451.8, 1529.7, 2185.3,
3013.1, 3703), bandwidth = c(697.8, 82.8, 416.9,
180.5, 51.5)), list(intensity = 0.0084942895689146,
nFormants = 5, frequency = c(1456.3, 1540.1, 2254.9,
2976.1, 3721.7), bandwidth = c(324.4, 221.7, 801.8,
244.4, 60.5)), list(intensity = 0.0084942895689146,
nFormants = 5, frequency = c(1280.3, 1565.4, 2239.5,
2976.2, 3739), bandwidth = c(372, 241.7, 749.1, 246.6,
80.1)), list(intensity = 0.0084942895689146, nFormants = 5,
frequency = c(1176.8, 1521.8, 2237.8, 2943, 3758.3
), bandwidth = c(733.9, 113.3, 466.4, 251.8, 92.7
)), list(intensity = 0.0084942895689146, nFormants = 5,
frequency = c(1144.9, 1553.1, 2209.3, 2920.8, 3737.8
), bandwidth = c(811, 66.9, 516.8, 310.7, 63.1)),
list(intensity = 0.00251441713770844, nFormants = 5,
frequency = c(1149.8, 1569.7, 2243, 3005.3, 3808.5
), bandwidth = c(387.7, 97.3, 323.1, 227, 52)), list(
intensity = 0.000498073026612528, nFormants = 5,
frequency = c(1284.1, 1518.9, 2113.4, 2994.9, 3759.4
), bandwidth = c(665.6, 275.8, 439.8, 210.1, 101.2
)), list(intensity = 0.000125282905169297, nFormants = 5,
frequency = c(1093.2, 1444.9, 2015.8, 3036.3, 3781
), bandwidth = c(1371.9, 183.4, 341.6, 173.4, 81.4
)), list(intensity = 0.000541185759231496, nFormants = 5,
frequency = c(992.8, 1534.7, 2163.1, 3023.5, 3800.6
), bandwidth = c(757.8, 95.3, 268.7, 232.9, 44.6)),
list(intensity = 0.000541185759231496, nFormants = 5,
frequency = c(873.4, 1520.3, 2109.2, 2972, 3716.9
), bandwidth = c(897.4, 79, 280, 349.9, 77.1)), list(
intensity = 0.000541185759231496, nFormants = 5,
frequency = c(858.6, 1271.1, 1925.9, 2974.7, 3769.4
), bandwidth = c(331.8, 270.2, 268.5, 310.2, 102)),
list(intensity = 0.000805311397263781, nFormants = 5,
frequency = c(767.6, 1179.9, 1877, 2948.3, 3787),
bandwidth = c(353.6, 207.1, 321.5, 255.6, 83.7)),
list(intensity = 0.00164562977713011, nFormants = 5,
frequency = c(639.8, 1147.7, 1838.1, 2930.9, 3709.9
), bandwidth = c(458.2, 239, 608.2, 280.1, 49.4)),
list(intensity = 0.00305030282930809, nFormants = 5,
frequency = c(416.8, 1128.8, 1915.5, 2875.5, 3691.8
), bandwidth = c(286.2, 180, 908.5, 273.7, 44.4)),
list(intensity = 0.00333796175116372, nFormants = 5,
frequency = c(388.5, 1037, 2150.7, 2887.9, 3715.2
), bandwidth = c(62.8, 232.9, 570.5, 497.3, 70)),
list(intensity = 0.00381086048889988, nFormants = 5,
frequency = c(404.5, 1030.4, 2166.7, 2841.9, 3650.8
), bandwidth = c(47.2, 172.5, 527.6, 552, 56.1)),
list(intensity = 0.00381086048889988, nFormants = 5,
frequency = c(415, 1008.8, 2286.3, 2811.7, 3639.5
), bandwidth = c(30.9, 135.4, 477, 578.4, 42.1)),
list(intensity = 0.00381086048889988, nFormants = 5,
frequency = c(421.9, 981.5, 2280, 2939.2, 3668.2),
bandwidth = c(29.1, 141.4, 461.5, 602.6, 60.3)),
list(intensity = 0.00381086048889988, nFormants = 5,
frequency = c(424.5, 955.3, 2233.1, 3008.5, 3665.6
), bandwidth = c(32, 122.8, 525.2, 538.8, 61.5)),
list(intensity = 0.00381086048889988, nFormants = 5,
frequency = c(425, 955, 2199.1, 2979.3, 3679.9),
bandwidth = c(37.1, 110.7, 671.5, 438.2, 44.6)),
list(intensity = 0.00381086048889988, nFormants = 5,
frequency = c(423.8, 930.9, 2241.8, 2936.9, 3691.5
), bandwidth = c(40.8, 101, 738.9, 380.1, 35.2)),
list(intensity = 0.00381086048889988, nFormants = 5,
frequency = c(423, 909.6, 2281.9, 2973.1, 3701.6),
bandwidth = c(42.7, 80.4, 786.7, 394.5, 38.4)), list(
intensity = 0.00381086048889988, nFormants = 5, frequency = c(421.6,
899.9, 2323.8, 3044.1, 3699.4), bandwidth = c(42,
62.1, 795, 400.9, 55)), list(intensity = 0.00379265732431134,
nFormants = 5, frequency = c(418.5, 888.7, 2482.9,
2994.9, 3673.4), bandwidth = c(38.8, 42.3, 717.3,
539.9, 75)), list(intensity = 0.00340584306126874,
nFormants = 5, frequency = c(416.3, 881.1, 2593.6,
2934.6, 3681.1), bandwidth = c(37.2, 33.8, 478.8,
787.1, 77.9)), list(intensity = 0.00340584306126874,
nFormants = 5, frequency = c(417.9, 881.9, 2513.7,
2942.1, 3686.5), bandwidth = c(34.7, 31.5, 547.8,
595.5, 44.3)), list(intensity = 0.00340584306126874,
nFormants = 5, frequency = c(423.1, 888.5, 2422.2,
3033.9, 3714.2), bandwidth = c(36, 37, 536.5, 537,
30.1)), list(intensity = 0.00340584306126874, nFormants = 5,
frequency = c(428, 890.3, 2444, 3077.1, 3723.1),
bandwidth = c(34.2, 35.9, 470.8, 580.5, 31.1)), list(
intensity = 0.00340584306126874, nFormants = 5, frequency = c(434,
900.3, 2399.9, 3031.6, 3735.2), bandwidth = c(36.2,
39.6, 631.5, 467.2, 32)), list(intensity = 0.00340584306126874,
nFormants = 5, frequency = c(441.3, 916.6, 2433.3,
3053.2, 3758.9), bandwidth = c(42.1, 55.1, 682.8,
535.8, 36.5)), list(intensity = 0.00340584306126874,
nFormants = 5, frequency = c(448.4, 932.2, 2431,
2979.6, 3738), bandwidth = c(52.2, 82.8, 732.6, 508.5,
28.3)), list(intensity = 0.00332450572653481, nFormants = 5,
frequency = c(459.3, 959.1, 2437.5, 2828.8, 3709.6
), bandwidth = c(74.1, 122.3, 946.9, 391.9, 31.3)),
list(intensity = 0.00332450572653481, nFormants = 5,
frequency = c(467.1, 1008.7, 2433.9, 2777.3, 3716.1
), bandwidth = c(81, 83.8, 1277.5, 323.6, 39)), list(
intensity = 0.0030886063452311, nFormants = 5, frequency = c(462.2,
1026.3, 2237.7, 2753.1, 3733.8), bandwidth = c(78.6,
30.7, 1359.9, 213.3, 30.1)), list(intensity = 0.00284798546072446,
nFormants = 5, frequency = c(482.1, 1027.6, 2014.2,
2768.1, 3736.9), bandwidth = c(107.7, 25.6, 1085.2,
183.3, 17.4)), list(intensity = 0.00583189665816964,
nFormants = 5, frequency = c(542.3, 1061.2, 2134.1,
2818.2, 3725.5), bandwidth = c(99.7, 56, 1231.9,
315.3, 42.3)), list(intensity = 0.00889069111891238,
nFormants = 5, frequency = c(562.6, 1117.8, 2200.5,
2799.1, 3737.4), bandwidth = c(49.2, 75.8, 1170.8,
281.9, 36.7)), list(intensity = 0.00889069111891238,
nFormants = 5, frequency = c(580.5, 1192.4, 2274.7,
2748.8, 3731.2), bandwidth = c(56, 72.7, 1164.1,
218.8, 24.2)), list(intensity = 0.00889069111891238,
nFormants = 5, frequency = c(629.7, 1265, 2205.2,
2782.4, 3751), bandwidth = c(95.6, 76.8, 991.9, 221.6,
21.5)), list(intensity = 0.00889069111891238, nFormants = 5,
frequency = c(645.6, 1320, 2148.1, 2849.4, 3745.6
), bandwidth = c(87.3, 83.9, 929.7, 296, 21)), list(
intensity = 0.0199920819913616, nFormants = 5, frequency = c(655.1,
1345.7, 1929.5, 2983.5, 3733.3), bandwidth = c(116.4,
73.6, 763.9, 372.9, 20.2)), list(intensity = 0.0449573311364646,
nFormants = 5, frequency = c(695.2, 1379.7, 2205.2,
2743.3, 3767.7), bandwidth = c(135, 80.5, 773.5,
399.9, 18.4)), list(intensity = 0.0638262432174788,
nFormants = 5, frequency = c(731.9, 1416.8, 2203.5,
2736.3, 3768.6), bandwidth = c(187.1, 96.5, 799.1,
378.8, 26.7)), list(intensity = 0.0678100440926364,
nFormants = 5, frequency = c(768.3, 1428.3, 2136.8,
2831.3, 3790.4), bandwidth = c(246.1, 87.9, 720.6,
378.1, 46)), list(intensity = 0.0786516537502495,
nFormants = 5, frequency = c(784.7, 1442.7, 2185.9,
2839.8, 3836.4), bandwidth = c(185.3, 55.9, 775.7,
415.6, 27.3)), list(intensity = 0.0894336186233894,
nFormants = 5, frequency = c(818.4, 1447.4, 2108.9,
2809.4, 3835.9), bandwidth = c(190.8, 88, 754.6,
330.9, 25.7)), list(intensity = 0.0894336186233894,
nFormants = 5, frequency = c(817.6, 1452.9, 2112.4,
2774.5, 3823.8), bandwidth = c(208.7, 117.8, 712.4,
276.1, 30.9)), list(intensity = 0.115475924340128,
nFormants = 5, frequency = c(822.9, 1441.3, 2084.6,
2763.2, 3802.2), bandwidth = c(306.3, 106.3, 692.5,
225.8, 28.6)), list(intensity = 0.115475924340128,
nFormants = 5, frequency = c(858.3, 1461.7, 2120.6,
2748.2, 3807.8), bandwidth = c(338, 135.4, 855.9,
288.3, 38.1)), list(intensity = 0.115475924340128,
nFormants = 5, frequency = c(886.5, 1471.3, 2165.2,
2766.5, 3840.5), bandwidth = c(304.2, 137.1, 777.7,
298.3, 44.8)), list(intensity = 0.115475924340128,
nFormants = 5, frequency = c(896.9, 1475.2, 2076.4,
2734, 3820), bandwidth = c(238.7, 107.5, 924.7, 206.7,
55.4)), list(intensity = 0.115475924340128, nFormants = 5,
frequency = c(892.2, 1471.5, 1880.6, 2748.4, 3836.6
), bandwidth = c(188.9, 79.9, 929.4, 137.2, 72.3)),
list(intensity = 0.115475924340128, nFormants = 5, frequency = c(881.3,
1456.7, 1834.8, 2756.2, 3821.6), bandwidth = c(136.2,
97, 669.8, 100.9, 94.4)), list(intensity = 0.115475924340128,
nFormants = 5, frequency = c(870, 1447.5, 1813.1,
2754.5, 3733), bandwidth = c(154, 109.5, 547.2, 147.8,
73.7)), list(intensity = 0.115475924340128, nFormants = 5,
frequency = c(871.7, 1468, 2005, 2690.7, 3718.3),
bandwidth = c(156.1, 71, 929.2, 218.9, 75.4)), list(
intensity = 0.0912920713958398, nFormants = 5, frequency = c(869,
1466, 2112.1, 2676.6, 3768), bandwidth = c(83.6,
37.7, 985.1, 209.9, 68.3)), list(intensity = 0.0912920713958398,
nFormants = 5, frequency = c(832.9, 1470, 2191.3,
2867.9, 3828.6), bandwidth = c(72.9, 47.2, 578.1,
266.7, 45.9)), list(intensity = 0.0912920713958398,
nFormants = 5, frequency = c(853.4, 1470, 2255.9,
2843.4, 3862.3), bandwidth = c(53.2, 30.1, 635.4,
267, 41.4)), list(intensity = 0.0912920713958398,
nFormants = 5, frequency = c(818, 1466.6, 2221.8,
2854.3, 3862.3), bandwidth = c(81.6, 60.3, 695.5,
226.2, 39.9)), list(intensity = 0.0591466543816893,
nFormants = 5, frequency = c(817.5, 1463, 2246.3,
2821.4, 3847.7), bandwidth = c(111.1, 53.6, 709,
207.8, 43.7)), list(intensity = 0.0591466543816893,
nFormants = 5, frequency = c(800.6, 1446.7, 2315.2,
2869.5, 3852.5), bandwidth = c(129, 98.7, 632, 307.7,
67.2)), list(intensity = 0.0591466543816893, nFormants = 5,
frequency = c(798.2, 1457.5, 2333.5, 2879.4, 3903.4
), bandwidth = c(128.5, 81.8, 718.6, 304.6, 53.7)),
list(intensity = 0.0591466543816893, nFormants = 5, frequency = c(738.1,
1457.3, 2232.7, 2838.1, 3864.2), bandwidth = c(214.2,
108.4, 1067.9, 192.7, 45.8)), list(intensity = 0.0499964452246575,
nFormants = 5, frequency = c(621.7, 1476.2, 2214.5,
2802, 3865.5), bandwidth = c(258.7, 129.2, 1368.3,
111, 45.2)), list(intensity = 0.0499964452246575,
nFormants = 5, frequency = c(533.1, 1455.7, 1831.1,
2777.4, 3851.1), bandwidth = c(193.7, 331, 845.3,
70.4, 46.5)), list(intensity = 0.0499964452246575,
nFormants = 5, frequency = c(473.1, 1341.6, 1839.5,
2762.7, 3802.9), bandwidth = c(159.3, 510.3, 695.1,
96.8, 79.2)), list(intensity = 0.0499964452246575,
nFormants = 5, frequency = c(466.8, 1452, 1706.1,
2767.9, 3731.1), bandwidth = c(217.9, 516.2, 1333.8,
63.2, 119.2)), list(intensity = 0.0112244420033243,
nFormants = 5, frequency = c(557.7, 1296.5, 1770.4,
2768.7, 3672.1), bandwidth = c(227, 853.8, 642.1,
115.2, 103)), list(intensity = 0.00406811306824212,
nFormants = 5, frequency = c(543.7, 1359.3, 1930.7,
2739.4, 3789.4), bandwidth = c(148.8, 435.5, 701.5,
133.4, 110.9)), list(intensity = 0.00178056224054474,
nFormants = 5, frequency = c(515.8, 1355.9, 1832.7,
2750.3, 3878.1), bandwidth = c(154.5, 296, 741.5,
76.7, 75.6)), list(intensity = 0.000474352405725075,
nFormants = 5, frequency = c(551.1, 1445.9, 1673.7,
2788.8, 3821.6), bandwidth = c(303.1, 389.7, 1291.2,
136.1, 62.8)), list(intensity = 0.000253315539809338,
nFormants = 5, frequency = c(633.1, 1452.7, 2041.8,
3014.2, 3819.3), bandwidth = c(230.6, 323.6, 902,
382.3, 75)), list(intensity = 0.000137660993838874,
nFormants = 5, frequency = c(565.7, 1413.7, 1955.7,
2839.6, 3807.2), bandwidth = c(230.2, 385, 1202,
377.5, 85.8)), list(intensity = 4.36908742605472e-05,
nFormants = 5, frequency = c(505.2, 1279.5, 1789.8,
2763.4, 3813.3), bandwidth = c(227.7, 407.4, 848.5,
178.5, 79.9)), list(intensity = 0.0007354435724391,
nFormants = 5, frequency = c(527.8, 1161.4, 1849.5,
2766.3, 3782.4), bandwidth = c(370.6, 509.8, 583.8,
209.4, 66.4)), list(intensity = 0.0007354435724391,
nFormants = 5, frequency = c(730, 1346.7, 2032.1,
2906.2, 3751.6), bandwidth = c(204.8, 439.8, 630.7,
243.3, 104.4)), list(intensity = 0.024464453177085,
nFormants = 5, frequency = c(822.2, 1632, 2209, 3111.1,
3812.9), bandwidth = c(314.3, 320.6, 417.2, 111.9,
45.8)), list(intensity = 0.0292909236000111, nFormants = 5,
frequency = c(799.8, 1619.6, 2153.9, 3124.9, 3782.6
), bandwidth = c(428.2, 374.1, 477.6, 114.6, 42.2
)), list(intensity = 0.0292909236000111, nFormants = 5,
frequency = c(516.2, 1504.5, 2063.2, 3091.1, 3741.9
), bandwidth = c(141.6, 236.2, 523.8, 159.5, 47.1
)), list(intensity = 0.0292909236000111, nFormants = 5,
frequency = c(544.7, 1488.1, 1793.4, 2918.7, 3802.2
), bandwidth = c(91.3, 244.9, 624.2, 122.6, 72.5)),
list(intensity = 0.0292909236000111, nFormants = 5, frequency = c(583.3,
1469.4, 1894.4, 2883.4, 3851), bandwidth = c(71, 186.5,
557.9, 75.8, 56.2)), list(intensity = 0.0292909236000111,
nFormants = 5, frequency = c(585, 1485.1, 1975.3,
2861.3, 3826.8), bandwidth = c(89.4, 158.1, 552.5,
95.6, 55.8)), list(intensity = 0.0292909236000111,
nFormants = 5, frequency = c(580.3, 1472.1, 1937.1,
2808.3, 3764.3), bandwidth = c(178.8, 173, 560.4,
92.9, 76.3)), list(intensity = 0.0292909236000111,
nFormants = 5, frequency = c(582.7, 1442.7, 1858.8,
2750.1, 3750.3), bandwidth = c(211.9, 261.3, 496,
67.9, 78)), list(intensity = 0.0292909236000111,
nFormants = 5, frequency = c(572.3, 1442.6, 1843.3,
2749.7, 3785.8), bandwidth = c(238.2, 269.2, 666.7,
123.3, 44.8)), list(intensity = 0.0279276658811202,
nFormants = 5, frequency = c(541.9, 1390.1, 1870.3,
2799.1, 3811.8), bandwidth = c(238.9, 243.3, 631.2,
239.4, 33.4)), list(intensity = 0.0279276658811202,
nFormants = 5, frequency = c(476.8, 1336.8, 1887.1,
2818.7, 3808.8), bandwidth = c(292.3, 197.4, 598.4,
392.9, 43.8)), list(intensity = 0.0249408348163337,
nFormants = 5, frequency = c(406.1, 1369.7, 1927.6,
2658.1, 3729.1), bandwidth = c(285.6, 219, 675.2,
451.2, 57.3)), list(intensity = 0.0206688917026051,
nFormants = 5, frequency = c(357.3, 1322.6, 1706.4,
2686.8, 3663.1), bandwidth = c(241.8, 488, 407.7,
146.5, 82.5)), list(intensity = 0.00896151404489938,
nFormants = 5, frequency = c(306.6, 1134.1, 1739.2,
2728.4, 3634.5), bandwidth = c(173.3, 471.6, 330.5,
65, 166.7)), list(intensity = 0.00480644142071012,
nFormants = 5, frequency = c(302.6, 1356.8, 1882,
2734.4, 3595.5), bandwidth = c(96.2, 339.8, 628.4,
97, 328.1)), list(intensity = 0.0039532417116797,
nFormants = 5, frequency = c(298.1, 1389.2, 2033.2,
2771.1, 3638.7), bandwidth = c(69.1, 214, 588.6,
92.4, 292.3)), list(intensity = 0.00287545307387581,
nFormants = 5, frequency = c(289.1, 1374.6, 1950.4,
2783.9, 3628.1), bandwidth = c(72.9, 222.8, 477,
81.7, 240.1)), list(intensity = 0.00287545307387581,
nFormants = 5, frequency = c(288, 1387.5, 1943.6,
2768, 3576.3), bandwidth = c(79.5, 225.1, 508.8,
80.3, 234.2)), list(intensity = 0.00191660934681614,
nFormants = 5, frequency = c(285.5, 1376.7, 1909.7,
2788.7, 3544.4), bandwidth = c(74.5, 196.6, 476.5,
64.7, 239.3)), list(intensity = 0.00191660934681614,
nFormants = 5, frequency = c(280.1, 1381.6, 1971.8,
2806.8, 3578.6), bandwidth = c(59.4, 190.9, 406.6,
52.6, 320.4)), list(intensity = 0.00273483801907607,
nFormants = 5, frequency = c(279.1, 1376.2, 1922.5,
2789.1, 3662.1), bandwidth = c(55.4, 298.2, 312,
52.3, 297.6)), list(intensity = 0.00478577732888992,
nFormants = 5, frequency = c(288.1, 1360.5, 1878.2,
2753.2, 3678.9), bandwidth = c(74.7, 322.5, 313.3,
113, 117.7)), list(intensity = 0.00545155820367855,
nFormants = 5, frequency = c(338.5, 1332.2, 1863.6,
2720.8, 3597.5), bandwidth = c(195, 457.9, 395.3,
232.8, 78.7)), list(intensity = 0.00545155820367855,
nFormants = 5, frequency = c(394.8, 1212.9, 1758.4,
2698.1, 3579.3), bandwidth = c(393.3, 550.6, 301.7,
201.6, 60.6)), list(intensity = 0.00573150230909244,
nFormants = 5, frequency = c(396, 1218.9, 1759, 2768.9,
3611.8), bandwidth = c(515.6, 395.2, 375.5, 346.9,
58.1)), list(intensity = 0.00573150230909244, nFormants = 5,
frequency = c(437.8, 1213.1, 1791.4, 2940, 3698.2
), bandwidth = c(543.1, 254.3, 369.4, 448.5, 77.4
)), list(intensity = 0.00573150230909244, nFormants = 5,
frequency = c(511.8, 1240.1, 1801.7, 2970.9, 3773.9
), bandwidth = c(481.2, 222.1, 323.8, 421, 50.6)),
list(intensity = 0.00573150230909244, nFormants = 5,
frequency = c(505, 1299.4, 1886.4, 3012.1, 3773.6
), bandwidth = c(395.3, 180.4, 290.4, 445.2, 45.9
)), list(intensity = 0.00573150230909244, nFormants = 5,
frequency = c(481, 1304, 1883.6, 3018.9, 3698.7),
bandwidth = c(336.1, 161.4, 261.7, 373.4, 58.6)),
list(intensity = 0.00573150230909244, nFormants = 5,
frequency = c(487, 1262.3, 1793.9, 3083.1, 3630.5
), bandwidth = c(311.8, 221.2, 232.9, 247.9, 78.6
)), list(intensity = 0.00573150230909244, nFormants = 5,
frequency = c(460.8, 1213.2, 1755.9, 3090.4, 3559
), bandwidth = c(293.7, 268.3, 188.1, 178.3, 112.1
)), list(intensity = 0.00573150230909244, nFormants = 5,
frequency = c(405.4, 1258.6, 1779.6, 3034.6, 3456.5
), bandwidth = c(273.3, 403.6, 257.3, 227.3, 196.8
)), list(intensity = 0.00481692390175562, nFormants = 5,
frequency = c(360.6, 1432.3, 1931.8, 2791.9, 3474.6
), bandwidth = c(144.9, 358.2, 547.6, 381.3, 222.7
)), list(intensity = 0.00481692390175562, nFormants = 5,
frequency = c(341.9, 1470.5, 1924.3, 2697.8, 3627.9
), bandwidth = c(64.8, 212.5, 411.4, 160.4, 219.6
)), list(intensity = 0.00254424533471212, nFormants = 5,
frequency = c(333, 1500.6, 2115.8, 2736.1, 3589),
bandwidth = c(42.9, 93.4, 414.6, 202.2, 320.7)),
list(intensity = 0.00085922424651712, nFormants = 5,
frequency = c(329.5, 1481.1, 2120.8, 2770.9, 3539.4
), bandwidth = c(25.2, 128, 378.5, 146.4, 439.9)),
list(intensity = 0.0007983755756729, nFormants = 5, frequency = c(330.3,
1442.9, 2035.6, 2743.7, 3445.3), bandwidth = c(24.8,
232, 447.5, 132.8, 592.3)), list(intensity = 0.00214303266170352,
nFormants = 5, frequency = c(329.7, 1414.8, 1953.5,
2739.5, 3659.7), bandwidth = c(25.8, 291.2, 419.8,
86.5, 449.1)), list(intensity = 0.0029216499253024,
nFormants = 5, frequency = c(330.4, 1429.3, 1987.4,
2781.4, 3681.4), bandwidth = c(28.1, 206.6, 441.1,
100.5, 173.7)), list(intensity = 0.0029216499253024,
nFormants = 5, frequency = c(346.2, 1442.7, 2041.4,
2846.4, 3654.9), bandwidth = c(59.4, 194.4, 517.6,
242.4, 94.8)), list(intensity = 0.0029216499253024,
nFormants = 5, frequency = c(351.5, 1451.8, 1930,
3009, 3669.1), bandwidth = c(80.3, 161.1, 326.1,
290.8, 107.2)), list(intensity = 0.0029216499253024,
nFormants = 5, frequency = c(355.9, 1477.8, 1874.5,
3004.1, 3648.7), bandwidth = c(112.5, 169.6, 320.3,
371.9, 67.7)), list(intensity = 0.0029216499253024,
nFormants = 5, frequency = c(361.8, 1476.6, 1845.7,
3095.2, 3693.8), bandwidth = c(146.7, 159.5, 273.8,
323.1, 57.5)), list(intensity = 0.0029216499253024,
nFormants = 5, frequency = c(364.4, 1479.7, 1849.5,
3071.2, 3682.7), bandwidth = c(172.2, 146, 266.7,
267.2, 56.4)), list(intensity = 0.0029216499253024,
nFormants = 5, frequency = c(362.5, 1482.2, 1827.7,
3068.8, 3628.6), bandwidth = c(193.9, 134.7, 317.1,
253.5, 61.4)), list(intensity = 0.0029216499253024,
nFormants = 5, frequency = c(350.9, 1466.5, 1717.3,
3098.2, 3665.2), bandwidth = c(220.9, 149.9, 306.4,
217.6, 43.7)), list(intensity = 0.00284705920122636,
nFormants = 5, frequency = c(334.1, 1433.8, 1669.6,
3019.6, 3667.7), bandwidth = c(213.4, 158, 300.6,
231, 59.2)), list(intensity = 0.00260752587857022,
nFormants = 5, frequency = c(328.9, 1437.3, 1666.7,
2890.6, 3600), bandwidth = c(180.8, 138.8, 518, 284.7,
78.3)), list(intensity = 0.00231273258159277, nFormants = 5,
frequency = c(323.5, 1437.2, 1699.7, 2862.2, 3579.4
), bandwidth = c(142.3, 141.4, 797.7, 298, 91.7)),
list(intensity = 0.00171470075663359, nFormants = 5,
frequency = c(316.9, 1302.1, 2052.6, 2897.8, 3596.1
), bandwidth = c(98.7, 192.8, 592.9, 392.9, 112.2
)), list(intensity = 0.00171470075663359, nFormants = 5,
frequency = c(315.1, 1265.5, 2081.6, 2652.1, 3524.8
), bandwidth = c(116.9, 304.4, 928.3, 342.1, 68.8
)), list(intensity = 0.00115884691313823, nFormants = 5,
frequency = c(309.3, 1447.4, 1767.1, 2690.9, 3517.4
), bandwidth = c(110.1, 294.3, 1225.4, 263.1, 43.9
)), list(intensity = 0.000340868770782682, nFormants = 5,
frequency = c(297.1, 1441.1, 2319.1, 2769.8, 3661.2
), bandwidth = c(87.7, 179.4, 1060.9, 301.3, 140.5
)), list(intensity = 0.000197113601417233, nFormants = 5,
frequency = c(270.4, 1473.4, 2473.3, 2939.8, 3751.5
), bandwidth = c(96.2, 137.6, 337.8, 501.8, 139.2
)), list(intensity = 0.000143266563595355, nFormants = 5,
frequency = c(198.4, 1492.5, 2258.2, 2741.5, 3753.1
), bandwidth = c(321.8, 188.7, 669.1, 202.8, 111.6
)), list(intensity = 9.44613529364061e-05, nFormants = 5,
frequency = c(200, 1528.6, 2204.5, 2759.9, 3831.8
), bandwidth = c(248.7, 132.2, 518.1, 62.6, 73.3)),
list(intensity = 3.36314344503738e-05, nFormants = 5,
frequency = c(255, 1515, 2281, 2775.5, 3767), bandwidth = c(135.4,
80.7, 385.1, 96.2, 90.8)), list(intensity = 1.17731596218976e-05,
nFormants = 5, frequency = c(307.9, 1504.5, 2423.8,
2783.7, 3723.8), bandwidth = c(105.1, 84, 282.2,
204.5, 104.3)), list(intensity = 1.17731596218976e-05,
nFormants = 5, frequency = c(326.8, 1520.4, 2418.8,
2781.2, 3771.2), bandwidth = c(93.4, 80.7, 358.2,
188.5, 71.3)), list(intensity = 8.07304653300645e-06,
nFormants = 5, frequency = c(336.8, 1549.1, 2402.2,
2857.9, 3763.6), bandwidth = c(97.5, 116.2, 271.9,
206.2, 109.2)), list(intensity = 5.26173379227444e-06,
nFormants = 5, frequency = c(350, 1563.3, 2365.7,
2875.9, 3714.1), bandwidth = c(97.6, 88.4, 230.4,
228.4, 101.3)), list(intensity = 5.26173379227444e-06,
nFormants = 5, frequency = c(359.4, 1545.8, 2320.3,
2858.1, 3715.6), bandwidth = c(155, 89.4, 297.3,
141.3, 95.8)), list(intensity = 5.26173379227444e-06,
nFormants = 5, frequency = c(326.5, 1497.2, 2212.1,
2812.7, 3754.5), bandwidth = c(318.7, 58, 418.5,
95.8, 60.3)), list(intensity = 3.63213340555674e-06,
nFormants = 5, frequency = c(298.1, 1497.2, 2325,
2765.1, 3719.4), bandwidth = c(352, 44.5, 388, 89.9,
51.7)), list(intensity = 3.63213340555674e-06, nFormants = 5,
frequency = c(299.1, 1459.9, 2414.5, 2770.7, 3694.7
), bandwidth = c(252.7, 101.8, 315.8, 129.9, 58.6
)), list(intensity = 3.63213340555674e-06, nFormants = 5,
frequency = c(333.6, 1488, 2391.2, 2829.8, 3626),
bandwidth = c(298.5, 95, 368.8, 107.7, 87.2)), list(
intensity = 3.79350476588661e-06, nFormants = 5,
frequency = c(346.9, 1542.9, 2361.4, 2852, 3580.8
), bandwidth = c(231.9, 116.3, 365.2, 164.7, 95.1
)), list(intensity = 4.16331113782043e-06, nFormants = 5,
frequency = c(369.7, 1547.6, 2352.2, 2863.8, 3674.9
), bandwidth = c(335.2, 132.2, 259.2, 154.1, 115.2
)), list(intensity = 4.16331113782043e-06, nFormants = 5,
frequency = c(321.3, 1505.4, 2249.7, 2849.4, 3734.6
), bandwidth = c(452.1, 90.8, 271.1, 155, 78.3)))), class = c("list",
type = "Formant 2", name = "H.Formant"))
)
}


#' snd.sample
#'
#' Returns sample Sound object.
#'
#' @return snd
#' @export
#' @seealso \code{\link{snd.plot}}
#'
#' @examples
#' snd <- snd.sample()
#' snd.plot(snd)
snd.sample <- function() {
snd <- structure(list(t = seq(0, 5483)/8000, sig = structure(c(0, 0.00116, 
0.001373, 0.001862, 0.001526, 0.001648, -0.000336, -0.001617, 
-0.004334, -0.004547, -0.006989, -0.008728, -0.011811, -0.01297, 
-0.018281, -0.01764, -0.021241, -0.019959, -0.020203, -0.019257, 
-0.014771, -0.011383, -0.003693, -0.000855, 0.00586, 0.005646, 
0.013184, 0.011078, 0.015839, 0.00824, 0.008698, 0.001923, 0.002655, 
-0.004364, 0.006104, -0.002411, 0.001709, 0.002655, 0.008271, 
0.013611, 0.014801, 0.012909, 0.013062, 0.019196, 0.016449, 0.017609, 
0.011811, 0.006745, 0.009613, 0.003235, 0.0065, -0.008911, -0.00412, 
-0.014863, -0.012543, -0.019257, -0.019227, -0.0206, -0.022858, 
-0.016541, -0.014435, -0.004028, -0.0047, -0.003449, 0.002441, 
0.002319, 0.010437, 0.003021, 0.007691, -0.002258, 0.005463, 
-0.004791, 0.009217, -0.005707, 0.004608, 0.00528, 0.010895, 
0.005951, 0.00882, 0.01117, 0.01944, 0.011658, 0.01352, 0.008179, 
0.004456, 0.005676, 0.002686, -0.005524, -0.005005, -0.017457, 
-0.00766, -0.018159, -0.018677, -0.021393, -0.020417, -0.022126, 
-0.014771, -0.012391, -0.013001, -0.007996, -0.002289, 0.00528, 
0.005188, 0.008637, 0.007569, 0.012421, 0.008148, 0.005585, 0.002289, 
0.000244, -0.002411, 0.000641, -0.002106, -0.006714, -0.004303, 
-3.1e-05, 9.2e-05, 0.008789, 0.006958, 0.011902, 0.014069, 0.015046, 
0.017426, 0.019684, 0.016511, 0.015748, 0.016022, 0.013276, 0.011505, 
0.005737, -0.004913, 0.002136, -0.013855, -0.003235, -0.021577, 
-0.014008, -0.015076, -0.019013, -0.015595, -0.019471, -0.010224, 
-0.016419, -0.00589, -0.014771, -0.010681, -0.014527, -0.005829, 
-0.0065, -0.009033, -0.004364, -0.004212, -0.001892, 0.009064, 
0.001862, 0.014283, 0.010193, 0.018372, 0.015137, 0.026215, 0.015687, 
0.018525, 0.014252, 0.020386, 0.012513, 0.014069, 0.003265, 0.008454, 
0.004486, 0.005097, 0.001312, 0.002197, -0.003998, -0.00586, 
-9.2e-05, -0.002625, 0.003784, -0.004028, -0.006561, -0.002564, 
-0.000977, 0.003815, -0.007965, -0.009735, -0.017914, -0.014649, 
-0.010346, -0.011536, -0.021821, -0.027619, -0.014801, -0.0112, 
-0.002045, -0.010681, -0.008209, -0.007721, 0.012513, 0.008118, 
0.014222, 0.004944, 0.007843, 0.015656, 0.016419, 0.014832, 0.01001, 
0.005463, 0.007752, 0.014191, 0.005676, 0.010743, -0.001648, 
0.002228, 0.001984, 0.004517, 0.006989, -0.000153, -0.007599, 
-0.000305, 0.006623, -0.00235, 0.000763, -0.010529, -0.006378, 
-0.008362, -0.007782, -0.01117, -0.010773, -0.016572, -0.011353, 
-0.009003, -0.006714, -0.008087, -0.006531, -0.003784, 0.004151, 
0.001831, 0.005829, -0.000946, 0.006897, 0.000732, 0.002747, 
0.005615, -0.002441, -0.001953, -0.004975, -0.00177, 0.000641, 
0.00058, -0.009339, -0.002655, -0.000336, 0.000763, 0.00296, 
0.001373, 0.001404, 0.009369, 0.00412, 0.013306, 0.004608, 0.007202, 
0.006073, 0.00412, 0.001495, 0.004364, -0.001373, -0.003327, 
-0.007416, -0.000671, -0.006195, -0.001709, -0.012024, -0.000946, 
-0.014649, 0.00058, -0.01059, 0.001953, -0.009369, -0.007447, 
-0.00647, 0.002655, -0.004761, -0.003784, -0.006409, 0.001617, 
0.001251, 0.002838, -0.006043, -0.001679, 0.004669, -0.000183, 
0.004669, -0.001373, 0.005676, 0.002564, 0.007904, 0.006775, 
0.006684, -6.1e-05, 0.013276, 0.003662, 0.003937, -0.002533, 
0.002441, 0.00235, 3.1e-05, -0.005005, -0.001679, -0.004212, 
-0.003296, -0.006806, -0.005036, -0.002411, -0.004089, -0.003327, 
-0.005402, -0.006928, 0.001312, -0.002503, -0.004151, -0.003143, 
-0.001953, -0.003052, -0.000855, -0.004913, 0.000488, -0.001648, 
-0.003723, 0.005707, -0.000855, 0.00589, 0.003021, 0.000366, 
0.007874, 0.007141, 0.001648, 0.002838, 0.006806, -0.000305, 
0.009949, -0.004913, 0.003815, 0.000427, 0.004395, -0.001007, 
-0.000824, -0.002441, 0.000732, -0.002625, 0, -0.004059, 0.001892, 
-0.007782, 0.000366, -0.005737, 0.000366, -0.008454, 0.00119, 
-0.004486, 0.006867, -0.003937, -0.002838, -0.001465, -0.000824, 
0.003754, 0.005615, -0.003296, -0.00354, 0.002197, 0.003601, 
-0.001404, -0.005463, -0.002686, 0.003998, 0.000122, 0.004303, 
0.00061, 0.00061, -0.000763, -0.00058, 0.002594, 0.007355, -0.002197, 
-0.002625, -0.000488, 0.002075, 0.003967, 0.003601, -0.004242, 
-0.000763, -0.004303, 0.015046, -0.001312, -0.009156, -0.006623, 
0.009583, 0.002594, -0.00763, -0.004975, 0.003693, 9.2e-05, 0.000519, 
-0.001434, 0.000336, 3.1e-05, -0.008606, 0.001373, 0.001404, 
-0.008911, 0.005158, -0.003815, 0.002594, -0.003998, -0.003906, 
0.001617, 0.01355, -0.003235, 0.000641, 0.010468, -0.00116, 0.011231, 
0.003265, 0.004975, 0.004975, -0.00647, 0.007691, -0.001404, 
0.008087, -0.010285, 0.005615, -0.004852, 0.004669, -0.002808, 
0.001831, -0.004578, -0.004578, 0.001526, 0.003174, -0.004212, 
0.00293, -0.012574, 0.005371, -0.004517, 0.000305, -0.005188, 
-0.003815, 0.000305, 0.000366, -0.002411, 0.001282, 0.00647, 
0.004852, 0.002289, 0.010437, 0.002838, 0.011536, -0.000793, 
-0.002655, 0.008698, 0.007508, -0.000336, -0.008026, 0.0065, 
-0.003388, 0.016633, -0.003876, 0.015564, -0.007965, 0.014344, 
-0.003754, 0.01001, -0.001801, 0.00058, -0.00116, 0.003571, -0.003571, 
0.011872, -0.005737, -0.001099, -0.003052, 0.0112, 0.009583, 
0.027497, 0.004456, 0.018738, 0.010804, 0.007508, -0.001984, 
-0.001679, -0.02234, 0.002808, -0.018769, -0.010193, -0.008881, 
-0.006836, -0.02179, 0.015015, -0.012268, 0.006806, 0.006867, 
0.004364, 0.003967, 0.006165, -0.011292, -0.001099, -0.007324, 
-0.012482, -0.00116, -0.011109, -0.013062, -0.010773, -9.2e-05, 
-0.019288, 0.008881, -0.011505, -0.002319, -0.005188, -0.001129, 
-0.003327, 0.014801, -0.019288, 0.004395, -0.007294, 0.016633, 
-0.006256, 0.015107, -0.000763, 0.016663, -0.005249, 0.003265, 
-0.012116, -0.002411, -0.033662, 0.005005, -0.017823, -0.013245, 
-0.021027, -0.002503, -0.006684, 0.011872, -0.01648, 0.016633, 
-0.005615, 0.013367, -0.004975, 0.004273, -0.010987, 0.001434, 
-0.022858, 0.002319, -0.009857, 0.002503, -0.00116, 0.002472, 
0.003632, 0.009522, 0.003479, 0.011109, 0.006073, -0.008728, 
0.008209, -0.003082, -0.004395, -0.004669, 0.013123, -0.014832, 
0.008667, -0.015076, 0.016358, 0.005097, 0.002625, -0.008057, 
0.017914, -0.014771, 0.005371, -0.003113, -0.003357, -0.006592, 
-0.001282, -0.005493, 0.010681, -0.00647, -0.010407, 0.013672, 
0.005493, -0.00119, -0.016449, -0.006195, -0.005768, 0.01059, 
-0.013031, -0.005005, -0.005615, 0.007447, 0.003296, 0.010376, 
-0.004578, 0.004578, 0.01062, 0.012909, 0.003998, 0.013062, 0.008423, 
0.020264, 0.007447, 0.005676, 0.01587, 0.015137, 0.004364, 0.003662, 
0.008789, 0.002625, 0.003052, -0.007843, -0.001892, -0.00531, 
-0.007599, -0.010712, -0.005493, -0.007477, -0.00824, -0.012085, 
-0.021516, -0.03238, -0.043672, -0.035005, -0.041536, -0.046052, 
-0.068789, -0.072878, -0.068972, -0.014618, -0.006378, 0.010315, 
0.006714, 0.031587, 0.067843, 0.109134, 0.095126, 0.087252, 0.080142, 
0.09595, 0.110904, 0.091769, 0.057192, 0.033631, 0.042024, 0.043184, 
0.052034, 0.018952, 0.005585, -0.002838, 0.000397, -0.033357, 
-0.073366, -0.0983, -0.117405, -0.134037, -0.160894, -0.204566, 
-0.224769, -0.193487, -0.13773, -0.063753, -0.0112, 0.024201, 
0.066195, 0.119694, 0.163457, 0.173223, 0.151921, 0.101108, 0.086184, 
0.063448, 0.053468, 0.01941, 0.004791, 0.00116, 0.030885, 0.059206, 
0.067568, 0.06708, 0.064852, 0.079226, 0.080752, 0.0553, 0.019745, 
-0.005066, -0.016449, -0.018342, -0.037019, -0.065981, -0.088778, 
-0.114902, -0.151799, -0.163823, -0.183355, -0.217627, -0.263619, 
-0.192175, -0.124516, -0.01767, 0.031953, 0.056215, 0.108219, 
0.176122, 0.213477, 0.211341, 0.165929, 0.079928, 0.056337, 0.023133, 
0.001556, -0.031373, -0.048128, -0.048128, 0.009644, 0.057131, 
0.085726, 0.091708, 0.078799, 0.072634, 0.074282, 0.047884, 0.006531, 
-0.025697, -0.049165, -0.047731, -0.034944, -0.03534, -0.039277, 
-0.039338, -0.03592, -0.041536, -0.063173, -0.136692, -0.179327, 
-0.223151, -0.26661, -0.202918, -0.080203, -0.012116, 0.033265, 
0.074801, 0.140385, 0.226814, 0.260933, 0.208167, 0.139348, 0.062685, 
0.023133, 0.012757, -0.03531, -0.096561, -0.119114, -0.096225, 
-0.03238, 0.052644, 0.07828, 0.070803, 0.069582, 0.07474, 0.08655, 
0.076998, 0.020081, -0.034516, -0.034974, -0.018921, 0.009125, 
0.016968, -0.003113, -0.011444, 0.008911, 0.02591, 0.025117, 
-0.009369, -0.06119, -0.076968, -0.106388, -0.155034, -0.197607, 
-0.279733, -0.193457, -0.030488, 0.024964, 0.053682, 0.050447, 
0.108982, 0.192267, 0.249062, 0.173528, 0.093204, 0.003662, -0.022706, 
-0.012879, -0.044557, -0.103092, -0.129856, -0.109226, -0.041047, 
0.047914, 0.076724, 0.077731, 0.080355, 0.103916, 0.13126, 0.125248, 
0.068056, 0.007721, -0.022279, -0.021577, -0.0094, -0.0206, -0.053377, 
-0.062441, -0.038942, 0.004791, 0.052065, 0.041505, 0.00589, 
0.004028, 0.00882, 0.006775, -0.022828, -0.082369, -0.178076, 
-0.211798, -0.259987, -0.14423, -0.016205, -0.004608, 0.015412, 
0.020142, 0.104984, 0.173833, 0.22776, 0.142949, 0.056825, -0.025666, 
-0.046205, -0.019745, -0.034761, -0.072573, -0.11774, -0.089572, 
-0.025239, 0.079073, 0.129154, 0.112064, 0.091769, 0.07944, 0.086612, 
0.076022, 0.036225, -0.045442, -0.088198, -0.089969, -0.049074, 
-0.014161, -0.004456, -0.001068, 0.008789, 0.029664, 0.047792, 
0.043367, 0.012421, -0.003906, -0.008057, -0.010041, -0.013215, 
-0.023164, -0.032502, -0.030488, -0.025452, -0.038484, -0.06885, 
-0.125004, -0.174413, -0.17658, -0.069033, -0.039094, 0.004273, 
0.013489, 0.037599, 0.099002, 0.160558, 0.192541, 0.157384, 0.104465, 
0.02002, -0.009919, -0.031251, -0.047426, -0.064425, -0.089541, 
-0.074557, -0.037202, 0.017182, 0.058718, 0.07709, 0.059633, 
0.038453, 0.016999, -0.005585, -0.014527, -0.036042, -0.056307, 
-0.069735, -0.064302, -0.037965, -0.015809, 0.014954, 0.044008, 
0.05298, 0.051241, 0.061464, 0.081332, 0.062258, 0.049867, 0.006165, 
-0.020203, -0.031373, -0.025575, -0.009278, 0.003998, 0.001312, 
-0.009796, -0.003418, -0.001465, 0.016511, 0.025788, 0.012207, 
-0.00586, -0.024995, -0.041444, -0.07889, -0.111148, -0.158666, 
-0.14127, -0.077151, -0.038575, 0.002503, -0.00058, 0.016327, 
0.041902, 0.087008, 0.110446, 0.105869, 0.068361, 0.024415, 0.006104, 
-0.025056, -0.046632, -0.056032, -0.054903, -0.04062, -0.014649, 
0.012513, 0.03003, 0.059603, 0.076052, 0.082827, 0.073611, 0.053529, 
0.025544, -0.000793, -0.009247, -0.010834, -0.015137, -0.025697, 
-0.029298, -0.025941, -0.00824, 0.016938, 0.028871, 0.028962, 
0.046175, 0.047578, 0.032136, 0.026307, 0.007752, -0.006226, 
-0.017151, -0.025178, -0.037843, -0.038606, -0.042909, -0.044038, 
-0.040864, -0.032655, -0.010132, 0.004578, 0.008942, 0.001984, 
-0.009613, -0.03766, -0.065493, -0.096774, -0.114994, -0.08475, 
-0.065188, -0.033235, -0.007599, 0.018067, 0.039277, 0.070193, 
0.101505, 0.11362, 0.12186, 0.103946, 0.074007, 0.031922, -0.010559, 
-0.03824, -0.046846, -0.040345, -0.030335, -0.013703, -0.010285, 
0.000916, 0.015992, 0.03238, 0.047304, 0.055818, 0.052858, 0.035279, 
0.013062, -0.006897, -0.021821, -0.033937, -0.043977, -0.050783, 
-0.055147, -0.047243, -0.036042, -0.0253, -0.013764, 0.012238, 
0.044221, 0.05884, 0.073733, 0.062929, 0.044771, 0.021912, 0.002655, 
-0.01413, -0.026276, -0.037599, -0.057405, -0.062288, -0.061342, 
-0.04651, -0.026368, -0.003113, 0.011689, 0.015412, 0.00705, 
-0.020325, -0.05768, -0.073183, -0.064943, -0.054476, -0.028871, 
-0.007569, 0.01117, 0.032411, 0.051943, 0.065706, 0.07886, 0.091678, 
0.089999, 0.074709, 0.043184, 0.001953, -0.034303, -0.060671, 
-0.069002, -0.057497, -0.034547, -0.009919, 0.0094, 0.016297, 
0.013794, 0.014466, 0.019898, 0.028138, 0.036195, 0.033387, 0.018983, 
0.001587, -0.013459, -0.022858, -0.025544, -0.022614, -0.016541, 
-0.009491, -0.005676, 0.004395, 0.005829, 0.01413, 0.030915, 
0.038148, 0.044374, 0.037935, 0.024873, 0.013733, 0.008454, 0.000916, 
-0.00766, -0.017457, -0.032289, -0.039827, -0.041993, -0.044069, 
-0.042024, -0.043306, -0.057436, -0.079592, -0.094668, -0.083865, 
-0.063723, -0.030457, 0.004975, 0.031343, 0.049135, 0.060671, 
0.070162, 0.078494, 0.084536, 0.080691, 0.066836, 0.046022, 0.019166, 
-0.011292, -0.037721, -0.058199, -0.065615, -0.054079, -0.029542, 
0, 0.026002, 0.039277, 0.038972, 0.034394, 0.031159, 0.033387, 
0.038697, 0.035981, 0.023865, 0.005371, -0.016388, -0.037141, 
-0.046754, -0.047914, -0.04178, -0.027711, -0.011628, 0.00354, 
0.011994, 0.016297, 0.024049, 0.032685, 0.044465, 0.050417, 0.046968, 
0.032685, 0.015839, -0.000671, -0.016511, -0.024873, -0.031159, 
-0.038026, -0.038484, -0.034425, -0.030488, -0.027314, -0.02765, 
-0.036714, -0.05118, -0.069613, -0.087283, -0.082064, -0.06769, 
-0.042543, -0.008881, 0.023774, 0.049715, 0.066897, 0.080996, 
0.088107, 0.090365, 0.084506, 0.07178, 0.053468, 0.029511, 0.004028, 
-0.020631, -0.040834, -0.050752, -0.046754, -0.032228, -0.013184, 
0.003693, 0.014954, 0.017792, 0.017304, 0.019288, 0.023133, 0.025605, 
0.02765, 0.024812, 0.016633, 0.005676, -0.007355, -0.022736, 
-0.029633, -0.032472, -0.032929, -0.028932, -0.016297, -0.004242, 
0.012116, 0.03592, 0.044893, 0.0553, 0.056703, 0.053713, 0.045473, 
0.035127, 0.019166, 0.000183, -0.015473, -0.031373, -0.043336, 
-0.050691, -0.055757, -0.058657, -0.058321, -0.056856, -0.062227, 
-0.074343, -0.089969, -0.087069, -0.075442, -0.049501, -0.013459, 
0.020356, 0.050813, 0.071444, 0.084658, 0.090793, 0.094699, 0.090274, 
0.079867, 0.062654, 0.037294, 0.009644, -0.016236, -0.038209, 
-0.05298, -0.053285, -0.041475, -0.023011, -0.003632, 0.008209, 
0.012085, 0.012116, 0.013947, 0.018464, 0.024964, 0.031739, 0.032929, 
0.027528, 0.017151, 0.002594, -0.01294, -0.023041, -0.021424, 
-0.018586, -0.011048, -0.00354, 0.000763, 0.003723, 0.008301, 
0.014954, 0.020234, 0.027894, 0.032472, 0.030122, 0.023408, 0.010865, 
-0.004517, -0.01767, -0.027955, -0.037629, -0.044618, -0.054537, 
-0.07416, -0.098666, -0.12122, -0.117038, -0.098209, -0.063478, 
-0.021821, 0.013062, 0.040193, 0.057436, 0.07178, 0.083193, 0.09714, 
0.106418, 0.107212, 0.097354, 0.070864, 0.032441, -0.008423, 
-0.04062, -0.057741, -0.058565, -0.047975, -0.032746, -0.018555, 
-0.00824, -0.00174, 0.00412, 0.013825, 0.027985, 0.040986, 0.050447, 
0.051393, 0.044191, 0.032746, 0.02121, 0.008393, -0.002411, -0.01062, 
-0.019807, -0.02411, -0.024812, -0.027345, -0.027375, -0.025452, 
-0.021821, -0.015381, -0.00412, 0.00528, 0.009949, 0.011078, 
0.003265, -0.01474, -0.043672, -0.075533, -0.102359, -0.100925, 
-0.089175, -0.063478, -0.03412, -0.005036, 0.015687, 0.031129, 
0.051302, 0.068606, 0.087161, 0.099796, 0.09949, 0.081729, 0.05182, 
0.018769, -0.010712, -0.026795, -0.031709, -0.029817, -0.027009, 
-0.025361, -0.025788, -0.021332, -0.012268, 0.004028, 0.024171, 
0.041505, 0.054109, 0.057924, 0.054445, 0.044282, 0.034303, 0.023865, 
0.013916, 0.004822, -0.005371, -0.016999, -0.02649, -0.032289, 
-0.034272, -0.030671, -0.025941, -0.023621, -0.025452, -0.034669, 
-0.052889, -0.077548, -0.102237, -0.127079, -0.115146, -0.095035, 
-0.066195, -0.034516, -0.003845, 0.024079, 0.049379, 0.084536, 
0.111423, 0.134526, 0.140507, 0.129185, 0.098666, 0.060274, 0.022126, 
-0.010865, -0.029847, -0.042116, -0.050325, -0.055452, -0.05298, 
-0.045228, -0.030793, -0.00998, 0.010346, 0.027131, 0.040834, 
0.052126, 0.05942, 0.06354, 0.062532, 0.054811, 0.042634, 0.025758, 
0.00708, -0.00885, -0.019349, -0.023682, -0.024018, -0.023865, 
-0.025239, -0.028657, -0.032624, -0.043214, -0.061007, -0.082583, 
-0.106967, -0.139225, -0.132756, -0.11359, -0.093692, -0.068819, 
-0.04059, -0.00531, 0.030061, 0.080264, 0.11951, 0.146275, 0.149907, 
0.136448, 0.11127, 0.082125, 0.05472, 0.025147, -0.000458, -0.023927, 
-0.041902, -0.052004, -0.046113, -0.033448, -0.016572, -0.001587, 
0.011109, 0.020783, 0.031312, 0.043672, 0.050966, 0.053865, 0.049348, 
0.038301, 0.025208, 0.013977, 0.00531, -0.002258, -0.012116, 
-0.022156, -0.028108, -0.034791, -0.041688, -0.053621, -0.074007, 
-0.097293, -0.112705, -0.134922, -0.125858, -0.095401, -0.078097, 
-0.064058, -0.053438, -0.018677, 0.017487, 0.07242, 0.114872, 
0.1348, 0.130497, 0.11652, 0.107273, 0.093905, 0.08121, 0.053316, 
0.021332, -0.010315, -0.027253, -0.034852, -0.039338, -0.035554, 
-0.035829, -0.031434, -0.022095, -0.002503, 0.012513, 0.02472, 
0.030244, 0.033479, 0.039491, 0.047395, 0.055666, 0.051637, 0.039094, 
0.025086, 0.007996, -0.006348, -0.019623, -0.033326, -0.061373, 
-0.087283, -0.108707, -0.127476, -0.157964, -0.16306, -0.128056, 
-0.105808, -0.081759, -0.058535, -0.008759, 0.035585, 0.080721, 
0.11478, 0.13245, 0.136265, 0.138157, 0.141911, 0.124241, 0.094913, 
0.054628, 0.018311, -0.004395, -0.016694, -0.024689, -0.03647, 
-0.042543, -0.037721, -0.02295, -0.01178, -0.0047, -0.000824, 
0.004059, 0.014679, 0.025208, 0.027802, 0.023835, 0.020539, 0.01822, 
0.013947, 0.007996, -0.003021, -0.018769, -0.031312, -0.047334, 
-0.073519, -0.09714, -0.119114, -0.144047, -0.165349, -0.12653, 
-0.103458, -0.094485, -0.081362, -0.033387, 0.034852, 0.080966, 
0.116306, 0.130802, 0.14893, 0.155675, 0.167425, 0.150731, 0.117161, 
0.08124, 0.050783, 0.024842, -0.007141, -0.028596, -0.045595, 
-0.046663, -0.04648, -0.040956, -0.035585, -0.03238, -0.01944, 
-0.001984, 0.01532, 0.020997, 0.027741, 0.027223, 0.026276, 0.022431, 
0.016114, 0.004913, -0.010987, -0.027497, -0.049104, -0.074862, 
-0.089724, -0.117649, -0.143864, -0.167974, -0.128758, -0.117344, 
-0.121525, -0.101535, -0.052065, 0.017701, 0.054079, 0.086337, 
0.117801, 0.161412, 0.177435, 0.182073, 0.167669, 0.147252, 0.128666, 
0.106845, 0.072176, 0.03592, 0.007904, -0.016388, -0.035707, 
-0.053926, -0.058138, -0.052431, -0.046663, -0.042238, -0.035768, 
-0.026795, -0.013581, -0.00351, 0.00235, 0.005432, 0.006989, 
0.00235, -0.00763, -0.019684, -0.039583, -0.054628, -0.069979, 
-0.094638, -0.119541, -0.130131, -0.102603, -0.114139, -0.113651, 
-0.086489, -0.04358, -0.001953, 0.020325, 0.057192, 0.089602, 
0.129124, 0.135594, 0.147313, 0.143742, 0.140324, 0.133732, 0.113224, 
0.091281, 0.063021, 0.044527, 0.020875, 0.000519, -0.021729, 
-0.037477, -0.043428, -0.050142, -0.04651, -0.041749, -0.034547, 
-0.030457, -0.020966, -0.019166, -0.0141, -0.016053, -0.008606, 
-0.012116, -0.017762, -0.028596, -0.039766, -0.045137, -0.058016, 
-0.075045, -0.084353, -0.082888, -0.081088, -0.092349, -0.079287, 
-0.056551, -0.029908, -0.013947, 0.003754, 0.034761, 0.063143, 
0.077731, 0.086154, 0.09772, 0.100253, 0.104984, 0.105045, 0.098086, 
0.081881, 0.073458, 0.060091, 0.050356, 0.033509, 0.018921, 0.007324, 
-0.002533, -0.011567, -0.018891, -0.022645, -0.026215, -0.024415, 
-0.023804, -0.023743, -0.025697, -0.02414, -0.018097, -0.014771, 
-0.025819, -0.033723, -0.036164, -0.041353, -0.049593, -0.062624, 
-0.076052, -0.081942, -0.078188, -0.082675, -0.088046, -0.074801, 
-0.060915, -0.03766, -0.020722, 0.003388, 0.028871, 0.049806, 
0.062624, 0.080935, 0.095126, 0.100406, 0.10828, 0.106876, 0.105106, 
0.097507, 0.088931, 0.078799, 0.067202, 0.045991, 0.031129, 0.020783, 
0.002838, -0.013489, -0.022065, -0.028047, -0.034425, -0.040193, 
-0.039705, -0.040681, -0.039888, -0.035951, -0.029572, -0.026429, 
-0.031007, -0.029023, -0.028657, -0.02884, -0.033876, -0.041169, 
-0.060579, -0.065188, -0.066042, -0.069857, -0.092135, -0.083285, 
-0.067598, -0.050569, -0.040895, -0.022248, 0.011658, 0.038392, 
0.053163, 0.075106, 0.106082, 0.11008, 0.121158, 0.122227, 0.125126, 
0.114566, 0.101352, 0.086062, 0.070711, 0.045656, 0.025513, 0.010895, 
-0.013153, -0.031861, -0.036897, -0.04294, -0.051607, -0.05475, 
-0.050966, -0.042177, -0.038087, -0.036164, -0.026887, -0.022645, 
-0.016205, -0.011414, -0.006317, -0.011292, -0.013977, -0.023713, 
-0.023621, -0.04178, -0.051759, -0.073275, -0.068911, -0.069124, 
-0.101321, -0.074313, -0.071291, -0.039613, -0.02945, 0.00296, 
0.028016, 0.063417, 0.073183, 0.107181, 0.129002, 0.123295, 0.131352, 
0.125492, 0.118473, 0.096683, 0.080294, 0.058321, 0.042879, 0.008209, 
0.000549, -0.017914, -0.033631, -0.048006, -0.053713, -0.0524, 
-0.055391, -0.050356, -0.044801, -0.03061, -0.031159, -0.012085, 
-0.009796, 0.000153, -0.001923, 0.002045, 0.001221, -0.006684, 
-0.027131, -0.032716, -0.043825, -0.075259, -0.089053, -0.103946, 
-0.078433, -0.122959, -0.097446, -0.075472, -0.043641, -0.024567, 
0.005799, 0.052889, 0.086215, 0.10062, 0.127384, 0.159978, 0.14301, 
0.142827, 0.133457, 0.119938, 0.089084, 0.061831, 0.039399, 0.017914, 
-0.015503, -0.028108, -0.038301, -0.058535, -0.064119, -0.064119, 
-0.056001, -0.053896, -0.043031, -0.027863, -0.013459, -0.009552, 
0.006134, 0.016266, 0.019318, 0.016907, 0.013306, 0.006714, -0.009125, 
-0.037477, -0.04416, -0.069613, -0.110935, -0.130375, -0.112674, 
-0.110233, -0.152532, -0.099399, -0.072604, -0.020966, -0.011078, 
0.039552, 0.10361, 0.130802, 0.134007, 0.177313, 0.188726, 0.161534, 
0.154241, 0.130589, 0.112003, 0.062319, 0.027223, 0.007111, -0.022553, 
-0.05826, -0.06357, -0.069124, -0.085788, -0.080386, -0.069002, 
-0.050813, -0.046785, -0.025636, -0.004395, 0.013947, 0.015717, 
0.031556, 0.038545, 0.034486, 0.023316, 0.015137, 0.0065, -0.02646, 
-0.060488, -0.068758, -0.105441, -0.138493, -0.166204, -0.119572, 
-0.138035, -0.150761, -0.091617, -0.045503, 0.007721, 0.02649, 
0.094272, 0.15479, 0.172491, 0.166784, 0.213752, 0.198309, 0.164434, 
0.134007, 0.105502, 0.072695, 0.013367, -0.026704, -0.038911, 
-0.072054, -0.097568, -0.088839, -0.087313, -0.089267, -0.071108, 
-0.045778, -0.020844, -0.010468, 0.011017, 0.037385, 0.043825, 
0.044465, 0.051088, 0.046937, 0.030244, 0.010651, -0.005768, 
-0.019471, -0.06415, -0.092196, -0.109226, -0.135441, -0.174566, 
-0.186254, -0.117588, -0.143345, -0.131779, -0.065096, 0.006287, 
0.055788, 0.080752, 0.142766, 0.211676, 0.204627, 0.190466, 0.222419, 
0.18482, 0.132878, 0.087741, 0.048982, 0.010102, -0.052492, -0.090304, 
-0.081454, -0.109409, -0.113956, -0.089846, -0.06534, -0.055483, 
-0.022523, 0.005402, 0.0365, 0.046907, 0.055208, 0.076754, 0.067843, 
0.052919, 0.048219, 0.02826, 0.00589, -0.021302, -0.034242, -0.05533, 
-0.084811, -0.118046, -0.115574, -0.147465, -0.166478, -0.196844, 
-0.109714, -0.097415, -0.131657, -0.041963, 0.023072, 0.097781, 
0.102481, 0.14832, 0.214698, 0.230934, 0.167333, 0.191839, 0.163213, 
0.096683, 0.034883, -0.005554, -0.038423, -0.081759, -0.118839, 
-0.11298, -0.088137, -0.102512, -0.053377, -0.024873, 0.004944, 
0.026765, 0.055696, 0.078158, 0.081973, 0.071474, 0.072329, 0.063723, 
0.031312, 0.015534, -0.004486, -0.016083, -0.046388, -0.052675, 
-0.049379, -0.062532, -0.092654, -0.10123, -0.090396, -0.127171, 
-0.152226, -0.176183, -0.061831, -0.089846, -0.106052, -0.035463, 
0.057436, 0.107944, 0.094882, 0.132176, 0.212165, 0.209479, 0.125736, 
0.144627, 0.122929, 0.060152, -0.024262, -0.053407, -0.049318, 
-0.094089, -0.12186, -0.097018, -0.047151, -0.039735, -0.024049, 
0.020783, 0.06415, 0.063326, 0.059206, 0.07889, 0.071627, 0.059511, 
0.023804, 0.019593, 0.006592, -0.0159, -0.026948, -0.021302, 
-0.027772, -0.024964, -0.012513, -0.018128, -0.019776, -0.058718, 
-0.068545, -0.087649, -0.127567, -0.199438, -0.149876, -0.061495, 
-0.143437, -0.105075, -0.021821, 0.11536, 0.103122, 0.090548, 
0.168462, 0.270516, 0.173711, 0.09891, 0.130955, 0.094577, -0.004089, 
-0.104038, -0.086612, -0.069582, -0.120945, -0.149937, -0.046113, 
0.001373, -0.004486, 0.020081, 0.082766, 0.112613, 0.080874, 
0.059603, 0.074374, 0.063997, 0.007111, -0.010529, -0.017243, 
-0.012268, -0.032838, -0.023103, -0.01294, 0.010437, 0.016358, 
0.023591, 0.018952, 0.007965, -0.024934, -0.089236, -0.102054, 
-0.150822, -0.208289, -0.238289, -0.099033, -0.109073, -0.116855, 
-0.052614, 0.109256, 0.197211, 0.124821, 0.150151, 0.26017, 0.245369, 
0.08063, 0.053743, 0.039949, -0.010865, -0.143681, -0.178838, 
-0.106571, -0.081454, -0.128178, -0.064791, 0.049806, 0.075259, 
0.090274, 0.089694, 0.133671, 0.12476, 0.058626, 0.022156, 0.032685, 
-0.009613, -0.047609, -0.049471, -0.023072, 0.001404, -0.011719, 
0.017182, 0.04767, 0.069674, 0.0459, 0.030763, 0.006653, -0.01297, 
-0.08945, -0.14835, -0.18012, -0.204566, -0.265847, -0.224433, 
-0.041169, -0.069796, -0.043703, 0.052553, 0.23487, 0.240883, 
0.14951, 0.143468, 0.222602, 0.134129, -0.033204, -0.068484, 
-0.07944, -0.098636, -0.183081, -0.164342, -0.07062, 0.012146, 
0.00647, 0.059816, 0.135044, 0.165838, 0.147374, 0.093142, 0.061068, 
0.044221, 0.005066, -0.057314, -0.062349, -0.04883, -0.025727, 
-0.029389, -0.002991, 0.035768, 0.087161, 0.073641, 0.045076, 
0.051515, 0.06122, 0.026856, -0.045381, -0.079562, -0.075442, 
-0.107944, -0.186773, -0.187536, -0.174718, -0.212683, -0.12656, 
0.043977, -0.009491, 0.014344, 0.101627, 0.215735, 0.158574, 
0.076296, 0.037935, 0.08359, 0.031159, -0.078188, -0.106143, 
-0.075564, -0.03531, -0.046876, -0.029878, 0.014405, 0.120334, 
0.127262, 0.071444, 0.062197, 0.094668, 0.064516, -0.017212, 
-0.064669, -0.049715, 0.001709, -0.024812, -0.024873, 0.026429, 
0.075961, 0.073336, 0.059969, 0.036592, 0.047975, 0.043428, 0.014771, 
-0.016022, -0.027985, -0.021393, -0.011475, -0.025636, -0.064425, 
-0.079348, -0.10773, -0.124943, -0.168432, -0.239204, -0.198187, 
0.026826, -0.007233, -0.035127, 0.026826, 0.173284, 0.19068, 
0.122379, 0.010804, 0.042573, 0.082614, -0.008026, -0.077609, 
-0.09537, -0.039796, 0.009766, 0.021088, -0.009613, 0.06946, 
0.114963, 0.099033, 0.044954, 0.023499, 0.012879, 0.013184, -0.023774, 
-0.052889, -0.015168, 0.035829, 0.063265, 0.04709, 0.05002, 0.064302, 
0.073183, 0.023103, -0.007324, -0.024323, -0.025636, -0.017884, 
0.008576, -0.002686, -0.002167, 0.014588, 0.024751, 0.013276, 
-0.023469, -0.115696, -0.174902, -0.182592, -0.23133, -0.296274, 
-0.158177, 0.040529, 0.041108, 0.069094, 0.102023, 0.210242, 
0.224555, 0.139256, -0.022584, -0.008942, -0.019745, -0.027772, 
-0.088565, -0.105197, -0.056124, 0.056673, 0.079501, 0.071627, 
0.063265, 0.082522, 0.100314, 0.054323, -0.0271, -0.055422, -0.027314, 
-0.008972, 0.018036, 0.017243, 0.041658, 0.075747, 0.094699, 
0.055605, 0.036775, -0.001434, -0.013977, -0.00943, -0.02649, 
-0.053774, -0.009766, 0.024232, 0.043733, 0.04471, 0.001953, 
0.003388, -0.005219, -0.056948, -0.147008, -0.203375, -0.241768, 
-0.223579, -0.250801, -0.122868, 0.075655, 0.109989, 0.114414, 
0.137089, 0.186773, 0.181585, 0.114811, -0.043428, -0.067904, 
-0.070681, -0.04239, -0.051088, -0.048341, -0.040376, 0.053652, 
0.106815, 0.123539, 0.078768, 0.032502, 0.021302, 0.020203, -0.011017, 
-0.053377, -0.057619, -0.017609, 0.034242, 0.075442, 0.081759, 
0.07178, 0.070284, 0.055055, 0.02591, -0.00177, -0.035676, -0.052522, 
-0.041536, -0.02414, -0.001129, 0.01883, 0.028718, 0.042726, 
0.025941, -0.003265, -0.029664, -0.054964, -0.09241, -0.125309, 
-0.170019, -0.189154, -0.178167, -0.171239, -0.13123, 0.045106, 
0.113773, 0.124577, 0.112339, 0.116825, 0.117038, 0.119816, 0.030061, 
-0.046663, -0.079867, -0.077364, -0.032472, -0.007508, -0.028474, 
-0.000427, 0.05417, 0.07007, 0.096805, 0.068667, 0.016633, -0.003082, 
-0.005921, -0.009919, 0.012665, 0.020631, 0.019898, 0.035249, 
0.06119, 0.06885, 0.063601, 0.025758, 0.003998, -0.003662, -0.020783, 
-0.023682, -0.016083, -0.032777, -0.018555, 0.006439, 0.019105, 
0.013611, 0.005097, -0.016785, -0.032289, -0.029786, -0.050539, 
-0.052858, -0.059145, -0.059297, -0.076296, -0.085818, -0.116611, 
-0.113529, -0.124424, -0.055635, 0.026215, 0.05768, 0.059023, 
0.078005, 0.081912, 0.084048, 0.063143, 0.024049, 0.001221, -0.023621, 
-0.036073, -0.016846, 0.014008, 0.013245, 0.015198, 0.013184, 
0.03708, 0.067446, 0.074282, 0.038759, 0.018403, 0.014466, 0.041871, 
0.037965, 0.025605, 0.002716, 0.008545, 0.017884, 0.035066, 0.021668, 
0.013001, 0.002014, 0.002686, -0.002686, 0.000946, -0.008942, 
-0.012299, -0.022858, -0.02411, -0.00824, 0.000855, -0.016266, 
-0.038575, -0.046266, -0.04767, -0.041444, -0.071474, -0.119419, 
-0.150609, -0.149785, -0.148991, -0.06354, 0.026246, 0.070956, 
0.096683, 0.113498, 0.100833, 0.117924, 0.099185, 0.048982, -0.006806, 
-0.052065, -0.075655, -0.044527, -0.02298, -0.010712, 0.016663, 
0.029878, 0.051515, 0.080233, 0.084231, 0.058046, 0.032228, -0.012604, 
-0.016846, -0.005554, 0.00647, 0.013703, 0.02002, 0.030976, 0.043519, 
0.041353, 0.034425, 0.025636, 0.002869, -0.016572, -0.017762, 
-0.018342, -0.022248, -0.027711, -0.032014, -0.027497, -0.0047, 
0.0065, -0.005127, -0.02118, -0.039338, -0.047121, -0.044893, 
-0.055391, -0.078005, -0.100711, -0.122196, -0.123508, -0.119724, 
-0.035951, 0.040956, 0.089969, 0.096988, 0.088961, 0.068911, 
0.077853, 0.063112, 0.031526, -0.014191, -0.040651, -0.041749, 
-0.009217, 0.006684, 0.024689, 0.025391, 0.029267, 0.032991, 
0.050142, 0.046632, 0.041261, 0.021363, -0.000885, -0.006409, 
0.001709, 0.002258, 0.012879, 0.021912, 0.022095, 0.029145, 0.029328, 
0.018677, 0.010132, -0.004364, -0.022401, -0.022065, -0.025666, 
-0.026551, -0.014222, -0.010926, -0.007935, 0.007355, -0.008301, 
-0.021058, -0.022553, -0.034577, -0.041261, -0.034974, -0.048372, 
-0.068422, -0.093692, -0.121708, -0.132359, -0.114872, -0.032807, 
0.040498, 0.079836, 0.089419, 0.088382, 0.074923, 0.070833, 0.048585, 
0.022889, -0.002441, -0.017487, -0.030213, -0.023255, -0.007599, 
0.015015, 0.020356, 0.02649, 0.031404, 0.043825, 0.044832, 0.036256, 
0.017945, 0.001892, -0.006561, -0.003571, 0.002747, 0.011322, 
0.031129, 0.039583, 0.033662, 0.025056, 0.013184, -0.001099, 
-0.008576, -0.014863, -0.021149, -0.02002, -0.017151, -0.008332, 
-0.005219, -0.001038, 0.001556, -0.007569, -0.022034, -0.035096, 
-0.04181, -0.042177, -0.045869, -0.070711, -0.100742, -0.1171, 
-0.123356, -0.121708, -0.036531, 0.045747, 0.092257, 0.106326, 
0.097415, 0.068178, 0.064028, 0.041963, 0.020692, -0.009613, 
-0.038697, -0.048921, -0.021058, -0.004151, 0.028169, 0.0412, 
0.040559, 0.037446, 0.045991, 0.035676, 0.03589, 0.023316, 0.010071, 
-0.002991, -0.004822, -0.003265, 0.014374, 0.02176, 0.036287, 
0.038179, 0.024415, 0.011353, 0.008301, -0.0047, -0.009949, -0.012482, 
-0.017792, -0.015809, -0.007935, -0.004303, 0.012574, 0.004456, 
-0.015107, -0.032289, -0.044527, -0.052248, -0.048311, -0.057222, 
-0.078951, -0.104984, -0.119022, -0.135685, -0.09592, 0.010102, 
0.079012, 0.11655, 0.103793, 0.060671, 0.033815, 0.031617, 0.016511, 
0.009003, -0.014679, -0.035493, -0.019745, 0.008454, 0.031159, 
0.056093, 0.042512, 0.018555, 0.008362, 0.002228, 0.003754, 0.018464, 
0.007721, 0.003113, 0.013947, 0.030671, 0.037202, 0.046205, 0.031159, 
0.018097, 0.011322, 0.009369, -0.004791, -0.009308, -0.021332, 
-0.012635, -0.002197, 0.005921, 0.011963, 0.019593, 0.007477, 
0.002319, -0.006012, -0.007752, -0.028626, -0.037904, -0.053743, 
-0.049562, -0.04471, -0.039827, -0.052034, -0.077639, -0.108432, 
-0.105045, -0.110599, -0.051119, 0.066652, 0.105838, 0.10126, 
0.056276, 0.005188, -0.007752, 0.010834, -0.001587, 0.005402, 
-0.001373, 0.002686, 0.038514, 0.069735, 0.054781, 0.034364, 
-0.008545, -0.025697, -0.00708, 0.015137, 0.025056, 0.036103, 
0.023896, 0.030549, 0.049287, 0.039521, 0.020631, 0.00763, -0.008271, 
6.1e-05, 0.008881, 0.015503, 0.02002, 0.004822, -0.004852, 0.007172, 
0.014618, 0.009491, 0.003174, -0.011719, -0.012085, -0.011292, 
-0.014863, -0.026276, -0.039399, -0.041749, -0.025391, -0.00824, 
-0.003388, -0.00293, -0.01999, -0.064364, -0.104892, -0.119144, 
-0.118717, -0.096347, 0.01175, 0.08591, 0.099765, 0.071383, 0.022156, 
-0.008332, 0.006134, 0.00589, 0.012726, 0.017579, 0.011902, 0.034028, 
0.058901, 0.0412, 0.015656, -0.013367, -0.030824, 0.000641, 0.035371, 
0.046968, 0.050722, 0.037019, 0.02118, 0.032044, 0.020631, -0.001923, 
-0.015076, -0.022309, -0.008728, 0.020386, 0.028871, 0.035524, 
0.024354, -0.001129, -0.006684, -0.002167, -0.014924, -0.014039, 
-0.012909, -0.017273, -0.013855, -0.009033, -0.012879, -0.019959, 
-0.02707, -0.017273, 0.000732, 0.007416, -0.005127, -0.034394, 
-0.085025, -0.118046, -0.124516, -0.109867, -0.103641, -0.010498, 
0.07593, 0.104526, 0.088473, 0.038667, -0.007202, -0.005982, 
-0.006134, 0.002777, 0.021851, 0.018372, 0.031404, 0.053682, 
0.037538, 0.014679, -9.2e-05, -0.01352, 0.007019, 0.035432, 0.03592, 
0.037843, 0.030671, 0.013611, 0.015809, 0.019593, 0.00174, -0.014008, 
-0.018403, -0.005432, 0.02646, 0.041658, 0.033357, 0.015534, 
-0.007141, -0.017029, -0.008393, -0.010987, -0.007752, 0.000275, 
-0.001679, -0.003662, -0.006958, -0.022187, -0.027558, -0.019562, 
-0.005585, 0.032289, 0.028474, -0.000916, -0.02533, -0.039705, 
-0.040986, -0.031617, -0.052492, -0.089541, -0.105258, -0.093204, 
-0.073122, -0.04239, 0.030213, 0.070742, 0.06885, 0.037049, 0.013367, 
0.011017, 0.022797, 0.020966, 0.02533, 0.019501, 0.015168, 0.030152, 
0.03946, 0.027772, 0.011841, -0.009552, -0.0065, 0.024415, 0.046419, 
0.045381, 0.025788, -0.001862, -0.011017, -0.006592, 0.00354, 
0.014801, 0.021149, 0.021302, 0.024537, 0.020447, 0.007263, -0.010743, 
-0.022828, -0.023957, -0.012055, -0.001862, 0.004395, 0.002655, 
-0.000855, -0.003601, -0.003845, -0.004334, -0.002136, 0.003601, 
-0.001312, -0.009369, -0.01825, -0.021668, -0.019959, -0.02179, 
-0.032289, -0.050844, -0.080294, -0.094089, -0.084475, -0.083224, 
-0.071596, 0.014649, 0.074496, 0.089541, 0.064791, 0.016572, 
-0.011322, 0.00647, 0.015137, 0.023652, 0.027436, 0.023225, 0.028932, 
0.036561, 0.022431, 0.009064, -0.00528, -0.010224, 0.008911, 
0.02942, 0.034486, 0.032014, 0.012543, 0.000916, 0.00763, 0.014527, 
0.013306, 0.011628, 0.004059, 0.005097, 0.012207, 0.008881, 0.000855, 
-0.008087, -0.020905, -0.020447, -0.006745, -0.000671, 0.004364, 
0.01178, 0.015564, 0.008332, -0.006989, -0.0271, -0.029145, -0.017701, 
0.005493, 0.018891, 0.006043, -0.013337, -0.020325, -0.018281, 
-0.020142, -0.018403, -0.026521, -0.038453, -0.057619, -0.073489, 
-0.075045, -0.068331, -0.080935, -0.032228, 0.041932, 0.074923, 
0.067232, 0.038942, 0.003327, 0.003723, 0.018311, 0.02121, 0.023988, 
0.023103, 0.021363, 0.034272, 0.031465, 0.018403, 0.011048, 0.00589, 
0.012268, 0.031068, 0.02826, 0.016633, 0.005829, -0.006043, -0.003235, 
0.010376, 0.012085, 0.012177, 0.008881, -0.002106, 0.000732, 
0.007782, 0.005615, 0.000244, -0.009522, -0.015564, -0.006806, 
-0.002441, 0.001068, 0.007172, 0.002655, -0.006134, -0.004883, 
-0.011536, -0.012116, 0.006714, 0.005219, -0.005554, -0.012299, 
-0.022858, -0.023316, -0.022309, -0.032075, -0.050325, -0.073489, 
-0.095248, -0.08533, -0.080905, -0.03943, 0.043397, 0.076724, 
0.062105, 0.029328, -0.00824, -0.013276, 0.0159, 0.02298, 0.028809, 
0.034059, 0.0318, 0.036073, 0.035432, 0.007324, -0.008026, -0.013276, 
-0.005463, 0.021882, 0.040864, 0.033174, 0.027314, 0.009949, 
-0.004761, -0.000671, 0.001556, -0.002258, 0.005097, 0.004578, 
0.005585, 0.008484, -0.001404, -0.015015, -0.017182, -0.018372, 
-0.007416, 0.007721, 0.010834, 0.010956, 0.007996, -0.004944, 
-0.012665, -0.018159, -0.022645, -0.018128, -0.007965, -0.004059, 
0.007202, 0.012024, 0.003693, -0.006073, -0.010163, -0.014191, 
-0.014496, -0.016205, -0.022767, -0.029145, -0.043733, -0.059938, 
-0.068331, -0.071139, -0.081423, -0.070315, -0.00763, 0.052767, 
0.077029, 0.056856, 0.025269, 0.011048, 0.015351, 0.019257, 0.021302, 
0.014771, 0.010468, 0.025178, 0.04294, 0.046083, 0.034608, 0.014985, 
0.000946, 0.006317, 0.013886, 0.01648, 0.012635, 0.010193, 0.009827, 
0.010956, 0.005036, -0.006928, -0.015046, -0.00998, 0.002655, 
0.01529, 0.019227, 0.013092, -0.000519, -0.010681, -0.017243, 
-0.016297, -0.011902, -0.000793, 0.006989, 0.009766, 0.001709, 
-0.010254, -0.013977, 0.001709, 0.012574, 0.002289, -0.01178, 
-0.01352, -0.00705, 0.001312, -0.005707, -0.030335, -0.059847, 
-0.079165, -0.075655, -0.056948, -0.061495, -0.036012, 0.027284, 
0.059572, 0.056185, 0.029786, 0.001343, -0.001038, 0.019379, 
0.023591, 0.030641, 0.029603, 0.027528, 0.033601, 0.036134, 0.016388, 
0.003571, -0.007721, -0.003449, 0.017457, 0.033418, 0.027802, 
0.022187, 0.008423, -9.2e-05, 0.001007, -0.005036, -0.014557, 
-0.008972, 0.000732, 0.010681, 0.016877, 0.008911, -0.001587, 
-0.004181, -0.000824, 0.006165, 0.002411, -0.010498, -0.017609, 
-0.010895, -0.007294, -0.007202, -0.017579, -0.025758, -0.020661, 
-0.003235, 0.00647, 0.00586, 0.000885, 0.006867, 0.033265, 0.025697, 
0.003998, -0.012421, -0.008545, -0.003693, 0.001343, -0.01706, 
-0.032655, -0.044588, -0.052217, -0.057436, -0.062471, -0.076052, 
-0.063448, -0.002838, 0.042451, 0.054598, 0.042665, 0.016877, 
0.008301, 0.018036, 0.018738, 0.015381, 0.016053, 0.017884, 0.037294, 
0.049715, 0.037416, 0.015534, -0.000397, -0.002899, 0.013367, 
0.021485, 0.014344, 0.008759, 0.005493, 0.006439, 0.010804, 0.003723, 
-0.006928, -6.1e-05, 0.010285, 0.013215, 0.010804, -0.004669, 
-0.020875, -0.024537, -0.022523, -0.017823, -0.00998, -0.009766, 
-0.006317, 0.004944, 0.009003, 0.003296, -0.002869, -0.004791, 
0.008148, 0.018403, 0.011994, 0.007416, 0.003357, 6.1e-05, -0.000458, 
-0.012055, -0.022675, -0.022065, -0.021119, -0.027558, -0.038362, 
-0.051485, -0.054842, -0.053896, -0.045747, -0.011628, 0.018311, 
0.028443, 0.031892, 0.0318, 0.024049, 0.024537, 0.024171, 0.01941, 
0.015839, 0.016633, 0.018616, 0.022828, 0.019623, 0.014313, 0.014954, 
0.018891, 0.025239, 0.02646, 0.014557, 0.000458, -0.006043, -0.003265, 
0.00589, 0.006378, -0.000885, -0.000397, 0.006836, 0.0112, 0.006806, 
-0.005371, -0.015137, -0.019044, -0.019684, -0.020051, -0.017792, 
-0.017335, -0.01764, -0.014496, -0.007508, 0.000183, 0.009003, 
0.017823, 0.023255, 0.017945, 0.01297, 0.008698, 0.007965, 0.005707, 
0.003449, -0.001129, -0.001953, -0.003845, -0.008484, -0.02179, 
-0.037172, -0.045351, -0.046724, -0.042451, -0.043153, -0.031434, 
-0.008362, 0.006409, 0.01001, 0.014344, 0.012879, 0.018006, 0.025971, 
0.022584, 0.020203, 0.01764, 0.020051, 0.023041, 0.01999, 0.009735, 
0.014679, 0.01941, 0.023194, 0.022309, 0.021119, 0.016602, 0.019684, 
0.014618, 0.007172, 0.004975, 0.004791, 0.005402, 0.009095, 0.001923, 
-0.009461, -0.017548, -0.020356, -0.019288, -0.016358, -0.020814, 
-0.02533, -0.024812, -0.014618, 0.009552, 0.006165, -0.012635, 
-0.015534, -0.002716, -0.009613, -0.022889, -0.056398, -0.068758, 
-0.055422, -0.044832, -0.033326, 0.017609, 0.035859, 0.033967, 
0.024506, 0.018342, 0.015717, 0.022248, 0.006989, 0.005402, 0.014527, 
0.017762, 0.02298, 0.018067, 0.00351, 0.002228, 0.010041, 0.008148, 
0.014954, 0.017548, 0.012085, 0.01236, 0.008942, -0.005402, -0.004425, 
-0.002228, 0.003601, 0.009125, 0.007721, 0.002167, 0.008271, 
0.003784, -0.003845, -0.007202, -0.010804, -0.01352, -0.007172, 
-0.012909, -0.013855, -0.005676, -0.003571, -0.005036, -0.003937, 
-0.015107, -0.014924, -0.009278, -0.010895, -0.008698, -0.004089, 
-0.007752, -0.005615, -0.002441, -0.001129, 0.005066, 0.007721, 
0.005768, 0.01175, 0.010468, 0.008209, 0.013703, 0.006775, 0.001129, 
0.003632, 0.002014, 0.002136, 0.01117, 0.003265, 0.000824, 0.001892, 
-0.003296, -0.010132, -0.007599, -0.008179, -0.000671, 0.002472, 
-0.003784, -0.001038, 0.023103, 0.011811, -0.000946, -0.006867, 
-0.004181, -0.006439, -0.008667, -0.029237, -0.034486, -0.032838, 
-0.046449, -0.05652, -0.055574, -0.06357, -0.070132, -0.030244, 
-0.001221, 0.019532, 0.022706, 0.02118, 0.015015, 0.023469, 0.012482, 
0.012879, 0.014985, 0.020722, 0.034974, 0.046266, 0.033509, 0.028169, 
0.02646, 0.022034, 0.030061, 0.028047, 0.019776, 0.022584, 0.026093, 
0.013581, 0.013459, 0.006348, -0.000641, 0.007782, 0.007111, 
0.00351, 0.006073, -0.000549, -0.003449, -0.008271, -0.01706, 
-0.013886, -0.005005, -0.012391, -0.015137, -0.011475, -0.011048, 
-0.005127, -0.010224, -0.015748, -0.014313, -0.01474, -0.014557, 
-0.0094, -0.009003, -0.003693, 0.005737, 0.003967, 0.000397, 
0.000946, -0.00589, -0.003784, 0.003174, -0.00238, -0.008606, 
-0.000702, 0.002625, 0.002716, -0.004791, -0.007691, -0.00293, 
0.007385, 0.004639, -0.004303, -0.002716, 0.004913, 0.002777, 
-0.001282, -0.004334, -0.012421, -0.002014, 0.003754, -0.00763, 
-0.004761, 0.003784, 0.013611, 0.007019, -0.002503, -0.002014, 
0.009857, 0.002472, -9.2e-05, -0.003143, 0.00586, 0.012177, 0.01352, 
0.000549, -0.005615, 0.003906, 0.009857, 0.000244, -0.01413, 
-0.016694, -0.014252, -0.011231, -0.021546, -0.031343, -0.024232, 
-0.01529, -0.008118, -0.015015, -0.018921, -0.016236, 0.00058, 
-0.00531, -0.003265, -0.016755, -0.003143, -0.001129, 0.013276, 
-0.012482, 0.002045, 0.01648, 0.030549, 0.019166, 0.014161, 0.019288, 
0.029817, 0.03824, 0.023499, 0.022523, 0.015168, 0.027284, 0.024201, 
0.018799, 0.004028, 0.013794, 0.012574, 0.013703, 0.000214, -0.010285, 
-0.012665, -0.011872, -0.024842, -0.035035, -0.030854, -0.033326, 
-0.040437, -0.04181, -0.032533, -0.030457, -0.032258, -0.037751, 
-0.030946, -0.012909, -0.006684, -0.002441, 0.005554, 0.021119, 
0.02353, 0.019227, 0.007935, 0.021821, 0.028596, 0.02823, 0.019868, 
0.026582, 0.025391, 0.024567, 0.020051, 0.01355, 0.015717, 0.02298, 
0.024537, 0.015381, 0.023621, 0.011109, 0.0112, 0.005219, 0.00708, 
0.005768, 0.006897, -0.002838, -0.000397, 0.006867, -0.004608, 
-0.004852, -0.009186, -0.009156, -0.005554, 0.001434, -0.009919, 
-0.016663, -0.008942, -0.007691, -0.005951, -0.01236, -0.015107, 
-0.012726, -0.013062, -0.016511, -0.016266, -0.019288, -0.017579, 
-0.018281, -0.016846, -0.011017, -0.011017, -0.009247, -0.012787, 
-0.007355, -0.007263, 0.004944, 0.006836, 0.003174, 0.012574, 
0.013703, 0.008423, 0.011994, 0.025422, 0.024751, 0.030091, 0.020417, 
0.020661, 0.017151, 0.013153, 0.006592, 0.007355, 0.007355, 0.012207, 
0.016785, 0.013153, 0.009949, 0.001312, -0.001373, -0.007996, 
-0.011567, -0.018647, -0.01297, -0.008911, -0.010956, -0.014985, 
-0.027192, -0.022919, -0.021393, -0.025208, -0.023835, -0.025666, 
-0.020875, -0.016541, -0.015595, -0.015961, -0.006806, -0.001495, 
0.001648, 0.007508, 0.012238, 0.01706, 0.019044, 0.020173, 0.020661, 
0.024598, 0.02356, 0.025086, 0.023988, 0.017029, 0.022401, 0.02353, 
0.019593, 0.016236, 0.02002, 0.013092, 0.00885, 0.005951, 0.000793, 
0.003082, 0.002838, -0.00647, -0.013001, -0.008179, -0.0094, 
-0.014008, -0.013459, -0.017792, -0.015442, -0.012665, -0.014435, 
-0.020631, -0.021271, -0.013886, -0.00351, -0.006409, -0.015595, 
-0.007447, -0.001617, 0.003113, -0.003784, -0.002167, 0.009552, 
0.013428, -0.001129, 0.002838, 0.012391, 0.00531, 0.002716, 0.011048, 
0.009857, 0.0141, 0.006897, 0.005127, 0.007233, 0.010681, 0.006592, 
0.007691, 0.009888, 0.010132, 0.010865, 0.004303, 0.000244, 0.002319, 
0.000519, -0.005829, -0.011322, -0.009278, -0.005341, -0.009766, 
-0.012513, -0.008789, -0.004944, -0.006012, -0.006378, -0.005829, 
0.000122, -0.003906, -0.009613, -0.010193, -0.002167, -0.004089, 
-0.008515, -0.000122, 0.001801, 0.001007, 0.004547, 0.005554, 
0.003662, 0.007843, 0.013153, -0.002747, 0.000427, 0.005127, 
0.008545, -0.003235, 0.000488, 0.003052, 0.009644, -9.2e-05, 
-0.002564, 0.00177, 0.004608, 0.003601, -0.003082, -0.001465, 
0.003784, 0.007141, -0.002899, -0.010834, -0.009186, -0.005371, 
-0.007202, -0.00882, -0.008972, -0.008179, -0.004975, -0.001984, 
-0.003052, -0.005036, -0.003693, -0.000214, 0.000122, -0.003052, 
-0.001923, 0.00235, 0.001862, 0.00528, 0.004456, 0.004273, 0.003693, 
0.006561, 0.007141, 0.004212, 0.001892, 0.003662, 0.002594, 3.1e-05, 
0.000855, -0.003723, -0.002899, 0.001526, 0.002411, -0.00058, 
9.2e-05, 0.001373, -0.001434, -0.004669, -0.003967, -0.005371, 
-0.005493, -0.008942, -0.013703, -0.000702, -0.001068, -0.007813, 
-0.0141, 0.001465, 0.005676, -0.000916, -0.002014, 0.002014, 
0.00119, 0.000885, -0.001648, -0.001984, -0.001984, -0.001343, 
0.005158, 0.00473, 0.005066, 0.001984, 0.002899, 0.005158, 0.003571, 
0.009674, 0.006867, -0.000275, 0.003479, 0.00766, 0.005371, 0.002411, 
0.002899, 0.006561, 0.005676, -0.000122, -0.001923, 0.001251, 
-0.001434, -0.003235, -0.005493, -0.001923, 0.002533, -0.004547, 
-0.009308, -0.008148, 0.000885, -0.007874, -0.011933, -0.008637, 
-0.002655, -0.004578, -0.008698, -0.004975, 0.003174, -0.000183, 
-0.001129, 0.005737, 0.005097, -0.000214, -0.000519, 0.009735, 
0.000793, -0.003357, 0.002655, 0.007538, 0.002167, 0.002808, 
0.008454, 0.008271, 0.008087, 0.004089, 0.005921, 0.002441, 0.005188, 
0.002747, -0.002808, -0.003143, -0.001465, -0.008209, -0.00354, 
-0.003265, -0.007843, -0.00943, -0.005249, -0.003449, -0.004517, 
-0.009888, -0.004273, -0.002045, -0.006134, -0.005829, -0.00061, 
3.1e-05, -0.005127, -0.005371, 0.002564, 0.002075, -0.005799, 
-0.004517, -0.001801, 0.009461, 0.001709, -0.007691, 0, 0.012909, 
0.00705, -0.001617, -0.001953, 0.011322, 0.006989, -0.005463, 
-0.004547, 0.007569, 0.004425, -0.00589, -0.000946, 0.003845, 
0.003815, 0.002533, -0.002594, 0.000549, 0.000702, -0.001953, 
-0.005341, -0.001648, -0.008301, -0.005371, -0.001556, 0.000549, 
-0.007477, -0.0094, -0.004669, 0.009125, -0.005341, -0.011963, 
0.002014, 0.00528, -0.009949, -0.007904, 0.001129, 0.002197, 
-0.010559, -0.002228, 0.00238, 0.002045, 0.002564, 0.003967, 
-0.000122, 0.003571, 0.007569, 0.00647, 0.000702, 0.003693, 0.003113, 
0.007965, 0, 0.000366, 0.005341, 0.005707, 0.004212, 0.00174, 
0.006073, 0.000458, 0.001556, 0.004578, 0.002594, -0.005676, 
0.00293, 0.003052, -0.00412, -0.002228, 0.00058, 0.000855, -0.007141, 
-0.001495, 0.00589, -0.001831, -0.010315, -0.001099, 0.007508, 
0.001099, -0.007813, 0.005737, 0.005829, -0.001587, 0, 0.00647, 
0.008118, -0.000946, 0.000702, 0.007477, 0.001953, 0.004456, 
0.001373, -0.002045, 0.004303, 0.007263, 0.00293, -0.001831, 
0.01001, 0.000366, -0.000732, 0.003052, 0.001129, 0.001953, -0.001129, 
-0.001434, 0.006561, 0.004395, -0.004364, 0.00586, 0.003998, 
0.005036, -0.0047, -0.002655, 0.005829, -0.001892, -0.007599, 
0.002716, 0.004089, -0.011475, -0.004975, 0.000427, 0.00235, 
-0.005066, 0.001953, 0.008332, 0.013642, -0.008881, 0.000336, 
0.0065, 0.005707, -0.010224, -0.016968, 0.010315, 0.004791, -0.011719, 
-0.021363, 0.011353, 0.00824, -0.001679, -0.009491, 0.006134, 
0.016968, -0.001495, -0.003662, -0.002197, 0.008179, -0.003906, 
-0.010712, -0.010498, 0.007538, -0.004608, -0.000244, -0.0112, 
0.00589, 0.012116, 0.000702, -0.009766, 0.000183, 0.017914, -0.003723, 
-0.004364, -0.00531, 0.004547, -0.007111, -0.001648, -0.008484, 
0.002136, -0.000336, 0.00235, -0.013062, 0.005188, 0.006165, 
-0.000366, -0.005463, -0.001709, 0.008545, -0.003174, -0.00412, 
-0.003693, 0.000641, -0.005707, -0.004028, -0.009369, -0.010193, 
-0.001221, 0.002441, -0.007324, -0.004242, 0.006348, 0.006256, 
-0.007019, -0.006806, 0.006104, 0.009064, -0.010071, -0.0112, 
0.006836, 0.005066, -0.003357, -0.010498, -0.006134, 0.006104, 
-0.004028, -0.004242, -0.00061, 0.002197, -0.00058, -0.00473, 
0.005615, 0.001495, 0.00177, -0.008698, 0.010132, 0.002777, -0.002319, 
-0.000305, -0.003876, 0.005921, -0.006073, -0.006195, -0.001587, 
0.009522, -0.00708, -0.000153, -0.00998, 0.010132, 0.007752, 
-0.003357, -0.014039, 0.012848, 0.007324, -0.002319, -0.011475, 
-0.005127, 0.008637, -0.00293, -0.015656, 0.000458, 0.007965, 
-0.005463, 0.000336, 0.003601, -0.000336, -0.001465, 0.004273, 
-0.007599, -0.002503, 0.003449, 0.002777, -0.000244, -0.003082, 
0.005219, 0.011689, 0.00647, -0.009796, 0.010163, 0.009705, -0.000916, 
-0.005585, -0.00296, 0.005371, 0.00351, -0.002747, 0.002045, 
0.009003, -0.000885, 0.003449, 0.0065, -0.001831, 0.003388, -0.00998, 
-0.00116, 0.008179, -0.002319, -0.007965, 0.005463, 0.011383, 
-0.005005, -0.010865, 0.003693, 0.014649, 0.003723, -0.017823, 
0.004883, 0.022889, -0.008881, -0.005432, -0.0065, 0.01474, 0.000183, 
-0.015656, 0.003021, 0.024079, -0.00473, -0.013062, 0.003235, 
0.012085, 0.008789, -0.017518, -0.008545, 0.02295, 0.009278, 
-0.017884, 0.007385, 0.011444, 0.012513, -0.008362, -0.002808, 
0.013703, 0.001984, 0.001709, -0.011872, 0.000916, 0.013123, 
-0.003967, -0.012818, 0.002441, 0.006928, 0.007477, -0.007233, 
-0.000397, 0.005158, 0.000366, 0.006226, -0.00351, -0.001434, 
0.00058, -0.001434, -0.005524, 0.004975, -0.010041, 0.000183, 
-0.002441, 0.002106, 0.00763, -0.000855, -0.000946, -0.004822, 
0.012299, -0.001282, -0.008484, -0.003479, 0.012085, -0.008393, 
0.00235, 0.00589, -0.012513, 0.003327, 0.013337, -0.011322, 0.00238, 
0.007477, -0.003143, -0.009217, 0.004791, 0.00531, 0.002045, 
-0.009003, -6.1e-05, 0.008057, 0.003235, -0.002289, 0.002991, 
0.000824, -0.003357, 0.005676, -0.003143, -0.004517, -0.005371, 
0.002258, -0.011017, -0.003235, 0.001617, -0.00119, -0.004334, 
-0.00119, 0.008057, 0.007019, -0.017701, -0.005615, 0.013611, 
-0.013245, -0.011597, -0.00589, -0.000183, -0.000153, -0.002319, 
-0.005463, 0.001373, 0.015656, -0.004913, 0.001434, -0.003082, 
0.001434, 0.001953, -0.016968, 0.003723, 0.009339, -0.009125, 
-0.004303, 0.01883, -0.005615, -0.021241, 0.013977, 0.010407, 
-0.014466, -0.001892, 0.004303, 0.008728, -0.006928, -0.009339, 
0.012299, 0.001953, -0.011292, 0.005707, 0.003449, -0.010804, 
0.012818, 0.00412, -0.010956, -0.000946, 0.00119, 0.006836, -0.006653, 
-0.000519, 0.008667, -0.012391, -0.007752, 0.015137, -0.005249, 
-0.018494, -0.000732, 0.011872, -0.000153, -0.006561, 0.001984, 
-0.003571, 0.006897, -0.001984, 0.003815, -0.009156, -0.003418, 
0.013245, -0.005982, -0.01352, 0.002625, 0.004395, -0.006775, 
-0.009095, 0.002197, 0.007233, -0.007416, -0.009278, 0.010956, 
0.003021, -0.012085, 0.007569, 0.013184, -0.008972, -0.013764, 
0.012696, 0.016022, -0.014557, -0.00586, 0.004425, -6.1e-05, 
0.010193, -0.006928, -0.003967, -0.000183, 0.00119, 0.007416, 
-0.015961, 0.00589, 0.006104, -0.009674, -0.008057, 0.014008, 
-0.002503, -0.001129, -0.014863, 0.020753, 0.00885, -0.005371, 
-0.014008, 0.003052, 0.012299, -0.001221, -0.020478, -0.007508, 
0.02176, -0.001129, -0.015961, 0.00061, 0.018799, -0.009735, 
-0.006775, 0.007111, -0.000732, 0.00061, -0.012757, 0.00708, 
0.004425, -0.011994, -0.010254, 0.009125, 0.00763, -0.011322, 
-0.005188, 0.004639, 0.013092, 0.004425, -0.012207, -0.006348, 
0.015076, 0.001923, -0.015259, -0.003784, 0.007874, -0.004517, 
-0.009888, -0.004517, 0.017487, 0.007385, -0.009796, -0.005737, 
0.012696, 0.004578, -0.009522, -0.015503, 0.002869, 0.013855, 
-0.004059, -0.023804, 0.00998, 0.027039, -0.017426, -0.005707, 
0.007874, 0.011444, -0.006806, 0.000214, 0.002136, -0.002747, 
-0.003845, -0.007263, 0.004456, -0.005921, -0.002167, 0.018433, 
-0.023164, 0.005493, 0.014771, -0.012818, -0.013215, 0.016511, 
0.005249, -0.010498, -0.00531, 0.008026, 0.007294, -0.018036, 
-0.005768, 0.018159, -0.007385, -0.020356, 0.000488, 0.015015, 
-0.005371, -0.005463, -0.004212, 0.006897, 0.00647, -0.023591, 
0.00998, 0.015046, -0.004944, -0.018311, 0.010865, 0.013215, 
-0.01294, -0.011261, -0.001556, 0.017823, -0.008148, -0.004212, 
0.003418, 0.008209, -0.007324, 0.000183, 0.016633, -0.005402, 
-0.00531, 0.006409, 0.000519, -0.000214, -0.003937, -0.001251, 
-0.003479, -3.1e-05, 0.005615, 0.005127, -0.003906, -0.003143, 
0.014588, 0.002258, -0.008881, 0.000946, 0.012116, -0.010743, 
-0.013947, 0.009278, 0.003876, -0.010224, -0.00238, 0.002991, 
0.006714, 0.000122, 0.008576, -0.009156, -0.005005, 0.006348, 
0.000488, -0.011719, 0.009949, -0.003449, -0.008026, 0.018006, 
-0.003021, -0.002869, 0.001587, 0.004852, -0.000519, 0.007111, 
-0.006897, -0.001099, 0.006317, -0.005737, -0.011597, 0.019715, 
0.006867, -0.011994, 0.001953, 0.008911, 0.002716, 0.001282, 
-0.004028, -0.007141, 0.016694, 0.002655, -0.011444, 0.005036, 
0.019776, -0.00412, -0.004151, -0.000793, 0.008576, 0.002289, 
-0.016999, 0.002441, 0.010163, -0.020325, 0.003998, 0.009491, 
-0.012452, 0.009583, -0.000763, 0.005066, 0.009369, -0.000763, 
-0.007843, -0.004456, 0.003906, 0.008515, -0.005066, -0.02768, 
0.011414, 0.010834, -0.00412, -0.009613, 0.010804, -0.000732, 
-0.011261, 0.013276, -0.002258, 0.001862, -0.01294, -3.1e-05, 
0.004852, -0.000641, -0.003937, 0.005737, -0.014008, -0.00473, 
0.011597, 0.006592, -0.012177, 0.001221, -0.011994, 0.01059, 
0.011963, -0.012696, -0.004761, 0.00885, 0.001679, 0.005402, 
-0.009033, 0.003876, -0.012726, 0.029389, -0.013337, -0.012116, 
0.003296, 0.020173, -0.002289, -0.02826, 0.022462, 3.1e-05, -0.002106, 
-0.015473, 0.008118, 0.004181, -0.00824, 0.012604, -0.014313, 
0.015412, 0.001495, -0.006745, -0.006409, 0.017182, -0.005829, 
-0.019715, 0.008728, 0.018097, -0.01883, -0.019593, 0.01648, 
0.008576, -0.0141, -0.002533, 0.004852, 0.016633, -0.007385, 
-0.020844, 0.016114, 0.003235, -0.004456, -0.003327, -0.008271, 
0.006409, 0.008484, -0.010132, -0.005707, 0.015595, 0.01352, 
-0.006165, -0.013153, 0.006226, 0.025971, -0.009186, -0.020997, 
-0.009705, 0.032167, -0.007935, -0.023011, -0.000946, 0.024384, 
0.004456, -0.018067, -0.004242, 0.017518, 0.006806, -0.014313, 
-0.006134, 0.015168, -3.1e-05, -0.006684, 0.004578, 0, 0.002869, 
0.008271, -0.016236, 0.006928, 0.003449, 0.000427, -0.004089, 
0.008484, -0.014344, 0.008576, 0.003388, -0.004303, 0.014801, 
-0.003235, -0.013153, 0.011628, 0.005737, -0.008667, 0.001129, 
-0.007263, 0.010102, 0.014801, -0.010376, -0.003296, 0.016938, 
-0.011414, 0.018769, -0.002991, 0.002655, -0.001831, 0.013398, 
-0.017212, 0.009583, 0.003662, -0.013672, 0.003967, 0.007935, 
-0.004975, -0.003113, 0.000458, 0.003662, -0.002014, 0.006043, 
-0.0047, 0.009003, -0.004181, 0.006989, 0.003052, -0.010376, 
0.009156, 0.007904, -0.001038, -0.01059, 0.010865, 9.2e-05, -0.015198, 
0.009125, 0.004242, -0.008667, -0.004151, 0.014313, -9.2e-05, 
-0.001129, -0.003967, 0.008301, 0.003265, -0.006989, 0.010163, 
0.009766, -0.016968, 0.004089, 0.016297, -0.010193, -0.009857, 
0.015107, -0.008393, -0.003876, 0.001556, 0.007935, -0.000824, 
-0.003449, -0.000916, -0.003998, 3.1e-05, 0.010773, -0.008332, 
-0.008271, 0.010498, 0.010804, -0.006684, -0.003601, -0.005524, 
0.006287, 0.000366, -0.011444, 0.004852, -0.00586, 0.006836, 
-0.004028, -0.013031, 0.013031, 0.000458, 0.00119, -0.013215, 
0.012207, 0.014985, -0.014496, -0.014191, 0.014954, 0.006928, 
-0.024567, 0.010529, 0.006226, -0.000702, -0.005493, -0.003967, 
0.005066, -0.011841, -0.003571, -0.000549, -0.012207, 0.001099, 
0.005554, -0.001007, -0.00589, 0.00174, 0.009857, 0.002777, -0.012909, 
0.008301, -0.001465, -0.008423, -0.008911, 0.005005, -0.004639, 
-0.013367, -0.006409, 0.008454, 0.008545, -0.005707, -0.010224, 
0.006348, 0.010743, -0.014283, -0.000671, -0.005036, 0.007111, 
-0.008789, -0.003601, -0.000763, 0.000244, 0.000671, -0.013306, 
0.009644, -0.003204, -0.004242, -0.001434, -0.002319, 0.001465, 
-0.001068, -0.004822, 0.004059, 0.005951, -0.007172, 0.007294, 
-0.000336, -0.009278, 0.013367, -0.001251, -0.011963, 0.006531, 
0.013153, -0.013947, -0.003296, 0.004273, -9.2e-05, 0.009491, 
-0.008393, -0.005097, 0.002289, 0.002014, -0.000855, 0.000275, 
0.016541, 0.008209, 0.004791, 0.009583, 0.019593, 0.011109, -0.001862, 
0.004578, 0.005982, -0.005585, -0.021241, -0.000946, -0.018616, 
-0.019013, -0.014191, -0.011353, -0.019807, -0.013855, -0.006226, 
-0.010193, -0.013581, -0.00531, 0.007904, -0.002899, -0.004913, 
0.006287, 0.01587, 0.011444, 0.007874, 0.004883, 0.014954, 0.012787, 
0.014496, -0.001221, -0.005554, 0.010102, 0.003906, -0.004547, 
-0.004425, -0.000183, -0.00647, 0.000366, -0.009522, -0.004578, 
-0.007233, -0.008423, 3.1e-05, -0.001068, -0.010743, -0.005799, 
0.013581, 0.003632, -0.002808, 0.007813, 0.015442, 0.012909, 
0.003815, 0.000305, 0.003662, 0.010895, -0.001007, -0.003388, 
0.001679, -0.006592, -0.003357, 0.000946, -0.009735, -0.000275, 
-9.2e-05, -0.00763, -0.001404, 0.004944, -0.010712, -0.000732, 
0.002289, 0.005127, -0.006897, 0.000946, 0.00119, 0.003113, 0.000336, 
0.002411, 0.004669, -0.002777, 0.006928, 0.005463, -0.008637, 
-0.000336, 0.016968, -0.002411, -0.009033, 0.007691, 0.009919, 
-0.007263, -0.00177, 0.007904, -0.00586, -0.001587, -0.007538, 
-0.000244, -0.000305, -0.002167, -0.003754, -0.000366, 0.007752, 
0.003906, -0.000641, -0.004547, 0.006592, 0.013581, -0.003601, 
-0.003265, -0.000275, 0.001373, -0.002686, -0.008148, -0.005707, 
-0.000885, -0.001495, -0.006928, -0.002075, 0.004242, -0.001526, 
0.002319, -0.004944, 0.004425, 0.0159, -0.001892, -0.005585, 
0.009735, 0.01175, 0.000366, -0.003174, -0.002533, -0.000214, 
-0.000855, -9.2e-05, -0.008362, -0.001404, 0.000763, -0.007141, 
-0.000916, -0.001831, -0.000458, 3.1e-05, -0.006104, 0.001038, 
0.002472, -0.00116, -0.000763, -0.00528, -0.001068, 0.009369, 
-0.000519, -0.008698, 0.005951, 0.006623, 0.002716, -0.005158, 
0.002503, 0.003204, -0.001953, 0.002045, -0.00293, -3.1e-05, 
-0.004456, -0.001679, -0.007904, -0.000977, 0, 0.000793, -0.000458, 
-0.008942, 0.002564, 0.007111, -0.00412, -0.003876, 0.005249, 
0.00116, 0.002625, 0.005524, -0.001312, -0.005341, 0.005005, 
0.005615, -0.006745, -0.004578, 0.004608, 0.001343, -0.003204, 
-0.000977, 0.004883, 0.003937, -0.00116, -0.002014, 0.002777, 
0.003296, -0.00058, -0.003235, 0, 0.002167, 0.000305, -0.002045, 
0.004669, 0.002564, 0.003479, -0.000244, -0.000153, 0.004059, 
0.003235, -0.003052, -0.006134, 0.002472, 0.00116, -0.004334, 
-0.006745, 0.001862, 0.003143, -0.006378, -0.006073, 0.005676, 
0.003113, -0.005646, -0.002594, -6.1e-05, 0.000763, 0.001312, 
0.000275, -0.00174, 0.002106, 0.004181, 0.000336, -0.003388, 
0.000488, 0.00296, -0.001526, 0.002197, -0.001434, 0.002655, 
-0.00119, -0.002594, -0.000275, -9.2e-05, -0.001373, -0.003388, 
0.001892, 0.00116, -0.000366, -0.001556, -0.001099, 0.002319, 
0.00354, 0.001892, -3.1e-05, 0.002136, 0.001892, 0.000549, -0.000793, 
-0.000305, -0.000885, -0.001984, 0.000549, -0.003143, -0.003052, 
-0.002228, -0.002564, -0.002045, -0.002594, -0.000366, -0.001984, 
-0.001495, 0.001526, 0.002106, 0.002228, 3.1e-05, 0.002411, 0.004089, 
0.002594, 0.001434, 0.000885, -0.000458, 9.2e-05, 0.001129, -0.002045, 
-0.002441, -0.000916, -0.000366, -0.000763, -0.002106, -0.002777, 
-0.001068, -0.000946, -0.002075, -0.001923, -0.000458, 3.1e-05, 
9.2e-05, -0.000336, 0.000488, 0.002228, 0.001648, 0.000702, 0.000702, 
0.00119, 0.001007, 0.000824, -0.000214, -0.000793, -0.000122, 
0.000366, 0.000244, -0.000824, -0.000488, -6.1e-05, 0.000793, 
0.000702, -0.000549, -0.000549, 3.1e-05, 0.000244, 6.1e-05, -0.000336, 
-0.000793, -0.000549, 0.000244, -0.000122, -0.000427, -0.000244, 
-3.1e-05, 9.2e-05, 0.000336, 0.000153, -3.1e-05, 3.1e-05, 0.000122, 
0.000153, 0.000122, 0.000183, 0.000244, 0.000153, 3.1e-05, 6.1e-05, 
6.1e-05, 6.1e-05, 3.1e-05, 0), .Dim = c(5484L, 1L)), fs = 8000L, 
    nChannels = 1, nBits = 16L, nSamples = 5484L, duration = 0.6855), class = c("list", 
type = "Sound", name = "sound.wav"))

    return(snd)
}