% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtl_pheno_simu.R
\name{qtl_pheno_simu}
\alias{qtl_pheno_simu}
\title{Simulating phenotype values with neighbor effects.}
\usage{
qtl_pheno_simu(
  b_self,
  b_nei,
  eigenK_self,
  eigenK_nei,
  b_ratio = c(1, 1),
  pveB,
  pve
)
}
\arguments{
\item{b_self}{A n x 1 genotype vector to design major additive genetic effect.}

\item{b_nei}{A vector of an explanatory variable for neighbor effects}

\item{eigenK_self}{Products of \code{eigen()} with self covariance matrices that are used as explanatory variables for the phenotype.}

\item{eigenK_nei}{Products of \code{eigen()} with neighbor covariance matrices that are used as explanatory variables for the phenotype.}

\item{b_ratio}{Ratio for contributions of \code{eigenK_self} and \code{eigenK_nei} to the phenotype.}

\item{pveB}{Proportion of variance explained by genetic effects attributable to the fixed effects (i.e., b_.. vector).}

\item{pve}{Proportion of variance explained by all genetic effects (i.e., b_.. and eigenK_..)}
}
\value{
A list of simulated phenotypes
\itemize{
\item{\code{y}} {Simulated phenotype values}
\item{\code{beta_self}} {major self-genetic effects}
\item{\code{beta_nei}} {major neighbor effects}
\item{\code{sigma_self}} {self polygenic effects}
\item{\code{sigma_nei}} {neighbor polygenic effects}
\item{\code{epsilon}} {residuals}
\item{\code{res_pveB}} {realized proportion of variation explained by major-effect genes}
\item{\code{res_pve}} {realized proportion of variation explained by major-effect genes and polygenic effects}
}
}
\description{
A function to simulate phenotype values with multiple sources of variation controlled
}
\author{
Eiji Yamamoto, and Yasuhiro Sato
}
