% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMouse-functions.R
\name{move}
\alias{move}
\title{Move Mouse Cursor to Pixel(x,y)}
\usage{
move(x, y, failSafe = TRUE)
}
\arguments{
\item{x}{horizontal coordinate as integer.}

\item{y}{vertical coordinate as integer.}

\item{failSafe}{Logical flag to allow for emergency stops. Default is \code{TRUE}.}
}
\description{
Moves the mouse cursor to the specified pixel. Top left corner of screen is pixel(0,0).
}
\note{
If failSafe is \code{TRUE}, the function checks whether the mouse cursor is at the upper left position of the screen (pixel: x = 0, y = 0) . If so, the function fails and throws an error, allowing for emergency stops during code execution.
}
\examples{
\dontrun{
move(50, 50)
delay(1000)
move(364, 200)
}
}
\seealso{
\code{\link{delay}}, \code{\link{left}}, \code{\link{right}}, \code{\link{pos}}, \code{\link{record}}
}
\keyword{move}
