% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ltp.R
\name{ltp}
\alias{ltp}
\title{R Interface of LTP-cloud service}
\usage{
ltp(input = NULL, file = NULL, mission = "ws",
  api_key = getOption("ltp_api_key"), maxUpload = 1e+05)
}
\arguments{
\item{input}{The input text.}

\item{file}{The input file.}

\item{mission}{Expected result for the cloud server, may be unfinished. Optional choices are
'ws' for word-splitting,
'pos' for part-of-speech,
'ner' for named entity recognition,
'dp' for dependency parser,
'srl' for semantic role labeling,
'all' for all missions.}

\item{api_key}{Your API_Key for the cloud server. Visit http://www.ltp-cloud.com/dashboard/ to get it.}

\item{maxUpload}{Due to the limitation of the server, we cut the input in pieces.}
}
\description{
This function deals with communication with the server.
XML result will be parsed if the mission is word-splitting.
Else the raw XML texts will be returned for further analysis.
}
\examples{
require(rLTP)
# This api_key is publicly accessible.
# So it is strongly recommended to register for your own key.
options(ltp_api_key='l2T9N724koSqEcDJvQHtRGVV2erajgPOgB0FAcLj')
ltp('Replace this field with a Chinese sentence.')
}

