% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm.R
\name{pm}
\alias{pm}
\title{Define the PM}
\usage{
pm(u = NULL, y, g, t = NULL)
}
\arguments{
\item{u}{is a vector of n input \code{\link{cp}}s \code{u = (u1, u2,..., un)}. In the special case
of first level perception mappings (1PM) the inputs are numerical values provided either by sensors or
obtained from a database.}

\item{y}{is the output \code{\link{cp}}.}

\item{g}{is an aggregation function employed to calculate w from the input \code{\link{cp}}s. For example,
\code{g} might be implemented using a set of fuzzy rules. In the case of 1PMs, \code{g} is built using a set of
membership functions.}

\item{t}{is a text generation algorithm which allows generating the sentences in \code{A}. In simple cases,
\code{t} is a linguistic template, e.g., cat("Alabama has", value, "the number of women in the last census".}
}
\value{
The generated \code{pm = list(u,y,g,t)}
}
\description{
Perception Mapping (PM) is used to create and aggregate \code{\link{cp}} objects. Each PM receives
a set of inputs (\code{\link{cp}} objects or numerical values) which are aggregated into a single CP.
}
\examples{
\dontrun{cp_depth <- cp("cp_depth",c("far",
                            "bit far",
                            "good",
                            "close",
                            "very close"))

g_depth <- function(u,y){
  y$w <- degree_mf(fuzzy_partitions(triangle_mf(450,450,550),
                                 triangle_mf( 450,550,600),
                                 trapezoid_mf(550,600,800, 1000),
                                 triangle_mf( 800,1000,1300),
                                 trapezoid_mf( 1000,1300,1500,1500)),u)
  y
}

pm_depth  <- pm(y=cp_depth, g=g_depth)

########################### HEIGHT DEFINITION ###########################################
cp_height <- cp("cp_height", c("high",
                             "average high",
                             "centered",
                             "average low",
                             "low"))

g_height <- function(u,y){
  y$w <- degree_mf(fuzzy_partitions(trapezoid_mf(-1000,-1000,-600,-400),
                                               triangle_mf(-600,-400,0),
                                               trapezoid_mf(-400,0,200,400),
                                               triangle_mf(200,400,600),
                                               trapezoid_mf(400,600,1000,1000)),u)
  y
}

pm_height <- pm(y=cp_height, g=g_height)

########################### WIDTH DEFINITION ###########################################
cp_width <- cp("cp_width",  c("left",
                               "average left",
                                "centered",
                                "average right",
                                 "right"))

g_width <- function(u,y){
  y$w <- degree_mf(fuzzy_partitions(triangle_mf(-1000,-600,-400),
                                               triangle_mf(-600,-400,0),
                                              triangle_mf(-400,0,400),
                                               triangle_mf(0,400,600),
                                               triangle_mf(400,600,1000,1000)),
                              u)
  y
}

pm_width  <- pm(y=cp_width,  g=g_width)

########################### FRAME DEFINITION ###########################################
cp_frame <- cp("cp_frame", c("bad",
                             "middle",
                             "good"))

g_frame <- function(u,y){

  operator <- operator(min, max)

  y$w<- infer_rules(fuzzy_rules( fuzzy_rule(0,0,1,0,0, 0,0,1,0,0, 0,0,1,0,0, 0,0,1),
                           fuzzy_rule(1,1,1,1,1, 1,1,1,1,1, 1,1,0,1,1, 1,0,0),
                           fuzzy_rule(1,1,1,1,1, 1,0,0,0,1, 0,0,1,0,0, 1,0,0),
                           fuzzy_rule(1,0,0,0,1, 1,1,1,1,1, 0,0,1,0,0, 1,0,0),
                           fuzzy_rule(0,1,0,1,0, 0,1,0,1,0, 0,0,1,0,0, 0,1,0)),
                     operator,
                     list(u[[1]]$w,u[[2]]$w,u[[3]]$w))

  y
}

t_frame <- function(y){

  templates <- c("It has been taken a bad framed photo",
                 "It has been taken a middle framed photo",
                 "It has been taken a good framed photo")

  return( templates[which.max(y$w)])
}

pm_frame <-  pm(y=cp_frame, g=g_frame, t=t_frame)
}
}
\seealso{
\code{\link{cp}}
}

