% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-structure.R
\name{data_structure}
\alias{data_structure}
\title{Define the data structure}
\usage{
data_structure(input, method)
}
\arguments{
\item{input}{is the input data. May be a vector, list or matrix with numbers.}

\item{method}{is the function with the data preprocesing techniques needed to prepare the GLMP input. The method must have
one argument, the \code{input} data:

\code{my_method <- function(input)}}
}
\value{
The generated \code{data_structure = list(input, method)}
}
\description{
Data structure provides the GLMP input. It constructor receives the input values and the method that defines
the data structure, i.e., the set of preprocesing techniques.
}
\examples{

values <- matrix(c(34,11,9,32), ncol=2)

my_method <- function (input){
 output <- c(mean(input[,1]), mean(input[,2]))
 output
}
 my_data_structure <- data_structure(values,my_method)
}

