% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report-template.R
\name{report_template}
\alias{report_template}
\title{Define the report template}
\usage{
report_template(properties = NULL, method, description = NULL)
}
\arguments{
\item{properties}{may be a vector, list or matrix with the user's needs,
preferences and goals. By default \code{properties = NULL}.}

\item{method}{is the function that generates the appropriate report. The method must have
two arguments: the list of properties and the list of pms:
\code{my_report_method}  \code{<-} \code{function(properties, pm){...}}.}

\item{description}{is the result of call the report template. By default is NULL}
}
\value{
The generated \code{report_template= list(properties, method,description)}
}
\description{
The text generation algorithm contains the programming code capable of generating
the appropriate report to each specific user. Algorithms must select and order
the linguistic expressions to generate the text included in the report.
#'
The \code{report_template} constructor receive as arguments the list of properties
and the method (programming code) capable of generating the appropriate report.
}
\examples{
properties = NULL
report_method <- function(properties,pm){
  pm_report(pm$pm_frame)
}
my_report <- report_template(properties,
                    report_method)
}

