% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getArea.R
\name{getArea}
\alias{getArea}
\title{Method to extract Niche Polygon Areas}
\usage{
getArea(estObj)
}
\arguments{
\item{estObj}{List object created from estKIN, estMCP or estEllipse functions}
}
\value{
A data.frame() of polygon areas.
}
\description{
Extracts the polygon area for an rKIN object for each group and level.
}
\examples{
data("rodents")
#estimate niche overlap between 2 species using kernel UD
test.kin<- estKIN(data=rodents, x="Ave_C", y="Ave_N", group="Species", 
                 levels=c(50, 75, 95), scaler=2)
#determine polygon sizes/areas
kin.area<- getArea(test.kin)
}
\author{
Shannon E. Albeke, Wyoming Geographic Information Science Center, University of Wyoming
}
