% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly5Model.R
\name{poly5Model}
\alias{poly5Model}
\title{Fitting a fifth-degree polynomial taper model}
\usage{
poly5Model(dbh,ht,di,hi, plotxy)
}
\arguments{
\item{dbh, }{vector of diameter at breast height}

\item{ht, }{vector of measured tree heights}

\item{di, }{vector of measured tree diameters at i heights}

\item{hi, }{vector of measured tree i heights}

\item{plotxy, }{plot the fitted model}
}
\value{
Returns a fifth-degree polynomial taper model as an object of class "lm"
}
\description{
poly5Model is used to fit a fifth-degree polynomial taper model
}
\examples{
# Importing forest inventory data
data(ForestInv01) 

# setting model parametersdbh and ht
hi<-ForestInv01[,2]
di<-ForestInv01[,3]
ht<-ForestInv01[,4]
dbh<-ForestInv01[,5]

# fitting the fifth-degree polynomial taper model
fit <- poly5Model(dbh,ht,di,hi, plotxy=TRUE)
#grid()
}
\references{
Schoepfer (1966) model :fifth-degree polynomial taper model 
\itemize{
  \eqn{di/dbh= (hi/ht) + (hi/ht)^2 + (hi/ht)^3 + (hi/ht)^4 + (hi/ht)^5}\cr
}
}
\author{
Carlos A. Silva, Samuel P. C. Carvalho, Carine Klauberg Silva and Manoela de O. Rosa
}
