% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DataSet.R
\docType{methods}
\name{initialize,DataSet-method}
\alias{addFieldMapping}
\alias{addFieldMapping,DataSet-method}
\alias{addStockEvent}
\alias{addStockEvent,DataSet-method}
\alias{dataSet}
\alias{initialize,DataSet-method}
\alias{setDataProvider,DataSet,data.frame-method}
\alias{setFieldMappings}
\alias{setFieldMappings,DataSet,list-method}
\alias{setStockEvents}
\alias{setStockEvents,DataSet,list-method}
\title{Initialize a DataSet}
\usage{
\S4method{initialize}{DataSet}(.Object, compared = FALSE, dataProvider,
  fieldMappings, stockEvents, ...)

dataSet(compared = FALSE, dataProvider, fieldMappings, stockEvents, ...)

\S4method{setDataProvider}{DataSet,data.frame}(.Object, dataProvider,
  keepNA = TRUE)

setFieldMappings(.Object, fieldMappings)

\S4method{setFieldMappings}{DataSet,list}(.Object, fieldMappings)

addFieldMapping(.Object, ...)

\S4method{addFieldMapping}{DataSet}(.Object, ...)

setStockEvents(.Object, stockEvents)

\S4method{setStockEvents}{DataSet,list}(.Object, stockEvents)

addStockEvent(.Object, stockEvent = NULL, ...)

\S4method{addStockEvent}{DataSet}(.Object, stockEvent = NULL, ...)
}
\arguments{
\item{.Object}{\linkS4class{DataSet}.}

\item{compared}{\code{logical}.}

\item{dataProvider}{\code{data.frame}. The data set data.
Important: the data sets need to come pre-ordered in ascending order.
Data with incorrect order might result in visual and functional glitches on the chart.}

\item{fieldMappings}{\code{list} of field mappings.
Field mapping is an object with fromField and toField properties.
fromField is a name of your value field in dataProvider.
toField might be chosen freely,
it will be used to set value/open/close/high/low fields for the StockGraph.
Example: list(fromField = "val1", toField ="value").}

\item{stockEvents}{\linkS4class{StockEvent}.}

\item{...}{Other properties.}

\item{keepNA}{\code{logical}.
Should the missing values appear in the list ?}

\item{stockEvent}{\linkS4class{StockEvent}.}
}
\value{
(updated) \code{\linkS4class{DataSet}} object
}
\description{
Initialize a DataSet
}
\examples{
new("DataSet")
dataSet(categoryField = "categoryField")
setDataProvider(.Object = dataSet(), data.frame(key = c("FR", "US"), value = c(20,10)))
addFieldMapping(.Object = dataSet(), fieldMappings = list(fromField ="val1", toField ="value"))
addFieldMapping(.Object = dataSet(), fromField ="val1", toField ="value")
}

