% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ChartCursor.R
\docType{methods}
\name{initialize,ChartCursor-method}
\alias{chartCursor}
\alias{initialize,ChartCursor-method}
\alias{setOneBalloonOnly}
\alias{setOneBalloonOnly,ChartCursor,logical-method}
\alias{setValueLineAxis}
\alias{setValueLineAxis,ChartCursor-method}
\title{Initialize a ChartCursor}
\usage{
\S4method{initialize}{ChartCursor}(.Object, animationDuration = 0.3,
  oneBalloonOnly, valueLineAxis, ...)

chartCursor(animationDuration = 0.3, oneBalloonOnly, valueLineAxis, ...)

setOneBalloonOnly(.Object, oneBalloonOnly)

\S4method{setOneBalloonOnly}{ChartCursor,logical}(.Object, oneBalloonOnly)

setValueLineAxis(.Object, valueLineAxis = NULL, ...)

\S4method{setValueLineAxis}{ChartCursor}(.Object, valueLineAxis = NULL, ...)
}
\arguments{
\item{.Object}{\linkS4class{ChartCursor}.}

\item{animationDuration}{Duration of animation of a line, in seconds.}

\item{oneBalloonOnly}{\code{logical}.
If this is set to TRUE, border color instead of background color will be changed when
user rolls-over the slice, graph, etc.}

\item{valueLineAxis}{\code{list}.
Properties of Axis of value line. If you set valueLineBalloonEnabled to true,
but you have more than one axis, you can use this property
to indicate which axis should display balloon.}

\item{...}{Properties of ChartCursor.
See \url{http://docs.amcharts.com/3/javascriptcharts/ChartCursor}}
}
\value{
(updated) .Object of class \linkS4class{ChartCursor}.
}
\description{
Initialize a ChartCursor
}
\section{Functions}{
\itemize{
\item \code{chartCursor}: 
}}
\examples{
new("ChartCursor", oneBalloonOnly = TRUE)
chartCursor()
chartCursor(oneBalloonOnly = TRUE)
setOneBalloonOnly(.Object = chartCursor(), oneBalloonOnly = TRUE)
setValueLineAxis(.Object = chartCursor(), title = "Hello !", axisTitleOffset = 12)
}

