% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GaugeAxis.R, R/GaugeAxis_setters.R
\docType{methods}
\name{initialize,GaugeAxis-method}
\alias{addBand}
\alias{addBand,GaugeAxis,GaugeBandOrMissing-method}
\alias{gaugeAxis}
\alias{initialize,GaugeAxis-method}
\alias{setBands}
\alias{setBands,GaugeAxis,list-method}
\title{Initialize a GaugeAxis}
\usage{
\S4method{initialize}{GaugeAxis}(.Object, axisAlpha = 1, bands, ...)

gaugeAxis(axisAlpha = 1, bands, ...)

setBands(.Object, bands)

\S4method{setBands}{GaugeAxis,list}(.Object, bands)

addBand(.Object, band = NULL, ...)

\S4method{addBand}{GaugeAxis,GaugeBandOrMissing}(.Object, band = NULL, ...)
}
\arguments{
\item{.Object}{\linkS4class{GaugeAxis}.}

\item{axisAlpha}{\code{numeric}.}

\item{bands}{\code{list} of \linkS4class{GaugeBand}.
Bands are used to draw color fills between specified values.}

\item{...}{other properties.}

\item{band}{\linkS4class{GaugeBand}.
Argument for method \code{addBand}.}
}
\description{
Initialize a GaugeAxis
}
\section{Functions}{
\itemize{
\item \code{gaugeAxis}: 
}}
\examples{
new("GaugeAxis", alpha = 1)
gaugeAxis()
bands <- list(gaugeBand(startValue = 70, endValue = 90),
              gaugeBand(startValue = 40, endValue = 60))
gaugeAxis(bands = bands)
# ---
addBand(.Object = gaugeAxis(), startValue = 0, endValue = 100)
# equivalent to
gaugeBand_obj <- gaugeBand(startValue = 0, endValue = 100)
addBand(.Object = gaugeAxis(), band = gaugeBand_obj)
# ---
}

