% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SStimeseries.R
\name{SStimeseries}
\alias{SStimeseries}
\title{A function to create a time-series table from an SS Report.sso file}
\usage{
SStimeseries(dir, plotdir = "default", nsex = FALSE)
}
\arguments{
\item{dir}{Locates the directory of the files to be read in, double
backslashes (or forwardslashes) and quotes necessary.}

\item{plotdir}{Directory where the table will be saved.  The default 
saves the table to the dir location where the Report.sso file is located.}

\item{nsex}{This will allow the user to calculate single sex values based on the new sex 
specification (-1) in SS for single sex models. Default value is FALSE. TRUE will not divide by 2.}
}
\value{
A csv file containing a time-series of total biomass, summary 
biomass, spawning biomass or output, relative depletion, total dead catch
the SPR, and the exploitation.
}
\description{
Reads the Report.sso within the directory and creates a time-series
table as required by the current Terms of Reference for West Coast 
groundfish.  Table includes the historical and the forecast years for 
the model.  Works with Stock Synthesis versions 3.24U and later.
}
\author{
Chantel Wetzel
}
