% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotComps.R
\name{SSplotComps}
\alias{SSplotComps}
\title{Plot composition data and fits.}
\usage{
SSplotComps(replist, subplots = c(1:21, 24), kind = "LEN", sizemethod = 1,
  aalyear = -1, aalbin = -1, plot = TRUE, print = FALSE,
  fleets = "all", fleetnames = "default", sexes = "all", yupper = 0.4,
  datonly = FALSE, samplesizeplots = TRUE, compresidplots = TRUE,
  bub = FALSE, showyears = TRUE, showsampsize = TRUE, showeffN = TRUE,
  sampsizeline = FALSE, effNline = FALSE, minnbubble = 3,
  pntscalar = NULL, scalebubbles = FALSE, cexZ1 = 1.5, bublegend = TRUE,
  colvec = c(rgb(1, 0, 0, 0.7), rgb(0, 0, 1, 0.7), rgb(0.1, 0.1, 0.1, 0.7)),
  linescol = c(rgb(0, 0.5, 0, 0.7), rgb(0.8, 0, 0, 0.7), rgb(0, 0, 0.8, 0.7)),
  axis1 = NULL, axis2 = NULL, blue = rgb(0, 0, 1, 0.7), red = rgb(1, 0,
  0, 0.7), pwidth = 6.5, pheight = 5, punits = "in", ptsize = 10,
  res = 300, plotdir = "default", cex.main = 1, linepos = 1,
  fitbar = FALSE, do.sqrt = TRUE, smooth = TRUE, cohortlines = c(),
  labels = c("Length (cm)", "Age (yr)", "Year", "Observed sample size",
  "Effective sample size", "Proportion", "cm", "Frequency", "Weight", "Length",
  "(mt)", "(numbers x1000)", "Stdev (Age) (yr)", "Conditional AAL plot, "),
  printmkt = TRUE, printsex = TRUE, maxrows = 6, maxcols = 6,
  maxrows2 = 2, maxcols2 = 4, rows = 1, cols = 1, andre_oma = c(3, 0,
  3, 0), andrerows = 3, fixdims = TRUE, fixdims2 = FALSE,
  maxneff = 5000, verbose = TRUE, scalebins = FALSE, addMeans = TRUE,
  ...)
}
\arguments{
\item{replist}{list created by \code{SSoutput}}

\item{subplots}{vector controlling which subplots to create}

\item{kind}{indicator of type of plot can be "LEN", "SIZE", "AGE", "cond",
"GSTAGE", "L[at]A", or "W[at]A".}

\item{sizemethod}{if kind = "SIZE" then this switch chooses which of the
generalized size bin methods will be plotted.}

\item{aalyear}{Years to plot multi-panel conditional age-at-length fits for
all length bins; must be in a "c(YYYY,YYYY)" format. Useful for checking the
fit of a dominant year class, critical time period, etc. Default=-1.}

\item{aalbin}{The length bin for which multi-panel plots of the fit to
conditional age-at-length data will be produced for all years.  Useful to
see if growth curves are ok, or to see the information on year classes move
through the conditional data. Default=-1.}

\item{plot}{plot to active plot device?}

\item{print}{print to PNG files?}

\item{fleets}{optional vector to subset fleets for which plots will be made}

\item{fleetnames}{optional vector of fleet names to put in the labels}

\item{sexes}{which sexes to show plots for. Default="all" which will include
males, females, and unsexed. This option is not fully implemented for all
plots.}

\item{yupper}{upper limit on ymax for polygon/histogram composition plots}

\item{datonly}{make plots of data without fits as well as data with fits?}

\item{samplesizeplots}{make sample size plots?}

\item{compresidplots}{make plots of residuals for fit to composition data?}

\item{bub}{make bubble plot for numbers at age or size?}

\item{showyears}{Add labels for years to sample size plots?}

\item{showsampsize}{add sample sizes to plot}

\item{showeffN}{add effective sample sizes to plot}

\item{sampsizeline}{show line for input sample sizes on top of conditional
age-at-length plots (TRUE/FALSE, still in development)}

\item{effNline}{show line for effective sample sizes on top of conditional
age-at-length plots (TRUE/FALSE, still in development)}

\item{minnbubble}{number of unique x values before adding buffer. see
?bubble3 for more info.}

\item{pntscalar}{This scalar defines the maximum bubble size for bubble
plots. This option is still available but a better choice is to use cexZ1
which allow the same scaling throughout all plots.}

\item{scalebubbles}{scale data-only bubbles by sample size, not just
proportion within sample? Default=FALSE.}

\item{cexZ1}{Character expansion (cex) for point associated with value of 1.}

\item{bublegend}{Add legend with example bubble sizes to bubble plots.}

\item{colvec}{Vector of length 3 with colors for females, males, unsexed fish}

\item{linescol}{Color for lines on top of polygons}

\item{axis1}{position of bottom axis values}

\item{axis2}{position of left size axis values}

\item{blue}{What color to use for males in bubble plots (default is slightly
transparent blue)}

\item{red}{What color to use for females in bubble plots (default is slightly
transparent red)}

\item{pwidth}{default width of plots printed to files in units of
\code{punits}. Default=7.}

\item{pheight}{default height width of plots printed to files in units of
\code{punits}. Default=7.}

\item{punits}{units for \code{pwidth} and \code{pheight}. Can be "px"
(pixels), "in" (inches), "cm" or "mm". Default="in".}

\item{ptsize}{point size for plotted text in plots printed to files (see
help("png") in R for details). Default=12.}

\item{res}{resolution of plots printed to files. Default=300}

\item{plotdir}{directory where PNG files will be written. by default it will
be the directory where the model was run.}

\item{cex.main}{character expansion parameter for plot titles}

\item{linepos}{should lines be added before points (linepos=1) or after
(linepos=2)?}

\item{fitbar}{show fit to bars instead of points}

\item{do.sqrt}{scale bubbles based on sqrt of size vector. see ?bubble3 for
more info.}

\item{smooth}{add loess smoother to observed vs. expected index plots and
input vs. effective sample size?}

\item{cohortlines}{optional vector of birth years for cohorts for which to
add growth curves to numbers at length bubble plots}

\item{labels}{vector of labels for plots (titles and axis labels)}

\item{printmkt}{show market categories in plot titles?}

\item{printsex}{show gender in plot titles?}

\item{maxrows}{maximum (or fixed) number or rows of panels in the plot}

\item{maxcols}{maximum (or fixed) number or columns of panels in the plot}

\item{maxrows2}{maximum number of rows for conditional age at length plots}

\item{maxcols2}{maximum number of columns for conditional age at length
plots}

\item{rows}{number or rows to return to as default for next plots to come or
for single plots}

\item{cols}{number or cols to return to as default for next plots to come or
for single plots}

\item{andre_oma}{Outer margins passed to Andre's multi-panel conditional
age-at-length plots.}

\item{andrerows}{Number of rows of Andre's conditional age-at-length plots
within each page. Default=3.}

\item{fixdims}{fix the dimensions at maxrows by maxcols or resize based on
number of years of data}

\item{fixdims2}{fix the dimensions at maxrows by maxcols in aggregate plots
or resize based on number of fleets}

\item{maxneff}{the maximum value to include on plots of input and effective
sample size. Occasionally a calculation of effective N blows up to very
large numbers, rendering it impossible to observe the relationship for other
data. Default=5000.}

\item{verbose}{return updates of function progress to the R GUI?}

\item{scalebins}{Rescale expected and observed proportions by dividing by
bin width for models where bins have different widths? Caution!: May not
work correctly in all cases.}

\item{addMeans}{Add parameter means in addition to medians for MCMC
posterior distributions in which the median and mean differ.}

\item{\dots}{additional arguments that will be passed to the plotting.}
}
\description{
Plot composition data and fits from Stock Synthesis output.  Multi-figure
plots depend on \code{make_multifig}.
}
\author{
Ian Taylor
}
\seealso{
\code{\link{SS_plots}}, \code{\link{make_multifig}}
}
\keyword{hplot}

