% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{m_add_sphere}
\alias{m_add_sphere}
\title{Add Sphere Shape}
\usage{
m_add_sphere(id, center, radius = 1, spec = m_shape_spec(), ...)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{center}{center point of sphere. Can be \code{m_sel()}.}

\item{radius}{radius of sphere.}

\item{spec}{Additional shape specifications defined with
\code{m_shape_spec()}.}

\item{...}{Additional shape specifcations, that can be called outside of
\code{m_shape_spec()} such as \code{color = 'blue'}}
}
\description{
Adds sphere at given location, with given radius.
}
\examples{
r3dmol() \%>\%
  m_add_model(data = m_fetch_pdb("1bna")) \%>\%
  m_add_sphere(
    center = m_sel(resi = 1),
    spec = m_shape_spec(color = "green", wireframe = TRUE)
  ) \%>\%
  m_zoom_to(sel = m_sel(resi = 1))
}
