% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\docType{data}
\name{r2spss_options}
\alias{r2spss_options}
\title{Options for package r2spss}
\format{
A list with the following two components:
\describe{
  \item{\code{get(which, drop = TRUE)}}{an accessor function to retrieve
  current options, which are usually returned as a named list.  Argument
  \code{which} allows to select which options to retrieve.  If a single
  option is selected, argument \code{drop} indicates whether only its value
  should be returned (\code{TRUE}) or a list of length one (\code{FALSE}).}
  \item{\code{set(...)}}{an accessor function to set certain options using
  \code{name = value} pairs.}
}
}
\usage{
r2spss_options
}
\description{
Retrieve or set global options for package \pkg{r2spss} (within the current
\R session) via accessor functions.
}
\details{
The following options are available:
\describe{
  \item{\code{version}}{a character string that controls the default for
  whether tables and plots should mimic the content and look of recent SPSS
  versions (\code{"modern"}) or older versions (<24; \code{"legacy"}).}
  \item{\code{minor}}{a logical that overrides whether function
  \code{\link{to_latex}} should include any supplied minor grid lines
  in SPSS tables.  In particular for tables that mimic older SPSS versions,
  minor grid lines can be somewhat distracting from the content, so setting
  this option to \code{FALSE} provides a quick way to suppress them.  The
  look of the resulting tables still closely mimics SPSS while being
  somewhat cleaner.}
}
}
\examples{
# retrieve the list of options
r2spss_options$get()

# retrieve a single option
r2spss_options$get("version")

\dontrun{

# set options
r2spss_options$set(version = "legacy", minor = FALSE)
}

}
\author{
Andreas Alfons
}
\keyword{utilities}
